# Writing Style Reference

## Eric Topol Voice Guide

Eric Topol's writing in Ground Truth represents the gold standard for medical thought leadership. Key characteristics:

### Opening Patterns

**DO:**
- Start with a specific clinical scenario
- Lead with surprising data
- Open with a question clinicians face

**DON'T:**
- Start with "In recent years..."
- Open with definitions
- Begin with historical timelines

**Examples:**

Good: "A 68-year-old man with stable angina and a positive stress test sits in your office, awaiting your recommendation. The data that should guide your advice just got more complicated."

Bad: "Coronary artery disease remains a leading cause of mortality worldwide, highlighting the need for evidence-based interventions."

### Evidence Presentation

**Numbers that matter:**
- Absolute risk reduction (ARR): "reduced events from 12% to 8%"
- Number needed to treat (NNT): "NNT of 25 over 3 years"
- Confidence intervals: "HR 0.74 (95% CI 0.65-0.85)"
- Hazard ratios with context

**Numbers to avoid:**
- Relative risk reduction alone (misleading)
- P-values without effect sizes
- Percentages without denominators

**Example:**
Good: "Dapagliflozin reduced the composite endpoint from 21.2% to 16.3%—an absolute reduction of 4.9 percentage points. Put another way, treating 21 patients for 18 months prevents one hospitalization or death."

Bad: "Dapagliflozin significantly reduced events (p<0.001), representing a 26% relative reduction."

### Hedging Language

**When certain (strong evidence):**
- "The data show..."
- "The trial demonstrated..."
- "This establishes..."

**When uncertain (limited evidence):**
- "These findings suggest..."
- "The data hint that..."
- "If confirmed..."

**When speculating:**
- "One might anticipate..."
- "It's tempting to conclude..."
- "Time will tell whether..."

### Transition Phrases

**Between evidence sections:**
- "Building on this foundation..."
- "The picture becomes more complex when..."
- "These findings gain context from..."

**Introducing limitations:**
- "Before embracing this conclusion..."
- "A closer look reveals..."
- "What the headlines miss..."

**Moving to implications:**
- "For the clinician in the office..."
- "This matters because..."
- "The practical question becomes..."

### Critique Patterns

**Balanced critique formula:**
1. Acknowledge the achievement
2. Identify the gap
3. Explain why it matters

**Example:**
"DAPA-HF delivered compelling evidence for SGLT2 inhibitors in HFrEF. What it couldn't tell us—by design—is whether these benefits extend to patients with preserved ejection fraction. That question, affecting roughly half of all heart failure patients, would require DELIVER to answer."

### Closing Patterns

**Strong closings:**
- Return to the opening scenario with new insight
- Concrete next steps for practice
- One memorable takeaway

**Weak closings:**
- "More research is needed"
- Restating the abstract
- Generic calls for guidelines

**Example:**
Good: "The 68-year-old in your office? The data now suggest watchful waiting may serve him as well as the cath lab—with none of the procedural risk. That's not nihilism; it's precision."

Bad: "In conclusion, this trial provides important evidence that will inform future guidelines and clinical practice."

---

## AI Tell Avoidance

### The Five Deadly Patterns

#### 1. Puffing Importance

Words that add no information:

| AI Pattern | Problem | Fix |
|------------|---------|-----|
| "represents a significant advancement" | Unsubstantiated claim | State what changed |
| "highlights the importance of" | Empty emphasis | Show the importance |
| "underscores the need for" | Cliché | Explain the need |
| "serves as a testament to" | Pompous | Delete |
| "plays a crucial role in" | Vague | Specify the role |

#### 2. Tailing Participles

Sentences ending with "-ing" phrases:

**AI:** "The trial enrolled 5,000 patients, highlighting the importance of large sample sizes."

**Human:** "The trial enrolled 5,000 patients—enough to detect a 15% difference with 90% power."

**AI:** "These findings support earlier research, emphasizing the consistency of SGLT2 inhibitor benefits."

**Human:** "These findings align with DAPA-HF and EMPEROR-Reduced."

#### 3. Negative Parallelism

"Not X, but Y" constructions:

**AI:** "This is not just a statistical finding—it's a clinical breakthrough."

**Human:** "The 4.9% absolute reduction translates to preventing one event per 21 patients treated."

#### 4. Ghost Language

Sensory words attached to abstract concepts:

**AI:** "The whisper of progress echoes through these data."

**Human:** (Just don't.)

#### 5. Promotional Puffery

Tourism-brochure language:

**AI:** "This landmark trial stands at the forefront of cardiovascular medicine."

**Human:** "This trial changes how we should treat heart failure."

### Vocabulary Substitutions

| Avoid | Use Instead |
|-------|-------------|
| delve into | examine, look at |
| leverage | use |
| utilize | use |
| landscape | field, area |
| tapestry | mix, combination |
| paradigm shift | change |
| game-changer | important |
| moving the needle | improving |
| at the end of the day | ultimately |
| going forward | in future |
| in terms of | regarding, about |
| in order to | to |
| due to the fact that | because |
| at this point in time | now |
| it is important to note that | [delete, just state it] |

### Sentence Structure

**Good rhythm:**
- Short sentence. Medium sentence with one clause. Longer sentence that develops a more complex idea, perhaps with a dash for emphasis—then returns to complete the thought. Short again.

**Bad rhythm:**
- Medium sentence. Medium sentence. Medium sentence. Medium sentence. Medium sentence.

**Vary openings:**
- Subject-verb: "The trial showed..."
- Prepositional: "In 4,744 patients..."
- Conditional: "If these findings hold..."
- Transitional: "Yet the question remains..."

### Numbers in Prose

**Integrate naturally:**
Good: "Among the 4,744 patients enrolled, 55% had no diabetes—a detail that would prove pivotal."

Bad: "4,744 patients were enrolled. 55% did not have diabetes."

**Contextualize:**
Good: "The 26% relative reduction sounds impressive until you see the absolute numbers: events fell from 21% to 16%, meaning 20 patients need treatment to prevent one event."

Bad: "There was a 26% relative reduction (p<0.001)."

---

## Citation Formatting

### In-Text (Vancouver)

Sequential numbering in order of appearance:

- Single: [1]
- Multiple separate: [1,3,7]
- Range: [4-6]
- Combined: [1,4-6,9]

### Reference List Format

```
1. McMurray JJV, Solomon SD, Inzucchi SE, et al. Dapagliflozin in Patients with Heart Failure and Reduced Ejection Fraction. N Engl J Med. 2019;381(21):1995-2008. doi:10.1056/NEJMoa1911303

2. Packer M, Anker SD, Butler J, et al. Cardiovascular and Renal Outcomes with Empagliflozin in Heart Failure. N Engl J Med. 2020;383(15):1413-1424. doi:10.1056/NEJMoa2022190
```

### Journal Abbreviations

- New England Journal of Medicine → N Engl J Med
- Journal of the American Medical Association → JAMA
- The Lancet → Lancet
- British Medical Journal → BMJ
- Journal of the American College of Cardiology → J Am Coll Cardiol
- Circulation → Circulation
- European Heart Journal → Eur Heart J
- JAMA Cardiology → JAMA Cardiol

---

## Quality Control Checklist

Before finalizing any section:

### Content
- [ ] Every claim has a citation
- [ ] Numbers include context (ARR, NNT, CI)
- [ ] Limitations acknowledged
- [ ] Clinical implications specific

### Style
- [ ] No AI tells (check all five patterns)
- [ ] Sentence lengths vary
- [ ] Opening is specific, not generic
- [ ] Closing is actionable, not platitude

### Format
- [ ] Citations numbered sequentially
- [ ] Headings consistent
- [ ] Word count within target (±10%)
- [ ] Transitions smooth between sections
