# Abstract Writing

## Structure Template

Abstract follows a fixed 8-part structure (150-200 words, one paragraph):

### Part 1: Background (1 sentence)
Establish context with trend or importance.

**Patterns:**
- "As [trend] grows/increases, ..."
- "The advent of [new thing] has led [field] into the era of [concept]..."
- "Deploying [technology] is an important measure to..."

**Example:**
> "As the number of prosumers with distributed energy resources (DERs) grows, the conventional centralized operation scheme may suffer from conflicting interests, privacy concerns, and incentive inadequacy."

### Part 2: Challenge (0-1 sentence)
State the problem or limitation. Can be combined with Part 1.

**Patterns:**
- "However, [limitation]..."
- "...may suffer from [problems]"
- "...are beyond the control of..."

### Part 3: This Paper (1 sentence)
State what this paper does. CRITICAL sentence.

**Patterns:**
- "This paper proposes [method] to address [challenge]."
- "In this paper, we propose [mechanism] to [goal]."
- "This paper addresses [problem] via [approach]."

**Example:**
> "In this paper, we propose an energy sharing mechanism to address the above challenges."

### Part 4: Method Description (1-2 sentences)
Describe key features of the proposed method.

**Patterns:**
- "It takes into account [factor 1] and [factor 2]."
- "Under [framework], [method] is proposed, which [result]."
- "The [method] will then [action], resulting in [outcome]."

**Example:**
> "It takes into account network constraints and fairness among prosumers."

### Part 5: Model/Framework (1 sentence)
Describe the theoretical framework.

**Patterns:**
- "In the proposed [system], [entities] play a [game type]."
- "The model casts down to a [formulation]."

### Part 6: Theoretical Properties (1-2 sentences)
State what is proved.

**Patterns:**
- "We prove that [property]."
- "The [object] is proved to have [properties]."
- "[Properties] are proved, such as [list]."

**Example:**
> "The market equilibrium is proved to have nice features in a large market or when it is a variational equilibrium."

### Part 7: Algorithm (1 sentence, optional)
Describe the solution algorithm.

**Patterns:**
- "An [type] algorithm is developed to [purpose]."
- "For implementation, a practical [algorithm] is developed with [property]."

**Example:**
> "An adaptive column-and-constraint generation (AC&CG) algorithm is developed."

### Part 8: Validation (1 sentence)
State that results validate the theory.

**Patterns:**
- "Numerical examples validate the theoretical results and show [finding]."
- "Case studies validate the theoretical results."
- "Experimental results validate the theoretical outcomes and show the practicability."

**Key word:** Use "validate" (not "show" or "demonstrate" alone).

---

## Key Rules

1. **No specific numbers** in abstract (save for conclusion)
2. **No citations** in abstract
3. **One paragraph** only
4. **150-200 words** typical length
5. **Use "validate"** for verification statements
6. **Abbreviations:** Introduce important ones with full form, e.g., "distributed energy resources (DERs)"

## Common Mistakes

- Adding specific percentages or numerical results
- Using "show" instead of "validate" for verification
- Making the abstract too long (>200 words)
- Forgetting to state what is proved
