---
name: Ad Copy Writer
slug: ad-copy-writer
description: Write high-converting advertising copy for paid media campaigns
category: marketing
complexity: intermediate
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "ad copy"
  - "facebook ads"
  - "google ads"
  - "linkedin ads"
  - "paid media copy"
tags:
  - advertising
  - paid-media
  - copywriting
  - ppc
  - social-ads
---

# Ad Copy Writer

Create scroll-stopping ad copy that captures attention and drives clicks across all major advertising platforms. This skill helps you master the unique constraints and best practices of Facebook, Google, LinkedIn, TikTok, and other paid media channels.

Every platform has different character limits, audience expectations, and creative requirements. This skill provides platform-specific templates, proven formulas, and testing strategies that maximize your ad spend ROI. From awareness campaigns to direct response, from B2B to B2C, get copy that converts.

Essential for performance marketers, media buyers, growth teams, and businesses running paid acquisition campaigns.

## Core Workflows

### Workflow 1: Facebook/Instagram Ads
1. **Hook Development** - Stop the scroll in first 3 seconds
2. **Primary Text** - Compelling body copy (125-250 chars visible)
3. **Headline Creation** - Benefit-driven, action-oriented
4. **Description Writing** - Supporting value proposition
5. **CTA Selection** - Match button to campaign goal
6. **Format Adaptation** - Feed, Stories, Reels variations
7. **Creative Alignment** - Copy that complements visuals

### Workflow 2: Google Search Ads
1. **Keyword Integration** - Include search terms naturally
2. **Headline Set** - 15 headlines for responsive search ads
3. **Description Set** - 4 descriptions for rotation
4. **Character Optimization** - Max impact in 30/90 char limits
5. **CTA Inclusion** - Clear action words
6. **USP Highlighting** - Differentiate from competitors
7. **Extension Copy** - Sitelinks, callouts, snippets

### Workflow 3: LinkedIn Ads
1. **Professional Tone** - B2B appropriate messaging
2. **Pain Point Focus** - Address business challenges
3. **Credibility Building** - Stats, awards, recognition
4. **Single Image Ads** - 150 char intro, headline, description
5. **Carousel Copy** - Story across multiple cards
6. **Video Ad Scripts** - Professional video hooks
7. **Thought Leadership** - Document ads, conversation ads

### Workflow 4: Ad Creative Testing
1. **Hypothesis Formation** - What are you testing and why
2. **Variable Isolation** - Test one element at a time
3. **Hook Variations** - Multiple opening approaches
4. **Benefit Angles** - Different value props
5. **CTA Testing** - Various call-to-action options
6. **Emotional vs Logical** - Different persuasion styles
7. **Winner Iteration** - Build on what works

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Facebook ad set | "Write Facebook ads for [product/offer]" |
| Google responsive ads | "Create Google responsive search ads for [keywords]" |
| LinkedIn ads | "Write LinkedIn sponsored content for [B2B offer]" |
| Ad hooks | "Generate 10 scroll-stopping hooks" |
| A/B variants | "Create ad copy variants to test [element]" |
| Retargeting copy | "Write retargeting ads for [audience]" |
| Video ad script | "Write script for [platform] video ad" |
| Carousel copy | "Create carousel ad copy for [product]" |

## Best Practices

- **Know platform limits** - Character counts vary by placement
- **Hook in 3 seconds** - Scroll speed is unforgiving
- **Benefit > Feature** - What's in it for them?
- **Specificity wins** - "147% increase" beats "dramatic growth"
- **Match message to stage** - Awareness vs consideration vs conversion
- **Test hooks first** - Opening line has highest impact
- **Use numbers** - Digits catch the eye
- **Create urgency** - Authentic time constraints work
- **Social proof** - Numbers, testimonials, logos
- **Clear CTA** - Tell them exactly what to do
- **Mobile-first** - Most social scrolling is mobile
- **Emoji strategy** - Use sparingly, test impact
- **Question hooks** - Engage with curiosity
- **Pain before gain** - Agitate problem, then solve
- **Consistent voice** - Match ad to landing page
