---
name: adapting-skills
description: Modifies existing skills for new contexts. Forks skills from repositories, adjusts for local conventions, and customizes behavior while preserving core functionality. Use when a skill is close but not quite right.
allowed-tools: Read, Write, WebFetch, Glob
---

# Adapting Skills

Modify an existing skill to fit a new context.

## When to Adapt vs Create New

**Adapt when:**
- Existing skill covers 70%+ of the need
- Changes are configuration, not architecture
- Core logic should be preserved

**Create new when:**
- Fundamental approach differs
- Would require rewriting most content
- Different domain entirely

## Adaptation Process

1. Read the source skill completely
2. Identify what needs to change
3. Fork to local skills directory
4. Make targeted modifications
5. Update name and description to reflect changes
6. Test with representative tasks

## Common Adaptations

- **Terminology** - Replace generic terms with domain-specific ones
- **Conventions** - Adjust coding style, formatting preferences
- **Scope** - Narrow or expand what the skill handles
- **Tools** - Swap underlying libraries or commands

## Preserve

- Core workflow logic
- Proven patterns
- Error handling
- Attribution to original source
