---
name: adr
description: Automatically detect architectural decisions and propose creating ADRs (Architecture Decision Records). Activate when user discusses choosing between options for data models, API design, system architecture, storage solutions, deployment strategies, caching approaches, authentication methods, error handling patterns, performance optimizations, or any decision that impacts system design. Always ask "Should I create an ADR for this decision?" when detected.
allowed-tools: [Read, Write, Glob, Bash]
---

# ADR (Architecture Decision Record) Skill

You are responsible for detecting and documenting architectural decisions.

## When to Propose an ADR

Monitor conversations for decisions that affect:

- **Data model** (schema changes, storage format, data relationships)
- **Module boundaries** (service separation, code organization, domain boundaries)
- **API contracts** (endpoint design, request/response formats, versioning)
- **Caching strategy** (what to cache, TTL, invalidation)
- **Architecture patterns** (event-driven, pub/sub, pipelines, CQRS)
- **Branching strategy** (git workflow, release process)
- **Deployment method** (containerization, serverless, infrastructure)
- **Storage choice** (SQL vs NoSQL, file storage, blob storage)
- **Service boundaries** (microservices, monolith, service mesh)
- **CI/CD structure** (build pipeline, testing strategy, deployment automation)
- **Performance constraints** (latency requirements, throughput, scalability)
- **Integration patterns** (webhooks, polling, streaming)
- **Authentication/Authorization** (auth strategy, session management, permissions)
- **Error handling** (retry logic, circuit breakers, fallbacks)

## When You Detect an Architectural Decision

Ask the user:
"This decision affects [aspect]. Should I create an ADR to document this?"

## ADR Template

Use this flexible template (omit sections not relevant to the conversation):

```markdown
# Decision: [Short Title]

Date: [YYYY-MM-DD]

## Context

[What led to this decision? What requirements, constraints, or problems exist?]

## Approach

[Describe the overall workflow, methodology, or implementation approach - this is often the most important section]

## Options Considered

[ONLY include if alternatives were explicitly discussed in the conversation]
- Option A: [brief description]
- Option B: [brief description]

## Decision Rationale

[Why this approach was chosen - key reasoning and goals]

## Trade-offs

[ONLY include if discussed - structure flexibly based on what was mentioned]

**Benefits:**
- [benefit 1]
- [benefit 2]

**Costs:**
- [tradeoff 1]
- [tradeoff 2]

**Impact:**
- [what systems/modules/workflows this affects]
```

## ADR Numbering

1. Check `/docs/adr/` for existing ADRs
2. Use sequential numbering: `0001`, `0002`, etc.
3. Format: `/docs/adr/NNNN-kebab-case-title.md`
4. Never overwrite existing ADRs

## ADR Index Maintenance

After creating an ADR, update `/docs/adr/index.md`:

```markdown
# Architecture Decision Records

1. [0001 - Decision Title](0001-decision-title.md)
2. [0002 - Another Decision](0002-another-decision.md)
```

## Rules

- Keep ADRs concise (not essays)
- One decision per ADR
- Always update the index
- Use today's date
- Focus on traceability, not perfection
