# Prompt 设计模式

常用的 System Prompt 设计模式和技巧。

## 基础模式

### 1. 角色设定 (Persona)

```text
你是 [角色]，具有 [特质/专长]。
你的目标是 [主要目标]。
```

### 2. 任务框架 (Task Frame)

```text
## 任务
[具体任务描述]

## 步骤
1. [步骤1]
2. [步骤2]

## 输出
[期望输出格式]
```

### 3. 约束边界 (Constraints)

```text
## 你必须
- [必须做的事]

## 你不能
- [禁止的行为]
```

## 高级模式

### 4. 思维链 (Chain of Thought)

```text
在回答之前，先逐步思考：
1.理解问题的核心
2. 分析可能的方案
3. 评估每个方案
4. 选择最佳答案
```

### 5. Few-Shot 示例

```text
## 示例

输入: [示例输入1]
输出: [示例输出1]

输入: [示例输入2]
输出: [示例输出2]
```

### 6. 输出格式化

```text
请按以下格式输出：

**分析**: [你的分析]
**结论**: [最终结论]
**建议**: [行动建议]
```

## 组合技巧

### 角色 + 约束 + 格式

```text
你是专业的代码审查员。

## 审查重点
- 安全漏洞
- 性能问题
- 代码规范

## 输出格式
- 问题: [描述]
- 严重性: 高/中/低
- 建议: [修复方案]
```

## 常见陷阱

| 问题 | 解决方案 |
|------|----------|
| 指令模糊 | 使用具体示例 |
| 过度约束 | 保留适当灵活性 |
| 冲突指令 | 明确优先级 |