#工具定义规范

Agent 工具的标准定义格式和最佳实践。

## 基本结构

```json
{
  "name": "tool_name",
  "description": "工具功能的清晰描述",
  "parameters": {
    "type": "object",
    "properties": {
      "param1": {
        "type": "string",
        "description": "参数说明"
      }
    },
    "required": ["param1"]
  }
}
```

## 参数类型

| 类型 | 说明 | 示例 |
|------|------|------|
| string | 文本 | `"hello"` |
| number | 数值 | `42`, `3.14` |
| integer | 整数 | `10` |
| boolean | 布尔 | `true`, `false` |
| array | 数组 | `[1, 2, 3]` |
| object | 对象 | `{"key": "value"}` |

## 参数约束

```json
{
  "param": {
    "type": "string",
    "enum": ["option1", "option2"],
    "minLength": 1,
    "maxLength": 100,
    "pattern": "^[a-z]+$"
  }
}
```

## 完整示例

```json
{
  "name": "search_documents",
  "description": "在文档库中搜索相关内容",
  "parameters": {
    "type": "object",
    "properties": {
      "query": {
        "type": "string",
        "description": "搜索关键词"
      },
      "limit": {
        "type": "integer",
        "description": "返回结果数量",
        "default": 10
      },
      "filters": {
        "type": "object",
        "description": "过滤条件",
        "properties": {
          "date_from": {"type": "string"},
          "date_to": {"type": "string"}
        }
      }
    },
    "required": ["query"]
  }
}
```

## 返回值规范

```json
{
  "success": true,
  "data": {},
  "error": null
}
```

## 错误码

| 码 | 说明 |
|----|------|
| 400 | 参数错误 |
| 404 | 资源不存在 |
| 500 | 内部错误 |

## 设计原则

1. **单一职责** - 每个工具只做一件事
2. **清晰命名** - 动词_名词 格式
3. **完整描述** - 说明用途和限制
4. **合理默认** - 提供sensible defaults