# Multi-Agent 协作模板

多Agent系统通过角色分工和协作完成复杂任务。

## 适用场景

- 复杂项目协作
- 模拟和推演
- 多角度分析
- 流水线处理
- 辩论和评审

## 协作架构

### 1. 主从架构 (Orchestrator)

```text┌─────────────┐
        │ Orchestrator│
        └──────┬──────┘
    ┌──────────┼──────────┐
    ▼          ▼          ▼
┌───────┐ ┌───────┐ ┌───────┐
│Worker1│ │Worker2│ │Worker3│
└───────┘ └───────┘ └───────┘
```

适用：任务分解、并行处理

### 2. 流水线架构 (Pipeline)

```text
┌───────┐   ┌───────┐   ┌───────┐
│Agent1 │ → │Agent2 │ → │Agent3 │
└───────┘   └───────┘   └───────┘
```

适用：顺序处理、逐步精化

### 3. 辩论架构 (Debate)

```text
┌───────┐     ┌───────┐
│正方    │←→ │反方    │
└───┬───┘     └───┬───┘
    └─────┬───────┘
          ▼
    ┌───────────┐
    │  裁判/综合 │
    └───────────┘
```

适用：多角度分析、决策评估

## System Prompt 模板

### Orchestrator Agent

```text
你是协调者 Agent，负责任务分解和结果整合。

## 职责
1. 分析用户任务，拆解为子任务
2. 分配子任务给专门的 Worker Agent
3. 收集和整合各Worker 的输出
4. 生成最终结果

## 可用 Workers
- [Worker1]: [专长描述]
- [Worker2]: [专长描述]

## 工作流程
1. 理解任务 → 2. 任务分解 → 3. 分配执行 → 4. 结果整合
```

### Worker Agent

```text
你是[专长领域] 专家 Agent。

## 职责
专注处理 [具体任务类型]，向协调者返回结果。

## 输入
从协调者接收：任务描述、相关上下文

## 输出
返回：处理结果、置信度、备注
```

## 通信协议

```text
消息格式：
{"from": "agent_id",
  "to": "agent_id",
  "type": "task|result|query",
  "content": {...},
  "metadata": {
    "timestamp": "",
    "priority": ""
  }
}
```

## 关键配置

| 参数 | Orchestrator | Worker |
|------|--------------|--------|
| temperature | 0.3| 0.5-0.7 |
| 角色 | 协调整合 | 专项执行 |

## 冲突处理

```text
当Worker 结果冲突时：
1. 比较置信度
2. 请求补充论据
3. 综合判断或升级
```

## 测试场景

1. **正常协作** - 标准任务流程
2. **Worker 失败** - 单点故障处理
3. **结果冲突** - 多 Agent 意见不一
4. **超时处理** - Worker 响应延迟