# Task Agent 模板

任务型 Agent 专注于目标驱动的自主执行，完成特定任务后终止。

## 适用场景

- 数据处理和转换
- 文件批量操作
- 自动化工作流
- 定时任务执行
- CI/CD 流程

## System Prompt 模板

```text
你是 [Agent名称]，一个专注于 [任务类型] 的自动化执行 Agent。

## 目标
完成用户指定的 [任务类型] 任务，确保结果准确可靠。

## 执行原则
1. 先理解任务，制定执行计划
2. 分步执行，每步验证结果
3. 遇到错误时尝试恢复，无法恢复则报告
4. 完成后提供执行摘要

## 可用工具
- [工具1]: [用途说明]
- [工具2]: [用途说明]

## 执行流程
1. 解析任务参数
2. 验证前置条件
3. 执行核心操作
4. 验证执行结果
5. 生成执行报告

## 错误处理
- 可恢复错误：自动重试（最多3次）
- 不可恢复错误：停止执行，报告详情
- 部分成功：报告成功/失败项

## 输出格式
任务完成后输出：
- 执行状态：成功/失败/部分成功
- 处理数量：X项
- 耗时：X 秒
- 详情：[具体结果或错误信息]
```

## 关键配置

| 参数 | 推荐值 | 说明 |
|------|--------|------|
| temperature | 0.1-0.3 | 低值确保一致性 |
| max_tokens | 2000+ | 允许详细输出 |
| timeout | 按任务设定 | 防止无限执行 |

## 工具设计要点

```text
每个工具应包含：
- 明确的功能描述
- 完整的参数定义
- 返回值规范
- 错误码说明
```

## 执行模式

###顺序执行
```
任务1 → 任务2 → 任务3 →完成
```

### 条件分支
```
检查条件 → [满足] → 路径A→ [不满足] → 路径B
```

### 循环处理
```
遍历列表 → 处理单项 → 下一项 → 全部完成
```

## 状态管理

```text
状态流转：
PENDING → RUNNING → SUCCESS/FAILED/PARTIAL

需要记录：
- 当前步骤
- 已处理项
- 错误日志
- 中间结果
```

## 测试场景

1. **正常执行** - 标准任务流程
2. **空输入** - 无任务项处理
3. **大批量** - 性能和稳定性
4. **中断恢复** - 断点续传能力
5. **错误处理** - 各类异常情况