# Wikipedia: Signs of AI Writing - Introduction

> **Source:** [Wikipedia:Signs of AI writing](https://en.wikipedia.org/wiki/Wikipedia:Signs_of_AI_writing)
>
> **This is an advice page from WikiProject AI Cleanup.** This page is not an encyclopedic article, nor one of Wikipedia's policies or guidelines, as it has not been thoroughly vetted by the community.

![A screenshot of ChatGPT reading: "[header] Legacy & Interpretation [body] The "Black Hole Edition" is not just a meme — it's a celebration of grassroots car culture, where ideas are limitless and fun is more important than spec sheets. Whether powered by a rotary engine, a V8 swap, or an imagined fighter jet turbine, the Miata remains the canvas for car enthusiasts worldwide."](https://upload.wikimedia.org/wikipedia/commons/thumb/4/49/Mazda_miata_black_hole_edition.jpg/500px-Mazda_miata_black_hole_edition.jpg)

LLMs tend to have an identifiable writing style.

## Purpose and Scope

This is a list of writing and formatting conventions typical of AI chatbots such as ChatGPT, with real examples taken from Wikipedia articles and drafts. It is meant to act as a field guide to help detect undisclosed AI-generated content on Wikipedia. This list is *descriptive*, not *prescriptive*; it consists of observations, not rules. Advice about formatting or language to avoid in Wikipedia articles can be found in the policies and guidelines and the Manual of Style, but does not belong on this page.

## Important Disclaimers

This list is *not* a ban on certain words, phrases, or punctuation. No one is taking your em-dashes away or claiming that only AI uses them. Not all text featuring the following indicators is AI-generated, as the large language models that power AI chatbots are trained on human writing, including the writing of Wikipedia editors. This is simply a catalog of very common patterns observed over many thousands of instances of AI-generated text, *specific to Wikipedia.* While some of its advice may be broadly applicable, some signs—particularly those involving punctuation and formatting—may not apply in a non-Wikipedia context.

The patterns here are also only potential *signs* of a problem, not *the problem itself*. While many of these issues are immediately obvious and easy to fix—e.g., excessive boldface, poor wordsmithing, broken markup, citation style quirks—they can point to less outwardly visible problems that carry much more serious policy risks. If LLM-generated text is polished enough (initially or subsequently tidied up), those surface defects might not be present, but the deeper problems likely will. Please do not merely treat these signs as the problems to be fixed; that could just make detection harder. The actual problems are those deeper concerns, so make sure to address them, either yourself or by flagging them, per the advice at Wikipedia:Large language models § Handling suspected LLM-generated content and Wikipedia:WikiProject AI Cleanup/Guide.

## Speedy Deletion Criteria

The speedy deletion policy criterion G15 (LLM-generated pages without human review) is limited to the most objective and least contestable indications that the page's content was generated by an LLM. There are three such indicators, the first of which can be found in § Communication intended for the user and the other two in § Citations. The other signs, though they may indeed indicate AI use, are not sufficient for speedy deletion.

## AI Detection Tools

Do not solely rely on artificial intelligence content detection tools (such as GPTZero) to evaluate whether text is LLM-generated. While they perform better than random chance, these tools have nontrivial error rates and cannot replace human judgment.

## Statistical Regression to the Mean

LLMs (and artificial neural networks in general) use statistical algorithms to guess (infer) what should come next based on a large corpus of training material. It thus tends to regress to the mean; that is, the result tends toward the most statistically likely result that applies to the widest variety of cases. It can simultaneously be a strength and a "tell" for detecting AI-generated content.

For example, LLMs are usually trained on data from the internet in which famous people are generally described with positive, important-sounding language. It will thus sand down specific, unusual, nuanced facts (which are statistically rare) and replace them with more generic, positive descriptions (which are statistically common). Thus the specific detail "invented a train-coupling device" might become "a revolutionary titan of industry." LLMs tend to smooth out unusual details and drift toward the most common, statistically probable way of describing a topic. It is like shouting louder and louder that a portrait shows a uniquely important person, while the portrait itself is fading from a sharp photograph into a blurry, generic sketch. The subject becomes simultaneously less specific and more exaggerated.

This statistical regression to the mean, a smoothing over of specific facts into generic statements that could apply to many topics, makes AI-generated content easier to detect.
