---
name: ai-content-quality-checker
description: AI生成コンテンツの総合品質チェックスキル。読みやすさ、正確性、関連性、独自性、SEO、アクセシビリティ、エンゲージメント、文法・スタイルを多角的に評価。
---

# AI Content Quality Checker Skill

AI生成コンテンツを多角的に評価し、総合的な品質をチェックするスキルです。

## 概要

このスキルは、AIが生成したあらゆるコンテンツ（記事、ドキュメント、ブログ、マーケティング文書等）を包括的に評価します。読みやすさ、正確性、SEO、アクセシビリティ、エンゲージメント、独自性など、多角的な観点から品質をチェックし、改善提案を行います。

## 主な機能

- **読みやすさ評価**: Flesch Reading Ease、文章の複雑さ、段落構造
- **正確性チェック**: 事実、統計、引用の正確性
- **関連性評価**: トピックとの関連性、対象読者への適合性
- **独自性チェック**: オリジナリティ、盗用の可能性
- **SEO評価**: キーワード、メタデータ、構造化データ
- **アクセシビリティ**: 読みやすさ、代替テキスト、構造
- **エンゲージメント**: 魅力度、行動喚起、ストーリー性
- **文法・スタイル**: 文法、スペル、表記の一貫性
- **技術的品質**: コード例、図表、リンクの品質
- **総合スコア**: 0-100点の品質評価

## 評価項目

### 1. 読みやすさ (Readability)

#### Flesch Reading Ease スコア

```
計算式:
206.835 - 1.015 × (総単語数 / 総文数) - 84.6 × (総音節数 / 総単語数)

スコア:
90-100: 非常に読みやすい（小学5年生レベル）
60-70:  普通（中学生レベル）
30-50:  やや難しい（大学生レベル）
0-30:   非常に難しい（大学院レベル）
```

#### 評価例

```
テキスト分析:
総単語数: 450
総文数: 25
平均文長: 18語
総音節数: 680

Flesch Reading Ease: 62
レベル: 普通（中学生レベル）

評価: ✓ 一般読者に適切
推奨: このレベルを維持
```

#### 文章の複雑さ

```
チェック項目:
- 平均文長: 15-25語が理想
- 長文の割合: 30語以上の文が20%以下
- 受動態の使用: 全体の10%以下
- 難解な語彙: 専門用語の適切な説明
```

**評価例**:
```
問題検出:
❌ 長文が多い（平均35語）
  → 推奨: 文を分割して平均20語以下に

⚠️ 受動態が多い（25%）
  → 推奨: 能動態に変更して明確に

✓ 専門用語に説明あり
```

#### 段落構造

```
チェック項目:
- 段落の長さ: 3-5文が理想
- 見出しの頻度: 3-4段落ごとに見出し
- 箇条書きの活用: 複数項目の列挙に使用
```

### 2. 正確性 (Accuracy)

#### 事実確認

```
検証項目:
✓ 日付・年号: 正確か
✓ 人名・組織名: スペルが正確か
✓ 統計データ: 出典が明記されているか
✓ 技術情報: 最新の情報か
✓ 引用: 正確な引用か
```

**評価例**:
```
事実チェック結果:

✓ 「React は 2013年に公開」→ 正確
✓ 「Facebook（現Meta）が開発」→ 正確
❌ 「市場シェア85%」→ 出典不明（要修正）
⚠️ 「最も人気のあるフレームワーク」→ 基準不明（曖昧）

正確性スコア: 75/100
推奨: 統計データに出典を追加
```

#### 技術的正確性

```
コード例のチェック:
✓ 構文エラーなし
✓ ベストプラクティスに準拠
✓ 最新のAPI使用
✓ セキュリティ上の問題なし
✓ 動作する完全なコード
```

### 3. 関連性 (Relevance)

#### トピックとの関連性

```
評価基準:
- タイトルと内容の一致度
- キーワードの適切な使用
- 話題のブレなし
- 深さと広さのバランス
```

**評価例**:
```
タイトル: 「TypeScriptの型システム入門」

内容分析:
✓ 型システムの説明: 60%（関連性高）
⚠️ JavaScriptの歴史: 15%（やや逸脱）
❌ Webpackの設定: 10%（無関係）
✓ 実践例: 15%（関連性高）

関連性スコア: 70/100
問題: Webpackの説明は別記事に分離すべき
```

#### 対象読者への適合性

```
対象読者: 初心者エンジニア（経験1年未満）

チェック項目:
✓ 前提知識が明記されている
❌ 高度な概念が説明なしに使用
✓ 用語集あり
⚠️ ステップバイステップの説明が不足

適合性スコア: 65/100
推奨: 各ステップをより詳しく説明
```

### 4. 独自性 (Originality)

#### オリジナリティ評価

```
チェック項目:
- 独自の視点・分析
- 独自の例・コード
- 独自の図表
- 他記事にない情報
```

**評価例**:
```
独自性分析:

✓ 独自の実装例あり
✓ 独自のユースケース提示
⚠️ 一般的な説明が多い（60%）
❌ 他のチュートリアルと類似したコード例

独自性スコア: 55/100
推奨: より具体的な実プロジェクトの例を追加
```

#### 盗用チェック

```
類似度分析:
- 外部ソースとの類似度チェック
- 公式ドキュメントからのコピペ検出
- 適切な引用の有無

警告レベル:
緑: 類似度 < 15%（問題なし）
黄: 類似度 15-30%（要確認）
赤: 類似度 > 30%（盗用の疑い）
```

### 5. SEO評価

#### タイトル最適化

```
チェック項目:
✓ 長さ: 50-60文字（理想）
✓ キーワード含む
✓ 魅力的な表現
✓ クリック誘導

評価例:
タイトル: 「React Hooks完全ガイド - useState, useEffect の使い方」

長さ: 32文字 ✓
キーワード: React, Hooks, useState, useEffect ✓
魅力度: 「完全ガイド」で価値を明示 ✓

SEOスコア: 85/100
```

#### メタディスクリプション

```
チェック項目:
✓ 長さ: 120-160文字
✓ キーワード含む
✓ 行動喚起
✓ 価値提案

評価例:
「React Hooksの基本から応用までを網羅。useState, useEffectの
実践的な使い方をコード例付きで解説します。」

長さ: 68文字 ⚠️ 短い（もっと詳しく）
キーワード: ✓
価値提案: ✓

推奨: 150文字程度に拡充
```

#### キーワード最適化

```
主要キーワード: 「React Hooks」

分析:
- 出現頻度: 15回（適切）
- キーワード密度: 1.8%（理想は1-2%）
- 見出しでの使用: 3/5（60%）✓
- 最初の100語以内: ✓

関連キーワード:
- useState: 12回 ✓
- useEffect: 10回 ✓
- カスタムフック: 3回 ⚠️ 増やす推奨

キーワードスコア: 82/100
```

#### 構造化データ

```
推奨される構造化データ:

Article Schema:
{
  "@type": "Article",
  "headline": "...",
  "author": "...",
  "datePublished": "2024-11-22",
  "image": "..."
}

BreadcrumbList:
ホーム > 技術記事 > React > Hooks

HowTo Schema（該当する場合）:
ステップバイステップの手順を構造化
```

### 6. アクセシビリティ

#### コンテンツアクセシビリティ

```
チェック項目:

✓ 見出し階層が正しい（H1 → H2 → H3）
✓ 画像に代替テキスト
✓ リンクテキストが説明的
✓ コントラスト比（テキスト推奨）
✓ 言語指定（lang属性）

評価例:
❌ 見出しがH1 → H3に飛んでいる
✓ 画像の代替テキストあり
⚠️ 「ここをクリック」などの曖昧なリンク

アクセシビリティスコア: 70/100
```

#### スクリーンリーダー対応

```
チェック項目:
- セマンティックHTML使用
- ARIAラベルの適切な使用
- 表の見出しセル明記
- フォーム要素のラベル
```

### 7. エンゲージメント

#### 魅力度

```
評価基準:
- 導入部の引きつけ
- ストーリー性
- 具体例の質
- ビジュアル要素
- 行動喚起
```

**評価例**:
```
導入部:
「Reactを学び始めたあなた、Hooksに戸惑っていませんか？
この記事を読めば、Hooksの本質を理解できます。」

評価: ✓ 読者の課題を明示、価値を提示

ストーリー性:
⚠️ 事実の羅列が多い
推奨: 具体的なシナリオを追加

具体例:
✓ 実践的なコード例が豊富

魅力度スコア: 75/100
```

#### 行動喚起 (CTA)

```
チェック項目:
- CTAの明確性
- 配置（記事の終わり、中間）
- 魅力的な文言
- 次のステップの明示

評価例:
CTA: 「今すぐ試してみよう！」

明確性: ⚠️ やや曖昧（何を試す？）
推奨: 「このコードをあなたのプロジェクトで試してみよう」
```

### 8. 文法・スタイル

#### 文法チェック

```
チェック項目:
✓ スペルミスなし
✓ 文法エラーなし
✓ 句読点の適切な使用
✓ 敬体/常体の統一
```

**検出例**:
```
問題点:
❌ 「あります」「ある」が混在 → 統一すべき
❌ 「、」の使いすぎ → 文を分割
⚠️ 専門用語の表記揺れ（TypeScript/type script）

文法スコア: 70/100
```

#### スタイルの一貫性

```
チェック項目:
- トーン（フォーマル/カジュアル）の統一
- 視点（一人称/二人称）の統一
- 用語の表記統一
- 数字の表記（全角/半角）統一
```

### 9. 技術的品質

#### コード例の品質

```
チェック項目:
✓ シンタックスハイライト
✓ 言語指定
✓ コメント付き
✓ 実行可能
✓ ベストプラクティス準拠

評価例:
```javascript
// ✓ 良い例
function fetchUser(id) {
  return fetch(`/api/users/${id}`)
    .then(response => response.json())
    .catch(error => {
      console.error('Error:', error);
      throw error;
    });
}
```

// ❌ 悪い例（エラーハンドリングなし）
function fetchUser(id) {
  return fetch(`/api/users/${id}`)
    .then(response => response.json());
}
```
```

#### リンクの品質

```
チェック項目:
✓ リンク切れなし
✓ HTTPSリンク
✓ 信頼できるソース
✓ リンクテキストが説明的
✓ 外部リンクに target="_blank"

評価例:
問題検出:
❌ リンク切れ: 2件
⚠️ HTTPリンク: 1件（HTTPSに変更推奨）
✓ 説明的なリンクテキスト
```

## 総合評価レポート

### レポート形式

```markdown
# コンテンツ品質評価レポート

## サマリー
- **総合スコア**: 78/100
- **評価日**: 2024-11-22
- **コンテンツタイプ**: 技術記事
- **対象読者**: 初心者〜中級者

## スコア内訳

| 項目 | スコア | 評価 |
|------|--------|------|
| 読みやすさ | 85/100 | 良好 |
| 正確性 | 75/100 | 改善推奨 |
| 関連性 | 80/100 | 良好 |
| 独自性 | 65/100 | 改善必要 |
| SEO | 82/100 | 良好 |
| アクセシビリティ | 70/100 | 改善推奨 |
| エンゲージメント | 75/100 | 改善推奨 |
| 文法・スタイル | 88/100 | 優秀 |
| 技術的品質 | 80/100 | 良好 |

## 詳細分析

### ✓ 優れている点
1. 文章が読みやすく、適切な長さ
2. 文法・スタイルが統一されている
3. SEO対策が適切

### ⚠️ 改善推奨
1. 統計データに出典を追加（正確性向上）
2. 独自の視点・例を増やす（独自性向上）
3. 見出し階層を修正（アクセシビリティ向上）

### ❌ 重大な問題
なし

## 改善提案

### 優先度: 高
1. **統計データに出典を追加**
   - 該当箇所: 3か所
   - 修正例: 「85%の開発者が使用（Stack Overflow Survey 2024）」

### 優先度: 中
2. **独自の実装例を追加**
   - 現状: 一般的なチュートリアル例が中心
   - 推奨: 実プロジェクトでの応用例を1-2個追加

3. **見出し階層を修正**
   - 問題: H1 → H3への飛び
   - 修正: H2を挿入

### 優先度: 低
4. **メタディスクリプションを拡充**
   - 現状: 68文字
   - 推奨: 150文字程度に

## ベンチマーク比較

同カテゴリの平均スコア: 72/100
あなたのスコア: 78/100

**評価**: 平均を上回る良好なコンテンツ
```

## 使用例

### 基本的な品質チェック

```
以下の記事を品質チェックしてください：

[記事全文]

評価項目: すべて
出力: 総合スコアと主な改善点
```

### 詳細レポート生成

```
以下の技術ブログ記事を詳細に評価してください：

[記事全文]

評価項目:
- 読みやすさ
- 正確性
- SEO
- エンゲージメント
- 技術的品質

対象読者: 初心者エンジニア
コンテンツタイプ: チュートリアル記事

出力形式: 詳細レポート（改善提案含む）
```

### SEO特化チェック

```
以下の記事のSEOを評価してください：

タイトル: [タイトル]
メタディスクリプション: [説明]
本文: [本文]

主要キーワード: React Hooks
関連キーワード: useState, useEffect, カスタムフック

SEO改善提案を詳細に提示してください。
```

### アクセシビリティチェック

```
以下のHTMLコンテンツのアクセシビリティを評価してください：

[HTML]

WCAG 2.1 レベルAA準拠を目標に、
問題点と修正案を提示してください。
```

### 複数記事の比較評価

```
以下の3つの記事を比較評価してください：

記事A: [テキスト]
記事B: [テキスト]
記事C: [テキスト]

評価基準:
- 総合品質
- SEO
- エンゲージメント

最も優れた記事を選択し、理由を説明してください。
```

## ベストプラクティス

1. **コンテキストの考慮**: 対象読者とコンテンツタイプに応じた評価
2. **バランス**: すべての項目をバランスよくチェック
3. **実用的な提案**: 実装可能な改善提案
4. **優先順位付け**: 重要度に応じた改善の順序
5. **ベンチマーク**: 同カテゴリの平均と比較
6. **継続的改善**: 定期的な品質チェック

## バージョン情報

- スキルバージョン: 1.0.0
- 最終更新: 2025-11-22

---

## 使用例まとめ

### シンプルなチェック

```
この記事の品質をチェックしてください：
[記事]
```

### 詳細な評価

```
以下の記事を詳細に評価してください：
[記事]

対象読者: [読者層]
コンテンツタイプ: [タイプ]
重視項目: [項目]

詳細レポートを生成してください。
```

このスキルで、AI生成コンテンツの品質を確保し、読者満足度を向上させましょう！
