# Community Impact Assessment

Evaluation of effects on communities, power dynamics, and stakeholder engagement.

## Stakeholder Analysis

### Affected Communities Identification

| Community | Relationship to System | Power Level | Impact Level |
|-----------|----------------------|-------------|--------------|
| [Community 1] | [Subject/User/Adjacent] | [High/Med/Low] | [High/Med/Low] |
| [Community 2] | | | |
| [Community 3] | | | |

### Prioritization Framework
Prioritize engagement with communities that are:
1. Most directly affected
2. Most vulnerable to harm
3. Least able to advocate for themselves
4. Historically marginalized
5. Bearing costs without receiving benefits

## Community Engagement

### Engagement Spectrum
| Level | Description | When Appropriate |
|-------|-------------|------------------|
| **Inform** | One-way communication | Low stakes, simple changes |
| **Consult** | Gather input | Moderate stakes, some flexibility |
| **Involve** | Ongoing dialogue | Significant impact |
| **Collaborate** | Shared decision-making | High stakes, community expertise needed |
| **Empower** | Community-led | Community most affected |

### Engagement Methods
| Method | Strengths | Limitations |
|--------|-----------|-------------|
| Surveys | Scalable, quantifiable | Surface-level, non-representative |
| Focus groups | Rich qualitative data | Small sample, facilitator bias |
| Public comment | Democratic, documented | Self-selecting, power imbalances |
| Advisory boards | Ongoing relationship | Tokenism risk, representation questions |
| Participatory design | Deep engagement | Resource intensive, slower |
| Community researchers | Insider knowledge | Training needed, compensation issues |

### Authentic Engagement Criteria
- [ ] Engagement early enough to influence design
- [ ] Adequate time for meaningful participation
- [ ] Accessible format (language, location, technology)
- [ ] Compensation for community members' time
- [ ] Clear how input will be used
- [ ] Feedback loop on decisions made

## Power Dynamics Analysis

### Power Mapping
| Actor | Type of Power | How System Affects Power |
|-------|---------------|-------------------------|
| System owner | Economic, informational | [Increases/Decreases] |
| Operators | Operational | [Increases/Decreases] |
| Subjects | | [Increases/Decreases] |
| Marginalized groups | | [Increases/Decreases] |
| Regulators | Legal | [Increases/Decreases] |

### Questions to Consider
1. Who gains power from this system?
2. Who loses power?
3. Does this reinforce existing inequities?
4. Are those most affected also making decisions?
5. What voice do affected communities have?

## Equity Analysis

### Distributional Equity
- Who receives the benefits of this system?
- Who bears the costs and risks?
- Are benefits and burdens fairly distributed?

### Procedural Equity
- Who is involved in decision-making?
- Are processes accessible to all?
- Is information equally available?

### Recognitional Equity
- Whose knowledge and experience is valued?
- Are all groups treated with dignity?
- Are cultural differences respected?

### Restorative Equity
- Does this address historical harms?
- Does this create new harms requiring repair?
- What accountability exists?

## Impact Categories

### Economic Impacts
- [ ] Job displacement or creation
- [ ] Wage effects
- [ ] Access to economic opportunity
- [ ] Wealth distribution effects
- [ ] Market concentration

### Social Impacts
- [ ] Effects on relationships and community
- [ ] Trust in institutions
- [ ] Social cohesion or division
- [ ] Stigmatization
- [ ] Cultural effects

### Political Impacts
- [ ] Effects on political participation
- [ ] Power over public discourse
- [ ] Democratic accountability
- [ ] Civil liberties

### Access Impacts
- [ ] Effects on access to services
- [ ] Digital divide considerations
- [ ] Accessibility for disabled users
- [ ] Language access

## Community Harm Assessment

### Harm Categories
| Harm Type | Description | Affected Groups | Severity |
|-----------|-------------|-----------------|----------|
| Exclusion | Denied access to opportunities | | |
| Surveillance | Privacy/autonomy violations | | |
| Manipulation | Behavior modification | | |
| Discrimination | Unfair treatment | | |
| Exploitation | Extracting value unfairly | | |
| Dependency | Reducing self-sufficiency | | |

### Compounding Harms
Consider how harms may compound for individuals facing multiple marginalization (intersectionality).

## Community Benefits Assessment

### Benefit Types
- Direct benefits (services, opportunities)
- Indirect benefits (efficiency gains passed on)
- Participatory benefits (voice, agency)
- Capacity building (skills, knowledge)

### Benefit Distribution
- Are benefits reaching intended communities?
- Are there barriers to accessing benefits?
- Are benefits sustainable?

## Output: Community Impact Summary

```markdown
## Community Impact Assessment

### Affected Communities
1. [Community 1]: [Impact description]
2. [Community 2]: [Impact description]
3. [Community 3]: [Impact description]

### Engagement Conducted
- Method: [Description]
- Participants: [Description]
- Key findings: [Summary]

### Power Dynamics
- Power shifts: [Who gains/loses]
- Equity concerns: [Description]

### Key Impacts
| Category | Positive | Negative |
|----------|----------|----------|
| Economic | | |
| Social | | |
| Access | | |

### Harms Identified
1. [Harm 1]: Affected [group], Severity [level]
2. [Harm 2]: Affected [group], Severity [level]

### Benefits Identified
1. [Benefit 1]: Benefiting [group]
2. [Benefit 2]: Benefiting [group]

### Recommendations
1. [Engagement recommendation]
2. [Mitigation recommendation]
3. [Benefit enhancement recommendation]
```

## Key Questions

1. Have affected communities been meaningfully engaged?
2. Who bears the costs and who receives the benefits?
3. Does this system increase or decrease power inequities?
4. Are marginalized communities adequately protected?
5. Is there accountability to affected communities?
