# Context & Impact Assessment

Foundation module for comprehensive ethics assessment. Load this first.

## System Context Analysis

### Purpose Definition
- **Primary objective**: What is the system designed to do?
- **Success metrics**: How is success measured? (Consider if metrics align with ethical goals)
- **Stakeholders**: Who commissioned, builds, operates, and is affected by this system?

### Deployment Context
- **Domain**: What sector/industry?
- **Scale**: How many people affected? Geographic scope?
- **Integration**: How does this fit into existing processes?
- **Alternatives**: What happens without this system?

### Historical Context
- **Previous approaches**: What came before? Why the change?
- **Known issues**: What problems existed in previous systems?
- **Power dynamics**: Who gains/loses power with this system?

## Impact Assessment Framework

### Direct Impact Analysis

| Stakeholder Group | Positive Impacts | Negative Impacts | Severity (1-5) | Likelihood (1-5) |
|-------------------|------------------|------------------|----------------|------------------|
| [Group 1] | | | | |
| [Group 2] | | | | |
| [Group 3] | | | | |

### Indirect Impact Analysis
- **Second-order effects**: What behaviors might change in response?
- **Market effects**: How might this affect competition, access, pricing?
- **Social effects**: How might this affect relationships, communities, trust?

### Differential Impact Assessment
- **Privileged groups**: Who is best served by this system?
- **Marginalized groups**: Who might be underserved or harmed?
- **Historical disadvantage**: Does this reinforce or address historical inequities?

## Risk Categorization

### Impact Severity Scale
| Level | Description | Examples |
|-------|-------------|----------|
| 1 - Minimal | Inconvenience only | Slightly slower service |
| 2 - Minor | Temporary setback | Need to resubmit application |
| 3 - Moderate | Significant but recoverable | Delayed access to service |
| 4 - Severe | Major lasting impact | Job loss, credit damage |
| 5 - Critical | Fundamental rights affected | Loss of liberty, healthcare denial |

### Vulnerability Factors
- Economic precarity
- Language/literacy barriers
- Disability status
- Immigration status
- Age (very young or elderly)
- Historical discrimination
- Geographic isolation
- Digital access limitations

## Stakeholder Mapping

### Power-Interest Grid

```
High Power
    │
    │   Keep Satisfied  │  Manage Closely
    │   (regulators)    │  (executives, users)
    ├───────────────────┼───────────────────
    │   Monitor         │  Keep Informed
    │   (general public)│  (affected communities)
    │
    └───────────────────┴───────────────────► High Interest
```

### Affected Communities Identification
1. **Primary users**: Those who directly interact with the system
2. **Subjects**: Those about whom decisions are made
3. **Operators**: Those who run and maintain the system
4. **Overseers**: Those responsible for governance
5. **Adjacent communities**: Those indirectly affected

## Key Questions to Answer

1. Who bears the costs if this system fails?
2. Who cannot opt out of this system?
3. What recourse do affected individuals have?
4. How does this shift power between parties?
5. What precedent does this set?

## Output: Context Summary

```markdown
## Context & Impact Summary

### System Overview
- **Purpose**: [Description]
- **Domain**: [Sector]
- **Scale**: [Number affected, geographic scope]

### Key Stakeholders
- **Decision makers**: [Who]
- **Operators**: [Who]
- **Affected populations**: [Who]

### Critical Impact Areas
1. [Impact area 1]: [Severity] / [Likelihood]
2. [Impact area 2]: [Severity] / [Likelihood]
3. [Impact area 3]: [Severity] / [Likelihood]

### Vulnerability Concerns
- [Concern 1]
- [Concern 2]

### Power Dynamics
- [Key observation about power shifts]

### Recommended Focus Areas
Based on this analysis, prioritize:
- [ ] [Module 1]
- [ ] [Module 2]
```
