# Regulatory Compliance

Overview of AI-specific regulations and compliance requirements.

## EU AI Act

### Risk Classification

| Risk Level | Examples | Requirements |
|------------|----------|--------------|
| **Unacceptable** | Social scoring, real-time biometric ID in public | Prohibited |
| **High-Risk** | Employment, credit, education, law enforcement, migration | Full compliance required |
| **Limited Risk** | Chatbots, emotion recognition, deepfakes | Transparency obligations |
| **Minimal Risk** | Spam filters, AI in games | No specific requirements |

### High-Risk Categories (Annex III)
1. Biometric identification and categorization
2. Critical infrastructure management
3. Education and vocational training
4. Employment, worker management, self-employment access
5. Essential services access (credit, emergency, benefits)
6. Law enforcement
7. Migration, asylum, border control
8. Justice and democratic processes

### High-Risk Requirements
- [ ] Risk management system
- [ ] Data governance
- [ ] Technical documentation
- [ ] Record-keeping
- [ ] Transparency and user information
- [ ] Human oversight
- [ ] Accuracy, robustness, cybersecurity
- [ ] Quality management system
- [ ] Conformity assessment
- [ ] EU database registration

### Prohibited Practices
- Subliminal manipulation causing harm
- Exploitation of vulnerabilities
- Social scoring by public authorities
- Real-time remote biometric ID in public (with exceptions)
- Emotion inference in workplace/education (with exceptions)
- Biometric categorization for sensitive attributes
- Scraping facial images for databases
- Predictive policing based solely on profiling

## US Framework

### Federal Level
- No comprehensive AI regulation (as of knowledge cutoff)
- Sector-specific regulations apply
- Executive orders on AI safety and rights
- FTC enforcement on deceptive/unfair practices

### Sector-Specific
| Sector | Key Regulations | Relevance to AI |
|--------|-----------------|-----------------|
| Employment | Title VII, ADA, ADEA | Hiring algorithms, accommodation |
| Credit | ECOA, FCRA | Lending models, credit scoring |
| Healthcare | HIPAA, FDA | Clinical decision support, diagnostics |
| Housing | Fair Housing Act | Tenant screening, advertising |
| Education | FERPA, Title IX | EdTech, admissions algorithms |
| Financial | GLBA, SEC rules | Trading algorithms, advice |

### State Laws
- **Colorado AI Act**: Disclosure requirements for high-risk AI
- **Illinois BIPA**: Biometric data consent
- **NYC Local Law 144**: Automated employment decision tools audit
- Various state privacy laws (CCPA, VCDPA, etc.)

## Domain-Specific Compliance

### Employment AI
- [ ] Adverse impact testing (4/5ths rule)
- [ ] Job-relatedness validation
- [ ] ADA interactive process preserved
- [ ] EEOC guidance followed
- [ ] State-specific requirements (NYC LL144 audit)

### Credit/Lending AI
- [ ] ECOA adverse action notices
- [ ] FCRA accuracy requirements
- [ ] Fair lending testing
- [ ] Model risk management (SR 11-7)
- [ ] Explainability for denials

### Healthcare AI
- [ ] FDA clearance if medical device
- [ ] Clinical validation
- [ ] HIPAA compliance
- [ ] Informed consent
- [ ] Provider oversight

## Compliance Checklist

### Documentation Requirements
- [ ] System description and intended purpose
- [ ] Risk assessment
- [ ] Data governance documentation
- [ ] Testing and validation results
- [ ] Bias assessment results
- [ ] Human oversight procedures
- [ ] Monitoring plan

### Operational Requirements
- [ ] Human oversight in place
- [ ] Logging and record-keeping active
- [ ] Incident reporting process
- [ ] Regular accuracy assessment
- [ ] Bias monitoring ongoing

### Transparency Requirements
- [ ] Users informed AI is in use
- [ ] Clear explanation of AI role
- [ ] Appeal/human review available
- [ ] Contact information provided

## Compliance Timeline (EU AI Act)

| Milestone | Date | Requirements |
|-----------|------|--------------|
| Prohibited AI | Feb 2025 | Prohibitions in effect |
| GPAI rules | Aug 2025 | General purpose AI requirements |
| High-risk (Annex III) | Aug 2026 | Full compliance required |
| High-risk (existing) | Aug 2027 | Existing systems in Annex I |

## Risk Assessment Template

```markdown
## Regulatory Risk Assessment

### System Classification
- EU AI Act: [Unacceptable/High/Limited/Minimal]
- Sector regulations: [Applicable regulations]
- Jurisdiction: [Geographic scope]

### Applicable Requirements
1. [Requirement]: [Status]
2. [Requirement]: [Status]
3. [Requirement]: [Status]

### Compliance Gaps
| Gap | Severity | Remediation | Timeline |
|-----|----------|-------------|----------|
| | | | |

### Documentation Status
- [ ] System documentation complete
- [ ] Testing documentation complete
- [ ] Governance documentation complete

### Ongoing Obligations
- [Monitoring requirement]: [Frequency]
- [Reporting requirement]: [Frequency]
- [Audit requirement]: [Frequency]
```

## Key Questions

1. What risk category does this system fall into?
2. Which jurisdictions' laws apply?
3. What sector-specific regulations apply?
4. What documentation is required?
5. What ongoing compliance obligations exist?
