# AI-Native Workflow: How-To Guide

> *"AI drafts, you decide timing and personal touches."*

---

## THE BIG PICTURE

You now have 4 AI habits built into your pipeline. Here's the one-liner for each:

| Habit | What It Does | When You Need It |
|-------|--------------|------------------|
| **1. BREADCRUMBS** | Links AI work to where you'll find it later | After any useful AI chat |
| **2. SWIPE FILES** | Shows winning emails by stage | Before writing any email |
| **3. TASK MAPPING** | Tells you what's YOU vs what's AI | Before starting any stage work |
| **4. PROMPT LIBRARY** | Lists commands that actually work | When you need the right command |

---

# HABIT 1: AI BREADCRUMBS

## The Rule

**If conversation >10 minutes OR produces reusable output → anchor immediately.**

Don't wait. Don't batch. Anchor while context is fresh.

## Where Things Go

```
                    PRIMARY (Source of Truth)
                    ┌─────────────────────────┐
                    │      HubSpot Notes      │
                    │  via /log-activity      │
                    └───────────┬─────────────┘
                                │
                    "Full analysis: See [Deal]_Folder/..."
                                │
                                ▼
                    SECONDARY (Deep Archive)
                    ┌─────────────────────────┐
                    │   Git Deal Folder       │
                    │   _NOTES.md or          │
                    │   Customer_Relationship │
                    │   _Documentation.md     │
                    └─────────────────────────┘
```

## The Mapping

| What You Created | Where It Goes | How |
|------------------|---------------|-----|
| Meeting summary | HubSpot Notes | `/log-activity` |
| Stage change | HubSpot Notes | `/update-deal` |
| Deep analysis | Git `_NOTES.md` | Save file, link in HubSpot |
| Email draft | Git `EMAIL_TO_[NAME]_*.md` | Save to deal folder |
| Brand Scout | `Brand Scout Reports/` | Save report, link when lead→deal |
| AI chat insight | HubSpot Notes (summary) | "Analysis generated via Claude [date]" |

## Anchor Triggers

Ask yourself:
- [ ] Did this chat go >10 minutes?
- [ ] Did I produce something reusable?
- [ ] Did I make a decision?
- [ ] Did I generate an email/analysis/report?

**If YES to any → anchor now.**

---

# HABIT 2: AI SWIPE FILES

## The Rule

**Before writing any external email, check what's worked before.**

## Swipe File Locations

| Stage | What's Available | Location |
|-------|------------------|----------|
| [04] Proposal Follow-up | 7 winning emails | `swipe-files/proposal-followups.md` |
| [09] Win-Back | 7 winning emails | `swipe-files/winbacks.md` |
| All Stages | Universal patterns | `swipe-files/patterns-summary.md` |

## [04] Proposal Follow-Up Cadence

| Day | Pattern | Key Move |
|-----|---------|----------|
| Day 1 | Delivery + Next Steps | Deliver rates, ask for specific meeting day |
| Day 3 | Soft Check-In | 2 sentences, assume progress |
| Day 7 | Value-Add Analysis | Send analysis they didn't ask for |
| Day 10 | Meeting Request | 3 specific times + booking link |
| Day 14 | Progress + Timeline | Show internal progress, create urgency |

## [09] Win-Back Scenarios

| Scenario | Pattern | Trigger |
|----------|---------|---------|
| They Ghosted | Re-engage with value | 90+ days silence |
| You Dropped Ball | Own + Times + Forward | Your mistake |
| Service Crisis | Acknowledge + Fix + Future | Their crisis |
| 90-Day Reminder | News hook + Check-in | Task triggers |

## Universal Golden Rules

| DO THIS | NOT THIS |
|---------|----------|
| Specific time slots | "When are you free?" |
| "I need X to complete Y" | "Just checking in" |
| Post-meeting recap + action items | Assuming they remember |
| "Can you confirm..." | Vague asks |
| 2 sentences | 2 paragraphs |

## Quick Diagnosis

| Problem | Use This Pattern |
|---------|------------------|
| Prospect went dark | "I'll have an update after [time]..." |
| Need a meeting | 3 specific times + booking link |
| Nothing's moving | Unprompted analysis |
| You dropped the ball | Own + reason + times + forward |
| Deal is stuck | 2-sentence soft check-in |

---

# HABIT 3: TASK MAPPING (YOU vs AI)

## The Rule

**Before any task >1 hour, list micro-tasks and mark each as M (Manual) or AI.**

## Stage Transition Mappings

### [01] Discovery Scheduled → [02] Discovery Complete

| Task | YOU | AI |
|------|-----|-----|
| Schedule the call | ✅ | Draft calendar invite |
| Pre-call research | Review/approve | ✅ `/brand-scout:scout` |
| Conduct discovery call | ✅ | — |
| Log meeting summary | Review/edit | ✅ Draft from bullet notes |
| Update HubSpot stage | One-click approve | ✅ Execute |
| Identify next action | ✅ Decide | ✅ Suggest based on 38 Questions |

### [02] Discovery Complete → [03] Rate Creation

| Task | YOU | AI |
|------|-----|-----|
| Review discovery notes | ✅ | — |
| Request rate creation | ✅ Submit | ✅ Draft request format |
| Gather shipping data | ✅ Request from prospect | ✅ Draft data request email |
| Analyze shipping profile | Review findings | ✅ Run analysis |
| Update deal stage | ✅ | ✅ Execute |

### [03] Rate Creation → [04] Proposal Sent

| Task | YOU | AI |
|------|-----|-----|
| Review rates from pricing | ✅ | — |
| Build proposal deck | Review/customize | ✅ Draft |
| Draft proposal email | Review/personalize | ✅ Draft |
| Send proposal | ✅ | — |
| Log activity | ✅ Trigger | ✅ Execute |
| Set follow-up reminders | ✅ Approve | ✅ Create tasks |

### [04] Proposal Sent → [05] Setup Docs Sent

| Task | YOU | AI |
|------|-----|-----|
| Receive verbal commit | ✅ | — |
| Generate setup docs | ✅ Trigger | ✅ Generate |
| Draft handoff email | Review | ✅ Draft |
| Send setup docs | ✅ | — |
| Update deal stage | ✅ | ✅ Execute |
| Schedule implementation kick-off | ✅ | Draft invite |

## The Decision Framework

**When unsure if M (Manual) or AI:**

| Question | If YES → |
|----------|----------|
| Does it require judgment? | Manual |
| Does it require your relationship? | Manual |
| Is it repetitive/templated? | AI |
| Does it need creativity within constraints? | AI |

---

# HABIT 4: PROMPT LIBRARY

## The Rule

**Use battle-tested commands. Don't reinvent prompts.**

## High Reliability Commands (Daily Use)

| Command | What It Does | When |
|---------|--------------|------|
| `/brand-scout:scout [Company]` | Full 9-section lead intel | Before outreach |
| `/check-lead [Company]` | HubSpot duplicate check | Before creating lead |
| `/add-lead [Company]` | Create company + contacts | After check clears |
| `/cvm-goals weekly` | Full funnel dashboard | Morning ritual |
| `/create-followup` | Draft follow-up email | Stages 2,4,5,6 |
| `/check-tasks` | Daily task review | Every morning |

## Medium Reliability Commands (As Needed)

| Command | What It Does | When |
|---------|--------------|------|
| `/deal-snapshot [Deal]` | Quick status summary | Before calls |
| `/update-deal` | Stage change + context | Stage transitions |
| `/log-activity` | Anchor breadcrumb to HubSpot | After meetings/chats |
| `/meeting-summary` | Summarize call notes | After discovery |
| `/coach-me` | Sales coaching | When stuck |
| `/next-action` | Suggest next move | When unsure |
| `/pipeline-health` | Stage analysis | Weekly review |

## Command Reliability Ratings

```
HIGH RELIABILITY (95%+) → Use confidently, works every time
├── /brand-scout:scout
├── /check-lead
├── /add-lead
├── /cvm-goals
├── /create-followup
└── /check-tasks

MEDIUM RELIABILITY (80-95%) → Works, may need context
├── /deal-snapshot
├── /update-deal
├── /log-activity
├── /meeting-summary
├── /coach-me
└── /next-action
```

---

# QUICK REFERENCE CARD

## Morning Ritual
```
1. /cvm-goals weekly    → See where you stand
2. /check-tasks         → What's due today
3. Pick top 3 actions   → Focus for the day
```

## Before Writing Any Email
```
1. What stage? → Check swipe file for that stage
2. What pattern? → Match situation to pattern
3. AI draft → Review/personalize → Send
```

## After Any AI Chat >10 min
```
1. Did I create something reusable? → YES
2. /log-activity → HubSpot note
3. Save file → Deal folder
4. Cross-link → Note references file
```

## Before Any Stage Transition
```
1. Check task mapping for this transition
2. Mark what's YOU vs AI
3. AI does drafts, YOU approves/sends
4. /update-deal when complete
```

---

## File Locations

```
.claude/skills/ai-native-workflow/
├── SKILL.md                           ← Main definition
├── HOW_TO_USE.md                      ← This guide
└── references/
    ├── breadcrumb-architecture.md     ← Anchoring rules
    ├── prompt-library.md              ← Battle-tested commands
    ├── task-templates.md              ← YOU vs AI mappings
    └── swipe-files/
        ├── patterns-summary.md        ← Universal patterns
        ├── proposal-followups.md      ← 7 winning [04] emails
        └── winbacks.md                ← 7 winning [09] emails
```

---

*"I can only show you the door. You're the one that has to walk through it."*

**Version**: 1.0
**Created**: 2025-12-14
**Framework**: The Nebuchadnezzar v3.2
