# Breadcrumb Architecture

> AI Breadcrumbs: Hyperlink AI conversations to workspace where output is used

## The 10-Minute Rule

**If conversation >10 minutes OR produces reusable output → anchor immediately.**

Don't wait. Don't batch. Anchor while context is fresh.

---

## Primary + Secondary System

```
HubSpot Notes (Primary - Source of Truth)
├── Activity timeline (calls, emails, meetings)
├── Stage change notes (with context)
└── Key decision breadcrumbs
        │
        └── Cross-link: "Full analysis: See [Deal]_Folder/_NOTES.md"
                │
                ▼
Git Deal Folder (Secondary - Deep Archive)
├── _NOTES.md or Customer_Relationship_Documentation.md
├── Brand Scout Report (if converted from lead)
├── Analysis outputs (PLD summaries, rate comparisons)
├── Proposal docs
└── Contract/implementation docs
```

---

## What Goes Where

| Content Type | Primary Location | Cross-Link Pattern |
|--------------|------------------|-------------------|
| Activity logs | HubSpot Notes | Auto-logged via `/log-activity` |
| Stage changes | HubSpot Notes | `/update-deal` adds context |
| Deep analysis | Git `_NOTES.md` | Link in HubSpot note |
| Brand Scout reports | `Brand Scout Reports/[Company]_*.md` | Link when lead→deal |
| Email drafts | `[DEAL]/EMAIL_TO_[NAME]_*.md` | — |
| Meeting recaps | HubSpot Notes | Summary in note, full in Git |
| AI chat outputs | HubSpot Notes (summary) | "Analysis generated via Claude [date]" |

---

## Anchoring Workflows

### After Discovery Call

1. `/log-activity` → HubSpot note with:
   - Meeting summary (3-5 bullets)
   - Key decisions
   - Action items with ownership
2. Git deal folder:
   - Save `Discovery_Notes.md` with full details
   - Update `Customer_Relationship_Documentation.md`

### After Analysis/Report

1. `/log-activity` → HubSpot note with:
   - "Analysis completed: [type]"
   - Key findings (2-3 bullets)
   - Cross-link: "Full report: See [Deal]_Folder/[filename]"
2. Git deal folder:
   - Save analysis output file
   - Update `_NOTES.md` with summary

### After AI Chat Produces Output

1. Determine output type:
   - Email draft → Save to `[DEAL]/EMAIL_TO_[NAME]_[date].md`
   - Analysis → Save to `[DEAL]/[type]_Analysis_[date].md`
   - Strategy → Save to `[DEAL]/_NOTES.md` (append)
2. HubSpot note: "AI output generated: [description]. See [filename]"

---

## File Naming Conventions

**Deal folders:**
```
[XX-STAGE]_Company_Name\
  ├── Customer_Relationship_Documentation.md
  ├── Discovery_Notes.md
  ├── Discovery_Complete.md
  ├── Deal_Status_Update_[YYYY-MM-DD].md
  ├── FINAL_PROPOSAL_SUMMARY.md
  ├── EMAIL_TO_[NAME]_[YYYY-MM-DD].md
  ├── [Company]_Analysis.py
  ├── [Company]_Audit_v3.xlsx
  └── *.csv (raw data)
```

**Brand Scout Reports:**
```
Brand Scout Reports\
  ├── [Company]_Brand_Scout_Report.md
  └── [Company]_Email_Sequence.md
```

---

## Cross-Link Templates

**HubSpot note referencing Git:**
```
Analysis completed: Zone optimization review
Key findings:
- 42% potential savings on Expedited
- 70% Select network eligibility
- DAS savings opportunity: $12K/year

Full report: See [04-PROPOSAL-SENT]_OTW_Holdings/OTW_Zone_Analysis_2025-01-15.md
```

**Git file referencing HubSpot:**
```
## Related HubSpot Activity

- Deal: [OTW Holdings](hubspot-link)
- Stage: 04-Proposal Sent
- Last activity: 2025-01-15 - Zone analysis sent
```

---

## Why Not Notion?

Adding a third system increases friction. HubSpot + Git covers:

| Need | Solution |
|------|----------|
| CRM visibility | HubSpot |
| Deep technical analysis | Git |
| Version control | Git |
| Search | Both |
| Mobile access | HubSpot app |
| Collaboration | HubSpot (internal), Git (code review) |

**Rule:** If you can't find it in 30 seconds, the breadcrumb system is broken.

---

## Quick Reference

**Anchor to HubSpot:**
```
/log-activity
```

**Anchor to Git:**
```
Save file to: C:\Users\BrettWalker\FirstMile_Deals\[XX-STAGE]_Deal_Name\
```

**Cross-link pattern:**
```
"Full analysis: See [Deal]_Folder/[filename].md"
```

**10-Minute Rule trigger:**
- Conversation >10 minutes? → Anchor
- Produced reusable output? → Anchor
- Made a decision? → Anchor
- Generated an email/analysis/report? → Anchor
