# Prompt Library - Battle-Tested Commands

> "10-15 battle-tested prompts, not 1000 random ones" - Jeff Su

## Reliability Ratings

| Rating | Meaning | Criteria |
|--------|---------|----------|
| HIGH | 95%+ works every time | Daily rotation, minimal context needed |
| MEDIUM | 80-95% may need context | Works but benefits from more detail |
| EXPERIMENTAL | <80% hit or miss | New or complex, may need iteration |

---

## High Reliability Commands

These work consistently and are in daily rotation:

| Command | Purpose | Stage | Mode | Reliability |
|---------|---------|-------|------|-------------|
| `/brand-scout:scout [Company]` | Full 9-section lead intel | 00→01 | Red Pill | HIGH |
| `/check-lead [Company]` | HubSpot duplicate check | 00 | Internal | HIGH |
| `/add-lead [Company]` | Create company + contacts | 00→01 | Internal | HIGH |
| `/cvm-goals weekly` | Full funnel dashboard | All | Red Pill | HIGH |
| `/check-tasks` | Daily task review | Daily | Internal | HIGH |
| `python unified_sync.py 9am` | Morning sync | Daily | Internal | HIGH |
| `python unified_sync.py eod` | End-of-day sync | Daily | Internal | HIGH |

---

## Medium Reliability Commands

These work but may need context or refinement:

| Command | Purpose | Stage | Mode | Reliability |
|---------|---------|-------|------|-------------|
| `/create-followup` | Draft follow-up email | 02,04,05,06 | Blue Pill | MEDIUM |
| `/deal-snapshot [Deal]` | Quick deal status | 04,05,07,08 | Red Pill | MEDIUM |
| `/update-deal` | Stage change + context | All | Internal | MEDIUM |
| `/log-activity` | Anchor breadcrumb to HubSpot | 02,04,05 | Internal | MEDIUM |
| `/meeting-summary` | Summarize call notes | 02,03 | Red Pill | MEDIUM |
| `/pipeline-health` | Stage analysis | Analysis | Red Pill | MEDIUM |
| `/next-action` | Suggest next move | When stuck | Internal | MEDIUM |
| `/complete-task [ID]` | Mark task complete | Daily | Internal | MEDIUM |

---

## Experimental Commands

New or complex, may need iteration:

| Command | Purpose | Stage | Mode | Reliability |
|---------|---------|-------|------|-------------|
| `/coach-me` | Sales coaching guidance | 02,03,05 | Internal | EXPERIMENTAL |
| `/contact-insights [Contact]` | Contact research | 02,03 | Red Pill | EXPERIMENTAL |
| `/dedupe-tasks` | Clean duplicate tasks | Maintenance | Internal | EXPERIMENTAL |

---

## Command Details

### `/brand-scout:scout [Company]`

**Purpose:** Generate comprehensive lead intelligence report

**Output:** 9-section report including:
1. Company Overview & Shipping Profile
2. Current Pain Points
3. Competitive Landscape
4. FirstMile Value Proposition Match
5. Estimated Savings Potential
6. Strategic Approach Recommendations
7. Key Stakeholders to Target
8. Tech & Marketing Stack
9. Growth Signals & News

**Best for:** New leads before outreach, discovery call prep

---

### `/cvm-goals weekly`

**Purpose:** Full pipeline dashboard with priorities

**Output:**
- Stage-by-stage deal counts
- Stale deals (by aging threshold)
- Priority actions for today
- Conversion metrics

**Best for:** Morning ritual, pipeline reviews

---

### `/create-followup`

**Purpose:** Draft contextual follow-up email

**Input needed:** Deal context (usually pulled from conversation)

**Output:** Draft email using appropriate swipe file pattern

**Best for:** [04] proposal follow-ups, [05] doc follow-ups

---

### `/deal-snapshot [Deal]`

**Purpose:** Quick status summary of specific deal

**Output:**
- Current stage + days in stage
- Last activity
- Next scheduled action
- Key contacts
- Blockers/risks

**Best for:** Before calls, quick reference

---

### `/update-deal`

**Purpose:** Move deal to new stage with context

**Input needed:** 
- Deal name
- New stage
- Context/reason for move

**Output:** HubSpot updated + note logged

**Best for:** Stage transitions

---

### `/log-activity`

**Purpose:** Anchor breadcrumb to HubSpot deal

**Input needed:**
- Deal name
- Activity type (call, email, meeting, note)
- Summary

**Output:** Activity logged to HubSpot timeline

**Best for:** Post-call logging, anchoring AI chat outputs

---

## Prompt Patterns (Not Commands)

### Shipping Data Analysis

```
Please analyze the provided shipping data to clearly outline:
• Service Level Performance: Percent delivered by service level
• Total Shipments: Count of all shipments processed
• Key Metrics: Average days in transit, total volume, SLA targets
• Xparcel Type: Breakdown and performance by service level
• Carrier & Product Analysis: Distribution by carrier and product

Include concise bullet points, tables, and charts.
```

**Use with:** `analysis_skill.md`

---

### Discovery Call Summarizer

```
Summarize this discovery call transcript using this structure:

1. Participants Present
2. Shipping Software & Systems Used
3. Order Volumes (daily, weekly, monthly, annual)
4. Current Carriers & Service Providers
5. Domestic & International Coverage
6. Commodities & Specs
7. Pain Points & Challenges
8. Goals & Needs
9. Action Items (with ownership)
10. Additional Notes

If no data available for section: "Not Provided or Unclear"
```

**Use with:** `/meeting-summary`

---

### Email Draft (Blue Pill)

```
Draft a follow-up email for [prospect] at [company].

Context:
- Current stage: [stage]
- Days since last contact: [days]
- Last interaction: [summary]
- Goal: [desired outcome]

Use these patterns:
- If Day 3: 2 sentences max, assume they're reviewing
- If Day 7: Add value unprompted
- If Day 10: 3 specific times + booking link
- If Day 14: Soft breakup or escalation
```

---

## Versioning Notes

Current versions in use:
- Brand Scout: v3.7 template
- Communication templates: v3.0
- Slash commands: No formal versioning

**Recommendation:** When a prompt gets significant update, append version (e.g., `brand-scout-v4.md`)

---

## Stage-by-Stage Command Routing

**When you're at a stage and need help, use these:**

### [00] Lead Generation
```
/brand-scout:scout [Company]    → Generate full intel report
/check-lead [Company]           → Check if exists in HubSpot
/add-lead [Company]             → Create company + contacts
```
**Swipe File:** `discovery-outreach.md`

### [01] Discovery Scheduled
```
/brand-scout:scout [Company]    → Pre-call research
/deal-snapshot [Deal]           → Quick status check
```
**Swipe File:** `internal-analysis.md` (Discovery Prep Sheet)

### [02] Discovery Complete
```
/meeting-summary                → Summarize call notes
/update-deal                    → Move to Rate Creation
/create-followup                → Draft data request
```
**Swipe File:** `internal-analysis.md` (Meeting Debrief)

### [03] Rate Creation
```
/deal-snapshot [Deal]           → Check status while waiting
/create-followup                → Follow up on PLD request
```
**Swipe File:** `internal-analysis.md` (Customer Shipping Analysis)

### [04] Proposal Sent
```
/create-followup                → Draft Day 3/7/10/14 emails
/deal-snapshot [Deal]           → Quick momentum check
/update-deal                    → Move forward or back
```
**Swipe File:** `proposal-followups.md`

### [05] Setup Docs Sent
```
/create-followup                → Draft doc reminder
/deal-snapshot [Deal]           → Track implementation
```
**Swipe File:** `patterns-summary.md`

### [06] Implementation → [07] Closed Won
```
/update-deal                    → Mark closed won
/log-activity                   → Final notes
```
**Swipe File:** N/A

### [08] Closed Lost → [09] Win-Back
```
/deal-snapshot [Deal]           → Review loss context
/create-followup                → Draft win-back email
```
**Swipe File:** `winbacks.md`

---

## Mode Reference

| Mode | Purpose | Examples |
|------|---------|----------|
| Blue Pill | Customer-facing communication | Emails, proposals, recaps |
| Red Pill | Internal analysis | PLD summary, Brand Scout, Snapshots |
| Internal | System operations | Stage updates, task management |

---

## Quick Diagnosis

**If stuck, ask yourself:**

| Situation | Command to try |
|-----------|----------------|
| "What's the status of X deal?" | `/deal-snapshot [Deal]` |
| "What should I do next?" | `/next-action` |
| "How's my pipeline overall?" | `/cvm-goals weekly` |
| "I need to follow up" | `/create-followup` |
| "I just had a call" | `/meeting-summary` |
| "Is this lead in HubSpot?" | `/check-lead [Company]` |
| "I need to research a company" | `/brand-scout:scout [Company]` |
| "I need to log something" | `/log-activity` |

---

## Anti-Patterns

```
NEVER:
- Invent new prompts when battle-tested ones exist
- Skip checking the swipe file for your stage
- Use experimental commands for critical tasks
- Chain 5+ commands without checking results

ALWAYS:
- Check prompt library before inventing
- Match command to current stage
- Use HIGH reliability for important actions
- Verify outputs before sending external
```
