# Cold Outreach Snippets

Modular email pieces for B2B sales outreach. Mix and match as needed.

**Source**: FirstMile Knowledge Base
**Last Updated**: 2025-12-19
**Tone**: Confident, direct, peer-to-peer. Not salesy. Not corporate.

---

## OPENING LINES (Pattern-Interrupt Hooks)

1. Your carrier announced 5.9%. You're actually paying 12%. Here's why.

2. Quick question: When's the last time you audited your surcharge stack?

3. Noticed [Company] ships lightweight goods. Curious if you're hitting minimum charge floors.

4. Your invoices probably don't match your rate card. Most don't.

5. Not sure who handles shipping at [Company], but this landed in my lap and seemed relevant.

---

## VALUE PROP ONE-LINERS

6. We route each parcel to the lowest-cost carrier that still hits your SLA.

7. One contract, 12 carriers, no rate-shopping required.

8. Ounce-based pricing—no more $11.99 floors on 4oz packages.

9. Residential surcharges don't stack when you zone-skip through our hubs.

10. Budget predictability: we absorb carrier rate volatility, you don't.

---

## PAIN POINT CALLOUTS

11. Residential surcharges went up 8.4%. That's not in the headline GRI.

12. UPS made 7 fuel surcharge changes last year alone. Hard to budget around that.

13. DIM triggers hit bulky-but-light items hardest—furniture, apparel, kits.

14. Single-carrier contracts = zero leverage when rates jump mid-year.

15. Off-cycle adjustments are the silent budget killer nobody talks about.

---

## SOFT CTAs

16. Worth a 15-minute look? I can pull comps for your volume profile.

17. Happy to run your shipment data through our rate engine—no commitment.

18. If you're renegotiating soon, might be useful context. Open to a quick call?

19. Send me a recent invoice. I'll show you where the margin leak is.

20. Not selling anything today—just curious if this matches what you're seeing.

---

## SIGN-OFF LINES

21. Either way, hope this was useful context for your next carrier review.

22. No pressure—just figured you'd want to see the math.

23. Let me know if I'm off base. Always learning.

24. Happy to be a resource even if timing isn't right.

25. Talk soon—or don't. Your call.

---

## MIX/MATCH COMBOS

| # | Use Case | Hook | Pain/Value | CTA | Sign-off |
|---|----------|------|------------|-----|----------|
| 1 | **Cold Opener (GRI angle)** | #1 | #11 | #17 | #21 |
| 2 | **Cold Opener (Budget angle)** | #2 | #15 | #17 | #22 |
| 3 | **Low-Pressure Follow-Up** | #5 | #10 | #20 | #24 |
| 4 | **Invoice Review** | #4 | #12 | #19 | #22 |
| 5 | **Lightweight Goods** | #3 | #8 | #16 | #21 |
| 6 | **Multi-Carrier Pitch** | #2 | #7 + #14 | #18 | #25 |
| 7 | **DIM Weight Victims** | #4 | #13 | #19 | #22 |
| 8 | **Contract Renegotiation** | #1 | #14 | #18 | #24 |
| 9 | **Zone-Skip Opportunity** | #5 | #9 + #11 | #16 | #23 |
| 10 | **Breakup Email** | #5 | #10 | #20 | #25 |

### Quick Reference

| Type | Best Numbers |
|------|--------------|
| Hooks | #1, #2 (pattern-interrupt), #4, #5 (soft) |
| Pain | #11 (residential), #12 (fuel), #13 (DIM), #14 (leverage), #15 (off-cycle) |
| Value | #7 (multi-carrier), #8 (ounce-based), #9 (zone-skip), #10 (predictability) |
| CTA | #17 (no-commitment), #18 (timing), #19 (strongest), #20 (low-pressure) |
| Sign-off | #21-22 (neutral), #24-25 (soft close) |

### Quick Tips

- Pair #1 or #2 (hook) + #11 or #15 (pain) + #17 (CTA) for cold openers
- Use #20 + #24 for low-pressure follow-ups
- #19 is your strongest conversion line - use when they're engaged

---

## GOLDEN RULES

- Specific > Vague ("8.4% residential surcharge increase" beats "surcharges went up")
- 2 sentences > 2 paragraphs
- "I can show you X" > "Let me know if you're interested"
- End with choice, not obligation ("Your call" > "Looking forward to hearing from you")

---

## BATCH SCHEDULING WORKFLOW (Added Jan 2026)

**Pattern**: Separate drafting (deep work) from scheduling (mechanical)

### Email Queue Format (`MONDAY_EMAIL_QUEUE.md`)

```markdown
# EMAIL 1 of 15
**To**: Jamil Bhuya
**Email**: jamil@yellowbeauty.com
**Subject**: Yellow Beauty's 9-country complexity

[Full body copy here - ready for paste]

---
# EMAIL 2 of 15
...
```

**Why It Works**: Sequential format enables copy-paste workflow without scrolling back.

### Superhuman Batch Schedule

1. Open draft or compose new
2. Paste body from queue file
3. `Ctrl+Shift+L` - Opens Send Later dialog
4. Type time: "Monday 7:45 am"
5. `Ctrl+Enter` - Confirms scheduling (NOT just Enter)
6. Screenshot to verify "scheduled." notification
7. Repeat for next email

**Critical**: Enter alone CLOSES the dialog without scheduling. MUST use Ctrl+Enter.

### Verification Step

After scheduling, always verify:
- Screenshot shows "scheduled." notification
- Email no longer in drafts
- Check Scheduled folder for confirmation

**Typical Performance**: 15 emails scheduled in ~20 minutes
