# [02] Discovery Outreach Swipe Files

> Blue Pill Mode - Cold outreach patterns that get replies and meetings scheduled

## Outreach Formula

```
Day 1: Initial hook (2-3 sentences, specific question)
Day 4: Value-add follow-up (insight they didn't ask for)
Day 8: Social proof / industry angle
Day 14: Soft breakup OR phone call
Day 45-60: Trigger-based re-engagement (GRI, news, peak)
```

---

## Winning Patterns

```
Good Subject Lines:
"Quick question about [Company]'s shipping mix"
"[Name], curious about your carrier split"
"Do you control all [Company]'s volume?"
"Zone [X] pricing - [Company]"

Bad Subject Lines:
"Introduction from FirstMile"
"Partnership opportunity"
"Checking in"
"Following up"

Good Hooks:
- Specific observation from research
- Question about their business
- Industry trend + their situation
- "Not trying to sell you anything in [month]"

Bad Hooks:
- "I noticed your company..."
- "We help brands like yours..."
- "Do you have 15 minutes?"
- Generic value prop
```

---

## WINNER #1: The Volume Reality Hook

**Context:** Brand Scout research revealed PE-backed DTC brand shipping from TX

**Subject:** Quick question about CapuTron's shipping mix

```
Hi Zach,

Doing some research on CapuTron - looks like you're shipping transcranial stimulation devices out of Texas, primarily through FedEx.

Quick question that's been on my mind:

Of your total parcel volume, how much do you actually control vs. what's locked to marketplaces or 3PL decisions?

I ask because January rate increases hit in 6 weeks, and the brands who know their REAL addressable volume are the ones who can actually do something about it.

Not trying to sell you anything in December - I know you're buried in peak. Just curious if this is something you've mapped out.

Brett Walker
Revenue Architect, FirstMile

P.S. - If you're seeing zone 8 pricing pressure to the coasts, happy to share what similar med-tech brands are doing.
```

**Why it worked:**
- Shows research done - Knows their product, location, carrier
- Specific question - Not generic "let's connect"
- Removes pressure - "Not trying to sell you in December"
- P.S. hook - Relevant pain point from research

**Result:** Reply with interest in January conversation.

---

## WINNER #2: The "Former Customer" Curiosity Opener

**Context:** Win-back outreach for brand that left 6+ months ago

**Subject:** Sparkle In Pink question

```
Hey Ali,

Ron mentioned you're a former FirstMile customer - we had a chance to chat and your name came up.

I'm genuinely curious: what happened?

Not trying to sell you on coming back - I just want to understand what we could have done differently. The feedback helps us improve.

If you have 5 minutes, I'd appreciate the candid insight.

Brett
```

**Why it worked:**
- Name-dropped internal champion (Ron)
- Curiosity, not sales pitch
- Asked for their perspective
- Short and respectful of time

**Result:** Opened dialogue that led to reconnection conversation.

---

## WINNER #3: Day 4 Value-Add (After No Reply)

**Context:** No reply to initial outreach, prospect at 3PL

**Subject:** Re: Quick question about Stackd's carrier mix

```
Hi Landon,

Following up on my note from Monday. Did some digging on 3PLs in your footprint.

Quick observation: most 3PLs shipping 20K+ packages/month from Utah are leaving 12-18% on the table in zone-based pricing because they're treating all destinations the same.

Your Denver-to-Utah corridor alone could be a different service level than your Zone 8 traffic.

Would a 15-minute zone analysis be useful? No commitment - just math.

Brett
```

**Why it worked:**
- Specific insight - Zone-based pricing opportunity
- Their geography - Utah, Denver corridor
- Easy ask - "15-minute zone analysis"
- No commitment - Just math

**Result:** Reply requesting the analysis, led to discovery call.

---

## WINNER #4: LinkedIn Engagement Follow-Up

**Context:** Prospect engaged with LinkedIn post, had researched them prior

**Subject:** Re: Your comment on multi-carrier complexity

```
Hi David,

Thanks for engaging with my post on multi-carrier complexity. Noticed you're at Swifthouse - looks like you're scaling fulfillment operations pretty aggressively.

The comment you left got me thinking:

When you hit 500K packages/year, the carrier math changes completely. The single-carrier simplicity that got you there becomes a constraint.

Is that a conversation happening internally, or is it still "future problem" territory?

Either way - happy to be a resource when the time comes.

Brett
```

**Why it worked:**
- Referenced their engagement
- Specific milestone (500K packages)
- Binary question - Easy to answer
- No pressure - "when the time comes"

**Result:** Reply that led to discovery scheduling.

---

## WINNER #5: The PE/Growth Angle

**Context:** PE-backed brand with growth mandate

**Subject:** [Company]'s multi-carrier complexity - margin opportunity

```
Hi Patricia,

Researching Gap Inc's Athleta logistics structure - impressive operation.

One pattern I keep seeing in PE-backed brands at your scale: the complexity of managing 3-4 carriers for different service levels eats margin faster than the volume discounts they negotiated.

It's a weird dynamic - you get better rates at scale, but the operational overhead to manage those rates often costs more than the savings.

Is that resonating, or is Athleta structured differently?

Brett Walker
Revenue Architect, FirstMile
```

**Why it worked:**
- Acknowledged their scale and sophistication
- Specific pain point (multi-carrier complexity)
- Framed as industry pattern, not criticism
- Open-ended question - Invites dialogue

**Result:** (Pending - example of executive outreach pattern)

---

## WINNER #6: The Italian Greeting (Cultural Personalization)

**Context:** Italian-named executive, research showed international background

**Subject:** Buongiorno Marco - domanda veloce

```
Buongiorno Marco,

Researching your shipping operation at Morelli Foods - impressive DTC growth in the specialty food space.

Quick question: Are you managing carriers in-house or through your 3PL? The answer changes the conversation completely.

Most food/beverage brands at your volume (looks like 5-10K packages/month based on your SKU count) are overpaying on zone 4-8 traffic by 15-20% because perishable surcharges get buried in the rates.

Worth a 10-minute conversation in January, or is carrier selection out of your hands?

Grazie,
Brett
```

**Why it worked:**
- Cultural personalization (Italian greeting)
- Shows detailed research (SKU count, volume estimate)
- Industry-specific insight (perishable surcharges)
- Binary qualifier - "In your hands or not?"

**Result:** Reply with Italian response, opened warm dialogue.

---

## Cadence Template

### Cold Outreach Sequence (New Lead)

| Day | Channel | Pattern | Key Move |
|-----|---------|---------|----------|
| Day 1 | Email | Initial hook | Specific question from Brand Scout |
| Day 4 | Email | Value-add | Insight unprompted |
| Day 8 | Email | Social proof | Similar company case study |
| Day 14 | Phone | Call attempt | Voice message + short email |
| Day 21 | Email | Soft breakup | "Not the right time?" |
| Day 45-60 | Email | Trigger | GRI, news, industry event |

### Reply Scenarios

**If they reply with question:**
- Answer directly
- Add one 38 Questions qualifier
- Propose specific time

**If they reply with objection:**
- Acknowledge, don't argue
- Pivot to "genuinely curious" stance
- Keep door open for future

**If no reply after Day 21:**
- Stop sequence
- Add to 90-day re-engagement list
- Flag for trigger-based outreach

---

## Subject Line A/B Tests

**For DTC Brands:**
- "Quick question about [Company]'s shipping mix"
- "[Name], curious about your carrier split"
- "Zone [X] to [Region] - [Company]"

**For 3PLs:**
- "Multi-tenant carrier strategy?"
- "[Company]'s per-client carrier cost"
- "3PL margin math question"

**For PE-Backed:**
- "[Company]'s logistics margin post-investment"
- "Growth mandate + carrier complexity"
- "Question for [Company]'s ops team"

---

## Anti-Patterns (What NOT to do)

```
NEVER:
- "I hope this email finds you well"
- "I wanted to reach out because..."
- "We're the leading provider of..."
- "Do you have 15 minutes for a call?"
- "I noticed your company on [generic source]"
- Multiple questions in one email
- Attachments in first email
- "Per my last email..."
- Em-dashes (Brett preference)

ALWAYS:
- One specific question
- Research-backed observation
- Low-pressure positioning
- Clear next step or binary question
- P.S. with relevant hook
```
