# [03] Internal Analysis Swipe Files

> Red Pill Mode - Internal work products AI generates for system use (not customer-facing)

## When to Use Red Pill Mode

```
Customer-facing communication? → Use Blue Pill (discovery-outreach.md, proposal-followups.md)
Internal analysis/documentation? → Use Red Pill (this file)
```

---

## Analysis Categories

| Category | Output Type | Destination |
|----------|-------------|-------------|
| PLD Analysis | Shipping profile summary | Deal folder |
| Transit Performance | SLA compliance report | Deal folder + HubSpot note |
| Brand Scout | Lead intelligence | `Brand Scout Reports/` |
| Discovery Prep | Call prep sheet | Deal folder |
| Meeting Debrief | Summary + next steps | HubSpot note |
| Deal Snapshot | Pipeline position | HubSpot note |

---

## WINNER #1: PLD Analysis Summary

**Context:** Customer sent Parcel Level Detail export for rate analysis

**Output Location:** `[##-STAGE]_Company_Name/Customer_Shipping_Analysis.md`

```markdown
## SHIPPING PROFILE: [Company Name]

**Analysis Date**: [Date]
**Data Period**: [Start] to [End] ([X] days)
**Source File**: [filename.xlsx]

---

### Volume Profile

| Metric | Value |
|--------|-------|
| Total Shipments | XX,XXX |
| Daily Average | X,XXX |
| Monthly Run Rate | XX,XXX |

### Carrier Mix

| Carrier | Volume | % | Spend | % |
|---------|--------|---|-------|---|
| FedEx | X,XXX | XX% | $XX,XXX | XX% |
| USPS | X,XXX | XX% | $XX,XXX | XX% |
| UPS | X,XXX | XX% | $XX,XXX | XX% |

### Weight Distribution

| Range | Volume | % | Avg Cost |
|-------|--------|---|----------|
| 0-1 lb | X,XXX | XX% | $X.XX |
| 1-5 lb | X,XXX | XX% | $X.XX |
| 5+ lb | X,XXX | XX% | $X.XX |

**Optimization Flag**: XXX packages at 15.99oz+ threshold

### Zone Distribution

| Zone | Volume | % | Avg Transit |
|------|--------|---|-------------|
| 1-4 (Regional) | X,XXX | XX% | X.X days |
| 5-8 (Cross-Country) | X,XXX | XX% | X.X days |

### Top Destination States

| State | Volume | % | Hub Assignment |
|-------|--------|---|----------------|
| CA | X,XXX | XX% | LAX - West Coast |
| TX | X,XXX | XX% | DFW - South Central |
| FL | X,XXX | XX% | MIA - Southeast |

---

### FirstMile Opportunity

**Network Allocation**:
- Select Network (metro hubs): XX% eligible
- National Network (all ZIPs): XX%

**Service Level Mapping**:
- Xparcel Ground (3-8d): XX% volume → $X.XX avg
- Xparcel Expedited (2-5d): XX% volume → $X.XX avg
- Xparcel Priority (1-3d): XX% volume → $X.XX avg

**Estimated Annual Savings**: $XX,XXX - $XX,XXX (XX-XX%)

---

*Analysis generated by The Nebuchadnezzar v3.3*
```

**Why it works:**
- Follows FIRSTMILE.md framework exactly
- Leads with volume metrics (not daily delivery %)
- Uses correct service terminology (Xparcel Ground/Expedited/Priority)
- Never names specific carriers in recommendations
- Includes hub mapping for top states
- Quantifies savings opportunity

---

## WINNER #2: Transit Executive Summary

**Context:** Performance report for customer QBR or internal review

**Output Location:** `[##-STAGE]_Company_Name/Transit_Performance_[Date].md`

```markdown
## TRANSIT PERFORMANCE: [Company Name]

**Report Period**: [Start] to [End]
**Service Level**: Xparcel [Ground/Expedited/Priority]
**SLA Window**: [3/5/8] business days

---

### SLA COMPLIANCE (Primary Metric)

| Service | Delivered | On-Time | SLA % | Status |
|---------|-----------|---------|-------|--------|
| Xparcel Priority | X,XXX | X,XXX | XX.X% | [Exceeds/Meets/Below] |
| Xparcel Expedited | X,XXX | X,XXX | XX.X% | [Exceeds/Meets/Below] |
| Xparcel Ground | X,XXX | X,XXX | XX.X% | [Exceeds/Meets/Below] |

**Compliance Thresholds**: Exceeds (>=95%) | Meets (>=90%) | Below (<90%)

---

### Transit Distribution

| Days | Count | % | Cumulative |
|------|-------|---|------------|
| 0-1 | X,XXX | XX% | XX% |
| 2-3 | X,XXX | XX% | XX% |
| 4-5 | X,XXX | XX% | XX% |
| 6-7 | X,XXX | XX% | XX% |
| 8+ | XXX | X% | 100% |

**Average Transit**: X.X days
**Median Transit**: X days

---

### Geographic Performance

| Region | Volume | Avg Transit | SLA % |
|--------|--------|-------------|-------|
| West Coast | X,XXX | X.X days | XX% |
| Mountain | X,XXX | X.X days | XX% |
| Central | X,XXX | X.X days | XX% |
| Southeast | X,XXX | X.X days | XX% |
| Northeast | X,XXX | X.X days | XX% |

---

### Action Items

| Issue | Impact | Resolution |
|-------|--------|------------|
| [Issue 1] | X% of late shipments | [Plan] |
| [Issue 2] | $X,XXX claims | [Plan] |

---

*Report generated by The Nebuchadnezzar v3.3*
```

**Why it works:**
- SLA compliance FIRST (per FIRSTMILE.md)
- Never leads with Day 0/Day 1 percentages
- Correct service level terminology
- Actionable insights with resolution plans

---

## WINNER #3: Brand Scout Intelligence Summary

**Context:** Lead research complete, need to anchor findings

**Output Location:** `Brand Scout Reports/[Company]_Brand_Scout_[Date].md`

```markdown
## BRAND SCOUT REPORT: [Company Name]

**Research Date**: [Date]
**Lead Quality Score**: [A+/A/B+/B/C]
**Confidence Level**: [High/Medium/Low]

---

### Quick Facts

| Field | Value | Confidence |
|-------|-------|------------|
| Monthly Volume | X,XXX-XX,XXX | ⚠️ Inferred |
| Current Carriers | FedEx, USPS | ✅ Confirmed |
| Fulfillment Model | In-House / 3PL | ✅ Confirmed |
| 3PL Provider | [Name] | ⚠️ Inferred |
| Free Ship Threshold | $XX | ✅ Confirmed |
| Ship Origin | [City, State] | ⚠️ Inferred |

---

### Decision Makers

**Primary Contact**:
- Name: [Full Name]
- Title: [Title]
- LinkedIn: [URL]
- Email: [email] (⚠️ pattern-based)

**Secondary Contact**:
- Name: [Full Name]
- Title: [Title]
- LinkedIn: [URL]

---

### Shipping Operations (from Shipping Page)

**Delivery Promise**: "[Exact quote from website]"
**Carriers Identified**: [List with source URLs]
**Pain Points Visible**:
- [Customer complaint pattern 1]
- [Customer complaint pattern 2]

---

### FirstMile Opportunity

**Network Fit**:
- Origin location: [City] → Nearest hub: [Hub]
- Volume estimate: Xparcel [Ground/Expedited] candidate
- Zone distribution: [Regional-heavy / Cross-country]

**Discovery Questions** (to fill gaps):
1. [Question for volume confirmation]
2. [Question for contract timing]
3. [Question for decision process]

---

### Sources

| Source | URL | Data Extracted |
|--------|-----|----------------|
| Shipping Policy | [URL] | Carriers, thresholds |
| LinkedIn | [URL] | Contacts |
| [Other] | [URL] | [Data] |

---

*Report generated by The Nebuchadnezzar v3.3*
*Research Time: [X] minutes*
```

**Why it works:**
- Structured for quick scanning
- Confidence levels on every data point
- Shipping page data REQUIRED (not optional)
- Discovery questions to fill gaps
- Sources documented for verification

---

## WINNER #4: Discovery Call Prep Sheet

**Context:** Discovery call scheduled, need prep documentation

**Output Location:** `[##-STAGE]_Company_Name/Discovery_Prep_[Date].md`

```markdown
## DISCOVERY PREP: [Company Name]

**Call Date**: [Date] [Time] [Timezone]
**Attendees**: [Names]
**Duration**: [30/45/60] minutes

---

### Pre-Call Research Summary

| What We Know | Source |
|--------------|--------|
| Monthly volume: ~X,XXX | Brand Scout |
| Current carriers: [List] | Shipping page |
| Ship origin: [Location] | [Source] |
| Pain points: [List] | Customer reviews |

---

### 38 Questions Focus Areas

**Volume Reality (Q1-Q4)**:
- [ ] Total monthly parcel volume?
- [ ] Controlled vs marketplace-locked?
- [ ] Seasonal peaks? (When? How much?)
- [ ] YoY growth rate?

**Carrier Situation (Q5-Q8)**:
- [ ] Current carrier mix (% each)?
- [ ] Contract renewal timing?
- [ ] Who negotiates rates?
- [ ] Rate review frequency?

**Operations (Q9-Q13)**:
- [ ] In-house or 3PL?
- [ ] WMS/TMS technology?
- [ ] Origin locations?
- [ ] Returns volume?

**Pain Points (Q14-18)**:
- [ ] Biggest shipping challenge?
- [ ] Claims/damage rate?
- [ ] Customer complaints?
- [ ] Cost pressure?

---

### Personalization Hooks

Based on Brand Scout research:

1. **[Hook 1]**: "[Specific observation about their business]"
   - Use when: [Scenario]

2. **[Hook 2]**: "[Industry trend affecting them]"
   - Use when: [Scenario]

3. **[Hook 3]**: "[PE/Growth angle if applicable]"
   - Use when: [Scenario]

---

### Objection Prep

| Likely Objection | Response |
|------------------|----------|
| "We're locked in with [carrier]" | "When does that contract renew? Happy to run numbers for your next negotiation." |
| "Our 3PL handles shipping" | "Do you have visibility into their carrier costs? Many brands are surprised by the markup." |
| "We're too small for new carriers" | "What's your monthly volume? Our Sendle program works great for 100-500 packages/month." |

---

### Call Objectives

1. **Qualify**: Confirm volume and decision authority
2. **Discover**: Identify 2-3 specific pain points
3. **Next Step**: Schedule rate review if qualified

---

### Post-Call Tasks (Pre-loaded)

- [ ] Log meeting summary to HubSpot
- [ ] Send recap email within 2 hours
- [ ] Request PLD if qualified
- [ ] Create follow-up task

---

*Prep sheet generated by The Nebuchadnezzar v3.3*
```

**Why it works:**
- Maps to 38 Questions framework
- Pre-loaded personalization hooks
- Objection responses ready
- Post-call tasks pre-loaded
- Clear call objectives

---

## WINNER #5: Meeting Debrief (HubSpot Note Format)

**Context:** Just finished discovery call, need to log findings

**Output Location:** HubSpot Note (associated with Deal)

```
DISCOVERY DEBRIEF - [Date]

ATTENDEES:
- FirstMile: Brett Walker
- Customer: [Name] ([Title])

38 QUESTIONS COVERAGE:
[X/38] questions answered

KEY INTEL:
- Volume: X,XXX/month ([controlled/mixed])
- Carriers: [List with %]
- Origin: [City, State]
- 3PL: [Name or In-House]
- Contract renewal: [Date/Month]
- Decision maker: [Name] (confirmed)

PAIN POINTS IDENTIFIED:
1. [Pain point with quote if possible]
2. [Pain point with context]
3. [Pain point]

OBJECTIONS RAISED:
- [Objection]: [How we addressed it]

NEXT STEPS:
[ ] [Action] - Owner: [Name] - Due: [Date]
[ ] [Action] - Owner: [Name] - Due: [Date]
[ ] [Action] - Owner: [Name] - Due: [Date]

DEAL HEALTH: [Hot/Warm/Cool/Cold]
WIN PROBABILITY: [%]
REASON: [One sentence explanation]

---
Logged by The Nebuchadnezzar v3.3 | [Timestamp]
```

**Why it works:**
- References 38 Questions coverage
- Captures intel for rate creation
- Objection handling documented
- Clear next steps with owners
- Deal health assessment included

---

## WINNER #6: Deal Snapshot (Pipeline Position)

**Context:** Need quick status check on where deal stands

**Output Location:** HubSpot Note or `/deal-snapshot` output

```
DEAL SNAPSHOT - [Company Name]

STAGE: [##] [Stage Name]
DAYS IN STAGE: [X] days
LAST ACTIVITY: [Date] ([Description])

PIPELINE POSITION:
[01] ━ [02] ━ [03] ━ ● ━ [05] ━ [06] ━ [07]
                    ↑ HERE

KEY METRICS:
- Monthly Volume: X,XXX (est.)
- Deal Value: $XX,XXX ARR
- Win Probability: XX%
- Close Date: [Date]

MOMENTUM:
[++] Positive signals:
  - [Signal 1]
  - [Signal 2]

[--] Risk factors:
  - [Risk 1]
  - [Risk 2]

STALE CHECK:
- Last customer contact: [X] days ago
- Open tasks: [X]
- Next scheduled activity: [Date]

RECOMMENDED ACTIONS:
1. [Action 1] - Due: [Date]
2. [Action 2] - Due: [Date]

---
Snapshot generated: [Timestamp]
```

**Why it works:**
- Visual pipeline position
- Momentum indicators (positive/negative)
- Stale detection built-in
- Actionable recommendations

---

## Output Routing Rules

| Analysis Type | Primary Destination | Secondary Destination |
|---------------|--------------------|-----------------------|
| PLD Analysis | Deal folder `.md` | HubSpot note (summary) |
| Transit Report | Deal folder `.md` | Excel workbook |
| Brand Scout | `Brand Scout Reports/` | HubSpot company record |
| Discovery Prep | Deal folder `.md` | (Internal only) |
| Meeting Debrief | HubSpot note | Deal folder backup |
| Deal Snapshot | HubSpot note | (Internal only) |

---

## Red Pill vs Blue Pill Quick Reference

| Mode | Purpose | Examples |
|------|---------|----------|
| Red Pill | Internal analysis | PLD summary, Brand Scout, Deal Snapshot |
| Blue Pill | Customer-facing | Emails, proposals, recaps |

**Trigger Detection**:
- "analyze", "summary", "report", "prep" → Red Pill
- "email", "follow-up", "send", "schedule" → Blue Pill

---

## Anti-Patterns (What NOT to Do)

```
NEVER in Red Pill outputs:
- Skip confidence levels on data points
- Leave sources undocumented
- Generate without checking FIRSTMILE.md compliance
- Lead transit reports with daily delivery %
- Name specific last-mile carriers in recommendations
- Save to wrong destination folder
- Skip HubSpot anchor when required

ALWAYS:
- Include confidence levels (✅ / ⚠️ / ❌)
- Document all sources with URLs
- Follow FIRSTMILE.md framework
- Lead with SLA compliance in transit reports
- Save to canonical folder location
- Anchor to HubSpot within 10 minutes
```

