# Cross-Stage Winning Patterns

> What works everywhere in the pipeline

## Universal Patterns (All Stages)

### The Golden Rules

| Do This | Not This |
|---------|----------|
| Specific time slots | "When are you free?" |
| "I need X to complete Y" | "Just checking in" |
| Post-meeting recaps + action items | Assuming they remember |
| "Can you confirm..." | Vague asks |
| 2 sentences | 2 paragraphs |

### Response Triggers

Emails that get replies share these traits:

1. **Easy to respond** - Yes/no questions, pick a time, confirm a fact
2. **Shows progress** - "I'll have an update after meeting at 2:30"
3. **Adds value** - Analysis, insight, or resource they didn't ask for
4. **Specific not vague** - Dates, times, numbers, percentages

### Red Flags (Avoid)

- "Any updates?" 
- "Just checking in"
- "What works for you?"
- Long detailed explanations
- Multiple questions in one email
- No clear call to action

---

## Pattern Library by Need

### Need: Re-Engage After Silence

**Best Pattern:** "I'll have an update after [specific time]..."

```
Hey [Name] - I'll have an update after meeting with [person/team] at [time] 
and should have [deliverable] to show you...

Is the [data/info] you shared last time inclusive of [specific scope]?
```

**Why it works:** Shows internal progress + easy yes/no question

---

### Need: Schedule a Meeting

**Best Pattern:** 3 Specific Times + Booking Link

```
Would you be available to jump on a [call type] tomorrow to [purpose]?

Any of these work for you tomorrow - [time 1], [time 2], or [time 3] [timezone]. 
You can book here [link] or just let me know!
```

**Why it works:** Multiple options + zero friction booking

---

### Need: Check Status Without Annoying

**Best Pattern:** 2-Sentence Soft Check-In

```
Hey [Name],

How are things looking as you review the [deliverable]? 
Would you have time to connect in the next few days?
```

**Why it works:** Assumes progress, soft ask, no pressure

---

### Need: Deliver Something + Keep Momentum

**Best Pattern:** Delivery + Specific Next Step

```
Hi [Name],

Attached are your [deliverable] for [scope]. 
I will follow up with additional info on [remaining items].

What is your schedule for [specific day]?
```

**Why it works:** Delivers value + immediate next step

---

### Need: Add Value When Nothing's Moving

**Best Pattern:** Unprompted Analysis

```
Hi [Name],

Following up on the data you sent over, I've pulled together a 
[summary/analysis] of [scope]. This should give you a clear picture 
of [insight]. See attached.

[Table or key metrics]

As a reminder, [additional resource or context].
```

**Why it works:** Shows expertise, creates obligation, moves deal forward

---

### Need: Recover After Your Mistake

**Best Pattern:** Own + Reason + Times + Forward

```
Hi [Name],

Apologies for [specific mistake]. [Honest reason - one sentence]. 
I appreciate your patience and would love to reconnect.

I'm available:
[Time 1]
[Time 2]
[Time 3]

Let me know which works best, and we'll get everything back on track.
```

**Why it works:** Takes responsibility, doesn't over-apologize, moves forward

---

### Need: Document a Meeting

**Best Pattern:** Structured Recap with Clear Ownership

```
Hi [Name],

Thanks for [meeting context]! [One sentence of genuine appreciation].

Meeting Notes:
[Key points - bullets]

[Your Company] Solutions Discussed:
[What you proposed - bullets]

Next Steps:
[Action items with clear ownership]

[Forward momentum closing]
```

**Why it works:** Documents everything, shows you listened, clear accountability

---

## Mode Mapping

| Stage | Mode | Best Patterns |
|-------|------|---------------|
| [02] Discovery | Blue Pill | Meeting request, soft check-in |
| [03] Rate Creation | Red Pill (internal) | Data requests, analysis delivery |
| [04] Proposal Sent | Blue Pill | All patterns (full cadence) |
| [05] Setup Docs | Blue Pill | Delivery + next step |
| [08] Closed Lost | Blue Pill | Recovery, value-add |
| [09] Win-Back | Blue Pill | Re-engagement, crisis response |

---

## Quick Diagnosis

**If prospect went dark:**
→ Try "I'll have an update after..." pattern

**If you need a meeting:**
→ Try 3 specific times + booking link

**If nothing's moving:**
→ Try unprompted analysis

**If you dropped the ball:**
→ Try own + reason + times + forward

**If deal is stuck:**
→ Try 2-sentence soft check-in
