# [04] Proposal Follow-Up Swipe Files

> Blue Pill Mode - External communication patterns that work

## Winning Formula

```
✅ Specific time slots > "When are you free?"
✅ "I need X to complete Y" > "Just checking in"
✅ Post-meeting recaps with action items > Assuming they remember
✅ "Can you confirm..." > Vague asks
✅ 2 sentences beats 2 paragraphs

❌ Generic "checking in" without context
❌ "Any updates?" emails
❌ Open-ended "what works for you?"
```

## Day-by-Day Cadence

| Day | Pattern | Key Move |
|-----|---------|----------|
| Day 1 | Delivery + Next Steps | Deliver rates, ask for specific meeting day |
| Day 3 | Soft Check-In | 2 sentences, assume progress |
| Day 7 | Value-Add Analysis | Send analysis they didn't ask for |
| Day 10 | Meeting Request + Times | 3 options + booking link |
| Day 14 | Progress Update + Timeline | Show internal progress, specific timing |

---

## WINNER #1: "I'll have an update after..." (Re-Engagement)

**Context:** Nick had checked in twice asking for updates

**Subject:** Re: Accepted: OTW Shipping - FirstMile

```
Hey Nick - I'll have an update after meeting with Brock (my vp sales) & Pricing team at 2:30 and should have some rates to show you…

Is the data you shared last time inclusive of all your ship-to zip codes from each location? I would like to double-check and get an up-to-date, accurate picture of your zip codes and whether they fall within our national or select network.
```

**Why it worked:**
- Specific timing - "after meeting at 2:30"
- Shows internal progress - Working with VP and pricing team
- Asks for confirmation - Easy yes/no
- Business reason - Why you need it

**Result:** Nick sent data files same day.

---

## WINNER #2: Value-Add Analysis (Unprompted)

**Context:** Nick sent data, you did analysis without being asked

**Subject:** Re: XParcel Rates

```
Hi Nick,

Following up on the data you sent over, I've pulled together a high-level summary of the eligible zip codes based on the two files. This should give you a clear picture of the network coverage for that specific volume. See attached files.

A) Last 30 Days Shipping (pg_with_summary.xlsx)

Select: 8,499 (55.0%)
National: 6,949 (45.0%)
DAS Eligible: 9,208 (59.6%)

B) Last 7 Days Shipping (MM - L7_with_summary.xlsx)

Select: 4,755 (70.2%)
National: 2,015 (29.8%)
DAS Eligible: 3,140 (46.4%)

As a reminder, both source files now have a 'Network Summary' tab with more detail on these numbers.
```

**Why it worked:**
- Added value unprompted - Did analysis without being asked
- Specific data - Exact percentages and breakdowns
- Easy to understand - Clear summary tables
- Next step implied - Ready to discuss rates

**Result:** Nick engaged and asked for full analysis.

---

## WINNER #3: Meeting Request with Specific Times

**Context:** Had preliminary rates ready to review

**Subject:** Re: Accepted: OTW Shipping - FirstMile

```
I caught up with Brock, and we've pulled together some preliminary rates to go over. They're not fully finalized yet, so I'd need to walk you through them during a meeting.

Would you be available to jump on a Teams call tomorrow to review?

Any of these work for you tomorrow - 10:30–11:00 am, 11:30 am–12:00 pm, or 1:45–2:15 pm MDT. You can book here [link] or just let me know!
```

**Why it worked:**
- Reason for meeting - "Walk you through preliminary rates"
- Multiple specific times - 3 options, not "when works?"
- Booking link - Made it easy to say yes
- Urgency but not pushy - "Tomorrow" without pressure

**Result:** Meeting scheduled same day.

---

## WINNER #4: Soft Check-In (2 Sentences)

**Context:** Rates sent, needed to gauge interest

**Subject:** Re: XParcel Rates

```
Hey Nick,

How are things looking as you review the Xparcel rates? Would you have time to connect in the next few days?
```

**Why it worked:**
- Super short - Only 2 sentences
- Assumes progress - "as you review"
- Soft ask - "next few days" not "ASAP"
- No pressure - Just checking in with purpose

**Result:** Nick responded with specific questions about the rates.

---

## WINNER #5: Delivery + Next Steps

**Context:** Delivering promised rates

**Subject:** Re: XParcel Rates

```
Hi Nick,

Attached are your Xparcel Domestic Rates for your UT and CT locations. I will follow up with additional info on remaining action items.

What is your schedule for Friday?
```

**Why it worked:**
- Delivers what was promised - Rates attached
- Acknowledges more to come - "remaining action items"
- Asks for next meeting - Specific day (Friday)
- Brief and professional - Gets to the point

**Result:** Nick responded with technical questions and scheduled follow-up.

---

## WINNER #6: Post-Meeting Recap

**Context:** Following up after discovery call

**Subject:** Re: Your FirstMile Quote

```
Hi Mohamed,

Thanks for the great conversation today! Really enjoyed learning about Team Shipper's operations and your expansion plans. Your tech setup with EasyPost integration makes this a perfect fit.

Meeting Notes:

Team Shipper: 7 Oregon locations, expanding nationally
Need parcel/LTL/FTL coverage with optimization technology
Currently using TeamShipper system + EasyPost for carrier aggregation
25 years software development experience on your team
Looking for volume-based pricing and carrier optimization

FirstMile Solutions Discussed:

Xparcel Ship Method: FirstMile's patented machine learning algorithm
National network: 100% US population coverage
Direct API integration with your existing EasyPost setup
Volume-based rates (example: $3.79 at 10 pkgs/day vs $3.45 at 1000 pkgs/day)

Next Steps:

Since you're already on EasyPost, we can skip the NDA
Send me 30-60 days of parcel shipment history when you get a chance
I'll run the analysis and get you competitive rates
15-20 business day setup process once we move forward

I'll get you that call recording as promised. Looking forward to moving this forward quickly!
```

**Why it worked:**
- Documented everything - Clear meeting summary
- Organized clearly - Bullet points, sections
- Shows you listened - Specific details about their business
- Clear next steps - Both parties know what to do
- Removed friction - "We can skip the NDA"

**Result:** Mohamed responded enthusiastically with volume projections.

---

## WINNER #7: Rate Delivery + Resources

**Context:** Delivering rates with complete package

**Subject:** Re: XParcel Rates

```
Hi Nick,

Attached are your Xparcel Domestic Rates for your UT and CT locations. I will follow up with additional info on remaining action items.

What is your schedule for Friday?

FirstMile Fuel: 70% discount of list fuel rate - https://www.firstmile.com/fuel
FirstMile Customer Portal | Domestic Tracking Report | Sample Power BI Dashboard

All fees included: DIM divisors, DAS, residential are found in attached FirstMile Customer Agreement, Terms & Conditions
```

**Why it worked:**
- Delivers immediately - Rates attached upfront
- Sets expectation - "Will follow up with additional info"
- Provides resources - Links to tools and terms
- Asks for meeting - Specific day

**Result:** Nick engaged with questions and scheduled next call.

---

## Adaptation Template

When drafting a [04] follow-up, use this structure:

```
[If Day 3]: 2 sentences max. Assume they're reviewing. Ask soft question.

[If Day 7]: Add value unprompted. Send analysis, insight, or comparison.

[If Day 10]: Offer 3 specific times. Include booking link. Reference progress.

[If Day 14]: Show internal progress. Give specific timeline. Business reason for urgency.
```
