# [09] Win-Back Swipe Files

> Blue Pill Mode - Re-engagement patterns that bring deals back to life

## Win-Back Formula by Situation

### When YOU Dropped the Ball
```
✅ Own it immediately - "Apologies for missing..."
✅ Give honest reason (not excuse) - "New customer launch came up"
✅ 3 specific times - Make it easy to reschedule
✅ "Back on track" framing - Positive forward momentum
```

### When THEY Went Dark
```
✅ Reference last interaction - "Following up on the data you sent..."
✅ Add value unprompted - Send analysis, summary, insights
✅ Specific timeline - "I'll have an update after 2:30"
✅ Yes/no questions only - Easy to respond
```

### When There's a Crisis
```
✅ Acknowledge severity - Don't minimize ("2,500 packages outside SLA")
✅ Propose specific time - "10 AM tomorrow"
✅ Bullet point agenda - What you'll cover
✅ "Solutions" not "problems" - Action-oriented language
```

---

## WINNER #1: Crisis Re-Engagement

**Context:** Customer initiated after service issues - 2,500 packages outside SLA

**Subject:** First Mile Reconnect

**Customer's email:**
```
Hey Brett,

Are you available for a call tomorrow? We've had a dramatic increase in complaints and want to talk through what's happening and the plan going forward. Let us know what times work for you.

Thank you,
Reid Malloch
```

**Brett's Response:**
```
Reid, Merrick,

We've got about 2,500 packages outside SLA and customers are considering switching. New high-volume clients could add more strain. Let's talk solutions at 10 AM tomorrow.

We'll cover:
• Find the cause
• Immediate fixes
• Adjust SLA performance in each service level

I'll send an invite. Let me know if 10 AM won't work.
```

**Why it worked:**
- Acknowledged the crisis - Didn't downplay 2,500 packages
- Specific meeting time - "10 AM tomorrow"
- Clear agenda - 3 bullet points
- Action-oriented - "Let's talk solutions"

**Result:** Meeting scheduled same day, deal saved, customer still shipping today.

---

## WINNER #2: The Apology + Reschedule

**Context:** Shahzad complained "Booked a time with you but never heard back"

**Subject:** Re: Your FirstMile Quote

```
Hi Shahzad,

Apologies for missing our booked meeting time last week. A new customer launch came up, and I got tied up ensuring a smooth start for them. I appreciate your patience and would love to reconnect.

I'm available:

Monday at 1:30 PM
Monday at 3:30 PM
Tuesday at 11:00 AM

Let me know which of these works best for you, and we'll get everything back on track.
```

**Why it worked:**
- Owned the mistake - "Apologies for missing"
- Gave honest reason - "New customer launch came up"
- Showed appreciation - "I appreciate your patience"
- 3 specific times - Easy to say yes
- Positive framing - "get everything back on track"

**Result:** Shahzad responded immediately, meeting rescheduled and held.

---

## WINNER #3: Post-Meeting Reconnect (Action Items)

**Context:** Rebuilding relationship after months of service issues

**Subject:** Fwd: Recap of your meeting with System Beauty

```
Hey Reid,

Thanks for making time to meet today. I'm following up on the items below.

Meeting: FirstMile Reconnect - System Beauty TX
September 04, 2025

Action Items:
✨ Email Reid details re customer service handling small calls - Walker Brett
✨ Follow up w/ Melissa re data issue & tracking number problem - Walker Brett
✨ Follow up w/ Melissa re weight rounding issue, get update - Walker Brett
✨ Compile & send data on label calls/win rates to Reid for review - Walker Brett
✨ Review data from Walker on label calls/win rates when received - Reid Malloch

Meeting Purpose:
To discuss FirstMile's service updates, address System Beauty's shipping concerns, and explore potential improvements in their partnership.

Key Takeaways:

FirstMile is expanding customer service capabilities with proactive management tools for deliveries and claims
System Beauty experienced tracking discrepancies, potentially due to over-labeling issues
Unresolved data/weight rounding problem persists, impacting client communication
FirstMile to analyze and optimize shipping rates for System Beauty, particularly in Zone 5
```

**Why it worked:**
- Comprehensive recap - Shows you listened
- Clear ownership - Brett took all action items
- Documented issues - Transparency about problems
- Forward momentum - Clear next steps

**Result:** Relationship rebuilt, ongoing partnership continues.

---

## WINNER #4: Value-Add Follow-Up (After They Checked In)

**Context:** Nick had checked in asking for updates after weeks of silence

**Subject:** Re: XParcel Rates

```
Hi Nick,

Following up on the data you sent over, I've pulled together a high-level summary of the eligible zip codes based on the two files. This should give you a clear picture of the network coverage for that specific volume. See attached files.

A) Last 30 Days Shipping (pg_with_summary.xlsx)
Network | Eligible Zip Codes | Coverage
Select: 8,499 | 55.0%
National: 6,949 | 45.0%
DAS Eligible: 9,208 | 59.6%

B) Last 7 Days Shipping (MM - L7_with_summary.xlsx)
Network | Eligible Zip Codes | Coverage
Select: 4,755 | 70.2%
National: 2,015 | 29.8%
DAS Eligible: 3,140 | 46.4%

As a reminder, both source files now have a 'Network Summary' tab with more detail on these numbers.
```

**Why it worked:**
- Added unexpected value - Did analysis unprompted
- Made it visual - Tables and percentages
- Easy to digest - Clear summary format
- Referenced their data - Shows you're working on it

**Result:** Nick engaged immediately with detailed follow-up questions.

---

## WINNER #5: "I'll have an update after..." Pattern

**Context:** Nick had checked in twice ("checking in again here, thanks!")

**Subject:** Re: Accepted: OTW Shipping - FirstMile

```
Hey Nick - I'll have an update after meeting with Brock (my vp sales) & Pricing team at 2:30 and should have some rates to show you…

Is the data you shared last time inclusive of all your ship-to zip codes from each location? I would like to double-check and get an up-to-date, accurate picture of your zip codes and whether they fall within our national or select network.
```

**Why it worked:**
- Specific timing - "after meeting at 2:30"
- Shows progress - Working with VP and pricing team
- Asks for confirmation - Easy yes/no
- Business reason - Why you need it

**Result:** Nick sent data files same day.

---

## WINNER #6: "Tomorrow?" Urgency

**Context:** Weeks of back-and-forth, needed to move forward

**Subject:** Re: Accepted: OTW Shipping - FirstMile

```
I caught up with Brock, and we've pulled together some preliminary rates to go over. They're not fully finalized yet, so I'd need to walk you through them during a meeting.

Would you be available to jump on a Teams call tomorrow to review?

Any of these work for you tomorrow - 10:30–11:00 am, 11:30 am–12:00 pm, or 1:45–2:15 pm MDT. You can book here [link] or just let me know!
```

**Why it worked:**
- Urgency without pressure - "Tomorrow" but multiple options
- Reason for meeting - "Walk you through preliminary rates"
- Transparency - "Not fully finalized yet"
- Booking link - Made it effortless

**Result:** Meeting scheduled within hours.

---

## WINNER #7: Short Check-In After Deliverable

**Context:** Nick went quiet after receiving rates

**Subject:** Re: XParcel Rates

```
Hey Nick,

How are things looking as you review the Xparcel rates? Would you have time to connect in the next few days?
```

**Why it worked:**
- Super short - 2 sentences only
- Assumes they're reviewing - Not "Did you review?"
- Soft ask - "Next few days" not urgent
- No guilt trip - Friendly tone

**Result:** Nick responded with technical questions and scheduled next call.

---

## Win-Back Scenarios

### Scenario A: They Ghosted After Proposal
1. Day 7: Soft check-in (2 sentences, assume reviewing)
2. Day 14: Value-add (send analysis they didn't ask for)
3. Day 21: "I'll have an update after..." (show internal progress)
4. Day 30: 3 specific times + booking link

### Scenario B: You Dropped the Ball
1. Own it immediately
2. Honest reason (not excuse)
3. 3 specific times
4. "Back on track" framing

### Scenario C: Service Crisis
1. Acknowledge severity (don't minimize)
2. Specific meeting time (not "ASAP")
3. Clear 3-point agenda
4. "Solutions" focus

### Scenario D: Lost Deal Re-Engagement (90+ Days)
1. Reference last interaction
2. "Things have changed at FirstMile" positioning
3. New value proposition (rates, services, network)
4. Soft ask: "Would it make sense to reconnect?"
