# Task Templates - YOU vs AI Mapping

> AI-First Task Planning: Before projects >1 hour, map tasks as Manual (M) or AI

## Core Principle

**AI drafts, you decide timing and personal touches.**

---

## [00] Lead Generation → [01] Discovery Scheduled

| Task | YOU | AI | Tool/Command | Swipe File |
|------|-----|-----|--------------|------------|
| Find target companies | Direction/criteria | ✅ Research | `/brand-scout:scout`, WebSearch | — |
| Research shipping page | Review findings | ✅ Scrape | Chrome MCP, BrightData | — |
| Find decision makers | Verify/approve | ✅ LinkedIn research | LinkedIn scrape | — |
| Check for existing records | — | ✅ Execute | `/check-lead` | — |
| Create HubSpot records | Approve | ✅ Execute | `/add-lead` | — |
| Generate Brand Scout report | Review | ✅ Generate | `/brand-scout:scout` | — |
| Draft initial outreach | Personalize + send | ✅ Draft | `/create-followup` | `discovery-outreach.md` |
| Send Email 1 | ✅ Timing + send | Draft | Superhuman | `discovery-outreach.md` |
| Day 4 follow-up | Review/send | ✅ Draft | `/create-followup` | `discovery-outreach.md` |
| Day 8 social proof | Review/send | ✅ Draft | `/create-followup` | `discovery-outreach.md` |
| Day 14 phone call | ✅ Make call | Draft voicemail | — | `discovery-outreach.md` |
| Day 21 soft breakup | Review/send | ✅ Draft | `/create-followup` | `discovery-outreach.md` |
| Move to [01] when meeting scheduled | ✅ | ✅ Execute | `/update-deal` | — |

**Granular YOU vs AI Breakdown:**

```
BRAND SCOUT RESEARCH:
  AI: WebSearch queries → find companies
  AI: Scrape shipping page → extract carriers, thresholds
  AI: LinkedIn research → find contacts
  YOU: Review quality, approve or reject leads
  AI: Create HubSpot records (if approved)
  AI: Generate Brand Scout report

OUTREACH SEQUENCE:
  AI: Draft Email 1 using personalization hooks
  YOU: Review, add personal touches, decide timing
  YOU: Send email (timing is relationship judgment)
  AI: Create Day 4/8/14/21 follow-up tasks
  AI: Draft each follow-up email
  YOU: Review/send each (or skip based on response)
```

**Time estimate:** 45-60 minutes per lead (15 min research, 30 min over sequence)

---

## [01] Discovery Scheduled → [02] Discovery Complete

| Task | YOU | AI | Tool/Command | Swipe File |
|------|-----|-----|--------------|------------|
| Schedule the call | ✅ | Draft calendar invite text | Calendar | — |
| Pre-call research | Review/approve | ✅ Generate | `/brand-scout:scout` | — |
| Generate discovery prep sheet | Review | ✅ Generate | — | `internal-analysis.md` |
| Conduct discovery call | ✅ | — | Fathom for transcript | 38 Questions |
| Log meeting summary | Review/edit | ✅ Draft from bullet notes | `/meeting-summary` | `internal-analysis.md` |
| Score 38 Questions coverage | ✅ Assess | — | — | Practice Gym |
| Update HubSpot stage | One-click approve | ✅ Execute | `/update-deal` | — |
| Identify next action | ✅ Decide | ✅ Suggest based on 38 Questions | `/next-action` | — |

**Granular YOU vs AI Breakdown:**

```
PRE-CALL:
  AI: Generate Brand Scout report (if not done)
  AI: Create Discovery Prep Sheet with:
      - Research summary (what we know)
      - 38 Questions focus areas
      - Personalization hooks
      - Objection prep
      - Post-call tasks (pre-loaded)
  YOU: Review prep sheet, add your own notes

DURING CALL:
  YOU: Conduct discovery using 38 Questions framework
  YOU: Listen for pain points, objections, buying signals
  AI: Fathom records transcript (if enabled)

POST-CALL:
  AI: Draft meeting debrief from your bullet notes
  YOU: Review/edit debrief, add key insights
  AI: Log to HubSpot as note
  AI: Create follow-up tasks
  YOU: Score 38 Questions coverage (how many answered?)
  YOU: Decide: Qualified → Rate Creation or Disqualified → Closed Lost
```

**Time estimate:** 45-60 minutes (15 min AI prep, 30 min call, 15 min wrap)

---

## [02] Discovery Complete → [03] Rate Creation

| Task | YOU | AI | Tool/Command | Swipe File |
|------|-----|-----|--------------|------------|
| Review discovery notes | ✅ | — | — | — |
| Draft data request email | Review/send | ✅ Draft | `/create-followup` | `patterns-summary.md` |
| Request rate creation (internal) | ✅ Submit | ✅ Format request | Internal template | — |
| Receive PLD from prospect | ✅ Follow up | ✅ Draft reminders | `/create-followup` | `proposal-followups.md` |
| Analyze shipping profile | Review findings | ✅ Run analysis | `analysis_skill.md` | `internal-analysis.md` |
| Generate Customer Shipping Analysis | Review | ✅ Generate | — | `internal-analysis.md` |
| Update deal stage | ✅ | ✅ Execute | `/update-deal` | — |

**Granular YOU vs AI Breakdown:**

```
DATA GATHERING:
  AI: Draft email requesting PLD/shipping data
  YOU: Personalize, add context from discovery call
  YOU: Send email (timing based on urgency)
  AI: Create follow-up task if no response in 48h
  AI: Draft follow-up reminders

RATE CREATION:
  YOU: Submit rate request to pricing team
  AI: Format request with all required fields
  YOU: Follow up with pricing if needed

ANALYSIS (when PLD received):
  AI: Run full shipping profile analysis
  AI: Generate Customer Shipping Analysis (Red Pill output)
  AI: Calculate FirstMile opportunity and savings
  YOU: Review findings, validate assumptions
  AI: Anchor analysis to deal folder
```

**Time estimate:** 30-45 minutes (plus wait time for PLD)

---

## [03] Rate Creation → [04] Proposal Sent

| Task | YOU | AI | Tool/Command | Swipe File |
|------|-----|-----|--------------|------------|
| Review rates from pricing | ✅ | — | — | — |
| Build proposal deck | Review/customize | ✅ Draft | Deck template | — |
| Include savings analysis | Review | ✅ Calculate | — | `internal-analysis.md` |
| Draft proposal email | Review/personalize | ✅ Draft | `/create-followup` | `proposal-followups.md` |
| Send proposal | ✅ | — | Superhuman | — |
| Log activity | ✅ Trigger | ✅ Execute | `/log-activity` | — |
| Set follow-up reminders | ✅ Approve | ✅ Create tasks | HubSpot tasks | — |

**Granular YOU vs AI Breakdown:**

```
PROPOSAL BUILDING:
  AI: Calculate savings from Customer Shipping Analysis
  AI: Draft proposal deck with customer-specific data
  AI: Generate comparison tables (current vs FirstMile)
  YOU: Review deck, customize messaging
  YOU: Decide what to emphasize (cost, service, simplicity)

PROPOSAL DELIVERY:
  AI: Draft proposal email with personalization
  YOU: Review email, add relationship context
  YOU: Decide timing (morning vs afternoon, day of week)
  YOU: Send proposal (present live if possible)
  AI: Log activity to HubSpot
  AI: Create Day 3/7/10/14 follow-up tasks
```

**Time estimate:** 45-60 minutes

---

## [04] Proposal Follow-Up Cadence

| Day | YOU | AI | Action | Swipe File |
|-----|-----|-----|--------|------------|
| Day 1 | ✅ Present live or send | Draft deck, email | Value recap | `proposal-followups.md` WINNER #1 |
| Day 3 | Review/send | ✅ Draft | 2-sentence soft check-in | `proposal-followups.md` WINNER #2 |
| Day 7 | ✅ Phone call attempt | Draft voicemail script | Multi-channel touch | `proposal-followups.md` WINNER #3 |
| Day 10 | Review/send | ✅ Draft | "Any questions?" + 3 specific times | `proposal-followups.md` WINNER #4 |
| Day 14 | ✅ Decision: push or pause | ✅ Draft | Soft breakup or escalation | `proposal-followups.md` WINNER #5/6 |

**Granular YOU vs AI Breakdown:**

```
EACH FOLLOW-UP:
  AI: Draft email using winning pattern from swipe file
  AI: Personalize with deal-specific context
  YOU: Review draft, add personal touches
  YOU: Decide: Send now, adjust, or skip?
  YOU: Send email
  AI: Log activity to HubSpot
  AI: Update next follow-up task

DECISION POINTS (YOU only):
  - Day 7: Should I call or email?
  - Day 10: Is this still viable or going cold?
  - Day 14: Push harder, pause, or close lost?
```

**Pattern:** AI drafts, you decide timing and personal touches.

---

## [04] Proposal Sent → [05] Setup Docs Sent

| Task | YOU | AI | Tool/Command | Swipe File |
|------|-----|-----|--------------|------------|
| Receive verbal commit | ✅ | — | — | — |
| Generate setup docs | ✅ Trigger | ✅ Generate | Internal system | — |
| Draft handoff email | Review | ✅ Draft | `/create-followup` | `patterns-summary.md` |
| Send setup docs | ✅ | — | Superhuman | — |
| Update deal stage | ✅ | ✅ Execute | `/update-deal` | — |
| Schedule implementation kick-off | ✅ | Draft invite | Calendar | — |
| Create deal snapshot | Review | ✅ Generate | `/deal-snapshot` | `internal-analysis.md` |

**Granular YOU vs AI Breakdown:**

```
VERBAL COMMIT:
  YOU: Receive "yes" from customer
  YOU: Confirm scope, timeline, contacts
  AI: Update deal stage
  AI: Create deal snapshot (pipeline position)

SETUP DOCS:
  AI: Generate setup docs from internal system
  AI: Draft handoff email with next steps
  YOU: Review email, personalize
  YOU: Send setup docs

IMPLEMENTATION PREP:
  AI: Draft calendar invite for kick-off
  YOU: Schedule at mutually available time
  AI: Create implementation tasks
```

**Time estimate:** 30 minutes

---

## [05] Setup Docs → [06] Implementation

| Task | YOU | AI | Tool/Command |
|------|-----|-----|--------------|
| Collect signed docs | ✅ Follow up | ✅ Draft reminders | `/create-followup` |
| Coordinate with ops | ✅ | — | Internal |
| Schedule training | ✅ | Draft invite | Calendar |
| Monitor implementation | ✅ Check-ins | ✅ Draft status updates | `/deal-snapshot` |
| Update deal stage | ✅ | ✅ Execute | `/update-deal` |

**Time estimate:** Variable (depends on customer)

---

## [06] Implementation → [07] Closed Won

| Task | YOU | AI | Tool/Command |
|------|-----|-----|--------------|
| Confirm go-live | ✅ | — | — |
| Send welcome/thank you | Review/send | ✅ Draft | Template |
| Update deal stage | ✅ | ✅ Execute | `/update-deal` |
| Log final notes | ✅ Key learnings | ✅ Format | `/log-activity` |
| Set 30-day check-in | ✅ | ✅ Create task | HubSpot tasks |

**Time estimate:** 15-20 minutes

---

## [04/05/06] → [08] Closed Lost

| Task | YOU | AI | Tool/Command |
|------|-----|-----|--------------|
| Receive/confirm loss | ✅ | — | — |
| Document loss reason | ✅ Provide context | ✅ Format | `/log-activity` |
| Update deal stage | ✅ | ✅ Execute | `/update-deal` |
| Move deal folder | ✅ | — | File system |
| Set 90-day win-back reminder | ✅ | ✅ Create task | HubSpot tasks |

**Time estimate:** 10-15 minutes

---

## [08] Closed Lost → [09] Win-Back

| Task | YOU | AI | Tool/Command | Swipe File |
|------|-----|-----|--------------|------------|
| Review loss reason | ✅ | — | Deal folder notes | — |
| Check for company changes | Review | ✅ Research | Web search | — |
| Identify win-back scenario | ✅ Classify | — | — | `winbacks.md` |
| Draft re-engagement email | Review/personalize | ✅ Draft | `/create-followup` | `winbacks.md` |
| Send win-back email | ✅ | — | Superhuman | — |
| Update deal stage | ✅ | ✅ Execute | `/update-deal` | — |
| Set follow-up sequence | ✅ | ✅ Create tasks | HubSpot tasks | — |

**Win-Back Scenario Classification:**

| Scenario | Swipe File Pattern | Timing |
|----------|-------------------|--------|
| They ghosted you | `winbacks.md` WINNER #1-2 | 90+ days |
| You dropped the ball | `winbacks.md` WINNER #3-4 | When you realize |
| Crisis / timing wrong | `winbacks.md` WINNER #5 | When crisis passes |
| 90+ days cold | `winbacks.md` WINNER #6-7 | Quarterly review |

**Granular YOU vs AI Breakdown:**

```
ASSESSMENT:
  YOU: Review why deal was lost
  YOU: Classify scenario (ghosted, dropped ball, crisis, cold)
  AI: Research company for recent changes
  AI: Check for news, new funding, leadership changes

WIN-BACK ATTEMPT:
  AI: Draft email using matching swipe file pattern
  YOU: Review, add personal acknowledgment
  YOU: Decide timing (morning, day of week)
  YOU: Send email
  AI: Log activity to HubSpot
  AI: Create follow-up sequence (Day 3, 7, 14)
```

**Time estimate:** 20-30 minutes

---

## Quick Mode (QM3.1) Output Format

When `--qm` flag or mobile context:

```
QM3.1 ACTIVE
[STAGE]: [02]→[03]
[YOU]: Review discovery notes, request rate creation
[AI]: Draft data request email, run shipping analysis
[COMMANDS]: /create-followup, analysis_skill.md
[STATUS]: READY
```

---

## Decision Framework

**Before any task >1 hour:**

1. List all micro-tasks
2. Mark each as M (Manual) or AI
3. For AI tasks, specify tool/command
4. Estimate time saved
5. Execute in order

**If unsure M or AI:**
- Does it require judgment? → M
- Does it require your relationship? → M
- Is it repetitive/templated? → AI
- Does it need creativity within constraints? → AI

---

## Daily Workflow Pattern

**Morning (9am sync):**

| Time | YOU | AI | Command |
|------|-----|-----|---------|
| 9:00 | — | Run morning sync | `python unified_sync.py 9am` |
| 9:05 | Review pipeline health | — | — |
| 9:10 | ✅ Pick 3 priority actions | Suggest based on stale/goals | — |
| 9:15 | Execute micro-actions | Draft emails, prep sheets | Various |

**Midday (noon check):**

| Time | YOU | AI | Command |
|------|-----|-----|---------|
| 12:00 | — | Run midday sync | `python unified_sync.py noon` |
| 12:05 | ✅ Adjust based on responses | — | — |
| 12:10 | Send scheduled follow-ups | ✅ Draft ready | Various |

**End of Day (EOD wrap):**

| Time | YOU | AI | Command |
|------|-----|-----|---------|
| 17:00 | — | Run EOD sync | `python unified_sync.py eod` |
| 17:05 | Review activity log | — | — |
| 17:10 | ✅ Clear remaining tasks or reschedule | Log to tomorrow | — |
| 17:15 | ✅ Anchor any AI outputs (10-min rule) | — | `/log-activity` |

---

## Swipe File Index

| File | Stage | Mode | Content |
|------|-------|------|---------|
| `discovery-outreach.md` | [00]→[01] | Blue Pill | Cold outreach emails |
| `proposal-followups.md` | [04] | Blue Pill | Follow-up after proposal |
| `winbacks.md` | [08]→[09] | Blue Pill | Re-engagement emails |
| `patterns-summary.md` | All | Both | Golden rules, quick diagnosis |
| `internal-analysis.md` | All | Red Pill | PLD, Brand Scout, Deal Snapshot |

---

## Anti-Patterns

```
NEVER:
- Send AI drafts without review
- Skip the "decide timing" step
- Let AI tasks accumulate without YOU review
- Forget to anchor outputs (10-minute rule)
- Run multiple stages without completing follow-ups

ALWAYS:
- Review every AI draft before sending
- YOU decide: timing, personal touches, send/skip
- Clear tasks daily (done or rescheduled)
- Anchor AI outputs within 10 minutes
- One active stage transition at a time per deal
```
