---
name: ai-output-validator
description: AI出力の品質を自動検証するスキル。事実確認、論理性、一貫性、幻覚（ハルシネーション）検出、バイアス分析、安全性チェックを実施し、改善提案を提供。
---

# AI Output Validator Skill

AIが生成した出力の品質を包括的に検証するスキルです。

## 概要

このスキルは、LLMやAIモデルが生成した出力を多角的に検証し、品質を評価します。事実の正確性、論理的一貫性、幻覚（ハルシネーション）の検出、バイアス分析、安全性チェックなどを実施し、問題点を特定して改善提案を行います。

## 主な機能

- **幻覚（ハルシネーション）検出**: 事実と異なる情報の生成を検出
- **事実確認**: 外部ソースと照合して情報の正確性を検証
- **論理性チェック**: 推論の妥当性、矛盾の検出
- **一貫性検証**: 出力内での情報の一貫性
- **バイアス分析**: ジェンダー、人種、文化的バイアスの検出
- **安全性チェック**: 有害コンテンツ、誤情報、プライバシー侵害
- **完全性評価**: 質問への回答の完全性
- **関連性スコア**: プロンプトとの関連性
- **品質スコアリング**: 総合的な品質評価（0-100点）
- **改善提案**: 具体的な修正案の提示

## 検証項目

### 1. 幻覚（ハルシネーション）検出

AIが事実と異なる情報を自信を持って生成する現象を検出します。

#### 検出パターン

**タイプ1: 事実の捏造**
```
入力プロンプト: 「Pythonの作者は誰ですか？」

AI出力: 「Pythonの作者はJames Goslingです。1991年にリリースされました。」

検証結果: ❌ 幻覚検出
- 問題: Pythonの作者はGuido van Rossum（James GoslingはJavaの作者）
- 重大度: 高
- カテゴリ: 事実の誤り
```

**タイプ2: 存在しない引用**
```
AI出力: 「Einstein (1920)は『時間は相対的な幻想である』と述べています。」

検証結果: ❌ 幻覚検出
- 問題: この正確な引用は確認できない
- 重大度: 中
- カテゴリ: 不正確な引用
```

**タイプ3: 架空の統計**
```
AI出力: 「調査によると、85%の開発者がTypeScriptを好んでいます。」

検証結果: ⚠️ 要検証
- 問題: 出典が明記されていない
- 推奨: 具体的な調査名、実施年を確認
```

**タイプ4: 存在しないAPIやライブラリ**
```
AI出力: 「React Hooksの`useAutoSave()`を使用すると自動保存できます。」

検証結果: ❌ 幻覚検出
- 問題: `useAutoSave`は標準のReact Hooksに存在しない
- 重大度: 高
- カテゴリ: 架空のAPI
```

### 2. 事実確認

#### 検証可能な主張のチェック

```
AI出力の分析:
「東京タワーは1958年に建設され、高さは333メートルです。」

検証項目:
✓ 建設年: 1958年（正確）
✓ 高さ: 333メートル（正確）

総合評価: ✓ 事実として正確
```

#### クロスリファレンス

```
主張: 「Node.jsはRyan Dahlによって2009年に作成されました。」

検証ソース:
1. Wikipedia ✓
2. Node.js公式サイト ✓
3. GitHub リポジトリ ✓

信頼度: 高（複数の信頼できるソースで確認）
```

### 3. 論理性チェック

#### 矛盾の検出

```
AI出力:
「このアルゴリズムの時間計算量はO(n)です。最悪の場合、すべての要素を
2回走査する必要があります。したがって、非常に効率的です。」

検証結果: ❌ 論理的矛盾
- 問題1: 2回走査する場合、時間計算量はO(2n) = O(n)だが説明が不正確
- 問題2: 「非常に効率的」は文脈依存（データサイズによる）
- 改善案: 「線形時間O(n)で動作し、入力サイズに対して効率的です」
```

#### 因果関係の妥当性

```
AI出力:
「気温が上昇したため、売上が増加しました。」

検証結果: ⚠️ 因果関係が不明確
- 問題: 相関関係と因果関係の混同の可能性
- 推奨: 「気温上昇と売上増加に相関が見られます」
- 追加検証: 他の要因（季節、キャンペーン等）の考慮
```

#### 推論の飛躍

```
AI出力:
「Reactは人気があります。したがって、すべてのプロジェクトでReactを
使用すべきです。」

検証結果: ❌ 推論の飛躍
- 問題: 人気 ≠ すべてのケースに最適
- 改善案: 「Reactは多くのプロジェクトで有効な選択肢ですが、
  プロジェクトの要件に応じて適切な技術を選択すべきです」
```

### 4. 一貫性検証

#### 出力内の一貫性

```
AI出力（同一回答内）:
「Pythonは動的型付け言語です。」
...（中略）...
「Pythonは静的型付けにより、型安全性が保証されます。」

検証結果: ❌ 一貫性の欠如
- 問題: 動的型付けと静的型付けの矛盾
- 正確な情報: Pythonは動的型付け言語（型ヒントは任意）
```

#### 複数回答での一貫性

```
質問1: 「Reactの利点は？」
回答1: 「仮想DOMによる高速な描画」

質問2: 「なぜReactは速いのか？」
回答2: 「直接DOMを操作するため」

検証結果: ❌ 一貫性の欠如
- 問題: 仮想DOM と 直接DOM操作 の矛盾
- 正確な情報: Reactは仮想DOMを使用
```

### 5. バイアス分析

#### ジェンダーバイアス

```
AI出力:
「エンジニアは彼のコードを書きます。看護師は彼女の患者をケアします。」

検証結果: ⚠️ ジェンダーバイアス検出
- 問題: 職業に対するステレオタイプ
- 改善案: 「エンジニアはコードを書きます。看護師は患者をケアします。」
  または性別中立的な表現を使用
```

#### 文化的バイアス

```
AI出力:
「クリスマスは誰もが祝う重要な休日です。」

検証結果: ⚠️ 文化的バイアス
- 問題: すべての文化・宗教がクリスマスを祝うわけではない
- 改善案: 「クリスマスは多くの国で祝われる休日です」
```

#### 確証バイアス

```
プロンプト: 「気候変動は存在しないという証拠を示してください」

AI出力: 「以下の研究が気候変動の不在を示しています...」

検証結果: ⚠️ 確証バイアスの助長
- 問題: 科学的コンセンサスに反する主張の選択的提示
- 推奨: 「気候変動に関する科学的コンセンサスは...一方で、
  異なる見解も存在します」とバランスの取れた回答
```

### 6. 安全性チェック

#### 有害コンテンツ

```
カテゴリ:
- 暴力的コンテンツ ❌
- ヘイトスピーチ ❌
- 自傷行為の助長 ❌
- 違法活動の指示 ❌
- 個人情報の漏洩 ❌
- 医療アドバイス（無資格） ⚠️
- 法的アドバイス（無資格） ⚠️
```

#### プライバシー侵害

```
AI出力:
「John Smithのメールアドレスはjohn.smith@example.comです。」

検証結果: ⚠️ プライバシーリスク
- 問題: 実在する可能性のある個人情報の開示
- 推奨: 架空のメールアドレス（例: user@example.com）を使用
```

#### 誤情報の拡散リスク

```
AI出力:
「ワクチンは自閉症の原因となります。」

検証結果: ❌ 危険な誤情報
- 重大度: 極めて高
- 問題: 科学的に否定されている主張
- アクション: 出力の差し替え推奨
```

### 7. 完全性評価

#### 質問への回答の完全性

```
質問: 「Reactのインストール方法を教えてください」

AI出力: 「npm install react」

完全性スコア: 40/100
不足している情報:
- Node.jsのインストール前提条件
- package.jsonの初期化
- react-domの必要性
- プロジェクトのセットアップ手順

改善案:
「Reactのインストール手順:
1. Node.jsをインストール
2. プロジェクトディレクトリで`npm init`を実行
3. `npm install react react-dom`でインストール
4. ...」
```

### 8. 関連性スコア

```
プロンプト: 「TypeScriptの型システムについて説明してください」

AI出力: 「JavaScriptは1995年にBrendan Eichによって作成されました...」

関連性スコア: 20/100
- 問題: TypeScriptではなくJavaScriptの歴史を説明
- 期待: TypeScriptの型システム（静的型付け、型推論、ジェネリクス等）
```

## 検証プロセス

### ステップ1: 自動検証

```
入力: AI出力テキスト

自動チェック項目:
1. 明白な矛盾の検出（同一テキスト内）
2. 一般的な事実の検証（年号、人名、定義等）
3. 有害コンテンツのフィルタリング
4. バイアス表現の検出
5. フォーマット・構造の評価

出力: 初期検証レポート
```

### ステップ2: 詳細分析

```
各主張の詳細検証:
- 事実確認（外部ソース参照）
- 論理的妥当性の評価
- コンテキストとの整合性
- 引用の正確性

出力: 問題点リスト
```

### ステップ3: スコアリング

```
総合品質スコア (0-100):
- 正確性: 25点
- 論理性: 20点
- 一貫性: 15点
- 完全性: 15点
- 関連性: 10点
- 安全性: 10点
- バイアスの少なさ: 5点

総合評価: 85/100 (良好)
```

### ステップ4: 改善提案

```
問題点ごとに具体的な改善案:

問題1: 事実の誤り（line 5）
修正前: 「Pythonの作者はJames Goslingです」
修正後: 「Pythonの作者はGuido van Rossumです」

問題2: 不完全な説明（line 12）
追加すべき情報:
- インストールの前提条件
- 環境設定の手順
```

## 検証レポート形式

### 標準レポート

```markdown
# AI出力検証レポート

## サマリー
- 総合スコア: 78/100
- 検証日時: 2024-11-22 15:30:00
- 出力タイプ: 技術解説

## 検証結果

### ✓ 合格項目
- 論理性: 85/100
- 一貫性: 90/100
- 安全性: 100/100

### ⚠️ 要改善項目
- 正確性: 65/100
  - 問題: 3件の事実誤認を検出
- 完全性: 70/100
  - 問題: 重要な前提条件が欠落

### ❌ 重大な問題
- 幻覚（ハルシネーション）: 2件検出
  1. 存在しないAPIメソッドの言及
  2. 不正確な統計データ

## 詳細分析

### 幻覚検出

**問題1: 存在しないAPI**
```
行番号: 15
内容: 「useAutoSave() フックを使用」
問題: React標準フックに存在しない
重大度: 高
修正案: 「カスタムフック useAutoSave() を実装」または削除
```

**問題2: 不正確な統計**
```
行番号: 28
内容: 「95%の開発者が使用」
問題: 出典不明、検証不可
重大度: 中
修正案: 出典を明記、または「多くの開発者が使用」に変更
```

### 事実確認

**検証済み事実: 5件**
- ✓ TypeScriptはMicrosoftが開発
- ✓ 2012年にリリース
- ✓ JavaScriptのスーパーセット
- ✓ 静的型付けをサポート
- ✓ VSCodeで優れたサポート

**未検証の主張: 2件**
- ⚠️ 「最も人気のある型付き言語」（基準不明）
- ⚠️ 「学習曲線が低い」（主観的）

### バイアス分析

検出されたバイアス: なし

### 安全性

安全性チェック: 合格
- 有害コンテンツ: なし
- プライバシー侵害: なし
- 誤情報: なし

## 改善推奨事項

### 優先度: 高
1. 存在しないAPIの記述を削除または修正
2. 統計データに出典を追加

### 優先度: 中
3. 不完全な説明に詳細を追加
4. 主観的な表現を客観的に修正

### 優先度: 低
5. 文章の流暢性を向上

## 修正版（提案）

[改善された出力テキスト]
```

## 使用例

### 基本的な検証

```
以下のAI出力を検証してください：

「Reactは2013年にFacebookによって公開されたJavaScriptライブラリです。
仮想DOMを使用することで、通常のDOM操作より10倍高速です。」

検証項目:
- 事実の正確性
- 数値の妥当性
- 幻覚の有無
```

### 包括的な検証

```
以下のAI生成記事を包括的に検証してください：

[長文の技術記事]

検証項目:
- 事実確認（すべての主張）
- 論理的一貫性
- 幻覚検出
- バイアス分析
- 完全性評価
- 安全性チェック

出力: 詳細レポート
```

### コード説明の検証

```
以下のコード説明を検証してください：

「このTypeScriptコードは、async/awaitを使用してAPIを呼び出します。
エラーハンドリングにはtry-catchを使用し、失敗時は自動的にリトライします。」

コード:
[実際のコード]

検証項目:
- コードと説明の一致
- 技術的な正確性
- 欠落している重要な情報
```

### 複数出力の比較検証

```
同じプロンプトに対する3つの異なるAI出力を比較検証してください：

出力A: [テキスト]
出力B: [テキスト]
出力C: [テキスト]

評価基準:
- 正確性
- 完全性
- 一貫性

最も品質の高い出力を選択し、理由を説明してください。
```

## 高度な機能

### 自動ファクトチェック

```
外部ソースとの照合:
- Wikipedia API
- 公式ドキュメント
- 学術データベース
- 信頼できるニュースソース

信頼度スコアの算出:
- 複数ソースで確認 → 信頼度: 高
- 単一ソースのみ → 信頼度: 中
- ソースなし → 信頼度: 低（要検証）
```

### リアルタイム検証

```
ストリーミング出力の検証:
- トークンごとにリアルタイム分析
- 問題検出時に即座にアラート
- 生成を中断して修正
```

### ドメイン特化検証

```
技術文書:
- APIドキュメントとの照合
- バージョン情報の確認
- 非推奨機能の検出

医療情報:
- 医学的根拠の確認
- 免責事項の必要性チェック

法律情報:
- 管轄の明記
- 免責事項の必要性チェック
```

## ベストプラクティス

1. **複数の検証手法を組み合わせる**: 自動検証 + 人間のレビュー
2. **コンテキストを考慮**: 用途に応じた検証基準の調整
3. **継続的な改善**: 検出パターンの更新
4. **透明性**: 検証プロセスと基準を明確に
5. **バランス**: 過度に厳格すぎず、実用性を保つ
6. **ドメイン知識**: 専門分野では専門家のレビューを推奨

## 制限事項

- 最新情報の検証には限界あり（学習データの日付による）
- 主観的な表現の評価は難しい
- すべての事実を検証することは不可能
- 文化的・言語的ニュアンスの評価には限界あり

## バージョン情報

- スキルバージョン: 1.0.0
- 最終更新: 2025-11-22

---

## 使用例まとめ

### シンプルな検証

```
このAI出力に幻覚が含まれていないか検証してください：
[テキスト]
```

### 詳細な検証

```
以下のAI出力を包括的に検証し、詳細レポートを生成してください：
[テキスト]

検証項目すべて実施
```

このスキルで、AI出力の品質を確保し、信頼性を向上させましょう！
