# Alert Types Reference

Event types and alert configurations for drug discovery intelligence.

## Alert Categories

| Category | Description | Priority |
|----------|-------------|----------|
| Clinical | Trial updates, results | High |
| Regulatory | Approvals, rejections | Critical |
| Scientific | Publications, presentations | Medium |
| Business | Deals, partnerships, M&A | High |
| Patent | Filings, grants, expiries | Medium |
| Competitive | Competitor moves | Medium |
| Conference | Meeting abstracts | Low-Medium |
| Safety | Safety signals | Critical |

## Clinical Trial Alerts

### Trial Status Changes

| Event | Description | Priority |
|-------|-------------|----------|
| Trial starts | New trial initiated | Medium |
| Recruitment starts | Active enrollment | Low |
| Recruitment complete | Enrollment finished | Medium |
| Primary completion | Endpoint reached | High |
| Trial completes | Study finished | High |
| Trial terminated | Stopped early | Critical |
| Trial suspended | Paused | High |

### Clinical Results

| Event | Description | Priority |
|-------|-------------|----------|
| Positive Phase 2 | Good results | High |
| Negative Phase 3 | Trial failed | Critical |
| Publication of results | Paper published | Medium |
| Conference presentation | Data presented | Medium |

### Alert Configuration

```yaml
clinical_alerts:
  on_trial_start: true
  on_status_change: true
  on_completion: true
  on_publication: true
  filters:
    phase: [2, 3]
    indication: [NSCLC, CRC]
    competitors: [AZ, BMS, Merck]
```

## Regulatory Alerts

### FDA Actions

| Event | Description | Priority |
|-------|-------------|----------|
| NDA/BLA submission | Application filed | High |
| Priority review granted | Faster review | High |
| Breakthrough designation | Special status | High |
| CRL issued | Rejection letter | Critical |
| Approval | Drug approved | Critical |
| Advisory committee | Meeting scheduled | High |
| Label update | New information | Medium |

### EMA Actions

| Event | Description | Priority |
|-------|-------------|----------|
| MAA submission | Application filed | High |
| CHMP opinion | Committee recommendation | High |
| Approval | Drug approved | Critical |
| Refusal | Application rejected | Critical |
| Conditional approval | With obligations | High |

### NMPA (China) Actions

| Event | Description | Priority |
|-------|-------------|----------|
| NDA submission | Application filed | Medium |
| Priority review | Faster review | Medium |
| Approval | Drug approved | High |
| Rejection | Application rejected | High |

## Scientific Alerts

### Publications

| Event | Description | Priority |
|-------|-------------|----------|
| High-impact paper | Nature/Science/Cell | Medium |
| Target validation | New mechanism | Medium |
| Biomarker discovery | Predictive marker | Medium |
| Resistance mechanism | Drug resistance | High |
| Safety concern | Toxicity finding | High |
| Novel scaffold | New chemistry | Low-Medium |

### Preprint Servers

| Source | Type | Priority |
|--------|------|----------|
| bioRxiv | Biology | Medium |
| medRxiv | Medicine | Medium |
| chemRxiv | Chemistry | Low-Medium |

### Conference Abstracts

| Conference | Timing | Priority |
|-----------|--------|----------|
| ASCO | May/June | High |
| ESMO | September/October | High |
| AACR | March/April | Medium |
| ASH | December | Medium (hematology) |
| WCLC | September | Medium (oncology) |

## Business Alerts

### M&A Activity

| Event | Description | Priority |
|-------|-------------|----------|
| Acquisition announced | Company being acquired | Critical |
| Acquisition completed | Deal closed | Critical |
| Divestiture | Asset sold | High |
| Spin-off | Company separation | Medium |

### Licensing Deals

| Event | Description | Priority |
|-------|-------------|----------|
| Deal announced | Licensing agreement | High |
| Deal completed | Payment made | Medium |
| Option exercised | Option taken | High |
| Milestone triggered | Milestone met | Low-Medium |
| Termination | Deal ended | Medium |

### Partnership Announcements

| Event | Description | Priority |
|-------|-------------|----------|
| Collaboration | R&D partnership | Medium |
| Co-development | Joint development | High |
| Co-promotion | Joint marketing | Medium |
| Joint Venture | New entity | High |

### Investment Events

| Event | Description | Priority |
|-------|-------------|----------|
| IPO | Public offering | Medium |
| Follow-on offering | Additional shares | Low-Medium |
| Private financing | VC investment | Medium |
| PIPE | Private investment in public | Low-Medium |

## Patent Alerts

### Patent Filings

| Event | Description | Priority |
|-------|-------------|----------|
| PCT filed | International application | Medium |
| US patent filed | US application | Medium |
| EP patent filed | European application | Medium |
| CN patent filed | Chinese application | Medium |

### Patent Grants

| Event | Description | Priority |
|-------|-------------|----------|
| Patent granted | Patent issued | High |
| Patent rejected | Application denied | Medium |
| Patent opposed | Challenge filed | High |

### Patent Expiries

| Event | Description | Priority |
|-------|-------------|----------|
| Patent expires | Term ends | Low (generic) |
| SPC expires | Extension ends | Medium |
| Terminal disclaimer | Disclaimer filed | Low |

## Competitive Intelligence Alerts

### Pipeline Updates

| Event | Description | Priority |
|-------|-------------|----------|
| New program | Pipeline addition | Medium |
| Program discontinued | Pipeline removal | Medium |
| Indication change | New/modified indication | Medium |
| Stage change | Phase advancement | High |

### Commercial Updates

| Event | Description | Priority |
|-------|-------------|----------|
| Launch announced | Market entry | High |
| Label expansion | New indication | Medium |
| Price change | Pricing update | Low-Medium |
| Withdrawal | Market exit | High |

## Safety Alerts

### Safety Signals

| Event | Description | Priority |
|-------|-------------|----------|
| FDA safety alert | FDA warning | Critical |
| EMA safety alert | EMA warning | Critical |
| Black box warning | Label warning | Critical |
| Withdrawal for safety | Market exit due to safety | Critical |
| DILI signal | Liver toxicity | High |
| Cardiac toxicity | Heart safety | High |
| Death reported | Fatalities | Critical |

## Alert Priority Matrix

### Critical Alerts

- Immediate action required
- Regulatory approvals/rejections
- Major M&A
- Safety concerns
- Phase 3 trial failures

**Response time**: Within hours

### High Priority

- Action required within days
- Regulatory submissions
- Phase 2 results
- Patent grants
- Competitor approvals

**Response time**: Within 1-2 days

### Medium Priority

- Monitor for trends
- Publication of papers
- Conference abstracts
- Pipeline updates
- Deal announcements

**Response time**: Within 1 week

### Low Priority

- Information only
- General industry news
- Minor milestone payments
- Patent expiries (far future)

**Response time**: As part of regular review

## Alert Configuration Examples

### Target-Specific Alert

```yaml
name: EGFR Competitive Alerts
targets:
  - EGFR
  - Exon 19 deletion
  - T790M
  - C797S

competitors:
  - AstraZeneca
  - Johnson & Johnson
  - Roche
  - Merck

events:
  - clinical_trial_updates
  - regulatory_approvals
  - publications
  - patent_filings

priority:
  phase_3: high
  phase_2: medium
  phase_1: low

filters:
  exclude_preclinical: true
  exclude_observational: true
```

### Company-Specific Alert

```yaml
name: Competitor Monitoring
company: AstraZeneca

events:
  - pipeline_updates
  - partnership_announcements
  - regulatory_submissions
  - clinical_results

therapeutic_areas:
  - Oncology
  - Respiratory
  - Cardiovascular

exclude:
  - OTC products
  - Generics
```

## Notification Settings

### Frequency Options

| Frequency | Use Case |
|-----------|----------|
| Real-time | Critical safety events |
| Hourly | High-priority competitive |
| Daily | Active programs |
| Weekly | General monitoring |
| Monthly | Landscape updates |

### Notification Methods

| Method | Use Case |
|--------|----------|
| Email | Standard delivery |
| SMS | Critical alerts |
| Slack | Team integration |
| Dashboard | Passive monitoring |
| API | Automated systems |

### Digest vs. Individual

| Type | Pros | Cons |
|------|------|------|
| Individual | Immediate awareness | Alert fatigue |
| Digest | Curated, summarized | Delayed |

## Alert Deduplication

### Strategies

1. **Group related events**: Single notification for cluster
2. **Suppress duplicates**: Same event from multiple sources
3. **Throttle**: Limit frequency per alert type
4. **Aggregate**: Combine similar alerts

### Example

```python
# Group clinical trial updates within 24 hours
if event.type == "clinical" and similar_events_within_24h:
    group_and_send_digest()
```

## Alert Verification

### False Positive Reduction

| Check | Method |
|-------|--------|
| Source verification | Confirm from multiple sources |
| Cross-reference | Check against known data |
| Human review | Manual validation for high-priority |

### Quality Metrics

| Metric | Target |
|--------|--------|
| Precision | >80% (relevant alerts) |
| Recall | >90% (missed alerts) |
| Timeliness | <24 hours from event |

## Best Practices

1. **Start narrow**: Add filters gradually
2. **Adjust frequency**: Based on alert volume
3. **Review regularly**: Update filters as needed
4. **Document actions**: Track alert-driven decisions
5. **Escalation**: Path for critical alerts

## Common Pitfalls

| Pitfall | Solution |
|---------|----------|
| Alert fatigue | Reduce frequency, add filters |
| False positives | Increase specificity |
| Missed events | Broaden filters, multiple sources |
| Delayed notification | Check for source latency |
| Duplicate alerts | Implement deduplication
