---
name: analizador-traccion
description: Analiza métricas post-lanzamiento para determinar si un producto tiene tracción real o si debes pivotar. Interpreta señales de usuarios, retención, engagement y monetización. Úsalo después de lanzar para tomar decisiones basadas en datos sobre continuar, pivotar o cerrar.
---

# Analizador de Tracción

## Propósito

Este skill te ayuda a interpretar las métricas y señales de tu producto después del lanzamiento para responder la pregunta más importante: **"¿Tengo tracción real o estoy engañándome a mí mismo?"**

## Filosofía de Tracción

### ¿Qué es Tracción Real?

**Tracción NO es:**
- ❌ Muchos registros sin actividad
- ❌ Tráfico de un lanzamiento viral que no se convierte
- ❌ Amigos/familia usando el producto para apoyarte
- ❌ Métricas de vanidad (visitas, likes, seguidores)

**Tracción SÍ es:**
- ✅ Usuarios regresando sin que los contactes
- ✅ Crecimiento orgánico (usuarios refieren a otros)
- ✅ Disposición demostrada a pagar
- ✅ Usuarios pidiendo nuevas características
- ✅ Retención sostenida semana tras semana

### La Verdad Incómoda

**REGLA DE ORO:** Si tienes que preguntarte si tienes tracción, probablemente no la tienes.

La tracción real se siente diferente:
- Los usuarios te contactan a ti (no al revés)
- Recibes feedback sin solicitarlo
- Las métricas crecen sin esfuerzo extraordinario
- Hay urgencia en las solicitudes de los usuarios

## Marco de Evaluación de Tracción

### Nivel 1: 🔴 ZONA ROJA (Sin Tracción)
**Síntomas:**
- < 5% de registrados son activos
- Retención a 7 días < 10%
- Zero usuarios pagando después de 30 días
- No hay crecimiento orgánico
- Usuarios no completan el flujo principal
- Feedback es "está bien" o silencio

**Acción:** Pivotar inmediatamente o cerrar

### Nivel 2: 🟡 ZONA AMARILLA (Señales Mixtas)
**Síntomas:**
- 10-30% de usuarios activos
- Retención a 7 días: 20-40%
- 1-5 usuarios pagando
- Crecimiento lento pero constante
- Algunos usuarios comprometidos pero mayoría inactiva
- Feedback positivo pero sin urgencia

**Acción:** Investigar profundamente antes de doblar esfuerzo

### Nivel 3: 🟢 ZONA VERDE (Tracción Real)
**Síntomas:**
- > 40% de usuarios activos
- Retención a 7 días > 50%
- Usuarios pagando sin fricción
- Crecimiento orgánico medible
- Usuarios pidiendo features activamente
- Referrals espontáneos

**Acción:** Duplicar esfuerzos, construir más

## Métricas Críticas por Tipo de Producto

### SaaS / Web Apps

**Semana 1-2 (Post-Lanzamiento):**
- **Registros:** [X] usuarios
- **Activación:** % que completan setup/onboarding
- **Usuarios activos diarios (DAU):** [Y]
- **Feature core usado:** % de usuarios que lo usan

**Benchmarks:**
- ✅ Bueno: >60% completa onboarding, >40% usa feature core
- 🟡 Mediocre: 30-60% onboarding, 20-40% feature usage  
- 🔴 Malo: <30% onboarding, <20% feature usage

## Cuando Pivotar vs Perseverar

### Pivota Si:
- Han pasado 3+ meses sin mejora en retención core
- Los usuarios dicen "está bien" pero no lo usan
- Tienes que explicar por qué deberían usarlo
- La única tracción es de gente que te conoce
- Estás forzando encaje que no existe

### Persevera Si:
- Núcleo pequeño de usuarios super comprometidos
- Retención core está mejorando mes a mes
- Feedback pide "más de esto" no "cámbialo"
- Hay crecimiento orgánico medible
- Las entrevistas revelan dolor real
