---
name: Announcement Drafter
slug: announcement-drafter
description: Write clear, impactful company announcements for any audience
category: communication
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "draft announcement"
  - "write announcement"
  - "company announcement"
  - "create announcement"
tags:
  - announcements
  - company-communication
  - change-management
  - internal-comms
---

# Announcement Drafter

The Announcement Drafter skill helps you create clear, well-structured announcements for any organizational change, update, or news. Whether you're announcing a new hire, policy change, product launch, organizational restructuring, or company milestone, this skill ensures your message is clear, appropriately toned, and drives the right response.

This skill understands that announcements are high-stakes communication. They set tone, manage expectations, and can significantly impact morale, adoption, or perception. The skill helps you balance transparency with tact, excitement with realism, and information with brevity.

Great announcements inform, engage, and motivate. They answer key questions before they're asked, acknowledge impact, and provide clear next steps. This skill makes creating them efficient while maintaining the quality and care they deserve.

## Core Workflows

### Workflow 1: Internal Company Announcement
1. **Define Purpose**: Understand what's being announced and why
2. **Identify Audience**: Determine who needs to know and what they care about
3. **Assess Impact**: Understand how this affects different groups
4. **Structure Message**: Lead with news, explain impact, provide next steps
5. **Set Tone**: Match appropriate formality and emotion to content
6. **Review**: Check for clarity, completeness, and potential concerns

### Workflow 2: External Announcement
1. **Craft Message**: Develop external-facing narrative
2. **Consider Stakeholders**: Customers, partners, press, public
3. **Manage Expectations**: Set clear boundaries on what's happening
4. **Provide Evidence**: Support claims with data or proof points
5. **Include CTAs**: Give clear ways to engage or learn more
6. **Coordinate Timing**: Align with internal comms and other channels

### Workflow 3: Change Management Announcement
1. **Lead with Why**: Explain rationale before the what
2. **Acknowledge Impact**: Recognize how change affects people
3. **Provide Timeline**: Give clear dates and milestones
4. **Offer Support**: Share resources and who to contact
5. **Create Space for Feedback**: Open channels for questions
6. **Follow Up**: Plan ongoing communication cadence

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| New hire | "Draft announcement for new hire [name/role]" |
| Product launch | "Write product launch announcement for [product]" |
| Policy change | "Create announcement for new [policy] policy" |
| Org change | "Draft org restructuring announcement" |
| Milestone | "Write celebration announcement for [achievement]" |
| Incident | "Create incident announcement about [issue]" |
| Partnership | "Draft partnership announcement with [company]" |
| Event | "Write event announcement for [event name]" |

## Announcement Types & Templates

### Template 1: New Hire Announcement
```markdown
Subject: Please welcome [Name] to [Team/Company]!

Team,

I'm excited to announce that [Full Name] is joining [Company] as [Title] on [Team], starting [Date].

**About [First Name]:**
[2-3 sentences about background, experience, and what makes them awesome]

**In this role, [First Name] will:**
• [Responsibility 1]
• [Responsibility 2]
• [Responsibility 3]

[Personal touch: hobby, fun fact, or quote from them]

Please join me in welcoming [First Name] to the team!

[First Name], we're thrilled to have you aboard.

[Your name]

---
📧 [Email]
💬 [Slack: @username]
📍 [Location/Time zone]
```

### Template 2: Product Launch Announcement
```markdown
Subject: 🚀 Introducing [Product Name]

Hi everyone,

Today we're launching [Product Name] - [one-sentence description of what it is and who it's for].

**The Problem:**
[2-3 sentences on the problem this solves]

**Our Solution:**
[Product Name] helps [target audience] [achieve specific outcome] by [unique approach].

**Key Features:**
• [Feature 1] - [Benefit]
• [Feature 2] - [Benefit]
• [Feature 3] - [Benefit]

**Availability:**
[Product Name] is available [now/starting Date] for [pricing/who can access].

→ [Primary CTA button/link]

**What This Means for You:**
[Specific relevance to internal audience]

**Next Steps:**
• [Date]: [Milestone]
• [Date]: [Milestone]

Huge thanks to [Teams/people] who made this happen!

Questions? [Contact/channel]

[Your name]
```

### Template 3: Policy Change Announcement
```markdown
Subject: Update to [Policy Name] - Effective [Date]

Team,

We're making a change to our [policy area] policy, effective [Date].

**What's Changing:**
[Clear, concise explanation of the change]

**Why We're Making This Change:**
[Rationale - context and reasoning]

**What This Means for You:**

**If you [scenario A]:** [Impact and what to do]

**If you [scenario B]:** [Impact and what to do]

**How This Works:**
1. [Step or detail 1]
2. [Step or detail 2]
3. [Step or detail 3]

**Resources:**
• [Policy doc] → Link
• [FAQ] → Link
• [Support/contact info]

**Key Dates:**
• [Date]: [Milestone]
• [Date]: [Effective date]

**Questions?**
[Contact person/channel/office hours]

We believe this change will [positive outcome]. Thanks for your understanding as we make this transition.

[Your name]
```

### Template 4: Organizational Change
```markdown
Subject: Important Update: Changes to [Team/Department]

Team,

I want to share some important changes to [team/department] structure, effective [Date].

**What's Changing:**
[Clear explanation of the reorganization]

[Optional: Visual org chart]

**Why Now:**
[Context for timing and reasoning]
• Reason 1
• Reason 2
• Expected outcome

**What This Means:**

**For [Group A]:**
[Specific impact and changes]
Your new reporting structure: [Details]

**For [Group B]:**
[Specific impact and changes]

**Timeline:**
• [Date]: [Transition milestone]
• [Date]: [Completion]
• [Date]: [Review point]

**What Stays the Same:**
[Reassuring continuity points]

**Support During Transition:**
• [Resource 1]
• [Resource 2]
• [Office hours/Q&A session details]

I know change can be unsettling. [Acknowledge concerns]. We're committed to [supporting employees/making this smooth].

Questions? Please reach out to [contact] or join us for [Q&A session details].

[Your name]
```

### Template 5: Company Milestone
```markdown
Subject: 🎉 We Did It: [Milestone Achievement]

Team,

I'm thrilled to share that we just [achieved milestone]!

[Brief celebratory opening that captures the significance]

**By the Numbers:**
• [Metric 1]: [Impressive number]
• [Metric 2]: [Impressive number]
• [Metric 3]: [Impressive number]

**What This Means:**
[Impact and significance of the achievement]

**How We Got Here:**
[Brief story of the journey or key factors]

**Shoutouts:**
This wouldn't have been possible without:
• [Team/Person] for [specific contribution]
• [Team/Person] for [specific contribution]
• Everyone who [general contribution]

**Looking Ahead:**
[What's next or how this sets up future success]

Take a moment to celebrate this - you earned it! 🎉

[Optional: Details on celebration event/recognition]

[Your name]
```

### Template 6: Incident/Outage Announcement
```markdown
Subject: [Status]: [Service] Issue - [Date/Time]

Hi everyone,

We're currently experiencing [brief description of issue] affecting [who/what].

**Status:** [Investigating / Identified / Monitoring / Resolved]

**Impact:**
• [What's affected]
• [What's not affected]
• [Estimated users impacted]

**What We Know:**
[Clear, factual description of the issue]

**What We're Doing:**
[Actions being taken to resolve]

**Timeline:**
• [Time]: Issue began
• [Time]: Team notified
• [Time]: [Key milestone]
• **ETA for resolution:** [Estimate or "working on it"]

**Workaround:**
[If available: temporary solution or alternative]

**Updates:**
We'll provide updates every [timeframe] or when status changes.
Follow along: [Status page link]

**For Customers:**
[Guidance on customer communication if relevant]

We know this is frustrating. Our team is working hard to resolve this as quickly as possible.

Questions? [Emergency contact]

[Your name]

---
**[Update cadence as situation evolves]**
```

### Template 7: Partnership Announcement
```markdown
Subject: Exciting News: [Company] Partners with [Partner]

Team,

I'm excited to announce that [Company] is partnering with [Partner Company]!

**About [Partner]:**
[2-3 sentences on who they are and what they do]

**The Partnership:**
Together, we'll [description of what partnership enables].

**What This Means:**
• [Benefit 1]
• [Benefit 2]
• [Benefit 3]

**Timeline:**
• [Date]: [Milestone]
• [Date]: [Launch/integration]

**For Our Customers:**
[How this benefits end users]

**Internally:**
[How this affects team/processes]

**Next Steps:**
[What happens now]

This partnership positions us to [strategic benefit]. Thanks to [teams/people] who made this happen.

[External announcement coming [date/time]]

[Your name]
```

## Best Practices

### Structure Principles
- **Lead with News**: Put the announcement in the first sentence
- **Explain the Why**: Context and rationale matter
- **Address Impact**: Be specific about who's affected and how
- **Provide Next Steps**: Clear actions or timeline
- **Open Channels**: Give people a way to ask questions

### Tone Guidance

| Announcement Type | Tone | Example Opening |
|-------------------|------|-----------------|
| Positive News | Excited, Celebratory | "I'm thrilled to share that..." |
| Policy Change | Clear, Supportive | "We're making a change to improve..." |
| Difficult News | Honest, Empathetic | "I want to share some difficult news..." |
| Incident | Transparent, Factual | "We're currently experiencing..." |
| Milestone | Proud, Grateful | "We did it! Thanks to all of you..." |
| New Hire | Welcoming, Warm | "Please join me in welcoming..." |

### Timing Considerations
- **Internal First**: Tell employees before external announcement
- **All at Once**: Avoid letting people hear through rumor mill
- **Time of Day**: Mid-morning Tuesday-Thursday is often best
- **Day of Week**: Avoid Fridays for difficult news
- **Seasonal**: Consider holidays, busy periods, or other major events

### Audience Segmentation

When the same news needs different announcements:

**Executives/Leadership:**
- More strategic context
- Business impact and metrics
- Competitive positioning
- Risk and opportunity analysis

**Employees/Internal:**
- Personal impact
- How it affects daily work
- Support and resources
- Questions and concerns addressed

**Customers:**
- Benefits to them
- No internal jargon
- Clear timeline
- Support channels

**Public/Press:**
- Company positioning
- Market context
- Quotes from leadership
- Official boilerplate

## Writing Guidelines

### Be Clear
- Use simple language
- Avoid jargon and acronyms
- Be specific, not vague
- Use examples when helpful

### Be Complete
- Answer: What, Why, When, Who, How
- Address obvious questions proactively
- Provide resources and contacts
- Include next steps and timeline

### Be Honest
- Don't sugarcoat bad news
- Acknowledge uncertainty when present
- Admit mistakes if relevant
- Be realistic about impact

### Be Empathetic
- Acknowledge how people might feel
- Show you understand concerns
- Offer support and resources
- Use inclusive language

### Be Actionable
- Tell people what to do next
- Provide clear deadlines
- Offer resources and help
- Make it easy to get more info

## Common Pitfalls to Avoid

- **Burying the Lede**: Put the news up front, not in paragraph 3
- **Missing the Why**: People need context and rationale
- **No Impact Statement**: Be clear about who's affected and how
- **Vague Timeline**: Give specific dates when possible
- **No Questions Channel**: Always provide a way to ask questions
- **Too Much Detail**: Keep it concise, link to details
- **Wrong Tone**: Match tone to content (don't be chipper about layoffs)
- **One-and-Done**: Important changes need ongoing communication
- **Assumption of Knowledge**: Explain context, don't assume background
- **No Follow-Up**: Plan for next communication

## Change Management Best Practices

For announcements about significant changes:

**Before Announcing:**
- Brief leaders and managers first
- Prepare FAQs
- Set up support channels
- Plan follow-up communications

**In the Announcement:**
- Lead with why
- Acknowledge impact
- Provide support resources
- Give timeline
- Open feedback channels

**After Announcing:**
- Monitor questions and concerns
- Provide regular updates
- Adjust based on feedback
- Recognize those affected
- Celebrate milestones

## Sensitive Announcement Guidelines

### Layoffs/Reductions
- Be direct and compassionate
- Explain business rationale
- Detail support for affected employees
- Address survivor concerns
- Provide timeline
- Offer ways to help

### Acquisitions/Mergers
- Address uncertainty directly
- Be clear about timeline
- Explain cultural fit
- Detail what changes and what stays
- Provide integration milestones
- Create feedback channels

### Leadership Changes
- Announce departures respectfully
- Frame positively when possible
- Address transition plan
- Reassure about continuity
- Introduce new leadership warmly
- Provide context on selection

## Quality Checklist

Before sending any announcement:

**Content**
- [ ] News in first sentence
- [ ] Why explained clearly
- [ ] Impact addressed
- [ ] Timeline provided
- [ ] Next steps clear
- [ ] Questions channel specified

**Tone**
- [ ] Appropriate to news
- [ ] Empathetic to impact
- [ ] Professional but human
- [ ] Consistent with company voice

**Completeness**
- [ ] All stakeholders addressed
- [ ] Links work
- [ ] Contact info correct
- [ ] FAQs prepared if needed
- [ ] Follow-up plan in place

**Distribution**
- [ ] Right channels selected
- [ ] Timing appropriate
- [ ] Internal before external
- [ ] Coordinated with other comms

## Integration Points

- **Slack/Teams**: Post in appropriate channels
- **Email**: Send to distribution lists
- **Intranet**: Archive on company wiki
- **All-Hands**: Follow up in meetings
- **One-on-Ones**: Managers discuss with teams
- **FAQ System**: Link to detailed Q&A
- **Calendar**: Schedule follow-up communications
