# Artemis Debug - Quick Index

## Fast Investigation

```bash
python scripts/investigate.py -t {type} -w {webId} -u "{username}"
```

## Types

| Type | Use For |
|------|---------|
| `promotion` | Promo reject, bonus, lucky wheel |
| `payment` | Deposit, withdrawal, pending |
| `vip` | Level upgrade, benefits |
| `betting` | Bet settlement, void |
| `login` | Access, locked, 2FA |

## WebId Quick

| Site | WebId |
|------|-------|
| Saffaluck/sfl | 20154 |
| NocmakatiInc/nmi | 20107 |
| Bet25 | 20120 |
| GBW | 20109 |
| Lucky7 | 20132 |

## Status Codes

### Transaction
| Code | Status |
|------|--------|
| 1 | Pending |
| 2 | Rejected |
| 3 | Approved |

### Payment Gateway
| Code | Status |
|------|--------|
| 1003 | Pending |
| 1007 | Approved |
| 1009 | Rejected |

### VIP Levels
| Id | Level |
|----|-------|
| 1-2 | VIP0, Iron |
| 3-4 | Bronze, Silver |
| 5-7 | Gold, Plat, Diamond |

## To CAS Templates

```
Same FP used. Cannot claim twice from same device.
```

```
Deposit pending at gateway (Status=1003). No callback.
```

```
VIP level is Iron (2). Requires Gold (5). Not eligible.
```

```
Account Suspended (bit 1). Contact admin.
```

## Files

| Need | File |
|------|------|
| SQL rules | `memory/rules.md` |
| Patterns | `memory/brain.json` |
| WebIds | `docs/webids.md` |
| Queries | `docs/queries.md` |

## New User Setup

```bash
python scripts/core.py
```
