# AlertDB Database Schema

## Overview
The AlertDB database manages system alerts and notifications in the Coloris Framework. It handles alert creation, scheduling, and delivery tracking for various system components.

## Core Tables

### Alerts
Manages system alerts and notifications with support for both individual and group-based messaging.

```sql
CREATE TABLE [dbo].[Alerts](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Title] [nvarchar](500) NOT NULL,
	[Message] [nvarchar](4000) NOT NULL,
	[IsGroup] [bit] NULL,
	[GroupName] [nvarchar](4000) NULL,
	[CreatedOn] [datetime] NULL,
	[ScheduledAt] [datetime] NULL,
	[SentOn] [datetime] NULL
) ON [PRIMARY]
```

| Column | Type | Description |
|--------|------|-------------|
| Id | INT, PK | Primary key, auto-incrementing unique identifier for each alert |
| Title | NVARCHAR(500) | Alert title or subject line (required) |
| Message | NVARCHAR(4000) | Alert message content (required) |
| IsGroup | BIT | Flag indicating whether this is a group alert (nullable) |
| GroupName | NVARCHAR(4000) | Name of the target group for group alerts (nullable) |
| CreatedOn | DATETIME | Timestamp when the alert was created (nullable) |
| ScheduledAt | DATETIME | Timestamp when the alert is scheduled to be sent (nullable) |
| SentOn | DATETIME | Timestamp when the alert was actually sent (nullable) |

## Key Features

1. **Alert Management**
   - Unique alert identification with auto-incrementing IDs
   - Title and message content storage with appropriate length limits
   - Support for both individual and group-targeted alerts
   - Comprehensive timestamp tracking for alert lifecycle

2. **Scheduling System**
   - Future alert scheduling capabilities through ScheduledAt field
   - Delivery time tracking with SentOn timestamp
   - Creation time auditing with CreatedOn field

3. **Group Notifications**
   - Support for group-based alerts via IsGroup flag
   - Flexible group name management
   - Scalable group targeting system

## Security

1. **Role-Based Access**
   - Custom role `RoleCCWLCI` for alert operations
   - Dedicated login `CCWLCI` for alert service access with sysadmin privileges

2. **Permissions**
   - Execute permissions on all stored procedures
   - Select, Insert, Update permissions on Alerts table
   - Schema-level permissions for the `dbo` schema

## Relationships
- All alert records are self-contained within the Alerts table
- Group-based relationships managed through GroupName field
- Temporal relationships tracked through timestamp fields

## Best Practices
1. Always use stored procedures for alert operations
2. Maintain proper alert scheduling to avoid system overload
3. Implement regular cleanup of old/sent alerts to maintain performance
4. Follow proper error handling for alert delivery failures
5. Monitor alert delivery status through SentOn timestamps
6. Regular backup of alert data for audit purposes
7. Implement proper indexing on frequently queried fields (Id, CreatedOn, ScheduledAt) 