# ISB Schema Documentation

## Overview
This document describes the ISB core tables, their structures, and relationships. All tables are listed in alphabetical order, with detailed field descriptions and constraints.

## Core Tables

### Account
Defines user accounts in the ISB system.

```sql
CREATE TABLE [dbo].[Account] (
    [AccountId]             INT IDENTITY (1, 1) NOT NULL,
    [Name]                  NVARCHAR (50)  NOT NULL,
    [Email]                 NVARCHAR (50)  NOT NULL,
    [Password]              NVARCHAR (50)  NOT NULL,
    [IsVerifiedTwoFACode]   BIT,
    [SecretKey]             VARCHAR (MAX) NOT NULL,
    [CreatedOn]             DATETIME NOT NULL,
    CONSTRAINT [uq_account] UNIQUE([Email]),
);
```
| Column               | Type            | Description                                                                 |
|----------------------|-----------------|-----------------------------------------------------------------------------|
| AccountId            | INT, IDENTITY   | **Primary Key**. Auto-incremented unique identifier for the account.        |
| Name                 | NVARCHAR(50)    | Account holder's name.                                                      |
| Email                | NVARCHAR(50)    | Account email. **Unique constraint** (`uq_account`).                        |
| Password             | NVARCHAR(50)    | Account password (should be hashed in practice).                            |
| IsVerifiedTwoFACode  | BIT             | Indicates if 2FA code is verified.                                          |
| SecretKey            | VARCHAR(MAX)    | Secret key for 2FA or other security.                                       |
| CreatedOn            | DATETIME        | Account creation timestamp.                                                 |

---

### Brand
Defines brands associated with accounts in the ISB system.

```sql
CREATE TABLE [dbo].[Brand] (
    [BrandId]                INT IDENTITY (1, 1) NOT NULL,
    [AccountId]              INT NOT NULL,
    [WebId]                  INT NOT NULL,
    [SpecialRequirements]    NVARCHAR(MAX),
    [Language]               NVARCHAR(200) NOT NULL,
    [CreatedOn]              DATETIME NOT NULL,
    [ExpiredTime]            DATETIME NOT NULL,
    [IsClosed]               BIT,
    [IsOnBoardCustomer]      BIT DEFAULT(0)
);
```
| Column               | Type             | Description                                                                 |
|----------------------|------------------|-----------------------------------------------------------------------------|
| BrandId              | INT, IDENTITY    | **Primary Key**. Auto-incremented unique identifier for the brand.          |
| AccountId            | INT              | Reference to the owning account (likely a foreign key, but not declared).   |
| WebId                | INT              | Website identifier.                                                         |
| SpecialRequirements  | NVARCHAR(MAX)    | Any special requirements for the brand.                                     |
| Language             | NVARCHAR(200)    | Language code(s) for the brand.                                             |
| CreatedOn            | DATETIME         | Brand creation timestamp.                                                   |
| ExpiredTime          | DATETIME         | When the brand expires.                                                     |
| IsClosed             | BIT              | Indicates if the brand is closed.                                           |
| IsOnBoardCustomer    | BIT, DEFAULT(0)  | Indicates if the brand is for onboarding customers. Default is 0 (false).   |

---

## Relationships
- `Brand.AccountId` references `Account.AccountId` (not explicitly declared as a foreign key in the current schema).

## Notes
- All tables and columns are documented in accordance with the monika-schema-rule.mdc.
- If you add or modify tables, update this documentation accordingly. 