# Job Stored Procedures (SP) List

This document lists all stored procedures (SPs) and relevant scripts found in the `Job` folder and its subfolders. Each entry includes the SP name and a simple description. Entries are listed in alphabetical order by SP name.

| SP Name / Script | Description |
|------------------|-------------|
| AchieveMemberActionLog.sql | Archives and deletes old records from MemberActionLog, moving them to history. |
| AchieveUserActionRecord.sql | Archives and deletes old records from UserActionRecord, moving them to history. |
| Archive 186 days ago data.sql | Archives data older than 186 days (details in script). |
| ArchieveDailyBetSummaryByTimeZone.sql | Archives old DailyBetSummaryByTimeZone records to history by time zone. |
| ArchieveDailyBetSummaryCurrentByTimeZone.sql | Archives current DailyBetSummaryByTimeZone records to history by time zone. |
| ArchieveDailyBetSummaryHistoryByTimeZone.sql | Archives historical DailyBetSummaryByTimeZone records to history by time zone. |
| ArchieveSboCasinoBet.sql | Archives SBO casino bet records. |
| ArchieveSboCasinoBets60.sql | Archives SBO casino bet records (60-day batch). |
| ArchieveSboGamesBets.sql | Archives SBO games bet records. |
| ArchieveSboGamesBets60.sql | Archives SBO games bet records (60-day batch). |
| ArchieveSboSeamlessBets.sql | Archives SBO seamless bet records. |
| ArchieveSboSeamlessBets60.sql | Archives SBO seamless bet records (60-day batch). |
| ArchieveSboSportBetDetail.sql | Archives SBO sport bet detail records. |
| ArchieveSboSportBetDetail60.sql | Archives SBO sport bet detail records (60-day batch). |
| ArchieveSboSportBets.sql | Archives SBO sport bet records. |
| ArchieveSboSportBets60.sql | Archives SBO sport bet records (60-day batch). |
| ArchieveSboThirdPartySportBets.sql | Archives SBO third-party sport bet records. |
| ArchieveSboThirdPartySportBets60.sql | Archives SBO third-party sport bet records (60-day batch). |
| ArchieveSboThirdPartySportBetsDetail.sql | Archives SBO third-party sport bet detail records. |
| ArchieveSboThirdPartySportBetsDetail60.sql | Archives SBO third-party sport bet detail records (60-day batch). |
| ArchieveSboTransferGameproviderBets.sql | Archives SBO transfer game provider bet records. |
| ArchieveSboTransferGameproviderBets60.sql | Archives SBO transfer game provider bet records (60-day batch). |
| ArchieveSboVirtualSportSubBets.sql | Archives SBO virtual sport sub bet records. |
| ArchieveSboVirtualSportSubBets60.sql | Archives SBO virtual sport sub bet records (60-day batch). |
| ArchieveSboVirtualSportsBets.sql | Archives SBO virtual sports bet records. |
| ArchieveSboVirtualSportsBets60.sql | Archives SBO virtual sports bet records (60-day batch). |
| DeletePlayerLoginLogHistory.sql | Deletes old player login log history records. |
| DeleteSboCasinoBetHistory.sql | Deletes old SBO casino bet history records. |
| DeleteSboGameBetHistory.sql | Deletes old SBO game bet history records. |
| DeleteSboSeamlessBetsHistory.sql | Deletes old SBO seamless bets history records. |
| DeleteSboSportsBetDetailsHistory.sql | Deletes old SBO sports bet details history records. |
| DeleteSboSportsBetsHistory.sql | Deletes old SBO sports bets history records. |
| DeleteSboThirdPartySportBetDetailHistory.sql | Deletes old SBO third-party sport bet detail history records. |
| DeleteSboThirdPartySportBetsHistory.sql | Deletes old SBO third-party sport bets history records. |
| DeleteSboTransferGameproviderBetsHistory.sql | Deletes old SBO transfer game provider bets history records. |
| DeleteSboVirtualSportBetHistory.sql | Deletes old SBO virtual sport bet history records. |
| DeleteSboVirtualSportSubBetHistory.sql | Deletes old SBO virtual sport sub bet history records. |
| Job_Hourly_GameCompliance_SuspendActionCheck_1.0.0 | Checks and suspends game compliance actions hourly. |
| Calculate Reedemable.sql | Calculates redeemable referral amounts for customers. |
| Calculate Reward Referral Summary.sql | Calculates and updates referral reward summaries for customers. |
| CheckSQLException.ps1 | PowerShell script: Checks SQL exceptions in error logs and sends alerts. Not a SQL SP. |
| incorrectdailystament_game.sql | Checks and corrects incorrect daily statement data for games. |
| incorrectdailystament_seamlessgame.sql | Checks and corrects incorrect daily statement data for seamless games. |
| incorrectdailystament_sports.sql | Checks and corrects incorrect daily statement data for sports. |
| incorrectdailystament_statement.sql | Checks and corrects incorrect daily statement data. |
| incorrectdailystament_virtualsports.sql | Checks and corrects incorrect daily statement data for virtual sports. |
| incorrectBalance.sql | Checks and corrects incorrect balance data. |
| incorrectdailystament_casino.sql | Checks and corrects incorrect daily statement data for casino. |
| CheckAndFixIncorrectDailystatementTillYesterday.sql | Checks and fixes incorrect daily statements up to yesterday. |
| CheckNagetiveOutstanding.sql | Checks for negative outstanding balances. |
| CheckSBOSeamlessGameProviderRunningBet.sql | Checks for running bets in SBO seamless game provider. |
| CheckSGstatusandstatusatGPmonitor.sql | Checks SG status and status at game provider monitor. |
| CheckSeamlessDuplicateAction.sql | Checks for duplicate seamless actions. |
| Check Player Site Login Count.sql | Checks player site login count. |
| Archive93DaysSummatyHistoryData.sql | Archives 93 days of summary history data. |
| SboSportBetsSummary.sql | Summarizes SBO sport bets (not seamless). |
| SboSportBetsSummaryAPI.sql | Summarizes SBO sport bets via API (not seamless). |
| SboThirdPartySportBetSummary.sql | Summarizes SBO third-party sport bets (not seamless). |
| SboTransferBetsSummary.sql | Summarizes SBO transfer bets (not seamless). |
| SendMailWhenJobFail.sql | Sends mail when a job fails. |
| SboCasinoBetsSummary.sql | Summarizes SBO casino bets (not seamless). |
| SboGameBetsSummary.sql | Summarizes SBO game bets (not seamless). |
| SboLiveCoinSummeryJob.sql | Summarizes SBO live coin jobs (not seamless). |
| SboVirtualSportBetsSummary.sql | Summarizes SBO virtual sport bets (not seamless). |
| SboSeamlessBetsSummary.sql | Summarizes SBO seamless bets. |
| 1.ArchiveDailyBetSummaryToHistory.sql | Archives daily bet summary to history. |
| 2.Archive93DaysAgoData.sql | Archives data older than 93 days. |
| 3.SendMailWhenJobFail.sql | Sends mail when a job fails. |
| CalculateRewardReferralSummary.sql | Calculates and updates reward referral summary (daily). |
| CalculateReedemable.sql | Calculates redeemable referral amounts (daily). |
| 1.DeleteOperatorActivityLogByBatch.sql | Deletes operator activity log records by batch. |
| 2.SendMailWhenFail.sql | Sends mail when a delete operation fails. |
| 1.Delete.sql | Deletes SboSealessWalletRequest records. |
| 1.DeleteBalanceHistoryByBatch.sql | Deletes balance history records by batch. |
| 2.SendAlertWhenFail.sql | Sends alert when a delete operation fails. |
| 1.DeleteDailyStatementHistory.sql | Deletes daily statement history records. |

> **Note:** Some files are PowerShell scripts or utility scripts, not SQL stored procedures. Their purpose is noted in the description. 