## AffiliateContacts

```sql
CREATE TABLE [dbo].[AffiliateContacts]
(
    [ID]         INT  IDENTITY (1, 1)   NOT NULL,
    [WebId]      INT                    NOT NULL,
    [Username]   NVARCHAR (50)          NOT NULL,
    [AffiliateRequestId] INT            NOT NULL,
    [ContactType] NVARCHAR (50)         NOT NULL,
    [ContactValue] NVARCHAR(50)         NOT NULL,
    [CreatedBy]  NVARCHAR (50)          NULL,
    [CreatedOn]  DATETIME               NULL,
    [ModifiedBy] VARCHAR (50)           NULL,
    [ModifiedOn] DATETIME               NULL,
    CONSTRAINT [PK_AffiliateContacts] PRIMARY KEY CLUSTERED ([ID] ASC)
)
```

| Column              | Type            | Null | Default | Description                |
|---------------------|-----------------|------|---------|----------------------------|
| ID                  | INT (IDENTITY)  | NO   |         | Primary Key                |
| WebId               | INT             | NO   |         |                            |
| Username            | NVARCHAR(50)    | NO   |         |                            |
| AffiliateRequestId  | INT             | NO   |         |                            |
| ContactType         | NVARCHAR(50)    | NO   |         |                            |
| ContactValue        | NVARCHAR(50)    | NO   |         |                            |
| CreatedBy           | NVARCHAR(50)    | YES  |         |                            |
| CreatedOn           | DATETIME        | YES  |         |                            |
| ModifiedBy          | VARCHAR(50)     | YES  |         |                            |
| ModifiedOn          | DATETIME       | YES  |         |                            |

- **Primary Key:** `ID`
- **No foreign keys or unique constraints defined.**

## AffiliateRequest

```sql
CREATE TABLE [dbo].[AffiliateRequest]
(
    [ID]         INT  IDENTITY (1, 1)   NOT NULL,
    [WebId]      INT                    NOT NULL,
    [Username]   NVARCHAR (50)          NOT NULL,
    [Status]     INT                    NOT NULL,
    [CreatedBy]  VARCHAR (50)           NULL,
    [CreatedOn]  DATETIME               NULL,
    [ModifiedBy] VARCHAR (50)           NULL,
    [ModifiedOn] DATETIME               NULL,
    CONSTRAINT [PK_AffiliateRequest] PRIMARY KEY CLUSTERED ([ID] ASC)
)
```

| Column      | Type           | Null | Default | Description     |
|-------------|----------------|------|---------|----------------|
| ID          | INT (IDENTITY) | NO   |         | Primary Key     |
| WebId       | INT            | NO   |         |                 |
| Username    | NVARCHAR(50)   | NO   |         |                 |
| Status      | INT            | NO   |         |                 |
| CreatedBy   | VARCHAR(50)    | YES  |         |                 |
| CreatedOn   | DATETIME       | YES  |         |                 |
| ModifiedBy  | VARCHAR(50)    | YES  |         |                 |
| ModifiedOn  | DATETIME       | YES  |         |                 |

- **Primary Key:** `ID`
- **No foreign keys or unique constraints defined.**

## Announcement

```sql
CREATE TABLE [dbo].[Announcement]
(
	[Id] INT IDENTITY (1, 1)		NOT NULL,
	[WebIds] NVARCHAR(MAX)			NULL,
	[AccountTypes] NVARCHAR(MAX)		NULL,
	[SubAccountTypes] NVARCHAR(MAX)		NULL,
	[Title] NVARCHAR(500)			NOT NULL,
	[Content] NVARCHAR(MAX)			NOT NULL,
	[CreatedBy]  NVARCHAR (50)       NOT NULL,
    [CreatedOn]  DATETIME           NOT NULL DEFAULT (GETDATE()),
    [ModifiedBy] NVARCHAR (50)       NOT NULL,
    [ModifiedOn] DATETIME           NOT NULL DEFAULT (GETDATE()),
	[IsPopUp]	 BIT			NOT NULL DEFAULT 0,
	CONSTRAINT [PK_Announcement] PRIMARY KEY CLUSTERED ([Id] ASC)
)
```

| Column           | Type           | Null | Default         | Description     |
|------------------|----------------|------|-----------------|----------------|
| Id               | INT (IDENTITY) | NO   |                 | Primary Key     |
| WebIds           | NVARCHAR(MAX)  | YES  |                 |                 |
| AccountTypes     | NVARCHAR(MAX)  | YES  |                 |                 |
| SubAccountTypes  | NVARCHAR(MAX)  | YES  |                 |                 |
| Title            | NVARCHAR(500)  | NO   |                 |                 |
| Content          | NVARCHAR(MAX)  | NO   |                 |                 |
| CreatedBy        | NVARCHAR(50)   | NO   |                 |                 |
| CreatedOn        | DATETIME       | NO   | GETDATE()       |                 |
| ModifiedBy       | NVARCHAR(50)   | NO   |                 |                 |
| ModifiedOn       | DATETIME       | NO   | GETDATE()       |                 |
| IsPopUp          | BIT            | NO   | 0               |                 |

- **Primary Key:** `Id`
- **No foreign keys or unique constraints defined.**

## BoCategorySetting

```sql
CREATE TABLE [dbo].[BoCategorySetting]
(
    [WebId] INT NOT NULL,
    [CustomerId] INT NOT NULL,
    [IsNew] BIT NOT NULL DEFAULT (0),
    CONSTRAINT [PK_BoCategorySetting] PRIMARY KEY ([WebId],[CustomerId]) 
)
```

| Column      | Type | Null | Default | Description     |
|-------------|------|------|---------|----------------|
| WebId       | INT  | NO   |         | Primary Key (composite) |
| CustomerId  | INT  | NO   |         | Primary Key (composite) |
| IsNew       | BIT  | NO   | 0       |                 |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys or unique constraints defined.**

## CashAgentDomains

```sql
CREATE TABLE [dbo].[CashAgentDomains]
(
	[Id] INT NOT NULL PRIMARY KEY IDENTITY, 
    [CashAgentId] INT NOT NULL, 
    [DomainId] NVARCHAR(MAX) NOT NULL,
    [ExclusiveDomainId] INT NOT NULL default(0),
    [CopyFromDomainId] INT NOT NULL default(0),
    [CreatedBy] NVARCHAR(50) NOT NULL, 
    [CreatedOn] DATETIME NULL, 
    [ModifiedBy] NVARCHAR(50) NOT NULL, 
    [ModifiedOn] DATETIME NULL
)
```

| Column            | Type          | Null | Default | Description     |
|-------------------|--------------|------|---------|----------------|
| Id                | INT (IDENTITY)| NO  |         | Primary Key     |
| CashAgentId       | INT           | NO  |         |                 |
| DomainId          | NVARCHAR(MAX) | NO   |         |                 |
| ExclusiveDomainId | INT           | NO   | 0       |                 |
| CopyFromDomainId  | INT           | NO   | 0       |                 |
| CreatedBy         | NVARCHAR(50)  | NO  |         |                 |
| CreatedOn         | DATETIME      | YES |         |                 |
| ModifiedBy        | NVARCHAR(50)  | NO  |         |                 |
| ModifiedOn        | DATETIME      | YES |         |                 |

- **Primary Key:** `Id`
- **No foreign keys or unique constraints defined.**

## CashAgentEffectivePT

```sql
CREATE TABLE [dbo].[CashAgentEffectivePT]
(
	[WebId]			INT NOT NULL,
	[AgentId]			INT NOT NULL,
	[CustomerId]		INT NOT NULL,
	[ProductType]		INT NOT NULL,
	[GameproviderId]	INT NOT NULL,
	[EffectivePT]		Decimal(19,2) NOT NULL,
	[IsTransferred]		BIT DEFAULT (0) NOT NULL,
	[CreatedOn]		DATETIME DEFAULT (GETDATE()) NOT NULL,
	[ModifiedOn]		DATETIME CONSTRAINT [DF_CashAgentEffectivePT_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_CashAgentEffectivePT] PRIMARY KEY NONCLUSTERED ([WebId],[AgentId],[CustomerId],[ProductType],[GameproviderId]) WITH (FILLFACTOR = 85)
)
```

| Column         | Type           | Null | Default    | Description                |
|----------------|----------------|------|------------|----------------------------|
| WebId          | INT            | NO   |            | Primary Key (composite)    |
| AgentId        | INT            | NO   |            | Primary Key (composite)    |
| CustomerId     | INT            | NO   |            | Primary Key (composite)    |
| ProductType    | INT            | NO   |            | Primary Key (composite)    |
| GameproviderId | INT            | NO   |            | Primary Key (composite)    |
| EffectivePT    | Decimal(19,2)  | NO   |            |                            |
| IsTransferred  | BIT            | NO   | 0          |                            |
| CreatedOn      | DATETIME       | NO   | GETDATE()  |                            |
| ModifiedOn     | DATETIME       | NO   | GETDATE()  |                            |

- **Primary Key:** `WebId`, `AgentId`, `CustomerId`, `ProductType`, `GameproviderId` (composite)
- **Indexes:**
  - `IX_CashAgentEffectivePT_GetAgentDetail` on `CustomerId`
  - `IX_CashAgentEffectivePT_AgentId_IsTransferred` on `AgentId`, `IsTransferred` (includes `CustomerId`)
- **No foreign keys or unique constraints defined.**

## CashAgentPartner

```sql
CREATE TABLE [dbo].[CashAgentPartner] 
(
  [Id]                    INT             IDENTITY(1,1) NOT NULL,
  [AgentId]               INT             NOT NULL,
  [AgentPartnerId]        INT             NOT NULL,
  [Currency]              NVARCHAR(3)     NOT NULL,
  [IsDeleted]             BIT             NOT NULL DEFAULT 0,
  [CreatedOn]             DATETIME        NOT NULL DEFAULT (GETDATE()),
  [CreatedBy]             NVARCHAR(200)   NOT NULL,
  [ModifiedOn]            DATETIME        NOT NULL DEFAULT (GETDATE()),
  [ModifiedBy]            NVARCHAR(200)   NOT NULL,
  CONSTRAINT [PK_CashAgentPartner] PRIMARY KEY CLUSTERED ([Id] ASC)
);
```

| Column          | Type           | Null | Default    | Description     |
|-----------------|----------------|------|------------|----------------|
| Id              | INT (IDENTITY) | NO   |            | Primary Key     |
| AgentId         | INT            | NO   |            |                 |
| AgentPartnerId  | INT            | NO   |            |                 |
| Currency        | NVARCHAR(3)    | NO   |            |                 |
| IsDeleted       | BIT            | NO   | 0          |                 |
| CreatedOn       | DATETIME       | NO   | GETDATE()  |                 |
| CreatedBy       | NVARCHAR(200)  | NO   |            |                 |
| ModifiedOn      | DATETIME       | NO   | GETDATE()  |                 |
| ModifiedBy      | NVARCHAR(200)  | NO   |            |                 |

- **Primary Key:** `Id`
- **No foreign keys or unique constraints defined.**

## CashAgentPresetPT

```sql
CREATE TABLE [dbo].[CashAgentPresetPT]
(
	[WebId]			INT NOT NULL,
	[CustomerId]		INT NOT NULL,
	[ProductType]		INT NOT NULL,
	[GameproviderId]	INT NOT NULL,
	[AvailablePT]	Decimal(19,2) NOT NULL,
	[ModifiedOn]		DATETIME CONSTRAINT [DF_CashAgentEffectPT_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_CashAgentEffectPT] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[ProductType],[GameproviderId]) WITH (FILLFACTOR = 85)
)
```

| Column         | Type           | Null | Default    | Description                |
|----------------|----------------|------|------------|----------------------------|
| WebId          | INT            | NO   |            | Primary Key (composite)    |
| CustomerId     | INT            | NO   |            | Primary Key (composite)    |
| ProductType    | INT            | NO   |            | Primary Key (composite)    |
| GameproviderId | INT            | NO   |            | Primary Key (composite)    |
| AvailablePT    | Decimal(19,2)  | NO   |            |                            |
| ModifiedOn     | DATETIME       | NO   | GETDATE()  |                            |

- **Primary Key:** `WebId`, `CustomerId`, `ProductType`, `GameproviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CashAgentRequest

```sql
CREATE TABLE [dbo].[CashAgentRequest]
(
    [ID]         INT  IDENTITY (1, 1)   NOT NULL,
    [WebId]      INT                    NOT NULL,
    [ParentId]   INT                    NOT NULL,
    [Username]   NVARCHAR (50)          NOT NULL,
    [Status]     INT                    NOT NULL,
    [CreatedBy]  VARCHAR (50)           NULL,
    [CreatedOn]  DATETIME               NULL,
    [ModifiedBy] VARCHAR (50)           NULL,
    [ModifiedOn] DATETIME               NULL,
    CONSTRAINT [PK_CashAgentRequestRequest] PRIMARY KEY CLUSTERED ([ID] ASC)
)
```

| Column      | Type           | Null | Default | Description     |
|-------------|----------------|------|---------|----------------|
| ID          | INT (IDENTITY) | NO   |         | Primary Key     |
| WebId       | INT            | NO   |         |                 |
| ParentId    | INT            | NO   |         |                 |
| Username    | NVARCHAR(50)   | NO   |         |                 |
| Status      | INT            | NO   |         |                 |
| CreatedBy   | VARCHAR(50)    | YES  |         |                 |
| CreatedOn   | DATETIME       | YES  |         |                 |
| ModifiedBy  | VARCHAR(50)    | YES  |         |                 |
| ModifiedOn  | DATETIME       | YES  |         |                 |

- **Primary Key:** `ID`
- **No foreign keys, unique constraints, or indexes defined.**

---

## CashAgentRequestDetail

```sql
CREATE TABLE [dbo].[CashAgentRequestDetail]
(
    [ID]         INT  IDENTITY (1, 1)   NOT NULL,
    [CashAgentRequestId]  INT                    NOT NULL,
    [Username]   NVARCHAR (50)          NOT NULL,
    [InfoId] NVARCHAR (50)         NOT NULL,
    [InfoValue] NVARCHAR(50)          NULL,
    [CreatedBy]  NVARCHAR (50)          NULL,
    [CreatedOn]  DATETIME               NULL,
    [ModifiedBy] VARCHAR (50)           NULL,
    [ModifiedOn] DATETIME               NULL,
    CONSTRAINT [PK_CashAgentRequestDetail] PRIMARY KEY CLUSTERED ([ID] ASC)
)
```

| Column              | Type           | Null | Default | Description     |
|---------------------|----------------|------|---------|----------------|
| ID                  | INT (IDENTITY) | NO   |         | Primary Key     |
| CashAgentRequestId  | INT            | NO   |         |                 |
| Username            | NVARCHAR(50)   | NO   |         |                 |
| InfoId              | NVARCHAR(50)   | NO   |         |                 |
| InfoValue           | NVARCHAR(50)   | YES  |         |                 |
| CreatedBy           | NVARCHAR(50)   | YES  |         |                 |
| CreatedOn           | DATETIME       | YES  |         |                 |
| ModifiedBy          | VARCHAR(50)    | YES  |         |                 |
| ModifiedOn          | DATETIME       | YES  |         |                 |

- **Primary Key:** `ID`
- **No foreign keys, unique constraints, or indexes defined.**

---

## CashAgentSetting

```sql
CREATE TABLE [dbo].[CashAgentSetting]
(
    [ID]         INT  IDENTITY (1, 1)   NOT NULL,
    [CustomerId]  INT                    NOT NULL,
    [Name]   NVARCHAR (100)          NOT NULL,
    [Value] NVARCHAR (100)         NOT NULL,
    [CreatedBy]  NVARCHAR (50)          NULL,
    [CreatedOn]  DATETIME               NULL,
    [ModifiedBy] VARCHAR (50)           NULL,
    [ModifiedOn] DATETIME               NULL
)
```

| Column      | Type           | Null | Default | Description     |
|-------------|----------------|------|---------|----------------|
| ID          | INT (IDENTITY) | NO   |         | Primary Key     |
| CustomerId  | INT            | NO   |         |                 |
| Name        | NVARCHAR(100)  | NO   |         |                 |
| Value       | NVARCHAR(100)  | NO   |         |                 |
| CreatedBy   | NVARCHAR(50)   | YES  |         |                 |
| CreatedOn   | DATETIME       | YES  |         |                 |
| ModifiedBy  | VARCHAR(50)    | YES  |         |                 |
| ModifiedOn  | DATETIME       | YES  |         |                 |

- **Primary Key:** `ID` (implied by IDENTITY and usage)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CashPlayerPresetCommission

```sql
CREATE TABLE [dbo].[CashPlayerPresetCommission]
(
	[WebId]                 INT NOT NULL,
	[CustomerId]    INT NOT NULL,
	[PlayerDiscountA]        DECIMAL(5,4) NOT NULL,
	[PlayerDiscountB]        DECIMAL(5,4) NOT NULL,
	[PlayerDiscountC]        DECIMAL(5,4) NOT NULL,
	[PlayerDiscountD]        DECIMAL(5,4) NOT NULL default(0),
	[PlayerDiscountE]        DECIMAL(5,4) NOT NULL default(0),
	[PlayerDiscountF]        DECIMAL(5,4) NOT NULL default(0),
	[PlayerDiscount1X2]      DECIMAL(5,4) NOT NULL,
	[PlayerDiscountOther]    DECIMAL(5,4) NOT NULL,
	[GMPlayerDiscount]       DECIMAL(5,4) NOT NULL,
	[LCPlayerDiscount]       DECIMAL(5,4) NOT NULL,
	[ModifiedOn]             DATETIME CONSTRAINT [DF_CashPlayerPresetCommission_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
	[ModifiedBy]             NVARCHAR(50) NOT NULL,
	[UGroup]                 NVARCHAR(10) NOT NULL,
	[Currency]               NVARCHAR(10) NOT NULL,
    CONSTRAINT [PK_CashPlayerPresetCommission] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[Currency]) WITH (FILLFACTOR = 85)
)
```

| Column              | Type           | Null | Default | Description                |
|---------------------|----------------|------|---------|----------------------------|
| WebId               | INT            | NO   |         | Primary Key (composite)    |
| CustomerId          | INT            | NO   |         | Primary Key (composite)    |
| PlayerDiscountA     | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountB     | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountC     | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountD     | DECIMAL(5,4)   | NO   | 0       |                            |
| PlayerDiscountE     | DECIMAL(5,4)   | NO   | 0       |                            |
| PlayerDiscountF     | DECIMAL(5,4)   | NO   | 0       |                            |
| PlayerDiscount1X2   | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountOther | DECIMAL(5,4)   | NO   |         |                            |
| GMPlayerDiscount    | DECIMAL(5,4)   | NO   |         |                            |
| LCPlayerDiscount    | DECIMAL(5,4)   | NO   |         |                            |
| ModifiedOn          | DATETIME       | NO   | GETDATE()|                            |
| ModifiedBy          | NVARCHAR(50)   | NO   |         |                            |
| UGroup              | NVARCHAR(10)   | NO   |         |                            |
| Currency            | NVARCHAR(10)   | NO   |         | Primary Key (composite)    |

- **Primary Key:** `WebId`, `CustomerId`, `Currency` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CashPlayerPresetGPCommission

```sql
CREATE TABLE [dbo].[CashPlayerPresetGPCommission]
(
	[WebId]                 INT NOT NULL,
	[CustomerId]    INT NOT NULL,
	[GPId]      INT NOT NULL,
	[APIGameProviderId] INT NOT NULL,
	[GameProviderName] varchar(30) NOT NULL,
	[GPPlayerDiscount]        DECIMAL(5,4) NOT NULL,
	[ModifiedOn]             DATETIME CONSTRAINT [DF_CashPlayerPresetGPCommission_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
	[ModifiedBy]             NVARCHAR(50) NOT NULL,
	[Currency]               NVARCHAR(10) NOT NULL,
    CONSTRAINT [PK_CashPlayerPresetGPCommission] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[Currency],[GPId],[APIGameProviderId]) WITH (FILLFACTOR = 85)
)
```

| Column              | Type           | Null | Default | Description                |
|---------------------|----------------|------|---------|----------------------------|
| WebId               | INT            | NO   |         | Primary Key (composite)    |
| CustomerId          | INT            | NO   |         | Primary Key (composite)    |
| GPId                | INT            | NO   |         | Primary Key (composite)    |
| APIGameProviderId   | INT            | NO   |         | Primary Key (composite)    |
| GameProviderName    | VARCHAR(30)    | NO   |         |                            |
| GPPlayerDiscount    | DECIMAL(5,4)   | NO   |         |                            |
| ModifiedOn          | DATETIME       | NO   | GETDATE()|                            |
| ModifiedBy          | NVARCHAR(50)   | NO   |         |                            |
| Currency            | NVARCHAR(10)   | NO   |         | Primary Key (composite)    |

- **Primary Key:** `WebId`, `CustomerId`, `Currency`, `GPId`, `APIGameProviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CashPlayerPresetTsbCommission

```sql
CREATE TABLE [dbo].[CashPlayerPresetTsbCommission]
(
	[WebId]                 INT NOT NULL,
	[CustomerId]    INT NOT NULL,
	[GPId]      INT NOT NULL,
	[APIGameProviderId] INT NOT NULL,
	[GameProviderName] varchar(30) NOT NULL,
	[PlayerDiscountA]        DECIMAL(5,4) NOT NULL,
	[PlayerDiscountB]        DECIMAL(5,4) NOT NULL,
	[PlayerDiscountC]        DECIMAL(5,4) NOT NULL,
	[PlayerDiscountD]        DECIMAL(5,4) NOT NULL default(0),
	[PlayerDiscountE]        DECIMAL(5,4) NOT NULL default(0),
	[PlayerDiscountF]        DECIMAL(5,4) NOT NULL default(0),
	[PlayerDiscount1X2]      DECIMAL(5,4) NOT NULL,
	[PlayerDiscountOther]    DECIMAL(5,4) NOT NULL,
	[UGroup]                 NVARCHAR(10) NOT NULL,
	[ModifiedOn]             DATETIME DEFAULT (GETDATE()) NOT NULL,
	[ModifiedBy]             NVARCHAR(50) NOT NULL,
	[Currency]               NVARCHAR(10) NOT NULL,
    CONSTRAINT [PK_CashPlayerPresetTsbCommission] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[Currency],[GPId],[APIGameProviderId]) WITH (FILLFACTOR = 85)
)
```

| Column              | Type           | Null | Default | Description                |
|---------------------|----------------|------|---------|----------------------------|
| WebId               | INT            | NO   |         | Primary Key (composite)    |
| CustomerId          | INT            | NO   |         | Primary Key (composite)    |
| GPId                | INT            | NO   |         | Primary Key (composite)    |
| APIGameProviderId   | INT            | NO   |         | Primary Key (composite)    |
| GameProviderName    | VARCHAR(30)    | NO   |         |                            |
| PlayerDiscountA     | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountB     | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountC     | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountD     | DECIMAL(5,4)   | NO   | 0       |                            |
| PlayerDiscountE     | DECIMAL(5,4)   | NO   | 0       |                            |
| PlayerDiscountF     | DECIMAL(5,4)   | NO   | 0       |                            |
| PlayerDiscount1X2   | DECIMAL(5,4)   | NO   |         |                            |
| PlayerDiscountOther | DECIMAL(5,4)   | NO   |         |                            |
| UGroup              | NVARCHAR(10)   | NO   |         |                            |
| ModifiedOn          | DATETIME       | NO   | GETDATE()|                            |
| ModifiedBy          | NVARCHAR(50)   | NO   |         |                            |
| Currency            | NVARCHAR(10)   | NO   |         | Primary Key (composite)    |

- **Primary Key:** `WebId`, `CustomerId`, `Currency`, `GPId`, `APIGameProviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CashSettled

```sql
CREATE TABLE [dbo].[CashSettled] (
    [Id]                 BIGINT IDENTITY(1,1) NOT NULL,
    [WebId]              INT             NOT NULL,
    [CustomerId]         INT             NOT NULL,
    [ProductType]        INT             CONSTRAINT [DF_CashSettled_ProductType] DEFAULT ((0)) NOT NULL,
    [GameType]           INT             CONSTRAINT [DF_CashSettled_GameType] DEFAULT ((0)) NOT NULL,
    [AgtID]              INT             NOT NULL,
    [MaID]               INT             NOT NULL,
    [SmaID]              INT             NOT NULL,
    [SsmaID]             INT             NOT NULL,
    [ShID]               INT             NOT NULL,
    [TransferIn]         DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_TransferIn] DEFAULT ((0)) NOT NULL,
    [TransferOut]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_TransferOut] DEFAULT ((0)) NOT NULL,
    [SBPlayerCashSettled]    DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBPlayerCashSettled] DEFAULT ((0)) NULL,
    [SBPlayerCashReturn]     DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBPlayerCashReturn] DEFAULT ((0)) NULL,
    [SBAgtCashSettled]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBAgtCashSettled] DEFAULT ((0)) NULL,
    [SBAgtCashReturn]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBAgtCashReturn] DEFAULT ((0)) NULL,
    [SBMaCashSettled]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBMaCashSettled] DEFAULT ((0)) NULL,
    [SBMaCashReturn]         DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBMaCashReturn] DEFAULT ((0)) NULL,
    [SBSmaCashSettled]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBSmaCashSettled] DEFAULT ((0)) NULL,
    [SBSmaCashReturn]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBSmaCashReturn] DEFAULT ((0)) NULL,
    [SBSsmaCashSettled]      DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBSsmaCashSettled] DEFAULT ((0)) NULL,
    [SBSsmaCashReturn]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBSsmaCashReturn] DEFAULT ((0)) NULL,
    [SBShCashSettled]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBShCashSettled] DEFAULT ((0)) NULL,
    [SBShCashReturn]         DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_SBShCashReturn] DEFAULT ((0)) NULL,
    [LCPlayerCashSettled]    DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCCashSettled] DEFAULT ((0)) NOT NULL,
    [LCPlayerCashReturn]     DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCCashReturn] DEFAULT ((0)) NOT NULL,
    [LCAgtCashSettled]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCAgtCashSettled] DEFAULT ((0)) NOT NULL,
    [LCAgtCashReturn]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCAgtCashReturn] DEFAULT ((0)) NOT NULL,
    [LCMaCashSettled]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCMaCashSettled] DEFAULT ((0)) NOT NULL,
    [LCMaCashReturn]         DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCMaCashReturn] DEFAULT ((0)) NOT NULL,
    [LCSmaCashSettled]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCSmaCashSettled] DEFAULT ((0)) NOT NULL,
    [LCSmaCashReturn]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCSmaCashReturn] DEFAULT ((0)) NOT NULL,
    [LCSsmaCashSettled]      DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCSsmaCashSettled] DEFAULT ((0)) NOT NULL,
    [LCSsmaCashReturn]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCSsmaCashReturn] DEFAULT ((0)) NOT NULL,
    [LCShCashSettled]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCShCashSettled] DEFAULT ((0)) NOT NULL,
    [LCShCashReturn]         DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_LCShCashReturn] DEFAULT ((0)) NOT NULL,
    [GMPlayerCashSettled]    DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMCashSettled] DEFAULT ((0)) NOT NULL,
    [GMPlayerCashReturn]     DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMCashReturn] DEFAULT ((0)) NOT NULL,
    [GMAgtCashSettled]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMAgtCashSettled] DEFAULT ((0)) NOT NULL,
    [GMAgtCashReturn]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMAgtCashReturn] DEFAULT ((0)) NOT NULL,
    [GMMaCashSettled]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMMaCashSettled] DEFAULT ((0)) NOT NULL,
    [GMMaCashReturn]         DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMMaCashReturn] DEFAULT ((0)) NOT NULL,
    [GMSmaCashSettled]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMSmaCashSettled] DEFAULT ((0)) NOT NULL,
    [GMSmaCashReturn]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMSmaCashReturn] DEFAULT ((0)) NOT NULL,
    [GMSsmaCashSettled]      DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMSsmaCashSettled] DEFAULT ((0)) NOT NULL,
    [GMSsmaCashReturn]       DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMSsmaCashReturn] DEFAULT ((0)) NOT NULL,
    [GMShCashSettled]        DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMShCashSettled] DEFAULT ((0)) NOT NULL,
    [GMShCashReturn]         DECIMAL (19, 6) CONSTRAINT [DF_CashSettled_GMShCashReturn] DEFAULT ((0)) NOT NULL,
    [LastTransferOn]         DATETIME        NULL,
    [ModifiedBy]             NVARCHAR (50)   NULL,
    [ModifiedOn]             DATETIME        NULL,
    CONSTRAINT [PK_CashSettled] PRIMARY KEY CLUSTERED ([ID]) WITH (FILLFACTOR = 85)
);
```

| Column | Type | Null | Default | Description |
|--------|------|------|---------|-------------|
| ...    | ...  | ...  | ...     | ...         |

- **Primary Key:** `Id`
- **Indexes:**
  - `IX_CashSettled_vPlayerBalance_CustomerId` on `WebId`, `CustomerId`, `ProductType`, `GameType` (includes many columns)
- **No foreign keys or unique constraints defined.**

---

## CashUsed

```sql
CREATE TABLE [dbo].[CashUsed] (
    [Id]              BIGINT IDENTITY(1,1) NOT NULL,
    [WebId]           INT             NOT NULL,
    [CustomerId]      INT             NOT NULL,
    [ProductType]     INT             CONSTRAINT [DF_CashUsed_ProductType] DEFAULT ((0)) NOT NULL,
    [GameType]        INT             CONSTRAINT [DF_CashUsed_GameType] DEFAULT ((0)) NOT NULL,
    [Username]        NVARCHAR(50)    NOT NULL,
    [Currency]        NVARCHAR (3)    NULL,
    [AgtID]           INT             NOT NULL,
    [MaID]            INT             NOT NULL,
    [SmaID]           INT             NOT NULL,
    [SSmaID]          INT             NOT NULL,
    [ShID]            INT             NOT NULL,
    [SBPlayerCashUsed]    DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_SB_PlayerCashUsed] DEFAULT ((0)) NULL,
    [SBAgtCashUsed]       DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_SB_AgtCashUsed] DEFAULT ((0)) NULL,
    [SBMaCashUsed]        DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_SB_MaCashUsed] DEFAULT ((0)) NULL,
    [SBSmaCashUsed]       DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_SB_SmaCashUsed] DEFAULT ((0)) NULL,
    [SBSSmaCashUsed]      DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_SB_SSmaCashUsed] DEFAULT ((0)) NULL,
    [SBShCashUsed]        DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_SB_ShCashUsed] DEFAULT ((0)) NULL,
    [LCPlayerCashUsed]    DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_LCCashUsed] DEFAULT ((0)) NOT NULL,
    [LCAgtCashUsed]       DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_LCAgtCashUsed] DEFAULT ((0)) NOT NULL,
    [LCMaCashUsed]        DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_LCMaCashUsed] DEFAULT ((0)) NOT NULL,
    [LCSmaCashUsed]       DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_LCSmaCashUsed] DEFAULT ((0)) NOT NULL,
    [LCSSmaCashUsed]      DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_LCSSmaCashUsed] DEFAULT ((0)) NOT NULL,
    [LCShCashUsed]        DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_LCShCashUsed] DEFAULT ((0)) NOT NULL,
    [GMPlayerCashUsed]    DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_GMCashUsed] DEFAULT ((0)) NOT NULL,
    [GMAgtCashUsed]       DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_GMAgtCashUsed] DEFAULT ((0)) NOT NULL,
    [GMMaCashUsed]        DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_GMMaCashUsed] DEFAULT ((0)) NOT NULL,
    [GMSmaCashUsed]       DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_GMSmaCashUsed] DEFAULT ((0)) NOT NULL,
    [GMSSmaCashUsed]      DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_GMSSmaCashUsed] DEFAULT ((0)) NOT NULL,
    [GMShCashUsed]        DECIMAL (19, 6) CONSTRAINT [DF_CashUsed_GMShCashUsed] DEFAULT ((0)) NOT NULL,
    [ModifiedBy]          NVARCHAR (50)   NULL,
    [ModifiedOn]          DATETIME        NULL,
    [LastOrderOn]         DATETIME        NULL,
    CONSTRAINT [PK_CashUsed] PRIMARY KEY CLUSTERED ([ID]) WITH (FILLFACTOR = 95)
);
```

| Column | Type | Null | Default | Description |
|--------|------|------|---------|-------------|
| ...    | ...  | ...  | ...     | ...         |

- **Primary Key:** `Id`
- **Indexes:**
  - `IX_CashUsed_vPlayerBalance_CustomerId` on `WebId`, `CustomerId`, `ProductType`, `GameType` (includes many columns)
- **No foreign keys or unique constraints defined.**

---

## CompanyFlowCustomizeValue

```sql
CREATE TABLE [dbo].[CompanyFlowCustomizeValue] (
	[WebId]                 INT             NOT NULL,
    [CustomerId]           INT             NOT NULL,
	[PropertyName]           nvarchar(100)     NOT NULL,
    [Value]                nvarchar(100)     NOT NULL,
    [CreatedBy]            NVARCHAR (50)  NOT NULL,
    [CreatedOn]            DATETIME       CONSTRAINT [DF_CompanyFlowCustomizeValue_CreatedOn] DEFAULT (getdate()) NOT NULL,
    [ModifiedBy]           NVARCHAR (50)  NOT NULL,
    [ModifiedOn]           DATETIME       CONSTRAINT [DF_CompanyFlowCustomizeValue_ModifiedOn] DEFAULT (getdate()) NOT NULL,
    CONSTRAINT [PK_CompanyFlowCustomizeValue] PRIMARY KEY CLUSTERED ([Webid],[CustomerId],[PropertyName] ASC) WITH (FILLFACTOR = 85)
);
```

| Column        | Type          | Null | Default    | Description                |
|---------------|---------------|------|------------|----------------------------|
| WebId         | INT           | NO   |            | Primary Key (composite)    |
| CustomerId    | INT           | NO   |            | Primary Key (composite)    |
| PropertyName  | NVARCHAR(100) | NO   |            | Primary Key (composite)    |
| Value         | NVARCHAR(100) | NO   |            |                            |
| CreatedBy     | NVARCHAR(50)  | NO   |            |                            |
| CreatedOn     | DATETIME      | NO   | GETDATE()  |                            |
| ModifiedBy    | NVARCHAR(50)  | NO   |            |                            |
| ModifiedOn    | DATETIME      | NO   | GETDATE()  |                            |

- **Primary Key:** `WebId`, `CustomerId`, `PropertyName` (composite)
- **Indexes:**
  - `IX_CompanyFlowCustomizeValue_PropertyName` on `CustomerId`, `PropertyName` (includes `Value`)
- **No foreign keys or unique constraints defined.**

---

## CompanyIMNotificationSetting

```sql
CREATE TABLE [dbo].[CompanyIMNotificationSetting]
(
    [Id] INT IDENTITY (1, 1) NOT NULL PRIMARY KEY,
    [WebId] INT NOT NULL,
    [IMType] INT NOT NULL,
    [Currency] NVARCHAR (10) NOT NULL,
    [Setting] NVARCHAR (100) NOT NULL,
    [Amount] Decimal(19,6) NOT NULL DEFAULT 0,
    [Percentage] Decimal(19,6) NOT NULL DEFAULT 0,
    [Description] NVARCHAR (MAX) NOT NULL,
    [Status] NVARCHAR(20) NOT NULL,
    [Count] INT NOT NULL DEFAULT 0,
    [CreatedBy] NVARCHAR (50) NOT NULL,
    [CreatedOn] DATETIME DEFAULT (GETDATE()) NOT NULL,
    [ModifiedBy] NVARCHAR (50) NOT NULL,
    [ModifiedOn] DATETIME DEFAULT (GETDATE()) NOT NULL,
    [GMT] DECIMAL(19,6) DEFAULT(-4),
    CONSTRAINT CHK_Status CHECK ([Status] IN ('active', 'deleted')),
    CONSTRAINT CHK_Setting CHECK ([Setting] IN (
        'BigWin', 
        'BigStake', 
        'LargeWithdrawal', 
        'DepositAndWithdrawal', 
        'HourlyRegisterCount',
        'HourlyPlayerWinLostAmount',
        'HourlyPromotionBonus',
        'HourlyPromotionApplication'
        )
    )
)
```

| Column      | Type           | Null | Default    | Description     |
|-------------|----------------|------|------------|----------------|
| Id          | INT (IDENTITY) | NO   |            | Primary Key     |
| WebId       | INT            | NO   |            |                 |
| IMType      | INT            | NO   |            |                 |
| Currency    | NVARCHAR(10)   | NO   |            |                 |
| Setting     | NVARCHAR(100)  | NO   |            |                 |
| Amount      | Decimal(19,6)  | NO   | 0          |                 |
| Percentage  | Decimal(19,6)  | NO   | 0          |                 |
| Description | NVARCHAR(MAX)  | NO   |            |                 |
| Status      | NVARCHAR(20)   | NO   |            | CHECK ('active', 'deleted') |
| Count       | INT            | NO   | 0          |                 |
| CreatedBy   | NVARCHAR(50)   | NO   |            |                 |
| CreatedOn   | DATETIME       | NO   | GETDATE()  |                 |
| ModifiedBy  | NVARCHAR(50)   | NO   |            |                 |
| ModifiedOn  | DATETIME       | NO   | GETDATE()  |                 |
| GMT         | DECIMAL(19,6)  | YES  | -4         |                 |

- **Primary Key:** `Id`
- **Check Constraints:**
  - `CHK_Status` on `Status` (must be 'active' or 'deleted')
  - `CHK_Setting` on `Setting` (must be one of the listed values)
- **No foreign keys or unique constraints defined.**

---

## CompanyIMSettings

```sql
CREATE TABLE [dbo].[CompanyIMSettings]
(
	[Id] INT IDENTITY (1, 1) NOT NULL PRIMARY KEY,
    [WebId] INT NOT NULL,
	[IMType] INT NOT NULL,
    [TransactionType] INT NOT NULL,
    [TransactionStatus] NVARCHAR(200) NOT NULL,
    [CreatedBy] NVARCHAR (50) NOT NULL,
    [CreatedOn] DATETIME NOT NULL,
    [ModifiedBy] NVARCHAR (50) NOT NULL,
    [ModifiedOn] DATETIME NOT NULL,
    [GMT] DECIMAL(19,6) DEFAULT(-4)
    CONSTRAINT unique_WebId_IMType_TransactionType UNIQUE (WebId, IMType, TransactionType)
)
```

| Column            | Type           | Null | Default | Description     |
|-------------------|----------------|------|---------|----------------|
| Id                | INT (IDENTITY) | NO   |         | Primary Key     |
| WebId             | INT            | NO   |         |                 |
| IMType            | INT            | NO   |         |                 |
| TransactionType   | INT            | NO   |         |                 |
| TransactionStatus | NVARCHAR(200)  | NO   |         |                 |
| CreatedBy         | NVARCHAR(50)   | NO   |         |                 |
| CreatedOn         | DATETIME       | NO   |         |                 |
| ModifiedBy        | NVARCHAR(50)   | NO   |         |                 |
| ModifiedOn        | DATETIME       | NO   |         |                 |
| GMT               | DECIMAL(19,6)  | YES  | -4      |                 |

- **Primary Key:** `Id`
- **Unique Constraint:** `unique_WebId_IMType_TransactionType` on (`WebId`, `IMType`, `TransactionType`)
- **No foreign keys defined.**

---

## CompanyTelegramGroupSetting

```sql
CREATE TABLE [dbo].[CompanyTelegramGroupSetting]
(
	[Id] INT IDENTITY (1, 1) NOT NULL PRIMARY KEY,
    [WebId] INT NOT NULL,
    [GroupIds]   NVARCHAR (500) NOT NULL,
    [Language] NVARCHAR (50) NOT NULL,
    [CreatedBy] NVARCHAR (50) NOT NULL,
    [CreatedOn] DATETIME DEFAULT GETDATE(),
    [ModifiedBy] NVARCHAR (50) NOT NULL,
    [ModifiedOn] DATETIME DEFAULT GETDATE()
)
```

| Column      | Type           | Null | Default    | Description     |
|-------------|----------------|------|------------|----------------|
| Id          | INT (IDENTITY) | NO   |            | Primary Key     |
| WebId       | INT            | NO   |            |                 |
| GroupIds    | NVARCHAR(500)  | NO   |            |                 |
| Language    | NVARCHAR(50)   | NO   |            |                 |
| CreatedBy   | NVARCHAR(50)   | NO   |            |                 |
| CreatedOn   | DATETIME       | YES  | GETDATE()  |                 |
| ModifiedBy  | NVARCHAR(50)   | NO   |            |                 |
| ModifiedOn  | DATETIME       | YES  | GETDATE()  |                 |

- **Primary Key:** `Id`
- **No foreign keys, unique constraints, or indexes defined.**

---

## CrmLog

```sql
CREATE TABLE [dbo].[CrmLog] (
	[WebId]             INT NOT NULL,
    [Logid]            INT IDENTITY(1,1),
	[Custid]             INT NOT NULL default(0),
	[Roleid]             INT NOT NULL default(0),
	[Category]           NVARCHAR(50) default(''),
	[Problem]            NVARCHAR(1500) default(''),
	[Logdate]            DATETIME,
	[Createdby]          NVARCHAR(50) default(''),
	[Modifiedon]         DATETIME,
	[Modifiedby]         NVARCHAR(50) default(''),
	[Status]             NVARCHAR(10) default(''),
	[GroupId]            int,
	[Issue]              tinyint,
	[CommunicationMode]  tinyint,
	[Language]           tinyint,
	[Response]           NVARCHAR(1500),
	[HideFromInspector]  bit,
	[Type]               varchar(20),
	[Department]         NVARCHAR(50),
	[Brand]              NVARCHAR(50),
    CONSTRAINT [PK_CrmLog] PRIMARY KEY CLUSTERED ([WebId],[Logid] ASC) WITH (FILLFACTOR = 85)
);
```

| Column             | Type           | Null | Default    | Description                |
|--------------------|----------------|------|------------|----------------------------|
| WebId              | INT            | NO   |            | Primary Key (composite)    |
| Logid              | INT (IDENTITY) | NO   |            | Primary Key (composite)    |
| Custid             | INT            | NO   | 0          |                            |
| Roleid             | INT            | NO   | 0          |                            |
| Category           | NVARCHAR(50)   | YES  | ''         |                            |
| Problem            | NVARCHAR(1500) | YES  | ''         |                            |
| Logdate            | DATETIME       | YES  |            |                            |
| Createdby          | NVARCHAR(50)   | YES  | ''         |                            |
| Modifiedon         | DATETIME       | YES  |            |                            |
| Modifiedby         | NVARCHAR(50)   | YES  | ''         |                            |
| Status             | NVARCHAR(10)   | YES  | ''         |                            |
| GroupId            | INT            | YES  |            |                            |
| Issue              | TINYINT        | YES  |            |                            |
| CommunicationMode  | TINYINT        | YES  |            |                            |
| Language           | TINYINT        | YES  |            |                            |
| Response           | NVARCHAR(1500) | YES  |            |                            |
| HideFromInspector  | BIT            | YES  |            |                            |
| Type               | VARCHAR(20)    | YES  |            |                            |
| Department         | NVARCHAR(50)   | YES  |            |                            |
| Brand              | NVARCHAR(50)   | YES  |            |                            |

- **Primary Key:** `WebId`, `Logid` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CreditAdjustment

```sql
CREATE TABLE [dbo].[CreditAdjustment]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[Adjustment]        Decimal(19,6) NOT NULL,    
	[CreateBy]          NVARCHAR(50) NOT NULL,
	[CreateOn]          DATETIME DEFAULT (GETDATE()) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOT NULL,
	[ModifiedOn]        DATETIME  DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_CreditAdjustment] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column      | Type           | Null | Default    | Description                |
|-------------|----------------|------|------------|----------------------------|
| WebId       | INT            | NO   |            | Primary Key (composite)    |
| CustomerId  | INT            | NO   |            | Primary Key (composite)    |
| Adjustment  | Decimal(19,6)  | NO   |            |                            |
| CreateBy    | NVARCHAR(50)   | NO   |            |                            |
| CreateOn    | DATETIME       | NO   | GETDATE()  |                            |
| ModifiedBy  | NVARCHAR(50)   | NO   |            |                            |
| ModifiedOn  | DATETIME       | NO   | GETDATE()  |                            |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CreditDailyAdjustment

```sql
CREATE TABLE [dbo].[CreditDailyAdjustment]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[Adjustment]        Decimal(19,6) NOT NULL,    
	[AdjustmentDate]    DATE NOT NULL,    
	[AdjustmentDelta]   Decimal(19,6) NOT NULL,
	[IsFullTransfered]  BIT NOT NULL,    
	[Remark]            NVARCHAR(50) NULL,
	[CreateBy]          NVARCHAR(50) NOT NULL,
	[CreateOn]          DATETIME DEFAULT (GETDATE()) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOT NULL,
	[ModifiedOn]        DATETIME  DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_CreditDailyAdjustment] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[AdjustmentDate]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type           | Null | Default    | Description                |
|------------------|----------------|------|------------|----------------------------|
| WebId            | INT            | NO   |            | Primary Key (composite)    |
| CustomerId       | INT            | NO   |            | Primary Key (composite)    |
| Adjustment       | Decimal(19,6)  | NO   |            |                            |
| AdjustmentDate   | DATE           | NO   |            | Primary Key (composite)    |
| AdjustmentDelta  | Decimal(19,6)  | NO   |            |                            |
| IsFullTransfered | BIT            | NO   |            |                            |
| Remark           | NVARCHAR(50)   | YES  |            |                            |
| CreateBy         | NVARCHAR(50)   | NO   |            |                            |
| CreateOn         | DATETIME       | NO   | GETDATE()  |                            |
| ModifiedBy       | NVARCHAR(50)   | NO   |            |                            |
| ModifiedOn       | DATETIME       | NO   | GETDATE()  |                            |

- **Primary Key:** `WebId`, `CustomerId`, `AdjustmentDate` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## Customer

```sql
CREATE TABLE [dbo].[Customer] (
    [CustomerId]               INT            IDENTITY (1, 1) NOT NULL,
    [WebId]                    INT            NOT NULL,
    [AccountType]              TINYINT        NOT NULL,
    [Username]                 NVARCHAR (50)  NOT NULL,
    [Password]                 NVARCHAR (50)  NOT NULL,
    [PaymentPassword]          NVARCHAR (50)  NULL,
    [ShId]                     INT            NOT NULL,
    [SsmaId]                   INT            NOT NULL,
    [SmaId]                    INT            NOT NULL,
    [MaId]                     INT            NOT NULL,
    [AgtId]                    INT            NOT NULL,
    [ParentId]                 INT            NOT NULL,
    [FirstName]                NVARCHAR(50)   NULL,
    [LastName]                 NVARCHAR(50)   NULL,
    [Currency]                 CHAR (3)       NOT NULL,
    [Email]                    NVARCHAR (50)  NULL,
    [Phone]                    NVARCHAR (50)  NULL,
    [Mobile]                   NVARCHAR (50)  NULL,
    [Referral]                 NVARCHAR (50)  NULL,
    [ReferralLayer]            INT CONSTRAINT [DF_Customer_ReferralLayer] DEFAULT ((0)) NOT NULL,
    [LoginName]                NVARCHAR (50)  NOT NULL,
    [CustomerStatus]           INT            CONSTRAINT [DF_Customer_CustomerStatus] DEFAULT ((0)) NOT NULL,
    [LoginFailureCount]        TINYINT        CONSTRAINT [DF_Customer_LoginFailureCount] DEFAULT ((0)) NOT NULL,
    [LockOutExpiryOn]          DATETIME       NULL,
    [LastLoginOn]              DATETIME       NULL,
    [LastLoginIP]              NVARCHAR (50)  NULL,
    [LastLoginCountry]         CHAR (2)       NULL,
    [LastLoginURL]             NVARCHAR (255) NULL,
    [RegisterIp]               NVARCHAR (50)  NULL,
    [RegisterUrl]              NVARCHAR (255) NULL,
    [Remark]                   NVARCHAR (500) NULL,
    [LoginNameFlag]            BIT CONSTRAINT [DF_Customer_LoginNameFlag] DEFAULT (0) NOT NULL,
    [PasswordExpiryDate]       DATETIME       CONSTRAINT [DF_Customer_PasswordExpiry] DEFAULT (getdate()-(1)) NOT NULL,
    [CreatedBy]                NVARCHAR (50)  NOT NULL,
    [CreatedOn]                DATETIME       CONSTRAINT [DF_Customer_CreatedOn] DEFAULT (getdate()) NOT NULL,
    [ModifiedBy]               NVARCHAR (50)  NOT NULL,
    [ModifiedOn]               DATETIME       CONSTRAINT [DF_Customer_ModifiedOn] DEFAULT (getdate()) NOT NULL,
    [IsApi]                    BIT CONSTRAINT [DF_Customer_IsApi] DEFAULT (0) NOT NULL,
    CONSTRAINT [PK_Customer] PRIMARY KEY CLUSTERED ([CustomerId] ASC) WITH (FILLFACTOR = 85),
    CONSTRAINT [uq_customer] UNIQUE([WebId], [Username], [accountType]),
    [Tagged]                   NVARCHAR(MAX) DEFAULT '' NOT NULL,
    [BotId] BIGINT NULL,
    [ChatId] BIGINT NULL,
    [TelegramUserId] BIGINT NULL,
    [IsRead] BIT DEFAULT 0 NOT NULL,
    [ThreePasswordCycle] NVARCHAR(255) NULL
);
```

| Column              | Type            | Null | Default         | Description                |
|---------------------|-----------------|------|-----------------|----------------------------|
| CustomerId          | INT (IDENTITY)  | NO   |                 | Primary Key                |
| WebId               | INT             | NO   |                 |                            |
| AccountType         | TINYINT         | NO   |                 |                            |
| Username            | NVARCHAR(50)    | NO   |                 |                            |
| Password            | NVARCHAR(50)    | NO   |                 |                            |
| PaymentPassword     | NVARCHAR(50)    | YES  |                 |                            |
| ShId                | INT             | NO   |                 |                            |
| SsmaId              | INT             | NO   |                 |                            |
| SmaId               | INT             | NO   |                 |                            |
| MaId                | INT             | NO   |                 |                            |
| AgtId               | INT             | NO   |                 |                            |
| ParentId            | INT             | NO   |                 |                            |
| FirstName           | NVARCHAR(50)    | YES  |                 |                            |
| LastName            | NVARCHAR(50)    | YES  |                 |                            |
| Currency            | CHAR(3)         | NO   |                 |                            |
| Email               | NVARCHAR(50)    | YES  |                 |                            |
| Phone               | NVARCHAR(50)    | YES  |                 |                            |
| Mobile              | NVARCHAR(50)    | YES  |                 |                            |
| Referral            | NVARCHAR(50)    | YES  |                 |                            |
| ReferralLayer       | INT             | NO   | 0               |                            |
| LoginName           | NVARCHAR(50)    | NO   |                 |                            |
| CustomerStatus      | INT             | NO   | 0               |                            |
| LoginFailureCount   | TINYINT         | NO   | 0               |                            |
| LockOutExpiryOn     | DATETIME        | YES  |                 |                            |
| LastLoginOn         | DATETIME        | YES  |                 |                            |
| LastLoginIP         | NVARCHAR(50)    | YES  |                 |                            |
| LastLoginCountry    | CHAR(2)         | YES  |                 |                            |
| LastLoginURL        | NVARCHAR(255)   | YES  |                 |                            |
| RegisterIp          | NVARCHAR(50)    | YES  |                 |                            |
| RegisterUrl         | NVARCHAR(255)   | YES  |                 |                            |
| Remark              | NVARCHAR(500)   | YES  |                 |                            |
| LoginNameFlag       | BIT             | NO   | 0               |                            |
| PasswordExpiryDate  | DATETIME        | NO   | getdate()-(1)   |                            |
| CreatedBy           | NVARCHAR(50)    | NO   |                 |                            |
| CreatedOn           | DATETIME        | NO   | getdate()       |                            |
| ModifiedBy          | NVARCHAR(50)    | NO   |                 |                            |
| ModifiedOn          | DATETIME        | NO   | getdate()       |                            |
| IsApi               | BIT             | NO   | 0               |                            |
| Tagged              | NVARCHAR(MAX)   | NO   | ''              |                            |
| BotId               | BIGINT          | YES  |                 |                            |
| ChatId              | BIGINT          | YES  |                 |                            |
| TelegramUserId      | BIGINT          | YES  |                 |                            |
| IsRead              | BIT             | NO   | 0               |                            |
| ThreePasswordCycle  | NVARCHAR(255)   | YES  |                 |                            |

- **Primary Key:** `CustomerId`
- **Unique Constraint:** `uq_customer` on (`WebId`, `Username`, `accountType`)
- **Indexes:**
  - `IX_Report_And_BetList` on `WebId`, `Username`, `CustomerId`, `ParentId`, `AccountType`, `IsApi`, `MaId` (includes several columns)
  - `IX_Customer_Search_User` on `WebId`, `ParentId`, `CustomerId` (includes several columns)
  - `IX_Customer_Api_BetList_By_Downline` on `WebId`, `AccountType`, `IsApi` (includes several columns)
  - `IX_Customer_DownlineBetList` on `WebId`, `AccountType`, `MaId`, `IsApi` (includes `CustomerId`)
  - `IX_Customer_For_CompanyPerforamnceOverview` on `WebId`, `Currency`, `AccountType`, `AgtId` (includes several columns)
  - `IX_Customer_Login` on `LoginName`, `AccountType`
- **No foreign keys defined.**

---

## CustomerInstanceMessage

```sql
CREATE TABLE [dbo].[CustomerInstanceMessage]
(
    [WebId]      INT                    NOT NULL,
    [CustomerId]   INT                  NOT NULL,
	[InstanceMessageType] NVARCHAR(100) NOT NULL,
	[InstanceMessageContact] NVARCHAR(100) NOT NULL,
    [CreatedBy]  VARCHAR (50)           NULL,
    [CreatedOn]  DATETIME               NULL,
    [ModifiedBy] VARCHAR (50)           NULL,
    [ModifiedOn] DATETIME               NULL,
    CONSTRAINT [PK_CustomerInstanceMessage] PRIMARY KEY CLUSTERED ( CustomerId ,InstanceMessageType )
)
```

| Column                  | Type           | Null | Default | Description                |
|-------------------------|----------------|------|---------|----------------------------|
| WebId                   | INT            | NO   |         |                            |
| CustomerId              | INT            | NO   |         | Primary Key (composite)    |
| InstanceMessageType     | NVARCHAR(100)  | NO   |         | Primary Key (composite)    |
| InstanceMessageContact  | NVARCHAR(100)  | NO   |         |                            |
| CreatedBy               | VARCHAR(50)    | YES  |         |                            |
| CreatedOn               | DATETIME       | YES  |         |                            |
| ModifiedBy              | VARCHAR(50)    | YES  |         |                            |
| ModifiedOn              | DATETIME       | YES  |         |                            |

- **Primary Key:** `CustomerId`, `InstanceMessageType` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CustomerPreference

```sql
CREATE TABLE [dbo].[CustomerPreference] (
    [WebId]                    INT            NOT NULL,
    [CustomerId]               INT            NOT NULL,
	[PreferenceName]           NVARCHAR(100),
    [PreferenceValue]          NVARCHAR(100),
    [ModifiedOn]               DATETIME       CONSTRAINT [DF_CustomerPreference_ModifiedOn] DEFAULT (getdate()) NOT NULL,
	CONSTRAINT [PK_CustomerPreference] PRIMARY KEY CLUSTERED ([WebId],[CustomerId],[PreferenceName] ASC) WITH (FILLFACTOR = 85),
);
```

| Column           | Type           | Null | Default    | Description                |
|------------------|----------------|------|------------|----------------------------|
| WebId            | INT            | NO   |            | Primary Key (composite)    |
| CustomerId       | INT            | NO   |            | Primary Key (composite)    |
| PreferenceName   | NVARCHAR(100)  | YES  |            | Primary Key (composite)    |
| PreferenceValue  | NVARCHAR(100)  | YES  |            |                            |
| ModifiedOn       | DATETIME       | NO   | GETDATE()  |                            |

- **Primary Key:** `WebId`, `CustomerId`, `PreferenceName` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## CustomerSiteMessage

```sql
CREATE TABLE [dbo].[CustomerSiteMessage]
(
   [CustomerId] INT NOT NULL,
   [SiteMessageId] INT NOT NULL,
   [Status] INT NOT NULL,
   [CreatedBy] NVARCHAR(50) NOT NULL,
   [CreatedOn] DATETIME NOT NULL,
   [ModifiedBy] NVARCHAR(50) NOT NULL,
   [ModifiedOn] DATETIME NOT NULL
)
```

| Column         | Type         | Null | Default | Description             |
|----------------|--------------|------|---------|-------------------------|
| CustomerId     | INT          | NO   |         |                         |
| SiteMessageId  | INT          | NO   |         |                         |
| Status         | INT          | NO   |         |                         |
| CreatedBy      | NVARCHAR(50) | NO   |         |                         |
| CreatedOn      | DATETIME     | NO   |         |                         |
| ModifiedBy     | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn     | DATETIME     | NO   |         |                         |

- **Primary Key:** Not explicitly defined in the SQL, but likely (`CustomerId`, `SiteMessageId`)
- **Indexes:**
  - `IX_CustomerSiteMessage_SiteMessageId_Status_CreatedOn` on `SiteMessageId`, `Status`, `CreatedOn` (includes `CustomerId`)
- **No foreign keys or unique constraints defined.**

---

## GmAgentDiscount

```sql
CREATE TABLE [dbo].[GmAgentDiscount]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[ParentId]          INT NOT NULL,
	[Discount]          DECIMAL(5,4) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOt NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_GmAgentDiscount_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_GmAgentDiscount] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column      | Type         | Null | Default | Description             |
|-------------|--------------|------|---------|-------------------------|
| WebId       | INT          | NO   |         | Primary Key (composite) |
| CustomerId  | INT          | NO   |         | Primary Key (composite) |
| ParentId    | INT          | NO   |         |                         |
| Discount    | DECIMAL(5,4) | NO   |         |                         |
| ModifiedBy  | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn  | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GmAgentPTPreset

```sql
CREATE TABLE [dbo].[GmAgentPTPreset]
(
	[WebId]                 INT NOT NULL,
	[CustomerId]            INT NOT NULL,
	[ParentId]              INT NOT NULL,
	[AccountType]           INT NOT NULL,
	[MinPt]                 DECIMAL(3,2) NOT NULL,
	[ForcePt]               DECIMAL(3,2) NOT NULL,
	[IsTakeAll]             BIT NOT NULL,
	[ModifiedBy]            NVARCHAR(50) NOT NULL,
	[ModifiedOn]            DATETIME CONSTRAINT [DF_GmAgentPTPreset_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_GmAgentPTPreset] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column      | Type         | Null | Default | Description             |
|-------------|--------------|------|---------|-------------------------|
| WebId       | INT          | NO   |         | Primary Key (composite) |
| CustomerId  | INT          | NO   |         | Primary Key (composite) |
| ParentId    | INT          | NO   |         |                         |
| AccountType | INT          | NO   |         |                         |
| MinPt       | DECIMAL(3,2) | NO   |         |                         |
| ForcePt     | DECIMAL(3,2) | NO   |         |                         |
| IsTakeAll   | BIT          | NO   |         |                         |
| ModifiedBy  | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn  | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GmCashPlayerPresetBetSetting

```sql
CREATE TABLE [dbo].[GmCashPlayerPresetBetSetting]
(
	[WebId]             INT NOT NULL,
	[Currency]          CHAR(3) CONSTRAINT [DF_GmCashPlayerPresetBetSetting_Currency] DEFAULT ('') NOT NULL,
	[MinBet]            DECIMAL(18,2) NOT NULL,
	[MaxBet]            DECIMAL(18,2) NOT NULL,
	[MaxPerEvent]       DECIMAL(18,2) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOT NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_GmCashPlayerPresetBetSetting_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_GmCashPlayerPresetBetSetting] PRIMARY KEY NONCLUSTERED ([WebId],[Currency]) WITH (FILLFACTOR = 85)
)
```

| Column        | Type         | Null | Default | Description             |
|---------------|--------------|------|---------|-------------------------|
| WebId         | INT          | NO   |         | Primary Key (composite) |
| Currency      | CHAR(3)      | NO   | ''      | Primary Key (composite) |
| MinBet        | DECIMAL(18,2)| NO   |         |                         |
| MaxBet        | DECIMAL(18,2)| NO   |         |                         |
| MaxPerEvent   | DECIMAL(18,2)| NO   |         |                         |
| ModifiedBy    | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn    | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `Currency` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GmPlayerBetSetting

```sql
CREATE TABLE [dbo].[GmPlayerBetSetting]
(
	[WebId]                 INT NOT NULL,
	[CustomerId]            INT NOT NULL,
	[ParentId]              INT NOT NULL,    
	[Credit]                DECIMAL(18,2) NOT NULL,
	[MinBet]                DECIMAL(18,2) NOT NULL,
	[MaxBet]                DECIMAL(18,2) NOT NULL,
	[MaxPerEvent]           DECIMAL(18,2) NOT NULL,
	[DailyPlayerMaxLose]    DECIMAL(3, 2) CONSTRAINT [DF_GmPlayerBetSetting_DailyPlayerMaxLose] DEFAULT (1) NOT NULL,
	[DailyPlayerMaxWin]     DECIMAL(5, 2) CONSTRAINT [DF_GmPlayerBetSetting_DailyPlayerMaxWin] DEFAULT (0) NOT NULL,
	[DailyResetEnabled]     BIT CONSTRAINT [DF_GmPlayerBetSetting_DailyResetEnabled] DEFAULT (1) NOT NULL,
	[ModifiedBy]            NVARCHAR(50) NOT NULL,
	[ModifiedOn]            DATETIME CONSTRAINT [DF_GmPlayerBetSetting_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_GmPlayerBetSetting] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column              | Type           | Null | Default | Description                |
|---------------------|----------------|------|---------|----------------------------|
| WebId               | INT            | NO   |         | Primary Key (composite)    |
| CustomerId          | INT            | NO   |         | Primary Key (composite)    |
| ParentId            | INT            | NO   |         |                            |
| Credit              | DECIMAL(18,2)  | NO   |         |                            |
| MinBet              | DECIMAL(18,2)  | NO   |         |                            |
| MaxBet              | DECIMAL(18,2)  | NO   |         |                            |
| MaxPerEvent         | DECIMAL(18,2)  | NO   |         |                            |
| DailyPlayerMaxLose  | DECIMAL(3,2)   | NO   | 1       |                            |
| DailyPlayerMaxWin   | DECIMAL(5,2)   | NO   | 0       |                            |
| DailyResetEnabled   | BIT            | NO   | 1       |                            |
| ModifiedBy          | NVARCHAR(50)   | NO   |         |                            |
| ModifiedOn          | DATETIME       | NO   | GETDATE()|                            |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GmPlayerDiscount

```sql
CREATE TABLE [dbo].[GmPlayerDiscount]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[ParentId]          INT NOT NULL,
	[AgtId]             INT NOT NULL,
	[MaId]              INT NOT NULL,
	[SmaId]             INT NOT NULL,
	[SsmaId]            INT NOT NULL,
	[ShId]              INT NOT NULL,
	[PlayerDiscount]    DECIMAL(5,4) NOT NULL,
	[AgtDiscount]       DECIMAL(5,4) NOT NULL,
	[MaDiscount]        DECIMAL(5,4) NOT NULL,
	[SmaDiscount]       DECIMAL(5,4) NOT NULL,
	[SsmaDiscount]      DECIMAL(5,4) NOT NULL,
	[ShDiscount]        DECIMAL(5,4) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOT NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_GmPlayerDiscount_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_GmPlayerDiscount] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default | Description             |
|------------------|--------------|------|---------|-------------------------|
| WebId            | INT          | NO   |         | Primary Key (composite) |
| CustomerId       | INT          | NO   |         | Primary Key (composite) |
| ParentId         | INT          | NO   |         |                         |
| AgtId            | INT          | NO   |         |                         |
| MaId             | INT          | NO   |         |                         |
| SmaId            | INT          | NO   |         |                         |
| SsmaId           | INT          | NO   |         |                         |
| ShId             | INT          | NO   |         |                         |
| PlayerDiscount   | DECIMAL(5,4) | NO   |         |                         |
| AgtDiscount      | DECIMAL(5,4) | NO   |         |                         |
| MaDiscount       | DECIMAL(5,4) | NO   |         |                         |
| SmaDiscount      | DECIMAL(5,4) | NO   |         |                         |
| SsmaDiscount     | DECIMAL(5,4) | NO   |         |                         |
| ShDiscount       | DECIMAL(5,4) | NO   |         |                         |
| ModifiedBy       | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn       | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GmPlayerPtEffective

```sql
CREATE TABLE [dbo].[GmPlayerPtEffective]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[ParentId]          INT NOT NULL,
	[AgtId]             INT NOT NULL,
	[MaId]              INT NOT NULL,
	[SmaId]             INT NOT NULL,
	[SsmaId]            INT NOT NULL,
	[ShId]              INT NOT NULL,
	[HouseMin]          DECIMAL(3,2) NOT NULL,
	[HouseForce]        DECIMAL(3,2) NOT NULL,
	[HouseTakeAll]      BIT,
	[ShMin]             DECIMAL(3,2) NOT NULL,
	[ShForce]           DECIMAL(3,2) NOT NULL,
	[ShTakeAll]         BIT,
	[SsmaMin]           DECIMAL(3,2) NOT NULL,
	[SsmaForce]         DECIMAL(3,2) NOT NULL,
	[SsmaTakeAll]       BIT,
	[SmaMin]            DECIMAL(3,2) NOT NULL,
	[SmaForce]          DECIMAL(3,2) NOT NULL,
	[SmaTakeAll]        BIT,
	[MaMin]             DECIMAL(3,2) NOT NULL,
	[MaForce]           DECIMAL(3,2) NOT NULL,
	[MaTakeAll]         BIT,
	[ShPT]              DECIMAL(3,2) NOT NULL,
	[SsmaPT]            DECIMAL(3,2) NOT NULL,
	[SmaPT]             DECIMAL(3,2) NOT NULL,
	[MaPT]              DECIMAL(3,2) NOT NULL,
	[AgtPT]             DECIMAL(3,2) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOT NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_GmPlayerPtEffective_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
	CONSTRAINT [PK_GmPlayerPtEffective] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default | Description             |
|------------------|--------------|------|---------|-------------------------|
| WebId            | INT          | NO   |         | Primary Key (composite) |
| CustomerId       | INT          | NO   |         | Primary Key (composite) |
| ParentId         | INT          | NO   |         |                         |
| AgtId            | INT          | NO   |         |                         |
| MaId             | INT          | NO   |         |                         |
| SmaId            | INT          | NO   |         |                         |
| SsmaId           | INT          | NO   |         |                         |
| ShId             | INT          | NO   |         |                         |
| HouseMin         | DECIMAL(3,2) | NO   |         |                         |
| HouseForce       | DECIMAL(3,2) | NO   |         |                         |
| HouseTakeAll     | BIT          | YES  |         |                         |
| ShMin            | DECIMAL(3,2) | NO   |         |                         |
| ShForce          | DECIMAL(3,2) | NO   |         |                         |
| ShTakeAll        | BIT          | YES  |         |                         |
| SsmaMin          | DECIMAL(3,2) | NO   |         |                         |
| SsmaForce        | DECIMAL(3,2) | NO   |         |                         |
| SsmaTakeAll      | BIT          | YES  |         |                         |
| SmaMin           | DECIMAL(3,2) | NO   |         |                         |
| SmaForce         | DECIMAL(3,2) | NO   |         |                         |
| SmaTakeAll       | BIT          | YES  |         |                         |
| MaMin            | DECIMAL(3,2) | NO   |         |                         |
| MaForce          | DECIMAL(3,2) | NO   |         |                         |
| MaTakeAll        | BIT          | YES  |         |                         |
| ShPT             | DECIMAL(3,2) | NO   |         |                         |
| SsmaPT           | DECIMAL(3,2) | NO   |         |                         |
| SmaPT            | DECIMAL(3,2) | NO   |         |                         |
| MaPT             | DECIMAL(3,2) | NO   |         |                         |
| AgtPT            | DECIMAL(3,2) | NO   |         |                         |
| ModifiedBy       | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn       | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GmAgentBetSetting

```sql
CREATE TABLE [dbo].[GmAgentBetSetting]
(
	[WebId]                 INT NOT NULL,
	[CustomerId]            INT NOT NULL,
	[ParentId]              INT NOT NULL,    
	[Credit]                DECIMAL(18,2) NOT NULL,
	[MaxCredit]             DECIMAL(18,2) NOT NULL,
	[MinBet]                DECIMAL(18,2) NOT NULL,
	[MaxBet]                DECIMAL(18,2) NOT NULL,
	[MaxPerEvent]           DECIMAL(18,2) NOT NULL,
	[ModifiedBy]            NVARCHAR(50) NOT NULL,
	[ModifiedOn]            DATETIME CONSTRAINT [DF_GmAgentBetSetting_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
	[DailyPlayerMaxLose]    DECIMAL(3, 2) CONSTRAINT [DF_GmAgentBetSetting_DailyPlayerMaxLose] DEFAULT (1) NOT NULL,
	[DailyPlayerMaxWin]     DECIMAL(5, 2) CONSTRAINT [DF_GmAgentBetSetting_DailyPlayerMaxWin] DEFAULT (0) NOT NULL,
	[DailyResetEnabled]     BIT CONSTRAINT [DF_GmAgentBetSetting_DailyResetEnabled] DEFAULT (1) NOT NULL
    CONSTRAINT [PK_GmAgentBetSetting] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column              | Type           | Null | Default | Description                |
|---------------------|----------------|------|---------|----------------------------|
| WebId               | INT            | NO   |         | Primary Key (composite)    |
| CustomerId          | INT            | NO   |         | Primary Key (composite)    |
| ParentId            | INT            | NO   |         |                            |
| Credit              | DECIMAL(18,2)  | NO   |         |                            |
| MaxCredit           | DECIMAL(18,2)  | NO   |         |                            |
| MinBet              | DECIMAL(18,2)  | NO   |         |                            |
| MaxBet              | DECIMAL(18,2)  | NO   |         |                            |
| MaxPerEvent         | DECIMAL(18,2)  | NO   |         |                            |
| ModifiedBy          | NVARCHAR(50)   | NO   |         |                            |
| ModifiedOn          | DATETIME       | NO   | GETDATE()|                            |
| DailyPlayerMaxLose  | DECIMAL(3,2)   | NO   | 1       |                            |
| DailyPlayerMaxWin   | DECIMAL(5,2)   | NO   | 0       |                            |
| DailyResetEnabled   | BIT            | NO   | 1       |                            |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GmPlayerStatement

```sql
CREATE TABLE [dbo].[GmPlayerStatement]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[Username]          NVARCHAR(50) NOT NULL,
	[GamesWinLose]      DECIMAL(19,6) NOT NULL CONSTRAINT [DF_GmPlayerStatement_GamesWinLose] DEFAULT (0),
	[FullTransferTime]  DATETIME NULL,
	[FullTransferId]    NVARCHAR(50) NULL,
	[DailyResetDate]    SMALLDATETIME NULL,
	[LastResetTime]     DATETIME NULL,
	[ModifiedOn]        DATETIME NOT NULL CONSTRAINT [DF_GmPlayerStatement_ModifiedOn] DEFAULT (GETDATE()),
	CONSTRAINT [PK_GmPlayerStatement] PRIMARY KEY CLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column            | Type           | Null | Default | Description             |
|-------------------|----------------|------|---------|-------------------------|
| WebId             | INT            | NO   |         | Primary Key (composite) |
| CustomerId        | INT            | NO   |         | Primary Key (composite) |
| Username          | NVARCHAR(50)   | NO   |         |                         |
| GamesWinLose      | DECIMAL(19,6)  | NO   | 0       |                         |
| FullTransferTime  | DATETIME       | YES  |         |                         |
| FullTransferId    | NVARCHAR(50)   | YES  |         |                         |
| DailyResetDate    | SMALLDATETIME  | YES  |         |                         |
| LastResetTime     | DATETIME       | YES  |         |                         |
| ModifiedOn        | DATETIME       | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GpAgentCommission

```sql
CREATE TABLE [dbo].[GpAgentCommission]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[ParentId]          INT NOT NULL,
	[AccountType]       TINYINT NOT NULL,
	[GameProviderId]    INT NOT NULL,
	[Commission]        DECIMAL(5,4) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOt NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_GmAgentCommission_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_GmAgentCommission] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[GameProviderId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default | Description             |
|------------------|--------------|------|---------|-------------------------|
| WebId            | INT          | NO   |         | Primary Key (composite) |
| CustomerId       | INT          | NO   |         | Primary Key (composite) |
| ParentId         | INT          | NO   |         |                         |
| AccountType      | TINYINT      | NO   |         |                         |
| GameProviderId   | INT          | NO   |         | Primary Key (composite) |
| Commission       | DECIMAL(5,4) | NO   |         |                         |
| ModifiedBy       | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn       | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId`, `GameProviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## GpPlayerPtEffective

```sql
CREATE TABLE [dbo].[GpPlayerPtEffective]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[GpId]              INT NOT NULL,
	[ParentId]          INT NOT NULL,
	[AgtId]             INT NOT NULL,
	[MaId]              INT NOT NULL,
	[SmaId]             INT NOT NULL,
	[SsmaId]            INT NOT NULL,
	[ShId]              INT NOT NULL,
	[HouseMin]          DECIMAL(3,2) NOT NULL,
	[HouseForce]        DECIMAL(3,2) NOT NULL,
	[HouseTakeAll]      BIT,
	[ShMin]             DECIMAL(3,2) NOT NULL,
	[ShForce]           DECIMAL(3,2) NOT NULL,
	[ShTakeAll]         BIT,
	[SsmaMin]           DECIMAL(3,2) NOT NULL,
	[SsmaForce]         DECIMAL(3,2) NOT NULL,
	[SsmaTakeAll]       BIT,
	[SmaMin]            DECIMAL(3,2) NOT NULL,
	[SmaForce]          DECIMAL(3,2) NOT NULL,
	[SmaTakeAll]        BIT,
	[MaMin]             DECIMAL(3,2) NOT NULL,
	[MaForce]           DECIMAL(3,2) NOT NULL,
	[MaTakeAll]         BIT,
	[ShPT]              DECIMAL(3,2) NOT NULL,
	[SsmaPT]            DECIMAL(3,2) NOT NULL,
	[SmaPT]             DECIMAL(3,2) NOT NULL,
	[MaPT]              DECIMAL(3,2) NOT NULL,
	[AgtPT]             DECIMAL(3,2) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOT NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_GpPlayerPtEffective_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
	CONSTRAINT [PK_GpPlayerPtEffective] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[GpId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default | Description             |
|------------------|--------------|------|---------|-------------------------|
| WebId            | INT          | NO   |         | Primary Key (composite) |
| CustomerId       | INT          | NO   |         | Primary Key (composite) |
| GpId             | INT          | NO   |         | Primary Key (composite) |
| ParentId         | INT          | NO   |         |                         |
| AgtId            | INT          | NO   |         |                         |
| MaId             | INT          | NO   |         |                         |
| SmaId            | INT          | NO   |         |                         |
| SsmaId           | INT          | NO   |         |                         |
| ShId             | INT          | NO   |         |                         |
| HouseMin         | DECIMAL(3,2) | NO   |         |                         |
| HouseForce       | DECIMAL(3,2) | NO   |         |                         |
| HouseTakeAll     | BIT          | YES  |         |                         |
| ShMin            | DECIMAL(3,2) | NO   |         |                         |
| ShForce          | DECIMAL(3,2) | NO   |         |                         |
| ShTakeAll        | BIT          | YES  |         |                         |
| SsmaMin          | DECIMAL(3,2) | NO   |         |                         |
| SsmaForce        | DECIMAL(3,2) | NO   |         |                         |
| SsmaTakeAll      | BIT          | YES  |         |                         |
| SmaMin           | DECIMAL(3,2) | NO   |         |                         |
| SmaForce         | DECIMAL(3,2) | NO   |         |                         |
| SmaTakeAll       | BIT          | YES  |         |                         |
| MaMin            | DECIMAL(3,2) | NO   |         |                         |
| MaForce          | DECIMAL(3,2) | NO   |         |                         |
| MaTakeAll        | BIT          | YES  |         |                         |
| ShPT             | DECIMAL(3,2) | NO   |         |                         |
| SsmaPT           | DECIMAL(3,2) | NO   |         |                         |
| SmaPT            | DECIMAL(3,2) | NO   |         |                         |
| MaPT             | DECIMAL(3,2) | NO   |         |                         |
| AgtPT            | DECIMAL(3,2) | NO   |         |                         |
| ModifiedBy       | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn       | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId`, `GpId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## LcAgentCommission

```sql
CREATE TABLE [dbo].[LcAgentCommission]
(
	[WebId]             INT NOT NULL,
	[CustomerId]        INT NOT NULL,
	[ParentId]          INT NOT NULL,
	[AccountType]       TINYINT NOT NULL,
	[Commission]        DECIMAL(5,4) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOt NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_LcAgentCommission_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_LcAgentCommission] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default | Description             |
|------------------|--------------|------|---------|-------------------------|
| WebId            | INT          | NO   |         | Primary Key (composite) |
| CustomerId       | INT          | NO   |         | Primary Key (composite) |
| ParentId         | INT          | NO   |         |                         |
| AccountType      | TINYINT      | NO   |         |                         |
| Commission       | DECIMAL(5,4) | NO   |         |                         |
| ModifiedBy       | NVARCHAR(50) | NO   |         |                         |
| ModifiedOn       | DATETIME     | NO   | GETDATE()|                        |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## LcPlayerCommission

```sql
CREATE TABLE [dbo].[LcPlayerCommission]
(
    [WebId]             INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [ParentId]          INT NOT NULL,
    [AgtId]             INT NOT NULL,
    [MaId]              INT NOT NULL,
    [SmaId]             INT NOT NULL,
    [SSmaId]            INT NOT NULL,
    [ShId]              INT NOT NULL,
    [ShCommRate]        DECIMAL(5,4) NOT NULL,
    [SsmaCommRate]      DECIMAL(5,4) NOT NULL,
    [SmaCommRate]       DECIMAL(5,4) NOT NULL,
    [MaCommRate]        DECIMAL(5,4) NOT NULL,
    [AgtCommRate]       DECIMAL(5,4) NOT NULL,
    [PlayerCommRate]    DECIMAL(5,4) NOT NULL,
    [ModifiedBy]        NVARCHAR(50) NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_LcPlayerCommission_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_LcPlayerCommission] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default    | Description                  |
|------------------|--------------|------|------------|------------------------------|
| WebId            | INT          | NO   |            | Primary Key (composite)      |
| CustomerId       | INT          | NO   |            | Primary Key (composite)      |
| ParentId         | INT          | NO   |            |                              |
| AgtId            | INT          | NO   |            |                              |
| MaId             | INT          | NO   |            |                              |
| SmaId            | INT          | NO   |            |                              |
| SSmaId           | INT          | NO   |            |                              |
| ShId             | INT          | NO   |            |                              |
| ShCommRate       | DECIMAL(5,4) | NO   |            |                              |
| SsmaCommRate     | DECIMAL(5,4) | NO   |            |                              |
| SmaCommRate      | DECIMAL(5,4) | NO   |            |                              |
| MaCommRate       | DECIMAL(5,4) | NO   |            |                              |
| AgtCommRate      | DECIMAL(5,4) | NO   |            |                              |
| PlayerCommRate   | DECIMAL(5,4) | NO   |            |                              |
| ModifiedBy       | NVARCHAR(50) | NO   |            |                              |
| ModifiedOn       | DATETIME     | NO   | GETDATE()  |                              |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## LcPlayerPTEffective

```sql
CREATE TABLE [dbo].[LcPlayerPTEffective]
(
    [WebId]             INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [ParentId]          INT NOT NULL,
    [AgtId]             INT NOT NULL,
    [MaId]              INT NOT NULL,
    [SmaId]             INT NOT NULL,
    [SsmaId]            INT NOT NULL,
    [ShId]              INT NOT NULL,
    [HouseMin]          DECIMAL(3,2) NOT NULL,
    [HouseForce]        DECIMAL(3,2) NOT NULL,
    [HouseTakeAll]      BIT,
    [ShMin]             DECIMAL(3,2) NOT NULL,
    [ShForce]           DECIMAL(3,2) NOT NULL,
    [ShTakeAll]         BIT,
    [SsmaMin]           DECIMAL(3,2) NOT NULL,
    [SsmaForce]         DECIMAL(3,2) NOT NULL,
    [SsmaTakeAll]       BIT,
    [SmaMin]            DECIMAL(3,2) NOT NULL,
    [SmaForce]          DECIMAL(3,2) NOT NULL,
    [SmaTakeAll]        BIT,
    [MaMin]             DECIMAL(3,2) NOT NULL,
    [MaForce]           DECIMAL(3,2) NOT NULL,
    [MaTakeAll]         BIT,
    [ShPT]              DECIMAL(3,2) NOT NULL,
    [SsmaPT]            DECIMAL(3,2) NOT NULL,
    [SmaPT]             DECIMAL(3,2) NOT NULL,
    [MaPT]              DECIMAL(3,2) NOT NULL,
    [AgtPT]             DECIMAL(3,2) NOT NULL,
    [ModifiedBy]        NVARCHAR(50) NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_LcPlayerPTEffective_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_LcPlayerPTEffective] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default    | Description                  |
|------------------|--------------|------|------------|------------------------------|
| WebId            | INT          | NO   |            | Primary Key (composite)      |
| CustomerId       | INT          | NO   |            | Primary Key (composite)      |
| ParentId         | INT          | NO   |            |                              |
| AgtId            | INT          | NO   |            |                              |
| MaId             | INT          | NO   |            |                              |
| SmaId            | INT          | NO   |            |                              |
| SsmaId           | INT          | NO   |            |                              |
| ShId             | INT          | NO   |            |                              |
| HouseMin         | DECIMAL(3,2) | NO   |            |                              |
| HouseForce       | DECIMAL(3,2) | NO   |            |                              |
| HouseTakeAll     | BIT          | YES  |            |                              |
| ShMin            | DECIMAL(3,2) | NO   |            |                              |
| ShForce          | DECIMAL(3,2) | NO   |            |                              |
| ShTakeAll        | BIT          | YES  |            |                              |
| SsmaMin          | DECIMAL(3,2) | NO   |            |                              |
| SsmaForce        | DECIMAL(3,2) | NO   |            |                              |
| SsmaTakeAll      | BIT          | YES  |            |                              |
| SmaMin           | DECIMAL(3,2) | NO   |            |                              |
| SmaForce         | DECIMAL(3,2) | NO   |            |                              |
| SmaTakeAll       | BIT          | YES  |            |                              |
| MaMin            | DECIMAL(3,2) | NO   |            |                              |
| MaForce          | DECIMAL(3,2) | NO   |            |                              |
| MaTakeAll        | BIT          | YES  |            |                              |
| ShPT             | DECIMAL(3,2) | NO   |            |                              |
| SsmaPT           | DECIMAL(3,2) | NO   |            |                              |
| SmaPT            | DECIMAL(3,2) | NO   |            |                              |
| MaPT             | DECIMAL(3,2) | NO   |            |                              |
| AgtPT            | DECIMAL(3,2) | NO   |            |                              |
| ModifiedBy       | NVARCHAR(50) | NO   |            |                              |
| ModifiedOn       | DATETIME     | NO   | GETDATE()  |                              |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## LcPlayerStatement

```sql
CREATE TABLE [dbo].[LcPlayerStatement]
(
    [WebId]             INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [Username]          NVARCHAR(50) NOT NULL,
    [LiveCasinoWinLose] DECIMAL(19,6) NOT NULL CONSTRAINT [DF_LcPlayerStatement_GamesWinLose] DEFAULT (0),
    [FullTransferTime]  DATETIME NULL,
    [FullTransferId]    NVARCHAR(50) NULL,
    [DailyResetDate]    SMALLDATETIME NULL,
    [LastResetTime]     DATETIME NULL,
    [ModifiedOn]        DATETIME NOT NULL CONSTRAINT [DF_LcPlayerStatement_ModifiedOn] DEFAULT (GETDATE()),
    CONSTRAINT [PK_LcPlayerStatement] PRIMARY KEY CLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column             | Type           | Null | Default    | Description                  |
|--------------------|----------------|------|------------|------------------------------|
| WebId              | INT            | NO   |            | Primary Key (composite)      |
| CustomerId         | INT            | NO   |            | Primary Key (composite)      |
| Username           | NVARCHAR(50)   | NO   |            |                              |
| LiveCasinoWinLose  | DECIMAL(19,6)  | NO   | 0          |                              |
| FullTransferTime   | DATETIME       | YES  |            |                              |
| FullTransferId     | NVARCHAR(50)   | YES  |            |                              |
| DailyResetDate     | SMALLDATETIME  | YES  |            |                              |
| LastResetTime      | DATETIME       | YES  |            |                              |
| ModifiedOn         | DATETIME       | NO   | GETDATE()  |                              |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## MemberActionLog

```sql
CREATE TABLE [dbo].[MemberActionLog]
(
    [Id] INT IDENTITY(1, 1) PRIMARY KEY,
    [WebId] INT NOT NULL,
    [CustomerId] INT NOT NULL,
    [TraceId] NVARCHAR(50),
    [ActionType] NVARCHAR(50),
    [Target] NVARCHAR(100),
    [Ip] NVARCHAR(200),
    [Result] NVARCHAR(50),
    [Action] NVARCHAR(255),
    [Request] NVARCHAR(MAX),
    [Response] NVARCHAR(MAX),
    [ActionOn] DATETIME DEFAULT GETDATE(),
    [RequestId] NVARCHAR(200) NULL,
    [VisitorId] NVARCHAR(200) NULL
    -- Move the CHECK constraint to table level
    CONSTRAINT CK_MemberActionLog_Record
    CHECK
    (
        [ActionType] IS NULL
        OR [ActionType] = ''
        OR [ActionType] IN
        (
             'ApprovedDeposit', 'RejectDeposit', 'ApprovedWithdrawal', 'RejectWithdrawal',
             'ApprovedPromotion', 'RejectPromotion', 'ManualTransfer', 'ChangePassword',
             'ChangeMemberStatus', 'ChangeAccountInformation', 'ChangeBankAccountInfo',
             'ChangePromotionSetting', 'CreatePromotion', 'ChangeVIPSetting', 'ForceCompleteWithdrawalLimit'
        )
    )
    );
```

| Column      | Type           | Null | Default    | Description     |
|-------------|----------------|------|------------|----------------|
| Id          | INT (IDENTITY) | NO   |            | Primary Key     |
| WebId       | INT            | NO   |            |                |
| CustomerId  | INT            | NO   |            |                |
| TraceId     | NVARCHAR(50)   | YES  |            |                |
| ActionType  | NVARCHAR(50)   | YES  |            | CHECK constraint|
| Target      | NVARCHAR(100)  | YES  |            |                |
| Ip          | NVARCHAR(200)  | YES  |            |                |
| Result      | NVARCHAR(50)   | YES  |            |                |
| Action      | NVARCHAR(255)  | YES  |            |                |
| Request     | NVARCHAR(MAX)  | YES  |            |                |
| Response    | NVARCHAR(MAX)  | YES  |            |                |
| ActionOn    | DATETIME       | YES  | GETDATE()  |                |
| RequestId   | NVARCHAR(200)  | YES  |            |                |
| VisitorId   | NVARCHAR(200)  | YES  |            |                |

- **Primary Key:** `Id`
- **Check Constraint:** `CK_MemberActionLog_Record` on `ActionType` (see allowed values in SQL)
- **Indexes:**
  - `IX_MemberLog_WebId_ActionOn` on `WebId`, `ActionOn` (includes many columns)
- **No foreign keys or unique constraints defined.**

---

## MemberAffiliateDetails

```sql
CREATE TABLE [dbo].[MemberAffiliateDetails] (
    [Id] INT IDENTITY(1,1) PRIMARY KEY,
    [WebId] INT NOT NULL,
    [CustomerId] INT NOT NULL,
    [AffiliateCode] NVARCHAR(100) NOT NULL,
    [ModifiedBy] NVARCHAR(50) NOT NULL,
    [ModifiedOn] DATETIME NOT NULL DEFAULT GETDATE()
);
```

| Column         | Type           | Null | Default    | Description     |
|----------------|----------------|------|------------|----------------|
| Id             | INT (IDENTITY) | NO   |            | Primary Key     |
| WebId          | INT            | NO   |            |                |
| CustomerId     | INT            | NO   |            |                |
| AffiliateCode  | NVARCHAR(100)  | NO   |            |                |
| ModifiedBy     | NVARCHAR(50)   | NO   |            |                |
| ModifiedOn     | DATETIME       | NO   | GETDATE()  |                |

- **Primary Key:** `Id`
- **No foreign keys, unique constraints, or indexes defined.**

---

## MemberRemark

```sql
CREATE TABLE [dbo].[MemberRemark] (
    [Id] INT IDENTITY(1,1) PRIMARY KEY,
    [WebId] INT,
    [CustomerId] INT,
    [Remark] NVARCHAR(100),
    [ModifiedBy] NVARCHAR(100),
    [ModifiedOn] DATETIME,
    [CreatedOn] DATETIME,
    [CreatedBy] NVARCHAR(100),
    [ParentId] INT,
    [Status] NVARCHAR(50),
    CONSTRAINT CK_MemberRemark_Status CHECK ([Status] IN ('Active', 'Deleted'))
);
```

| Column      | Type           | Null | Default    | Description     |
|-------------|----------------|------|------------|----------------|
| Id          | INT (IDENTITY) | NO   |            | Primary Key     |
| WebId       | INT            | YES  |            |                |
| CustomerId  | INT            | YES  |            |                |
| Remark      | NVARCHAR(100)  | YES  |            |                |
| ModifiedBy  | NVARCHAR(100)  | YES  |            |                |
| ModifiedOn  | DATETIME       | YES  |            |                |
| CreatedOn   | DATETIME       | YES  |            |                |
| CreatedBy   | NVARCHAR(100)  | YES  |            |                |
| ParentId    | INT            | YES  |            |                |
| Status      | NVARCHAR(50)   | YES  |            | CHECK constraint|

- **Primary Key:** `Id`
- **Check Constraint:** `CK_MemberRemark_Status` on `Status` (must be 'Active' or 'Deleted')
- **No foreign keys, unique constraints, or indexes defined.**

---

## OperatorAnnouncement

```sql
CREATE TABLE [dbo].[OperatorAnnouncement]
(
	[Id]                INT  IDENTITY (1, 1)   NOT NULL,
    [AnnouncementId]   INT     NOT NULL, 
    [OperatorId]       INT     NOT NULL,
    [IsRead]           BIT     NOT NULL DEFAULT 0,
    [IsDeleted]        BIT     NOT NULL DEFAULT 0,
    [CreatedBy]        NVARCHAR (50)       NOT NULL,
    [CreatedOn]        DATETIME           NOT NULL DEFAULT (GETDATE()),
    [ModifiedBy]       NVARCHAR (50)       NOT NULL,
    [ModifiedOn]       DATETIME           NOT NULL DEFAULT (GETDATE()),
    CONSTRAINT [PK_OperatorAnnouncement] PRIMARY KEY CLUSTERED ([Id] ASC)
)
```

| Column         | Type           | Null | Default    | Description     |
|----------------|----------------|------|------------|----------------|
| Id             | INT (IDENTITY) | NO   |            | Primary Key     |
| AnnouncementId | INT            | NO   |            |                |
| OperatorId     | INT            | NO   |            |                |
| IsRead         | BIT            | NO   | 0          |                |
| IsDeleted      | BIT            | NO   | 0          |                |
| CreatedBy      | NVARCHAR(50)   | NO   |            |                |
| CreatedOn      | DATETIME       | NO   | GETDATE()  |                |
| ModifiedBy     | NVARCHAR(50)   | NO   |            |                |
| ModifiedOn     | DATETIME       | NO   | GETDATE()  |                |

- **Primary Key:** `Id`
- **No foreign keys, unique constraints, or indexes defined.**

---

## OperatorLoginLog

```sql
CREATE TABLE [dbo].[OperatorLoginLog]
(
    [Id] INT IDENTITY(1, 1) PRIMARY KEY,
    [Ip] NVARCHAR(200) NULL,
    [RequestActionUrl] NVARCHAR(200),
    [RequestData] NVARCHAR(MAX),
    [ResponseData] NVARCHAR(MAX),
    [ActionOn] DATETIME DEFAULT GETDATE(),
    [RequestId] NVARCHAR(200) NULL,
    [VisitorId] NVARCHAR(200) NULL
);
```

| Column            | Type           | Null | Default    | Description     |
|-------------------|----------------|------|------------|----------------|
| Id                | INT (IDENTITY) | NO   |            | Primary Key     |
| Ip                | NVARCHAR(200)  | YES  |            |                |
| RequestActionUrl  | NVARCHAR(200)  | NO   |            |                |
| RequestData       | NVARCHAR(MAX)  | NO   |            |                |
| ResponseData      | NVARCHAR(MAX)  | NO   |            |                |
| ActionOn          | DATETIME       | NO   | GETDATE()  |                |
| RequestId         | NVARCHAR(200)  | YES  |            |                |
| VisitorId         | NVARCHAR(200)  | YES  |            |                |

- **Primary Key:** `Id`
- **No foreign keys, unique constraints, or indexes defined.**

---

## PlayerPreference

```sql
CREATE TABLE [dbo].[PlayerPreference]
(
	[CustomerId] int  NOT NULL,
	[DisplayTime] int NOT NUll,
	[ThemeMode] INT NOT NULL DEFAULT 1, 
	[ModifiedBy] varchar(50) NOT NULL,
	[ModifiedOn] DateTime NOT NULL 
	CONSTRAINT [PK_Preference] PRIMARY KEY CLUSTERED 
	(
		[CustomerId] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
)
```

| Column      | Type         | Null | Default | Description     |
|-------------|--------------|------|---------|----------------|
| CustomerId  | INT          | NO   |         | Primary Key     |
| DisplayTime | INT          | NO   |         |                |
| ThemeMode   | INT          | NO   | 1       |                |
| ModifiedBy  | VARCHAR(50)  | NO   |         |                |
| ModifiedOn  | DATETIME     | NO   |         |                |

- **Primary Key:** `CustomerId`
- **No foreign keys, unique constraints, or indexes defined.**

---

## MigrateAgent

```sql
CREATE TABLE [dbo].[MigrateAgent]
(
    [Webid]        int NOT NULL,
    [AgentName] NVARCHAR(50) NOT NULL,
    [Currency] NVARCHAR(3) NOT NULL,
    [minbet] DECIMAL(19, 2) NOT NULL,
    [maxbet] DECIMAL(19, 2) NOT NULL,
    [maxpermatch]     DECIMAL(19, 2)           NOT NULL, 
    [tableLimit] INT NULL   
)
```

| Column       | Type           | Null | Default | Description     |
|--------------|----------------|------|---------|----------------|
| Webid        | INT            | NO   |         |                |
| AgentName    | NVARCHAR(50)   | NO   |         |                |
| Currency     | NVARCHAR(3)    | NO   |         |                |
| minbet       | DECIMAL(19,2)  | NO   |         |                |
| maxbet       | DECIMAL(19,2)  | NO   |         |                |
| maxpermatch  | DECIMAL(19,2)  | NO   |         |                |
| tableLimit   | INT            | YES  |         |                |

- **Primary Key:** Not explicitly defined in the SQL.
- **No foreign keys, unique constraints, or indexes defined.**

---

## MigratePlayer

```sql
CREATE TABLE [dbo].[MigratePlayer]
(
    [AgentName] NVARCHAR(50) NOT NULL, 
    [PlayerName] NVARCHAR(50) NOT NULL, 
    [Webid] INT NOT NULL,
)
```

| Column      | Type         | Null | Default | Description     |
|-------------|--------------|------|---------|----------------|
| AgentName   | NVARCHAR(50) | NO   |         |                |
| PlayerName  | NVARCHAR(50) | NO   |         |                |
| Webid       | INT          | NO   |         |                |

- **Primary Key:** Not explicitly defined in the SQL.
- **No foreign keys, unique constraints, or indexes defined.**

---

## Notifications

```sql
CREATE TABLE [dbo].[Notifications]
(
	[Id]                    BIGINT IDENTITY(1,1) NOT NULL,
	[WebId]                 INT NOT NULL,
	[CustomerId]            INT NOT NULL,
	[NotificationWay]       NVARCHAR(50) NOT NULL,
	[Title]                 NVARCHAR(1000) NOT NULL,
	[Content]               NVARCHAR(MAX) NOT NULL,
	[NotificationStartTime] DATETIME NOT NULL,
	[SentTimes]             INT NOT NULL DEFAULT(1),
	[MaxSendTimes]          INT NOT NULL DEFAULT(1),
	[CreatedOn]             DATETIME NOT NULL,
	[CreatedBy]             NVARCHAR(100) NOT NULL,
	CONSTRAINT [PK_Notifications] PRIMARY KEY NONCLUSTERED ([Id]) WITH (FILLFACTOR = 85)
)
```

| Column                | Type            | Null | Default | Description     |
|-----------------------|-----------------|------|---------|----------------|
| Id                    | BIGINT (IDENTITY)| NO  |         | Primary Key     |
| WebId                 | INT             | NO   |         |                |
| CustomerId            | INT             | NO   |         |                |
| NotificationWay       | NVARCHAR(50)    | NO   |         |                |
| Title                 | NVARCHAR(1000)  | NO   |         |                |
| Content               | NVARCHAR(MAX)   | NO   |         |                |
| NotificationStartTime | DATETIME        | NO   |         |                |
| SentTimes             | INT             | NO   | 1       |                |
| MaxSendTimes          | INT             | NO   | 1       |                |
| CreatedOn             | DATETIME        | NO   |         |                |
| CreatedBy             | NVARCHAR(100)   | NO   |         |                |

- **Primary Key:** `Id`
- **No foreign keys, unique constraints, or indexes defined.**

---

## PromotionCashSettled

```sql
CREATE TABLE [dbo].[PromotionCashSettled] (
    [Id]                    BIGINT IDENTITY(1,1) NOT NULL,
    [WebId]                 INT             NOT NULL,
    [CustomerId]            INT             NOT NULL,
    [PromotionRequestId]    INT             CONSTRAINT [DF_PromotionCashSettled_PromotionRequestId] DEFAULT ((0)) NOT NULL,
    [TransferIn]            DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_TransferIn] DEFAULT ((0)) NOT NULL,
    [TransferOut]           DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_TransferOut] DEFAULT ((0)) NOT NULL,
    [SBPlayerCashSettled]   DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_SBPlayerCashSettled] DEFAULT ((0)) NULL,
    [SBPlayerCashReturn]    DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_SBPlayerCashReturn] DEFAULT ((0)) NULL,
    [LCPlayerCashSettled]   DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_LCCashSettled] DEFAULT ((0)) NOT NULL,
    [LCPlayerCashReturn]    DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_LCCashReturn] DEFAULT ((0)) NOT NULL,
    [GMPlayerCashSettled]   DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_GMCashSettled] DEFAULT ((0)) NOT NULL,
    [GMPlayerCashReturn]    DECIMAL (19, 6) CONSTRAINT [DF_PromotionCashSettled_GMCashReturn] DEFAULT ((0)) NOT NULL,
    [ModifiedBy]            NVARCHAR (50)   NULL,
    [ModifiedOn]            DATETIME        NULL,
    CONSTRAINT [PK_PromotionCashSettled] PRIMARY KEY CLUSTERED ([ID]) WITH (FILLFACTOR = 85),
    CONSTRAINT [UQ_PromotionCashSettled] UNIQUE ([CustomerId],[PromotionRequestId])
);
```

| Column                | Type             | Null | Default | Description     |
|-----------------------|------------------|------|---------|----------------|
| Id                    | BIGINT (IDENTITY)| NO   |         | Primary Key     |
| WebId                 | INT              | NO   |         |                |
| CustomerId            | INT              | NO   |         |                |
| PromotionRequestId    | INT              | NO   | 0       | Unique          |
| TransferIn            | DECIMAL(19,6)    | NO   | 0       |                |
| TransferOut           | DECIMAL(19,6)    | NO   | 0       |                |
| SBPlayerCashSettled   | DECIMAL(19,6)    | YES  | 0       |                |
| SBPlayerCashReturn    | DECIMAL(19,6)    | YES  | 0       |                |
| LCPlayerCashSettled   | DECIMAL(19,6)    | NO   | 0       |                |
| LCPlayerCashReturn    | DECIMAL(19,6)    | NO   | 0       |                |
| GMPlayerCashSettled   | DECIMAL(19,6)    | NO   | 0       |                |
| GMPlayerCashReturn    | DECIMAL(19,6)    | NO   | 0       |                |
| ModifiedBy            | NVARCHAR(50)     | YES  |         |                |
| ModifiedOn            | DATETIME         | YES  |         |                |

- **Primary Key:** `Id`
- **Unique Constraint:** `UQ_PromotionCashSettled` on (`CustomerId`, `PromotionRequestId`)
- **Indexes:**
  - `IX_PromotionCashSettled_vPlayerBalance_CustomerId` on `WebId`, `CustomerId`, `PromotionRequestId` (includes several columns)
- **No foreign keys defined.**

---

## PromotionCashUsed

```sql
CREATE TABLE [dbo].[PromotionCashUsed] (
    [Id]                 BIGINT IDENTITY(1,1) NOT NULL,
    [WebId]              INT             NOT NULL,
    [CustomerId]         INT             NOT NULL,
    [PromotionRequestId] INT             CONSTRAINT [DF_PromotionCashUsed_PromotionRequestId] DEFAULT ((0)) NOT NULL,
    [Username]           NVARCHAR(50)    NOT NULL,
    [Currency]           NVARCHAR(3)     NULL,
    [SBPlayerCashUsed]   DECIMAL(19,6)   CONSTRAINT [DF_PromotionCashUsed_SB_PlayerCashUsed] DEFAULT ((0)) NULL,
    [LCPlayerCashUsed]   DECIMAL(19,6)   CONSTRAINT [DF_PromotionCashUsed_LCCashUsed] DEFAULT ((0)) NOT NULL,
    [GMPlayerCashUsed]   DECIMAL(19,6)   CONSTRAINT [DF_PromotionCashUsed_GMCashUsed] DEFAULT ((0)) NOT NULL,
    [ModifiedBy]         NVARCHAR(50)    NULL,
    [ModifiedOn]         DATETIME        NULL,
    [LastOrderOn]        DATETIME        NULL,
    CONSTRAINT [PK_PromotionCashUsed] PRIMARY KEY CLUSTERED ([ID]) WITH (FILLFACTOR = 95),
    CONSTRAINT [UQ_PromotionCashUsed] UNIQUE ([CustomerId],[PromotionRequestId])
);
```

| Column                | Type             | Null | Default | Description     |
|-----------------------|------------------|------|---------|----------------|
| Id                    | BIGINT (IDENTITY)| NO   |         | Primary Key     |
| WebId                 | INT              | NO   |         |                |
| CustomerId            | INT              | NO   |         |                |
| PromotionRequestId    | INT              | NO   | 0       | Unique          |
| Username              | NVARCHAR(50)     | NO   |         |                |
| Currency              | NVARCHAR(3)      | YES  |         |                |
| SBPlayerCashUsed      | DECIMAL(19,6)    | YES  | 0       |                |
| LCPlayerCashUsed      | DECIMAL(19,6)    | NO   | 0       |                |
| GMPlayerCashUsed      | DECIMAL(19,6)    | NO   | 0       |                |
| ModifiedBy            | NVARCHAR(50)     | YES  |         |                |
| ModifiedOn            | DATETIME         | YES  |         |                |
| LastOrderOn           | DATETIME         | YES  |         |                |

- **Primary Key:** `Id`
- **Unique Constraint:** `UQ_PromotionCashUsed` on (`CustomerId`, `PromotionRequestId`)
- **Indexes:**
  - `IX_PromotionCashUsed_vPlayerBalance_CustomerId` on `WebId`, `CustomerId`, `PromotionRequestId` (includes several columns)
- **No foreign keys defined.**

---

## PlayerTagSettings

```sql
CREATE TABLE [dbo].[PlayerTagSettings]
(
    [Id]  INT PRIMARY KEY IDENTITY (1, 1) NOT NULL,
    [WebId] INT NOT NULL,
    [Name] NVARCHAR(50) NOT NULL,
    [Description] NVARCHAR(MAX) NOT NULL,
    [Status] NVARCHAR(50) NOT NULL,
    [Color] NVARCHAR(50) NOT NULL,
    [Priority] INT NOT NULL,
    [CreatedOn]  DATETIME NOT NULL,
    [ModifiedBy] NVARCHAR (50) NOT NULL,
    [ModifiedOn] DATETIME NOT NULL,
    [CanBeDelete] BIT DEFAULT (0) NOT NULL,
    CONSTRAINT CK_PlayerTagSettings_Status CHECK ([Status] IN ('Enabled','Disabled','Deleted')),
    CONSTRAINT [UQ_PlayerTagSettings_WebId_Name] UNIQUE ([WebId], [Name])
)
```

| Column      | Type           | Null | Default | Description     |
|-------------|----------------|------|---------|----------------|
| Id          | INT (IDENTITY) | NO   |         | Primary Key     |
| WebId       | INT            | NO   |         |                 |
| Name        | NVARCHAR(50)   | NO   |         |                 |
| Description | NVARCHAR(MAX)  | NO   |         |                 |
| Status      | NVARCHAR(50)   | NO   |         | CHECK constraint|
| Color       | NVARCHAR(50)   | NO   |         |                 |
| Priority    | INT            | NO   |         |                 |
| CreatedOn   | DATETIME       | NO   |         |                 |
| ModifiedBy  | NVARCHAR(50)   | NO   |         |                 |
| ModifiedOn  | DATETIME       | NO   |         |                 |
| CanBeDelete | BIT            | NO   | 0       |                 |

- **Primary Key:** `Id`
- **Unique Constraint:** `UQ_PlayerTagSettings_WebId_Name` on (`WebId`, `Name`)
- **Check Constraint:** `CK_PlayerTagSettings_Status` on `Status` (must be 'Enabled', 'Disabled', or 'Deleted')
- **No foreign keys or indexes defined.**

---

## PromotionDailyCommissionSettings

```sql
CREATE TABLE [dbo].[PromotionDailyCommissionSettings]
(
	[WebId]             INT NOT NULL,
	[PromotionId]       INT NOT NULL,
	[ProductType]       INT NOT NULL,
	[GameProviderId]    INT NOT NULL,
	[Percentage]        DECIMAL(5,4) NOT NULL,
	[ModifiedBy]        NVARCHAR(50) NOT NULL,
	[ModifiedOn]        DATETIME CONSTRAINT [DF_PromotionDailyCommissionSettings_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
)
```

| Column         | Type         | Null | Default    | Description     |
|----------------|--------------|------|------------|----------------|
| WebId          | INT          | NO   |            |                |
| PromotionId    | INT          | NO   |            |                |
| ProductType    | INT          | NO   |            |                |
| GameProviderId | INT          | NO   |            |                |
| Percentage     | DECIMAL(5,4) | NO   |            |                |
| ModifiedBy     | NVARCHAR(50) | NO   |            |                |
| ModifiedOn     | DATETIME     | NO   | GETDATE()  |                |

- **Primary Key:** Not explicitly defined in the SQL.
- **No foreign keys, unique constraints, or indexes defined.**

---

## SbCashPlayerPresetBetSetting

```sql
CREATE TABLE [dbo].[SbCashPlayerPresetBetSetting]
(
    [WebId] INT NOT NULL,
    [Currency] CHAR(3) CONSTRAINT [DF_SbCashPlayerPresetBetSetting_Currency] DEFAULT ('') NOT NULL,
    [SportId] INT NOT NULL,
    [BetType] INT NOT NULL,
    [MinBet] DECIMAL(18,2) NOT NULL,
    [MaxBet] DECIMAL(18,2) NOT NULL,
    [MaxPerMatch] DECIMAL(18,2) NOT NULL,
    [Remark] NVARCHAR(500) NULL,
    [ModifiedBy] NVARCHAR(50) NOT NULL,
    [ModifiedOn] DATETIME CONSTRAINT [DF_SbCashPlayerPresetBetSetting_ModifiedOn] DEFAULT (GETDATE()) NOT NULL
    CONSTRAINT [PK_SbCashPlayerPresetBetSetting] PRIMARY KEY NONCLUSTERED ([WebId],[Currency],[SportId],[BetType]) WITH (FILLFACTOR = 85)
)
```

| Column        | Type           | Null | Default | Description                  |
|---------------|----------------|------|---------|------------------------------|
| WebId         | INT            | NO   |         | Primary Key (composite)      |
| Currency      | CHAR(3)        | NO   | ''      | Primary Key (composite)      |
| SportId       | INT            | NO   |         | Primary Key (composite)      |
| BetType       | INT            | NO   |         | Primary Key (composite)      |
| MinBet        | DECIMAL(18,2)  | NO   |         |                              |
| MaxBet        | DECIMAL(18,2)  | NO   |         |                              |
| MaxPerMatch   | DECIMAL(18,2)  | NO   |         |                              |
| Remark        | NVARCHAR(500)  | YES  |         |                              |
| ModifiedBy    | NVARCHAR(50)   | NO   |         |                              |
| ModifiedOn    | DATETIME       | NO   | GETDATE()|                             |

- **Primary Key:** `WebId`, `Currency`, `SportId`, `BetType` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## SbPlayerBetSettingDefault

```sql
CREATE TABLE [dbo].[SbPlayerBetSettingDefault]
(
    [SportId]   INT NOT NULL,
    [BetType]   INT NOT NULL,
    [MinBet]    DECIMAL(19,6) NOT NULL,
    [MaxBet]    DECIMAL(19,6) NOT NULL,
    [MaxPerMatch] DECIMAL(19,6) NOT NULL
)
```

| Column        | Type           | Null | Default | Description     |
|---------------|----------------|------|---------|----------------|
| SportId       | INT            | NO   |         |                |
| BetType       | INT            | NO   |         |                |
| MinBet        | DECIMAL(19,6)  | NO   |         |                |
| MaxBet        | DECIMAL(19,6)  | NO   |         |                |
| MaxPerMatch   | DECIMAL(19,6)  | NO   |         |                |

- **Primary Key:** Not explicitly defined in the SQL.
- **No foreign keys, unique constraints, or indexes defined.**

---

## SbPlayerPTEffective

```sql
CREATE TABLE [dbo].[SbPlayerPTEffective]
(
    [WebId]                     INT NOT NULL,
    [CustomerId]                INT NOT NULL,
    [ParentId]                  INT NOT NULL,
    [AgtId]                     INT NOT NULL,
    [MaId]                      INT NOT NULL,
    [SmaId]                     INT NOT NULL,
    [SsmaId]                    INT NOT NULL,
    [ShId]                      INT NOT NULL,
    [5050mktShPTMin]            DECIMAL(3,2) NOT NULL,
    [5050mktShPTMax]            DECIMAL(3,2) NOT NULL,
    [5050mktShTakeAll]          BIT NOT NULL,
    [5050mktSsmaPTMin]          DECIMAL(3,2) NOT NULL,
    [5050mktSsmaPTMax]          DECIMAL(3,2) NOT NULL,
    [5050mktSsmaTakeAll]        BIT NOT NULL,
    [5050mktSPTMin]             DECIMAL(3,2) NOT NULL,
    [5050mktSPTMax]             DECIMAL(3,2) NOT NULL,
    [5050mktSTakeAll]           BIT NOT NULL,
    [5050mktMPTMin]             DECIMAL(3,2) NOT NULL,
    [5050mktMPTMax]             DECIMAL(3,2) NOT NULL,
    [5050mktMTakeAll]           BIT NOT NULL,
    [5050mktAPTMin]             DECIMAL(3,2) NOT NULL,
    [5050mktAPTMax]             DECIMAL(3,2) NOT NULL,
    [5050mktATakeAll]           BIT NOT NULL,
    [5050mktShPT]               DECIMAL(3,2) NOT NULL,
    [5050mktSsmaPT]             DECIMAL(3,2) NOT NULL,
    [5050mktSPT]                DECIMAL(3,2) NOT NULL,
    [5050mktMPT]                DECIMAL(3,2) NOT NULL,
    [5050mktAPT]                DECIMAL(3,2) NOT NULL,
    [Non5050mktShPTMin]         DECIMAL(3,2) NOT NULL,
    [Non5050mktShPTMax]         DECIMAL(3,2) NOT NULL,
    [Non5050mktShTakeAll]       BIT NOT NULL,
    [Non5050mktSsmaPTMin]       DECIMAL(3,2) NOT NULL,
    [Non5050mktSsmaPTMax]       DECIMAL(3,2) NOT NULL,
    [Non5050mktSsmaTakeAll]     BIT NOT NULL,
    [Non5050mktSPTMin]          DECIMAL(3,2) NOT NULL,
    [Non5050mktSPTMax]          DECIMAL(3,2) NOT NULL,
    [Non5050mktSTakeAll]        BIT NOT NULL,
    [Non5050mktMPTMin]          DECIMAL(3,2) NOT NULL,
    [Non5050mktMPTMax]          DECIMAL(3,2) NOT NULL,
    [Non5050mktMTakeAll]        BIT NOT NULL,
    [Non5050mktAPTMin]          DECIMAL(3,2) NOT NULL,
    [Non5050mktAPTMax]          DECIMAL(3,2) NOT NULL,
    [Non5050mktATakeAll]        BIT NOT NULL,
    [Non5050mktShPT]            DECIMAL(3,2) NOT NULL,
    [Non5050mktSsmaPT]          DECIMAL(3,2) NOT NULL,
    [Non5050mktSPT]             DECIMAL(3,2) NOT NULL,
    [Non5050mktMPT]             DECIMAL(3,2) NOT NULL,
    [Non5050mktAPT]             DECIMAL(3,2) NOT NULL,
    [HDPLivemktShPTMin]         DECIMAL(3,2) NOT NULL,
    [HDPLivemktShPTMax]         DECIMAL(3,2) NOT NULL,
    [HDPLivemktShTakeAll]       BIT NOT NULL,
    [HDPLivemktSsmaPTMin]       DECIMAL(3,2) NOT NULL,
    [HDPLivemktSsmaPTMax]       DECIMAL(3,2) NOT NULL,
    [HDPLivemktSsmaTakeAll]     BIT NOT NULL,
    [HDPLivemktSPTMin]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktSPTMax]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktSTakeAll]        BIT NOT NULL,
    [HDPLivemktMPTMin]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktMPTMax]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktMTakeAll]        BIT NOT NULL,
    [HDPLivemktAPTMin]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktAPTMax]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktATakeAll]        BIT NOT NULL,
    [HDPLivemktShPT]            DECIMAL(3,2) NOT NULL,
    [HDPLivemktSsmaPT]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktSPT]             DECIMAL(3,2) NOT NULL,
    [HDPLivemktMPT]             DECIMAL(3,2) NOT NULL,
    [HDPLivemktAPT]             DECIMAL(3,2) NOT NULL,
    [OULivemktShPTMin]          DECIMAL(3,2) NOT NULL,
    [OULivemktShPTMax]          DECIMAL(3,2) NOT NULL,
    [OULivemktShTakeAll]        BIT NOT NULL,
    [OULivemktSsmaPTMin]        DECIMAL(3,2) NOT NULL,
    [OULivemktSsmaPTMax]        DECIMAL(3,2) NOT NULL,
    [OULivemktSsmaTakeAll]      BIT NOT NULL,
    [OULivemktSPTMin]           DECIMAL(3,2) NOT NULL,
    [OULivemktSPTMax]           DECIMAL(3,2) NOT NULL,
    [OULivemktSTakeAll]         BIT NOT NULL,
    [OULivemktMPTMin]           DECIMAL(3,2) NOT NULL,
    [OULivemktMPTMax]           DECIMAL(3,2) NOT NULL,
    [OULivemktMTakeAll]         BIT NOT NULL,
    [OULivemktAPTMin]           DECIMAL(3,2) NOT NULL,
    [OULivemktAPTMax]           DECIMAL(3,2) NOT NULL,
    [OULivemktATakeAll]         BIT NOT NULL,
    [OULivemktShPT]             DECIMAL(3,2) NOT NULL,
    [OULivemktSsmaPT]           DECIMAL(3,2) NOT NULL,
    [OULivemktSPT]              DECIMAL(3,2) NOT NULL,
    [OULivemktMPT]              DECIMAL(3,2) NOT NULL,
    [OULivemktAPT]              DECIMAL(3,2) NOT NULL,
    [ORmktShPTMin]              DECIMAL(3,2) NOT NULL,
    [ORmktShPTMax]              DECIMAL(3,2) NOT NULL,
    [ORmktShTakeAll]            BIT NOT NULL,
    [ORmktSsmaPTMin]            DECIMAL(3,2) NOT NULL,
    [ORmktSsmaPTMax]            DECIMAL(3,2) NOT NULL,
    [ORmktSsmaTakeAll]          BIT NOT NULL,
    [ORmktSPTMin]               DECIMAL(3,2) NOT NULL,
    [ORmktSPTMax]               DECIMAL(3,2) NOT NULL,
    [ORmktSTakeAll]             BIT NOT NULL,
    [ORmktMPTMin]               DECIMAL(3,2) NOT NULL,
    [ORmktMPTMax]               DECIMAL(3,2) NOT NULL,
    [ORmktMTakeAll]             BIT NOT NULL,
    [ORmktAPTMin]               DECIMAL(3,2) NOT NULL,
    [ORmktAPTMax]               DECIMAL(3,2) NOT NULL,
    [ORmktATakeAll]             BIT NOT NULL,
    [ORmktShPT]                 DECIMAL(3,2) NOT NULL,
    [ORmktSsmaPT]               DECIMAL(3,2) NOT NULL,
    [ORmktSPT]                  DECIMAL(3,2) NOT NULL,
    [ORmktMPT]                  DECIMAL(3,2) NOT NULL,
    [ORmktAPT]                  DECIMAL(3,2) NOT NULL,
    [ModifiedOn]                DATETIME CONSTRAINT [DF_SbPlayerPTEffective_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    [tstamp]                    timestamp,
    CONSTRAINT [PK_SbPlayerPTEffective] PRIMARY KEY CLUSTERED ([WebId],[CustomerId]) WITH (FILLFACTOR = 85)
)
```

| Column                | Type           | Null | Default    | Description                |
|-----------------------|----------------|------|------------|----------------------------|
| WebId                 | INT            | NO   |            | Primary Key (composite)    |
| CustomerId            | INT            | NO   |            | Primary Key (composite)    |
| ParentId              | INT            | NO   |            |                            |
| AgtId                 | INT            | NO   |            |                            |
| MaId                  | INT            | NO   |            |                            |
| SmaId                 | INT            | NO   |            |                            |
| SsmaId                | INT            | NO   |            |                            |
| ShId                  | INT            | NO   |            |                            |
| ...                   | ...            | ...  | ...        | Many PT columns omitted for brevity |
| ModifiedOn            | DATETIME       | NO   | GETDATE()  |                            |
| tstamp                | timestamp      | NO   |            |                            |

- **Primary Key:** `WebId`, `CustomerId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## StreamerGivenBetCount

```sql
CREATE TABLE [dbo].[StreamerGivenBetCount]
(
    [Id] INT IDENTITY (1, 1) NOT NULL, 
    [CustomerId] INT NOT NULL, 
    [WebId] INT NOT NULL, 
    [Username] NVARCHAR(50) NOT NULL, 
    [GivenBetCount] INT NOT NULL, 
    [UsedBetCount] INT NOT NULL, 
    [GivenBudget] Decimal(19,6) NOT NULL DEFAULT(0),
    [RemainingBudget] Decimal(19,6) NOT NULL DEFAULT(0),
    [CreatedOn] DATETIME NOT NULL DEFAULT (getdate()), 
    [ModifiedOn] DATETIME NOT NULL DEFAULT (getdate())
)
```

| Column           | Type            | Null | Default    | Description     |
|------------------|-----------------|------|------------|----------------|
| Id               | INT (IDENTITY)  | NO   |            | Primary Key     |
| CustomerId       | INT             | NO   |            |                |
| WebId            | INT             | NO   |            |                |
| Username         | NVARCHAR(50)    | NO   |            |                |
| GivenBetCount    | INT             | NO   |            |                |
| UsedBetCount     | INT             | NO   |            |                |
| GivenBudget      | Decimal(19,6)   | NO   | 0          |                |
| RemainingBudget  | Decimal(19,6)   | NO   | 0          |                |
| CreatedOn        | DATETIME        | NO   | getdate()  |                |
| ModifiedOn       | DATETIME        | NO   | getdate()  |                |

- **Primary Key:** `Id` (implied by IDENTITY and usage)
- **No foreign keys, unique constraints, or indexes defined.**

---

## TsbPlayerDiscount

```sql
CREATE TABLE [dbo].[TsbPlayerDiscount]
(
    [WebId]                 INT NOT NULL,
    [CustomerId]            INT NOT NULL,
    [GameProviderId]        INT NOT NULL,
    [ParentId]              INT NOT NULL,
    [AgtId]                 INT NOT NULL,
    [MaId]                  INT NOT NULL,
    [SmaId]                 INT NOT NULL,
    [SsmaId]                INT NOT NULL,
    [ShId]                  INT NOT NULL,
    [PlayerDiscount]        DECIMAL(5,4) NOT NULL,
    [AgtDiscount]           DECIMAL(5,4) NOT NULL,
    [MaDiscount]            DECIMAL(5,4) NOT NULL,
    [SmaDiscount]           DECIMAL(5,4) NOT NULL,
    [SsmaDiscount]          DECIMAL(5,4) NOT NULL,
    [ShDiscount]            DECIMAL(5,4) NOT NULL,
    [PlayerDiscount1X2]     DECIMAL(5,4) NOT NULL,
    [AgtDiscount1X2]        DECIMAL(5,4) NOT NULL,
    [MaDiscount1X2]         DECIMAL(5,4) NOT NULL,
    [SmaDiscount1X2]        DECIMAL(5,4) NOT NULL,
    [SsmaDiscount1X2]       DECIMAL(5,4) NOT NULL,
    [ShDiscount1X2]         DECIMAL(5,4) NOT NULL,
    [PlayerDiscountOther]   DECIMAL(5,4) NOT NULL,
    [AgtDiscountOther]      DECIMAL(5,4) NOT NULL,
    [MaDiscountOther]       DECIMAL(5,4) NOT NULL,
    [SmaDiscountOther]      DECIMAL(5,4) NOT NULL,
    [SsmaDiscountOther]     DECIMAL(5,4) NOT NULL,
    [ShDiscountOther]       DECIMAL(5,4) NOT NULL,
    [ModifiedOn]            DATETIME CONSTRAINT [DF_TsbPlayerDiscount_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    [ModifiedBy]            NVARCHAR(50),
    CONSTRAINT [PK_TsbPlayerDiscount] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[GameProviderId]) WITH (FILLFACTOR = 85)
)
```

| Column                | Type           | Null | Default    | Description                  |
|-----------------------|----------------|------|------------|------------------------------|
| WebId                 | INT            | NO   |            | Primary Key (composite)      |
| CustomerId            | INT            | NO   |            | Primary Key (composite)      |
| GameProviderId        | INT            | NO   |            | Primary Key (composite)      |
| ParentId              | INT            | NO   |            |                              |
| AgtId                 | INT            | NO   |            |                              |
| MaId                  | INT            | NO   |            |                              |
| SmaId                 | INT            | NO   |            |                              |
| SsmaId                | INT            | NO   |            |                              |
| ShId                  | INT            | NO   |            |                              |
| PlayerDiscount        | DECIMAL(5,4)   | NO   |            |                              |
| AgtDiscount           | DECIMAL(5,4)   | NO   |            |                              |
| MaDiscount            | DECIMAL(5,4)   | NO   |            |                              |
| SmaDiscount           | DECIMAL(5,4)   | NO   |            |                              |
| SsmaDiscount          | DECIMAL(5,4)   | NO   |            |                              |
| ShDiscount            | DECIMAL(5,4)   | NO   |            |                              |
| PlayerDiscount1X2     | DECIMAL(5,4)   | NO   |            |                              |
| AgtDiscount1X2        | DECIMAL(5,4)   | NO   |            |                              |
| MaDiscount1X2         | DECIMAL(5,4)   | NO   |            |                              |
| SmaDiscount1X2        | DECIMAL(5,4)   | NO   |            |                              |
| SsmaDiscount1X2       | DECIMAL(5,4)   | NO   |            |                              |
| ShDiscount1X2         | DECIMAL(5,4)   | NO   |            |                              |
| PlayerDiscountOther   | DECIMAL(5,4)   | NO   |            |                              |
| AgtDiscountOther      | DECIMAL(5,4)   | NO   |            |                              |
| MaDiscountOther       | DECIMAL(5,4)   | NO   |            |                              |
| SmaDiscountOther      | DECIMAL(5,4)   | NO   |            |                              |
| SsmaDiscountOther     | DECIMAL(5,4)   | NO   |            |                              |
| ShDiscountOther       | DECIMAL(5,4)   | NO   |            |                              |
| ModifiedOn            | DATETIME       | NO   | GETDATE()  |                              |
| ModifiedBy            | NVARCHAR(50)   | YES  |            |                              |

- **Primary Key:** `WebId`, `CustomerId`, `GameProviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## TsbPlayerPTEffective

```sql
CREATE TABLE [dbo].[TsbPlayerPTEffective]
(
    [WebId]                     INT NOT NULL,
    [CustomerId]                INT NOT NULL,
    [GameproviderId]            INT NOT NULL,
    [ParentId]                  INT NOT NULL,
    [AgtId]                     INT NOT NULL,
    [MaId]                      INT NOT NULL,
    [SmaId]                     INT NOT NULL,
    [SsmaId]                    INT NOT NULL,
    [ShId]                      INT NOT NULL,
    [5050mktShPTMin]            DECIMAL(3,2) NOT NULL,
    [5050mktShPTMax]            DECIMAL(3,2) NOT NULL,
    [5050mktShTakeAll]          BIT NOT NULL,
    [5050mktSsmaPTMin]          DECIMAL(3,2) NOT NULL,
    [5050mktSsmaPTMax]          DECIMAL(3,2) NOT NULL,
    [5050mktSsmaTakeAll]        BIT NOT NULL,
    [5050mktSPTMin]             DECIMAL(3,2) NOT NULL,
    [5050mktSPTMax]             DECIMAL(3,2) NOT NULL,
    [5050mktSTakeAll]           BIT NOT NULL,
    [5050mktMPTMin]             DECIMAL(3,2) NOT NULL,
    [5050mktMPTMax]             DECIMAL(3,2) NOT NULL,
    [5050mktMTakeAll]           BIT NOT NULL,
    [5050mktAPTMin]             DECIMAL(3,2) NOT NULL,
    [5050mktAPTMax]             DECIMAL(3,2) NOT NULL,
    [5050mktATakeAll]           BIT NOT NULL,
    [5050mktShPT]               DECIMAL(3,2) NOT NULL,
    [5050mktSsmaPT]             DECIMAL(3,2) NOT NULL,
    [5050mktSPT]                DECIMAL(3,2) NOT NULL,
    [5050mktMPT]                DECIMAL(3,2) NOT NULL,
    [5050mktAPT]                DECIMAL(3,2) NOT NULL,
    [Non5050mktShPTMin]         DECIMAL(3,2) NOT NULL,
    [Non5050mktShPTMax]         DECIMAL(3,2) NOT NULL,
    [Non5050mktShTakeAll]       BIT NOT NULL,
    [Non5050mktSsmaPTMin]       DECIMAL(3,2) NOT NULL,
    [Non5050mktSsmaPTMax]       DECIMAL(3,2) NOT NULL,
    [Non5050mktSsmaTakeAll]     BIT NOT NULL,
    [Non5050mktSPTMin]          DECIMAL(3,2) NOT NULL,
    [Non5050mktSPTMax]          DECIMAL(3,2) NOT NULL,
    [Non5050mktSTakeAll]        BIT NOT NULL,
    [Non5050mktMPTMin]          DECIMAL(3,2) NOT NULL,
    [Non5050mktMPTMax]          DECIMAL(3,2) NOT NULL,
    [Non5050mktMTakeAll]        BIT NOT NULL,
    [Non5050mktAPTMin]          DECIMAL(3,2) NOT NULL,
    [Non5050mktAPTMax]          DECIMAL(3,2) NOT NULL,
    [Non5050mktATakeAll]        BIT NOT NULL,
    [Non5050mktShPT]            DECIMAL(3,2) NOT NULL,
    [Non5050mktSsmaPT]          DECIMAL(3,2) NOT NULL,
    [Non5050mktSPT]             DECIMAL(3,2) NOT NULL,
    [Non5050mktMPT]             DECIMAL(3,2) NOT NULL,
    [Non5050mktAPT]             DECIMAL(3,2) NOT NULL,
    [HDPLivemktShPTMin]         DECIMAL(3,2) NOT NULL,
    [HDPLivemktShPTMax]         DECIMAL(3,2) NOT NULL,
    [HDPLivemktShTakeAll]       BIT NOT NULL,
    [HDPLivemktSsmaPTMin]       DECIMAL(3,2) NOT NULL,
    [HDPLivemktSsmaPTMax]       DECIMAL(3,2) NOT NULL,
    [HDPLivemktSsmaTakeAll]     BIT NOT NULL,
    [HDPLivemktSPTMin]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktSPTMax]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktSTakeAll]        BIT NOT NULL,
    [HDPLivemktMPTMin]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktMPTMax]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktMTakeAll]        BIT NOT NULL,
    [HDPLivemktAPTMin]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktAPTMax]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktATakeAll]        BIT NOT NULL,
    [HDPLivemktShPT]            DECIMAL(3,2) NOT NULL,
    [HDPLivemktSsmaPT]          DECIMAL(3,2) NOT NULL,
    [HDPLivemktSPT]             DECIMAL(3,2) NOT NULL,
    [HDPLivemktMPT]             DECIMAL(3,2) NOT NULL,
    [HDPLivemktAPT]             DECIMAL(3,2) NOT NULL,
    [OULivemktShPTMin]          DECIMAL(3,2) NOT NULL,
    [OULivemktShPTMax]          DECIMAL(3,2) NOT NULL,
    [OULivemktShTakeAll]        BIT NOT NULL,
    [OULivemktSsmaPTMin]        DECIMAL(3,2) NOT NULL,
    [OULivemktSsmaPTMax]        DECIMAL(3,2) NOT NULL,
    [OULivemktSsmaTakeAll]      BIT NOT NULL,
    [OULivemktSPTMin]           DECIMAL(3,2) NOT NULL,
    [OULivemktSPTMax]           DECIMAL(3,2) NOT NULL,
    [OULivemktSTakeAll]         BIT NOT NULL,
    [OULivemktMPTMin]           DECIMAL(3,2) NOT NULL,
    [OULivemktMPTMax]           DECIMAL(3,2) NOT NULL,
    [OULivemktMTakeAll]         BIT NOT NULL,
    [OULivemktAPTMin]           DECIMAL(3,2) NOT NULL,
    [OULivemktAPTMax]           DECIMAL(3,2) NOT NULL,
    [OULivemktATakeAll]         BIT NOT NULL,
    [OULivemktShPT]             DECIMAL(3,2) NOT NULL,
    [OULivemktSsmaPT]           DECIMAL(3,2) NOT NULL,
    [OULivemktSPT]              DECIMAL(3,2) NOT NULL,
    [OULivemktMPT]              DECIMAL(3,2) NOT NULL,
    [OULivemktAPT]              DECIMAL(3,2) NOT NULL,
    [ORmktShPTMin]              DECIMAL(3,2) NOT NULL,
    [ORmktShPTMax]              DECIMAL(3,2) NOT NULL,
    [ORmktShTakeAll]            BIT NOT NULL,
    [ORmktSsmaPTMin]            DECIMAL(3,2) NOT NULL,
    [ORmktSsmaPTMax]            DECIMAL(3,2) NOT NULL,
    [ORmktSsmaTakeAll]          BIT NOT NULL,
    [ORmktSPTMin]               DECIMAL(3,2) NOT NULL,
    [ORmktSPTMax]               DECIMAL(3,2) NOT NULL,
    [ORmktSTakeAll]             BIT NOT NULL,
    [ORmktMPTMin]               DECIMAL(3,2) NOT NULL,
    [ORmktMPTMax]               DECIMAL(3,2) NOT NULL,
    [ORmktMTakeAll]             BIT NOT NULL,
    [ORmktAPTMin]               DECIMAL(3,2) NOT NULL,
    [ORmktAPTMax]               DECIMAL(3,2) NOT NULL,
    [ORmktATakeAll]             BIT NOT NULL,
    [ORmktShPT]                 DECIMAL(3,2) NOT NULL,
    [ORmktSsmaPT]               DECIMAL(3,2) NOT NULL,
    [ORmktSPT]                  DECIMAL(3,2) NOT NULL,
    [ORmktMPT]                  DECIMAL(3,2) NOT NULL,
    [ORmktAPT]                  DECIMAL(3,2) NOT NULL,
    [ModifiedOn]                DATETIME CONSTRAINT [DF_TsbPlayerPTEffective_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    [tstamp]                    timestamp,
    CONSTRAINT [PK_TsbPlayerPTEffective] PRIMARY KEY CLUSTERED ([WebId],[CustomerId],[GameproviderId]) WITH (FILLFACTOR = 85)
)
```

| Column                | Type           | Null | Default    | Description                  |
|-----------------------|----------------|------|------------|------------------------------|
| WebId                 | INT            | NO   |            | Primary Key (composite)      |
| CustomerId            | INT            | NO   |            | Primary Key (composite)      |
| GameproviderId        | INT            | NO   |            | Primary Key (composite)      |
| ParentId              | INT            | NO   |            |                              |
| AgtId                 | INT            | NO   |            |                              |
| MaId                  | INT            | NO   |            |                              |
| SmaId                 | INT            | NO   |            |                              |
| SsmaId                | INT            | NO   |            |                              |
| ShId                  | INT            | NO   |            |                              |
| ...                   | ...            | ...  | ...        | Many PT columns omitted for brevity |
| ModifiedOn            | DATETIME       | NO   | GETDATE()  |                              |
| tstamp                | timestamp      | NO   |            |                              |

- **Primary Key:** `WebId`, `CustomerId`, `GameproviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## TsbAgentDiscount

```sql
CREATE TABLE [dbo].[TsbAgentDiscount]
(
    [WebId]             INT NOT NULL,
    [GameproviderId]    INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [ParentId]          INT NOT NULL,
    [DiscountGroupA]    DECIMAL(5,4) NOT NULL,
    [DiscountGroupB]    DECIMAL(5,4) NOT NULL,
    [DiscountGroupC]    DECIMAL(5,4) NOT NULL,
    [DiscountGroupD]    DECIMAL(5,4) NOT NULL DEFAULT(0),
    [DiscountGroupE]    DECIMAL(5,4) NOT NULL DEFAULT(0),
    [DiscountGroupF]    DECIMAL(5,4) NOT NULL DEFAULT(0),
    [DiscountOther]     DECIMAL(5,4) NOT NULL,
    [Discount1X2]       DECIMAL(5,4) NOT NULL,
    [ModifiedBy]        NVARCHAR(50) NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_TsbAgentDiscount_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_TsbAgentDiscount] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[GameProviderId]) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default | Description                  |
|------------------|--------------|------|---------|------------------------------|
| WebId            | INT          | NO   |         | Primary Key (composite)      |
| GameproviderId   | INT          | NO   |         | Primary Key (composite)      |
| CustomerId       | INT          | NO   |         | Primary Key (composite)      |
| ParentId         | INT          | NO   |         |                              |
| DiscountGroupA   | DECIMAL(5,4) | NO   |         |                              |
| DiscountGroupB   | DECIMAL(5,4) | NO   |         |                              |
| DiscountGroupC   | DECIMAL(5,4) | NO   |         |                              |
| DiscountGroupD   | DECIMAL(5,4) | NO   | 0       |                              |
| DiscountGroupE   | DECIMAL(5,4) | NO   | 0       |                              |
| DiscountGroupF   | DECIMAL(5,4) | NO   | 0       |                              |
| DiscountOther    | DECIMAL(5,4) | NO   |         |                              |
| Discount1X2      | DECIMAL(5,4) | NO   |         |                              |
| ModifiedBy       | NVARCHAR(50) | NO   |         |                              |
| ModifiedOn       | DATETIME     | NO   | GETDATE()|                             |

- **Primary Key:** `WebId`, `CustomerId`, `GameproviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## TsbAgentPTPreset

```sql
CREATE TABLE [dbo].[TsbAgentPTPreset]
(
    [WebId]             INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [ParentId]          INT NOT NULL,
    [GameproviderId]    INT NOT NULL,
    [AccountType]       INT NOT NULL,
    [5050mktPTMin]      DECIMAL(3,2) NOT NULL,
    [5050mktPTMax]      DECIMAL(3,2) NOT NULL,
    [5050mktTakeAll]    BIT,
    [non5050mktPTMin]   DECIMAL(3,2) NOT NULL,
    [non5050mktPTMax]   DECIMAL(3,2) NOT NULL,
    [non5050mktPTTakeAll] BIT NOT NULL,
    [HDPLiveMktPTMin]   DECIMAL(3,2) NOT NULL,
    [HDPLiveMktPTMax]   DECIMAL(3,2) NOT NULL,
    [HDPLiveMktPTTakeAll] BIT NOT NULL,
    [OULiveMktPTMin]    DECIMAL(3,2) NOT NULL,
    [OULiveMktPTMax]    DECIMAL(3,2) NOT NULL,
    [OULiveMktPTTakeAll] BIT NOT NULL,
    [OrMktPTMin]        DECIMAL(3,2) NOT NULL,
    [OrMktPTMax]        DECIMAL(3,2) NOT NULL,
    [OrMktPTTakeAll]    BIT NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_TsbAgentPTPreset_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    [ModifiedBy]        NVARCHAR(50) NOT NULL DEFAULT '',
    CONSTRAINT [PK_TsbAgentPTPreset] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[GameproviderId]) WITH (FILLFACTOR = 85)
)
```

| Column             | Type         | Null | Default    | Description                  |
|--------------------|--------------|------|------------|------------------------------|
| WebId              | INT          | NO   |            | Primary Key (composite)      |
| CustomerId         | INT          | NO   |            | Primary Key (composite)      |
| ParentId           | INT          | NO   |            |                              |
| GameproviderId     | INT          | NO   |            | Primary Key (composite)      |
| AccountType        | INT          | NO   |            |                              |
| 5050mktPTMin       | DECIMAL(3,2) | NO   |            |                              |
| 5050mktPTMax       | DECIMAL(3,2) | NO   |            |                              |
| 5050mktTakeAll     | BIT          | YES  |            |                              |
| non5050mktPTMin    | DECIMAL(3,2) | NO   |            |                              |
| non5050mktPTMax    | DECIMAL(3,2) | NO   |            |                              |
| non5050mktPTTakeAll| BIT          | NO   |            |                              |
| HDPLiveMktPTMin    | DECIMAL(3,2) | NO   |            |                              |
| HDPLiveMktPTMax    | DECIMAL(3,2) | NO   |            |                              |
| HDPLiveMktPTTakeAll| BIT          | NO   |            |                              |
| OULiveMktPTMin     | DECIMAL(3,2) | NO   |            |                              |
| OULiveMktPTMax     | DECIMAL(3,2) | NO   |            |                              |
| OULiveMktPTTakeAll | BIT          | NO   |            |                              |
| OrMktPTMin         | DECIMAL(3,2) | NO   |            |                              |
| OrMktPTMax         | DECIMAL(3,2) | NO   |            |                              |
| OrMktPTTakeAll     | BIT          | NO   |            |                              |
| ModifiedOn         | DATETIME     | NO   | GETDATE()  |                              |
| ModifiedBy         | NVARCHAR(50) | NO   | ''         |                              |

- **Primary Key:** `WebId`, `CustomerId`, `GameproviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## WithdrawalLimitAction

```sql
CREATE TABLE [dbo].[WithdrawalLimitAction]
(
    [Id] INT IDENTITY(1,1) PRIMARY KEY,
    [WebId] INT,
    [CustomerId] INT,
    [Action] NVARCHAR(50),
    [ActionDataInJson] NVARCHAR(MAX),
    [CreatedOn] DATETIME,
    [ProceedOn] DATETIME,
    [IsProceed] BIT,
    [IsNeedToProceedAfterValidate] BIT,
    [IsActionFromBo] BIT,
)
```

| Column                         | Type         | Null | Default | Description     |
|--------------------------------|--------------|------|---------|----------------|
| Id                             | INT (IDENTITY)| NO  |         | Primary Key     |
| WebId                          | INT          | YES  |         |                |
| CustomerId                     | INT          | YES  |         |                |
| Action                         | NVARCHAR(50) | YES  |         |                |
| ActionDataInJson               | NVARCHAR(MAX)| YES  |         |                |
| CreatedOn                      | DATETIME     | YES  |         |                |
| ProceedOn                      | DATETIME     | YES  |         |                |
| IsProceed                      | BIT          | YES  |         |                |
| IsNeedToProceedAfterValidate   | BIT          | YES  |         |                |
| IsActionFromBo                 | BIT          | YES  |         |                |

- **Primary Key:** `Id`
- **Indexes:**
  - `WithdrawalLimitAction_GetWithdrawalLimit` on `WebId`, `CustomerId`, `IsProceed`, `IsActionFromBo`
  - `IX_GetPendingWithdrawalLimitActions` on `IsProceed` (includes `Id`, `Action`, `ActionDataInJson`)
- **No foreign keys, unique constraints defined.**

---

## StockAccountRelation

```sql
CREATE TABLE [dbo].[StockAccountRelation]
(
    [Id]                BIGINT IDENTITY(1,1) NOT NULL,
    [WebId]             INT NOT NULL,
    [AncestorId]        INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [AccountType]       INT NOT NULL,
    [ProductType]       INT NOT NULL,
    [GameproviderId]    INT NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_EffectiveStockHolding_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_StockAccountRelation] PRIMARY KEY NONCLUSTERED (Id) WITH (FILLFACTOR = 85),
    CONSTRAINT [UQ_StockAccountRelation] UNIQUE ([WebId],[AncestorID],[CustomerId],[ProductType],[GameproviderId]) WITH (FILLFACTOR = 85)
)
```

| Column         | Type    | Null | Default    | Description                  |
|----------------|---------|------|------------|------------------------------|
| Id             | BIGINT  | NO   |            | Primary Key                  |
| WebId          | INT     | NO   |            |                              |
| AncestorId     | INT     | NO   |            |                              |
| CustomerId     | INT     | NO   |            |                              |
| AccountType    | INT     | NO   |            |                              |
| ProductType    | INT     | NO   |            |                              |
| GameproviderId | INT     | NO   |            |                              |
| ModifiedOn     | DATETIME| NO   | GETDATE()  |                              |

- **Primary Key:** `Id`
- **Unique Constraint:** `UQ_StockAccountRelation` on (`WebId`, `AncestorID`, `CustomerId`, `ProductType`, `GameproviderId`)
- **Indexes:**
  - `IX_StockAccountRelation_Webid_AncestorID_CustomerId` on `WebId`, `AncestorId`, `CustomerId` (includes `AccountType`)
- **No foreign keys defined.**

---

## StockAgentRebatePercentage

```sql
CREATE TABLE [dbo].[StockAgentRebatePercentage]
(
    [WebId]             INT NOT NULL,
    [StockHolderId]     INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [PoolId]            INT NOT NULL,
    [Percentage]        decimal(19,6) NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_StockAgentRebatePercentage_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_StockAgentRebatePercentage] PRIMARY KEY NONCLUSTERED ([WebId],[StockHolderId],[CustomerId],[PoolId]) WITH (FILLFACTOR = 85)
)
```

| Column         | Type         | Null | Default    | Description                  |
|----------------|--------------|------|------------|------------------------------|
| WebId          | INT          | NO   |            | Primary Key (composite)      |
| StockHolderId  | INT          | NO   |            | Primary Key (composite)      |
| CustomerId     | INT          | NO   |            | Primary Key (composite)      |
| PoolId         | INT          | NO   |            | Primary Key (composite)      |
| Percentage     | DECIMAL(19,6)| NO   |            |                              |
| ModifiedOn     | DATETIME     | NO   | GETDATE()  |                              |

- **Primary Key:** `WebId`, `StockHolderId`, `CustomerId`, `PoolId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## StockCompanyDailyExpense

```sql
CREATE TABLE [dbo].[StockCompanyDailyExpense]
(
    [WebId]             INT NOT NULL,
    [ProductType]       INT NOT NULL,
    [GameProviderId]    INT NOT NULL,
    [ExpenseDate]       DATETIME NOT NULL,
    [Expense]           DECIMAL(18,6),
    [ModifiedOn]        DATETIME NOT NULL,
    [Remark]            NVARCHAR(300) NULL,
    CONSTRAINT [PK_StockCompanyDailyExpense] PRIMARY KEY NONCLUSTERED ([WebId],[ProductType],[GameproviderId],[ExpenseDate]) WITH (FILLFACTOR = 85)
)
```

| Column         | Type         | Null | Default    | Description                  |
|----------------|--------------|------|------------|------------------------------|
| WebId          | INT          | NO   |            | Primary Key (composite)      |
| ProductType    | INT          | NO   |            | Primary Key (composite)      |
| GameProviderId | INT          | NO   |            | Primary Key (composite)      |
| ExpenseDate    | DATETIME     | NO   |            | Primary Key (composite)      |
| Expense        | DECIMAL(18,6)| YES  |            |                              |
| ModifiedOn     | DATETIME     | NO   |            |                              |
| Remark         | NVARCHAR(300)| YES  |            |                              |

- **Primary Key:** `WebId`, `ProductType`, `GameproviderId`, `ExpenseDate` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## StockHoldingEditRecord

```sql
CREATE TABLE [dbo].[StockHoldingEditRecord]
(
    [Id]                INT NOT NULL IDENTITY(1,1),
    [WebId]             INT NOT NULL,
    [CustomerId]        INT,
    [CurrentStockHolding] INT,
    [ProductType]       INT,
    [GameproviderId]    INT,
    [FutureStockHolding] INT,
    [EffectiveDate]     DATE,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_StockHoldingEditRecord_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    [ModifiedBy]        NVARCHAR(50) NOT NULL,
    CONSTRAINT [PK_StockHoldingEditRecord] PRIMARY KEY CLUSTERED ([Id]) WITH (FILLFACTOR = 85)
)
```

| Column              | Type         | Null | Default    | Description                  |
|---------------------|--------------|------|------------|------------------------------|
| Id                  | INT (IDENTITY)| NO  |            | Primary Key                  |
| WebId               | INT          | NO   |            |                              |
| CustomerId          | INT          | YES  |            |                              |
| CurrentStockHolding | INT          | YES  |            |                              |
| ProductType         | INT          | YES  |            |                              |
| GameproviderId      | INT          | YES  |            |                              |
| FutureStockHolding  | INT          | YES  |            |                              |
| EffectiveDate       | DATE         | YES  |            |                              |
| ModifiedOn          | DATETIME     | NO   | GETDATE()  |                              |
| ModifiedBy          | NVARCHAR(50) | NO   |            |                              |

- **Primary Key:** `Id`
- **No foreign keys, unique constraints, or indexes defined.**

---

## StockHoldingSettings

```sql
CREATE TABLE [dbo].[StockHoldingSettings]
(
    [WebId]             INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [ProductType]       INT NOT NULL,
    [GameproviderId]    INT NOT NULL,
    [StockHolding]      INT NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_PresetStockHolding_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    CONSTRAINT [PK_PresetStockHolding] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[ProductType],[GameproviderId]) WITH (FILLFACTOR = 85)
)
```

| Column         | Type         | Null | Default    | Description                  |
|----------------|--------------|------|------------|------------------------------|
| WebId          | INT          | NO   |            | Primary Key (composite)      |
| CustomerId     | INT          | NO   |            | Primary Key (composite)      |
| ProductType    | INT          | NO   |            | Primary Key (composite)      |
| GameproviderId | INT          | NO   |            | Primary Key (composite)      |
| StockHolding   | INT          | NO   |            |                              |
| ModifiedOn     | DATETIME     | NO   | GETDATE()  |                              |

- **Primary Key:** `WebId`, `CustomerId`, `ProductType`, `GameproviderId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## StockPool

```sql
CREATE TABLE [dbo].[StockPool]
(
    [WebId]             INT NOT NULL,
    [PoolId]            INT NOT NULL,
    [PoolDisplayname]   NVARCHAR(50) NOT NULL,
    [IsNeedToCalculate] BIT CONSTRAINT [DF_StockPool_IsNeedToCalculate] DEFAULT (1) NOT NULL,
    CONSTRAINT [PK_StockPool] PRIMARY KEY NONCLUSTERED ([WebId],[PoolId]) WITH (FILLFACTOR = 85)
)
```

| Column            | Type         | Null | Default    | Description                  |
|-------------------|--------------|------|------------|------------------------------|
| WebId             | INT          | NO   |            | Primary Key (composite)      |
| PoolId            | INT          | NO   |            | Primary Key (composite)      |
| PoolDisplayname   | NVARCHAR(50) | NO   |            |                              |
| IsNeedToCalculate | BIT          | NO   | 1          |                              |

- **Primary Key:** `WebId`, `PoolId` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## StockPoolMap

```sql
CREATE TABLE [dbo].[StockPoolMap]
(
    [Id]                INT Identity(1,1) NOT NULL,
    [WebId]             INT NOT NULL,
    [ProductType]       INT NOT NULL,
    [GameProviderType]  INT NOT NULL,
    [PoolId]            INT NOT NULL,
    CONSTRAINT [PK_StockPoolMap] PRIMARY KEY CLUSTERED ([Id] ASC) WITH (FILLFACTOR = 85)
)
```

| Column           | Type         | Null | Default    | Description                  |
|------------------|--------------|------|------------|------------------------------|
| Id               | INT (IDENTITY)| NO  |            | Primary Key                  |
| WebId            | INT          | NO   |            |                              |
| ProductType      | INT          | NO   |            |                              |
| GameProviderType | INT          | NO   |            |                              |
| PoolId           | INT          | NO   |            |                              |

- **Primary Key:** `Id`
- **No foreign keys, unique constraints, or indexes defined.**

---

## Trans

```sql
CREATE TABLE [dbo].[Trans]
(
    [TransCode] BIGINT NOT NULL
)
```

| Column     | Type   | Null | Default | Description     |
|------------|--------|------|---------|----------------|
| TransCode  | BIGINT | NO   |         |                |

- **Primary Key:** Not explicitly defined in the SQL.
- **No foreign keys, unique constraints, or indexes defined.**

---

## UserActionRecord

```sql
CREATE TABLE [dbo].[UserActionRecord]
(
  [Id]  INT PRIMARY KEY IDENTITY (1, 1) NOT NULL,
  [WebId] INT NOT NULL,
  [CustomerId] INT NOT NULL,
  [Username] NVARCHAR(50),
  [ActionType] NVARCHAR(50),
  [ActionUrl] NVARCHAR(MAX),
  [ActionOn] DATETIME,
  [IP] NVARCHAR(200),
  [FingerPrint] NVARCHAR(MAX)
  CONSTRAINT CK_UserActionRecord_Record CHECK ([ActionType] IN ('Register','Login', 'Deposit', 'Withdraw', 'ApplyPromotion', 'ApplyReferral', 'ForceCompleteWithdrawalLimit'))
)
```

| Column      | Type           | Null | Default | Description     |
|-------------|----------------|------|---------|----------------|
| Id          | INT (IDENTITY) | NO   |         | Primary Key     |
| WebId       | INT            | NO   |         |                |
| CustomerId  | INT            | NO   |         |                |
| Username    | NVARCHAR(50)   | YES  |         |                |
| ActionType  | NVARCHAR(50)   | YES  |         | CHECK constraint|
| ActionUrl   | NVARCHAR(MAX)  | YES  |         |                |
| ActionOn    | DATETIME       | YES  |         |                |
| IP          | NVARCHAR(200)  | YES  |         |                |
| FingerPrint | NVARCHAR(MAX)  | YES  |         |                |

- **Primary Key:** `Id`
- **Check Constraint:** `CK_UserActionRecord_Record` on `ActionType` (see allowed values in SQL)
- **Indexes:**
  - `IX_UserActionRecord_CustomerId` on `WebId`, `CustomerId`, `ActionType` (includes `Id`, `ActionOn`, `IP`, `FingerPrint`)
  - `IX_UserActionRecord_CustomerId_ActionType` on `CustomerId`, `ActionType` (includes `ActionOn`, `IP`)
  - `IX_UserActionRecord_ActionOn` on `WebId`, `Username`, `ActionType` (includes `ActionOn`)
- **No foreign keys, unique constraints defined.**

---

## LiveChatDomain

```sql
CREATE TABLE [dbo].[LiveChatDomain] (
    [WebId]                    INT            NOT NULL,
    [LiveChatDomain]           NVARCHAR (100)  NOT NULL,
    CONSTRAINT [PK_LiveChatDomain] PRIMARY KEY CLUSTERED ([WebId] ASC) WITH (FILLFACTOR = 85)
);
```

| Column          | Type           | Null | Default | Description     |
|-----------------|----------------|------|---------|----------------|
| WebId           | INT            | NO   |         | Primary Key     |
| LiveChatDomain  | NVARCHAR(100)  | NO   |         |                 |

- **Primary Key:** `WebId`
- **No foreign keys, unique constraints, or indexes defined.**

---

## Ref

```sql
CREATE TABLE [dbo].[Ref]
(
    [Refno] BIGINT NOT NULL
)
```

| Column     | Type   | Null | Default | Description     |
|------------|--------|------|---------|----------------|
| Refno      | BIGINT | NO   |         |                |

- **Primary Key:** Not explicitly defined in the SQL.
- **No foreign keys, unique constraints, or indexes defined.**

---

## ReferralRewardReferredNeedToCalculate

```sql
CREATE TABLE [dbo].[ReferralRewardReferredNeedToCalculate] 
  ( 
     [Id]           int IDENTITY(1,1),
     [ReferralId]   INT NOT NULL ,
     [CustomerId]   INT NOT NULL, 
     [ReferralParentId] INT NOT NULL,
     [WebId]        INT NOT NULL,
     [IsReferralCalculated] BIT NOT NULL, 
     [CreatedOn]    DateTime NOT NULL, 
     [ModifiedOn]   DATETIME NOT NULL  
); 
```

| Column               | Type         | Null | Default | Description     |
|----------------------|--------------|------|---------|----------------|
| Id                   | INT (IDENTITY)| NO  |         | Primary Key     |
| ReferralId           | INT          | NO   |         |                |
| CustomerId           | INT          | NO   |         |                |
| ReferralParentId     | INT          | NO   |         |                |
| WebId                | INT          | NO   |         |                |
| IsReferralCalculated | BIT          | NO   |         |                |
| CreatedOn            | DATETIME     | NO   |         |                |
| ModifiedOn           | DATETIME     | NO   |         |                |

- **Primary Key:** `Id` (implied by IDENTITY and usage)
- **No foreign keys, unique constraints, or indexes defined.**

---

## SbPlayerBetSetting

```sql
CREATE TABLE [dbo].[SbPlayerBetSetting]
(
    [WebId]             INT NOT NULL,
    [CustomerId]        INT NOT NULL,
    [SportId]           INT NOT NULL,
    [BetType]           INT NOT NULL,
    [ParentId]          INT NOT NULL,
    [MinBet]            DECIMAL(18,2) NOT NULL,
    [MaxBet]            DECIMAL(18,2) NOT NULL,
    [MaxPerMatch]       DECIMAL(18,2) NOT NULL,
    [Remark]            NVARCHAR(500) NULL,
    [IsCreditDailyAdjustment] BIT DEFAULT (0) NOT NULL,
    [ModifiedBy]        NVARCHAR(50) NOT NULL,
    [ModifiedOn]        DATETIME CONSTRAINT [DF_SbPlayerBetSetting_ModifiedOn] DEFAULT (GETDATE()) NOT NULL,
    [Credit]            DECIMAL(18,2) CONSTRAINT [DF_SbPlayerBetSetting_Credit] DEFAULT (0) NOT NULL,
    CONSTRAINT [PK_SbPlayerBetSetting] PRIMARY KEY NONCLUSTERED ([WebId],[CustomerId],[SportId],[BetType]) WITH (FILLFACTOR = 85)
)
```

| Column                    | Type           | Null | Default | Description                  |
|---------------------------|----------------|------|---------|------------------------------|
| WebId                     | INT            | NO   |         | Primary Key (composite)      |
| CustomerId                | INT            | NO   |         | Primary Key (composite)      |
| SportId                   | INT            | NO   |         | Primary Key (composite)      |
| BetType                   | INT            | NO   |         | Primary Key (composite)      |
| ParentId                  | INT            | NO   |         |                              |
| MinBet                    | DECIMAL(18,2)  | NO   |         |                              |
| MaxBet                    | DECIMAL(18,2)  | NO   |         |                              |
| MaxPerMatch               | DECIMAL(18,2)  | NO   |         |                              |
| Remark                    | NVARCHAR(500)  | YES  |         |                              |
| IsCreditDailyAdjustment   | BIT            | NO   | 0       |                              |
| ModifiedBy                | NVARCHAR(50)   | NO   |         |                              |
| ModifiedOn                | DATETIME       | NO   | GETDATE()|                             |
| Credit                    | DECIMAL(18,2)  | NO   | 0       |                              |

- **Primary Key:** `WebId`, `CustomerId`, `SportId`, `BetType` (composite)
- **No foreign keys, unique constraints, or indexes defined.**

---

## SiteMessage

```sql
CREATE TABLE [dbo].[SiteMessage]
(
    [ID] INT IDENTITY (1,1) NOT NULL,
    [WebId] INT NOT NULL,
    [Type] INT NOT NULL,
    [ReceiverType] NVARCHAR (50) NOT NULL,
    [ReceiverValue] NVARCHAR (MAX) NOT NULL,
    [CreatedBy] NVARCHAR (50) NOT NULL,
    [CreatedOn] DATETIME NOT NULL,
    [ModifiedBy] NVARCHAR (50) NOT NULL,
    [ModifiedOn] DATETIME NOT NULL
)
```

| Column         | Type           | Null | Default | Description     |
|----------------|----------------|------|---------|----------------|
| ID             | INT (IDENTITY) | NO   |         | Primary Key     |
| WebId          | INT            | NO   |         |                |
| Type           | INT            | NO   |         |                |
| ReceiverType   | NVARCHAR(50)   | NO   |         |                |
| ReceiverValue  | NVARCHAR(MAX)  | NO   |         |                |
| CreatedBy      | NVARCHAR(50)   | NO   |         |                |
| CreatedOn      | DATETIME       | NO   |         |                |
| ModifiedBy     | NVARCHAR(50)   | NO   |         |                |
| ModifiedOn     | DATETIME       | NO   |         |                |

- **Primary Key:** `ID`
- **No foreign keys, unique constraints, or indexes defined.**

---

## SiteMessageLanguage

```sql
CREATE TABLE [dbo].[SiteMessageLanguage]
(
   [ID] INT IDENTITY (1,1) NOT NULL,
   [SiteMessageId] INT NOT NULL,
   [Title] NVARCHAR(MAX) NOT NULL,
   [Content] NVARCHAR(MAX) NOT NULL,
   [Language] NVARCHAR(10) NOT NULL
)
```

| Column         | Type           | Null | Default | Description     |
|----------------|----------------|------|---------|----------------|
| ID             | INT (IDENTITY) | NO   |         | Primary Key     |
| SiteMessageId  | INT            | NO   |         |                |
| Title          | NVARCHAR(MAX)  | NO   |         |                |
| Content        | NVARCHAR(MAX)  | NO   |         |                |
| Language       | NVARCHAR(10)   | NO   |         |                |

- **Primary Key:** `ID`
- **No foreign keys, unique constraints, or indexes defined.**

---

## SpPlayerBetSettingDefault

```sql
CREATE TABLE [dbo].[SbPlayerBetSettingDefault]
(
    [SportId]   INT NOT NULL,
    [BetType]   INT NOT NULL,
    [MinBet]    DECIMAL(19,6) NOT NULL,
    [MaxBet]    DECIMAL(19,6) NOT NULL,
    [MaxPerMatch] DECIMAL(19,6) NOT NULL
)
```

| Column        | Type           | Null | Default | Description     |
|---------------|----------------|------|---------|----------------|
| SportId       | INT            | NO   |         |                |
| BetType       | INT            | NO   |         |                |
| MinBet        | DECIMAL(19,6)  | NO   |         |                |
| MaxBet        | DECIMAL(19,6)  | NO   |         |                |
| MaxPerMatch   | DECIMAL(19,6)  | NO   |         |                |

- **Primary Key:** Not explicitly defined in the SQL.
- **No foreign keys, unique constraints, or indexes defined.**

---
