# Monika SP Lookup Technical Details

## SP Versioning & InsertData.sql Maintenance Guideline

- Whenever you change the input/output (I/O) of a stored procedure (SP), you MUST increment the major version number of the SP (e.g., [old_version] → [new_version]).
- The SP file name should NOT contain the version, but the SP name in SQL must include the version.
- After updating the SP version, you MUST update the corresponding Value field in InsertData.sql to point to the new SP version (e.g., [dbo].[Promodia_Promotion_GetCompanyPromotions_[new_version]]).
- This ensures all API/services call the correct version and allows for proper rollback and traceability.
- Always follow the backend-coding-conventions.md for versioning and naming rules.

**Example:**
```
,(N'Promodia', 0, N'sp_lookup', N'Promodia_Promotion_GetCompanyPromotions', N'[dbo].[Promodia_Promotion_GetCompanyPromotions_[new_version]]', ...)
```

---

## Standard Lookup Process

1. **Start from the C# Call Site**
   - First, locate the relevant Service/Repository call under the Coloris.Core project and find the stored procedure (SP) name being called (e.g., `Promodia_Promotion_GetCompanyPromotions`).
2. **Search SQL Files**
   - In the Monika project, search for the SP name (e.g., `Promodia_Promotion_GetCompanyPromotions`). This is usually registered in release scripts or InsertData.sql.
3. **Find the Corresponding Value in InsertData.sql**
   - In `ApplicationSetting/Data/InsertData.sql` or related SQL files, find the entry where the SP name maps to a Value (e.g., `[dbo].[Promodia_Promotion_GetCompanyPromotions_[new_version]]`).
4. **Locate the Actual SP Implementation**
   - Use the Value from InsertData.sql to search for the `CREATE PROCEDURE` implementation in the SQL files.

---

## Example: Promodia_Promotion_GetCompanyPromotions

1. **C# Call Site**
   - In Promodia/Repositories/PromotionRepository.cs, you will see:
     ```csharp
     QueryMultiple<...>("Promodia_Promotion_GetCompanyPromotions", ...)
     ```
2. **Find SQL Registration**
   - In the release script or InsertData.sql, you will see a row for `Promodia_Promotion_GetCompanyPromotions` with a Value field pointing to the actual SP name in use.
3. **Find the Value**
   - The Value field is the actual SP name currently in use. Do not assume any specific version; always use the Value from InsertData.sql.
4. **Find the SP Implementation**
   - Search for `CREATE PROCEDURE` with the Value from InsertData.sql to find the full SQL implementation.

---

## Notes
- The actual SP version in use may change frequently. **Always rely on the Value field in InsertData.sql to determine the correct SP.**
- The recommended lookup order is: Coloris.Core → Promodia → Monika (SQL). 