# SQL Agent Job Scripts List

This document lists all SQL Agent Job scripts found in the `Sql Agent Job` folder. Each entry includes the job name and a simple description. Entries are listed in alphabetical order by job name.

| Job Name | Description |
|----------|-------------|
| [BackUp] Daily Diff backup at 2 30 7 30 14 30 and 19 30.sql | Performs differential database backups at scheduled times. |
| [BackUp] Daily Full backup at 10 pm.sql | Performs a full database backup daily at 10 PM. |
| [BackUp] Transaction log backup at every 10 mins.sql | Performs transaction log backups every 10 minutes. |
| [Daily][Archive] UserActionData.sql | Archives user action data daily. |
| [Daily][Check] Check All Products Summary Is Tally With Raw Data Or Not In One Week.sql | Checks if all product summaries tally with raw data for the past week. |
| [Daily][Check] Incorrect Dailystatement check for all products.sql | Checks for incorrect daily statements for all products. |
| [Daily][Summary] summary games for promotion by game.sql | Summarizes games for promotion by game daily. |
| [Daily][Summary][Archive] Archive DailyBetSummaryTable.sql | Archives DailyBetSummaryTable records daily. |
| [Daily][Summary][Not SeamlessBet] Insert bet into DailyBetSummaryTable by day.sql | Inserts non-seamless bets into DailyBetSummaryTable by day. |
| [Daily][Summary][SeamlessBetOnly] Insert bet into DailyBetSummaryTable by day.sql | Inserts seamless bets into DailyBetSummaryTable by day. |
| [Financial] Calculate Monthly Financial Report.sql | Calculates the monthly financial report. |
| [Monitor] Check Agent Job History is Failed.sql | Checks if any agent job history has failed. |
| [Monitor] Check INT and BIGINT Limit.sql | Checks INT and BIGINT column limits. |
| [Monitor] Customers with poor margin.sql | Identifies customers with poor margin. |
| [Monitor] Long query for Agent Job.sql | Identifies long-running queries for agent jobs. |
| [Monitor] Long query.sql | Identifies long-running queries. |
| [Monitor] Maybe is time to add more Aither.sql | Suggests adding more Aither resources if needed. |
| [Monthly] Reset Streamer Given Bet Count.sql | Resets the streamer given bet count monthly. |
| [Monthly] Update Currency USD Exchange Rate.sql | Updates the USD exchange rate for all currencies monthly. |
| [New][Archive] Archive TransactionHistory.sql | Archives transaction history records. |
| [New][Archive] DailyBetSummaryCurrent.sql | Archives current DailyBetSummary records. |
| [New][Archive] Move Data for SBOCasinoBet.sql | Moves SBO casino bet data to archive. |
| [New][Archive] Move Data for SBOGameBet.sql | Moves SBO game bet data to archive. |
| [New][Archive] Move Data for SBOSeamlessBet Partition Version.sql | Moves SBO seamless bet data (partition version) to archive. |
| [New][Archive] Move Data for SBOSeamlessBet.sql | Moves SBO seamless bet data to archive. |
| [New][Archive] Move Data for SBOSportsBet.sql | Moves SBO sports bet data to archive. |
| [New][Archive] Move Data for SBOThirdPartySportBet.sql | Moves SBO third-party sport bet data to archive. |
| [New][Archive] Move Data for SBOVirtualSportBet.sql | Moves SBO virtual sport bet data to archive. |
| [New][Archive] Move Data for SboTransferGameproviderBets.sql | Moves SBO transfer game provider bets data to archive. |
| [New][Leo] Check Deposit Transaction do statement correctly.sql | Checks if deposit transactions are processed correctly. |
| [New][Leo]Check Scheduler is alive or not.sql | Checks if the scheduler is alive and sends alerts if not. |
| [New][Summary] Transaction Summary.sql | Summarizes daily transaction data. |
| [Alert] Check Seamless Game Player WinRate.sql | Checks seamless game player win rate. |
| [Alert] Check Sports 3rdPartySports Sync bet.sql | Checks synchronization of sports third-party sports bets. |
| [Alert] Simple Settings Sp version not tally with DB max exist sp version.sql | Checks if simple settings SP version matches the DB max version. |
| [DBA] Delete Whoisactive HistoryData.sql | Deletes old Whoisactive history data. |
| [DBA] Whoisactive_Collection.sql | Collects Whoisactive data. |
| Monthly Update Exchange Rate.sql | Updates exchange rates monthly. |

> **Note:** If a job has no description in the script, it is noted as such or inferred from the file name. 