# PromotionService gRPC Endpoints

This document lists all gRPC endpoints (RPC methods) for the `PromotionService` in the Promodia backend, as defined in `Protos/promotion.proto` and implemented in `Services/PromotionService.cs`.

| Method Name                        | Request Type                                 | Response Type                                 | Description (inferred)                                   |
|------------------------------------|----------------------------------------------|-----------------------------------------------|----------------------------------------------------------|
| GetCreatePromotionTypeList         | ProtoGetCreatePromotionTypeListRequest        | ProtoGetCreatePromotionTypeListResponse        | Get available promotion types for creation               |
| CreateCompanyPromotion             | ProtoCompanyPromotion                        | ProtoCreateCompanyPromotionResponse            | Create a new company promotion                           |
| ProceedPromotion                   | ProtoProceedPromotionRequest                 | ProtoGeneralResponse                          | Change the status of a promotion request                 |
| GetCompanyPromotionList            | ProtoGetCompanyPromotionListRequest          | ProtoGetCompanyPromotionListForPsResponse      | Get list of company promotions (player site)             |
| GetCompanyPromotionListForBo       | ProtoGetCompanyPromotionListForBoRequest     | ProtoGetCompanyPromotionListResponse           | Get list of company promotions (back office)             |
| ApplyPromotion                     | ProtoApplyPromotionRequest                   | ProtoGeneralResponse                          | Apply for a promotion                                   |
| GetPromotionRequestList            | ProtoGetPromotionListRequest                 | ProtoGetPromotionListResponse                  | Get list of promotion requests                           |
| AutoApplyPromotion                 | ProtoAutoApplyPromotionRequest               | ProtoGeneralResponse                          | Automatically apply a promotion (register/deposit)       |
| UpdateCompanyPromotion             | ProtoUpdateCompanyPromotionRequest           | ProtoGeneralResponse                          | Update an existing company promotion                     |
| GetPromotionStatistic              | ProtoGetPromotionStatisticRequest            | ProtoGetPromotionStatisticResponse             | Get promotion statistics                                |
| GetPlayerPromotionWallet           | ProtoGetPlayerPromotionWalletRequest         | ProtoGetPlayerPromotionWalletResponse          | Get player's promotion wallet info                       |
| GetPromotionRequestBetDetail       | ProtoGetPromotionRequestBetDetailRequest     | ProtoGetPromotionRequestBetDetailResponse      | Get bet details for a promotion request                  |
| TransferToMainWallet               | ProtoTransferToMainWalletRequest             | ProtoGeneralResponse                          | Transfer bonus to main wallet                            |
| ForceReloadCache                   | ProtoForceReloadCacheRequest                 | ProtoForceReloadCacheResponse                  | Force reload of promotion-related cache                  |
| PromotionFailRecord                | ProtoPromotionFailRecordRequest              | ProtoGPromotionFailRecordResponse              | Get promotion fail records                               |
| GetCompanyPromotionDetail          | ProtoGetCompanyPromotionDetailRequest        | ProtoGetCompanyPromotionListResponse           | Get details of a specific company promotion              |
| GetPlayerPromotionWalletInfo       | ProtoGetPlayerPromotionWalletInfoRequest     | ProtoGetPlayerPromotionWalletInfoResponse      | Get detailed info of player's promotion wallet           |
| UpdateWaitingPromotionByBatch      | ProtoUpdateWaitingPromotionByBatchRequest    | ProtoGeneralResponse                          | Batch update waiting promotions                          |
| AutoApplyRebate                    | ProtoTimezoneRequest                         | ProtoGeneralResponse                          | Automatically apply rebate promotions                    |
| GetLuckyWheelSpinResult            | ProtoPromodiaGetLuckyWheelSpinResultRequest  | ProtoPromodiaGetLuckyWheelSpinResultResponse   | Get result of a lucky wheel spin                         |
| GetLuckyWheelOptions               | ProtoGetLuckyWheelOptionsRequest             | ProtoGetLuckyWheelOptionsResponse              | Get available lucky wheel options                        |
| GetLuckyWheelTicket                | ProtoGetLuckyWheelTicketRequest              | ProtoGeneralResponse                          | Get a lucky wheel ticket                                 |
| GetAvailableLuckyWheelTickets      | ProtoGetAvailableLuckyWheelTicketsRequest    | ProtoGetAvailableLuckyWheelTicketsResponse     | Get available lucky wheel tickets                        |
| UpdateLuckyWheelPerformanceForTicketAndGetTicket | ProtoUpdateLuckyWheelPerformanceAndGetTicketRequest | ProtoGeneralResponse | Update lucky wheel performance and get ticket             |
| SelectPlayerPromotionWallet        | ProtoSelectPlayerPromotionWalletRequest      | ProtoGeneralResponse                          | Select a player's promotion wallet                       |
| ApplyPromotionForNewPlayer         | ProtoApplyPromotionForNewPlayerRequest       | ProtoGeneralResponse                          | Apply promotion for a new player                         |
| GetGivenAndUsageTickets            | ProtoGetGivenAndUsageTicketsRequest          | ProtoGetGivenAndUsageTicketsResponse           | Get given and used tickets for promotions                |
| CouponRedeemPromotion              | ProtoCouponRedeemPromotionRequest            | ProtoCouponRedeemPromotionResponse             | Redeem a coupon for a promotion                          |
| GetCouponCodeGivenUsage            | ProtoGetCouponCodeGivenUsageRequest          | ProtoGetCouponCodeGivenUsageResponse           | Get usage info for coupon codes                          |
| CheckAvailableCouponPromotion      | ProtoCheckAvailableCouponPromotionRequest    | ProtoCheckAvailableCouponPromotionResponse     | Check if a coupon promotion is available                 |
| GetSpecificPromotionOption         | ProtoGetSpecificPromotionOptionRequest       | ProtoGetSpecificPromotionOptionResponse        | Get details of a specific promotion option               |
| GetDepositPromotionOptionsForBo    | ProtoGetDepositPromotionOptionsForBoRequest  | ProtoGetDepositPromotionOptionsForBoResponse   | Get deposit promotion options (back office)              |
| GetDepositPromotionOptionsForPlayer| ProtoGetDepositPromotionOptionsForPlayerRequest | ProtoGetDepositPromotionOptionsForPlayerResponse | Get deposit promotion options (player)                |
| UpsertDepositPromotionOptions      | ProtoUpsertDepositOptionRequest              | ProtoGeneralResponse                          | Insert or update deposit promotion options               |
| PreCheckDepositPromotion           | ProtoPreCheckPromotionDepositOptionRequest   | ProtoPreCheckPromotionDepositOptionResponse    | Pre-check for deposit promotion eligibility              |
| GetMemberPromotion                 | ProtoGetMemberPromotionRequest               | ProtoGetMemberPromotionResponse                | Get member's promotion info                             |
| GetPromotionFilterRecord           | ProtoPromodiaGetPromotionFilterRecordRequest | ProtoPromodiaGetPromotionFilterRecordResponse  | Get promotion filter records                             |
| GetReferralEvent                   | ProtoGetReferralEventRequest                 | ProtoGetReferralEventResponse                  | Get referral event info                                 |
| CreateReferralMember               | ProtoCreateReferralMemberRequest             | ProtoGeneralResponse                          | Create a new referral member                             |
| GetRedeemHistory                   | ProtoGetRedeemHistoryRequest                 | ProtoGetRedeemHistoryResponse                  | Get referral redeem history                              |
| GetCompanyReferral                 | ProtoGetCompanyReferralRequest               | ProtoGetCompanyReferralResponse                | Get company referral info                                |
| GetRedeemableInfo                  | ProtoGetRedeemableInfoRequest                | ProtoGetRedeemableInfoResponse                 | Get info about redeemable referrals                      |
| GetReferralFilter                  | ProtoGetReferralFilterRequest                | ProtoGetReferralFilterResponse                 | Get referral filter info                                 |
| GetRedeemRequestSummary            | ProtoGetRedeemRequestSummaryRequest          | ProtoGetRedeemRequestSummaryResponse           | Get summary of redeem requests                           |
| GetRedeemRequest                   | ProtoGetRedeemRequestRequest                 | ProtoGetRedeemRequestResponse                  | Get details of a redeem request                          |
| GetReferrerWallets                 | ProtoGetReferrerWalletsRequest               | ProtoGetReferrerWalletsResponse                | Get list of referrer wallets                             |
| GetReferralStatistic               | ProtoGetReferralStatisticRequest             | ProtoGetReferralStatisticResponse              | Get referral statistics                                  |
| GetReferrerWalletDetail            | ProtoGetReferrerWalletDetailRequest          | ProtoGetReferrerWalletDetailResponse           | Get details of a referrer wallet                         |
| GetReferralInfo                    | ProtoGetReferralInfoRequest                  | ProtoGetReferralInfoResponse                   | Get referral info                                        |
| GetRefereeDetail                   | ProtoGetRefereeDetailRequest                 | ProtoGetRefereeDetailsResponse                 | Get details of a referee                                 |
| GetReferralSettings                | ProtoGetReferralSettingsRequest              | ProtoGetReferralSettingsResponse               | Get referral settings                                    |

</rewritten_file> 