# VipService gRPC Endpoints

This document lists all gRPC endpoints (RPC methods) for the `VipService` in the Promodia backend, as defined in `Protos/vip.proto` and implemented in `Services/VipService.cs`.

| Method Name                        | Request Type                                 | Response Type                                 | Description (inferred)                                   |
|------------------------------------|----------------------------------------------|-----------------------------------------------|----------------------------------------------------------|
| UpdateVipEvent                     | ProtoUpdateVipEventRequest                   | ProtoGeneralResponse                          | Update a VIP event                                       |
| GetVipEvent                        | ProtoGetVipEventRequest                      | ProtoGetVipEventResponse                      | Get VIP event information                                |
| UpdateVipMemberLevel               | ProtoUpdateVipMemberLevelRequest             | ProtoGeneralResponse                          | Update a VIP member's level                              |
| GetVipMemberInfo                   | ProtoGetVipMemberInfoRequest                 | ProtoGetVipMemberInfoResponse                 | Get VIP member information                               |
| UpdateVipMemberPerformance         | ProtoUpdateVipMemberPerformanceRequest       | ProtoGeneralResponse                          | Update a VIP member's performance                        |
| GetPlayerVipEventPerformance       | ProtoGetPlayerVipEventPerformanceRequest     | ProtoGetPlayerVipEventPerformanceResponse     | Get a player's VIP event performance                     |
| GetVipLevelInfo                    | ProtoGetVipLevelInfoRequest                  | ProtoGetVipLevelInfoResponse                  | Get information about VIP levels                         |
| CalculateVipBonusMemberPerformance | ProtoCalculateVipBonusMemberPerformanceRequest| ProtoGeneralResponse                         | Calculate bonus performance for VIP members              |
| GetVipReport                       | ProtoGetVipReportRequest                     | ProtoGetVipReportResponse                     | Get VIP report                                           |
| CalculateVipRebateMemberPerformance| ProtoCalculateVipRebateMemberPerformanceRequest| ProtoGeneralResponse                        | Calculate rebate performance for VIP members             |
| GetVipLevelRecord                  | ProtoGetVipLevelRecordRequest                | ProtoGetVipLevelRecordResponse                | Get VIP level record                                     | 