# Monika SP Reference

**Total:** 1466 SPs

## SP by Issue Type

### Promotion
| SP | Use |
|----|-----|
| `UpdatePromotionRequest.sql` | Approve/Reject/Complete |
| `Sp_Promotion_AutoCompletePromotionWallet.sql` | Auto-complete |
| `Promodia_AddPromotionSystemRejectRecord.sql` | Rejection log |
| `Record_InsertBalanceHistoryForPromotion.sql` | Balance history |

### Account
| SP | Use |
|----|-----|
| `Coloris_Account_AddSingleTransfer.sql` | Single wallet transfer |
| `Coloris_Account_GetWithdrawalLimit.sql` | Withdrawal limit |
| `Coloris_Account_GetStatementList.sql` | Statement list |

### VIP
| SP | Use |
|----|-----|
| `Promodia_UpdateVipMemberLevel.sql` | Level update |
| `Promodia_CalculateVipBonusMemberPerformance.sql` | Bonus calc |
| `Promodia_GetVipMemberInfo.sql` | Member info |

### Payment
| SP | Use |
|----|-----|
| `Hermes_Transaction_ValidateAndUpdateTransactionStatus.sql` | Status update |
| `Hermes_Account_InsertPaymentDepositRequest.sql` | Deposit |

### Record
| SP | Use |
|----|-----|
| `Coloris_Record_GetBalanceHistory.sql` | Balance history query |
| `Record_InsertBalanceHistory.sql` | Insert record |

## Quick Search

```bash
# Find SP by name (adjust path to your monika location)
find ~/projects/BackEnd/monika -name "*keyword*.sql"

# Search SP content
grep -rl "BalanceHistory" ~/projects/BackEnd/monika/Monika/*/dbo/Stored\ Procedures/
```

## Database Paths

| DB | Relative Path |
|----|---------------|
| Main | `Monika/Main/dbo/Stored Procedures/` |
| Account | `Monika/Account/dbo/Stored Procedures/` |
| Promotion | `Monika/Promotion/dbo/Stored Procedures/` |
| VIP | `Monika/VIP/dbo/Stored Procedures/` |
| Record | `Monika/Record/dbo/Stored Procedures/` |
| Payment | `Monika/Payment/dbo/Stored Procedures/` |
