# SQL Query Templates

## Customer

```sql
-- Get customer info
SELECT TOP 1 [CustomerId], [Username], [Currency], [VipLevel], [CustomerStatus], [CreatedOn]
FROM [Main].[dbo].[Customer] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
```

```sql
-- Get player balance
SELECT [CustomerId], [CashBalance], [Outstanding], [Currency]
FROM [Main].[dbo].[vPlayerBalance] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
```

## Promotion

```sql
-- Check promotion request
SELECT TOP 20 [Id], [CustomerId], [Username], [Status], [ApproveAmount],
       [IsCreatePromotionWallet], [MinTurnoverToWithdrawal], [CreatedOn]
FROM [Promotion].[dbo].[PromotionRequest] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

```sql
-- Check rejection records
SELECT TOP 20 [Id], [CustomerId], [Username], [ActionType], [RejectSetting],
       [CompanyPromotionId], [Remark], [CreatedOn]
FROM [Promotion].[dbo].[PromotionSystemRejectRecord] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
ORDER BY [CreatedOn] DESC
```

## Balance History

```sql
-- Get balance history by customer
SELECT TOP 50 [Id], [CustomerId], [Username], [ActionType], [CashBalanceDelta],
       [WalletId], [Remark], [ModifiedDate], [ModifiedBy]
FROM [Record].[dbo].[BalanceHistory] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [ModifiedDate] DESC
```

```sql
-- Get balance history by WalletId (PromotionRequestId)
SELECT TOP 20 [Id], [CustomerId], [ActionType], [CashBalanceDelta], [ModifiedDate]
FROM [Record].[dbo].[BalanceHistory] WITH(NOLOCK)
WHERE [WalletId] = {promotionRequestId}
ORDER BY [ModifiedDate] DESC
```

## VIP

```sql
-- Check VIP level changes
SELECT TOP 20 [Id], [CustomerId], [FromLevelId], [ToLevelId], [CreatedOn], [CreatedBy]
FROM [VIP].[dbo].[MemberLevelChangeLog] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

```sql
-- Check VIP performance
SELECT TOP 10 [Id], [CustomerId], [LevelId], [Deposit], [Turnover], [CreatedOn]
FROM [VIP].[dbo].[MemberPerformance] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

```sql
-- Check benefits setting
SELECT TOP 20 [Id], [EventId], [LevelId], [Type], [Commission], [ModifiedOn], [ModifiedBy]
FROM [VIP].[dbo].[BenefitsSetting] WITH(NOLOCK)
WHERE [EventId] IN (SELECT [Id] FROM [VIP].[dbo].[Event] WHERE [WebId] = {webId})
ORDER BY [ModifiedOn] DESC
```

## Transactions

```sql
-- Check transaction request
SELECT TOP 20 [ID], [TransactionType], [TransactionStatus], [CustomerId], [Amount],
       [BeforeBalance], [AfterBalance], [RefNo], [CreatedOn]
FROM [Account].[dbo].[TransactionRequest] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

```sql
-- Check statement
SELECT TOP 20 [StatementId], [RefNo], [CustomerId], [StatementType],
       [CashIn], [CashOut], [CreatedOn], [Remark]
FROM [Account].[dbo].[Statement] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

## Payment

```sql
-- Check payment transaction
SELECT TOP 20 [Id], [RefNo], [Status], [Amount], [ProviderRef], [CreatedOn]
FROM [Payment].[dbo].[Transaction] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [RefNo] = '{refNo}'
ORDER BY [CreatedOn] DESC
```

```sql
-- Check withdrawal limit
SELECT TOP 10 [Id], [CustomerId], [Status], [Amount], [Requirement],
       [CurrentTurnover], [EventId], [CreatedOn]
FROM [Account].[dbo].[WithdrawalLimit] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

## Settings

```sql
-- Check customer settings override
SELECT [Id], [Value], [WebId]
FROM [ApplicationSetting].[dbo].[CustomerSettingsOverride] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Id] = 'isSingleWalletEnabled'
```

## Login

```sql
-- Check login history
SELECT TOP 20 [Id], [Username], [IP], [Result], [DeviceType], [CreatedOn]
FROM [AAA].[dbo].[LoginHistory] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
ORDER BY [CreatedOn] DESC
```
