# SQL Rules

## MUST FOLLOW

| Rule | Correct | Wrong |
|------|---------|-------|
| Columns | `SELECT [Id], [Name]` | `SELECT *` |
| Count | `COUNT(1)` | `COUNT(*)` |
| Table hint | `WITH(NOLOCK)` | No hint |
| Limit | `TOP 100` | No limit |
| Sort | `ORDER BY [Col] DESC` | No sort |
| Money | `DECIMAL(19,6)` | `FLOAT` |
| Cross-DB | `[DB].[dbo].[Table]` | `[Table]` |

## Checklist

Before EVERY query:
- [ ] No `SELECT *`
- [ ] No `COUNT(*)`
- [ ] Every table has `WITH(NOLOCK)`
- [ ] Has `TOP N`
- [ ] Has `ORDER BY`

## Template

```sql
SELECT TOP 100 [Col1], [Col2], [Col3]
FROM [Database].[dbo].[Table] WITH(NOLOCK)
WHERE [WebId] = {webId}
  AND [CreatedOn] >= '{startDate}'
ORDER BY [CreatedOn] DESC
```
