# Status Codes Reference

## Transaction Types

| Code | Type |
|------|------|
| 100 | Deposit |
| 200 | Withdrawal |
| 300 | PromotionBonus |
| 500 | Bonus |
| 600 | Rebate |
| 700 | PaymentWithdrawal |
| 1500 | PaymentGatewayDeposit |
| 1600 | PaymentGatewayWithdrawal |
| 1700 | ManualBonus |
| 2000 | ManualRebate |
| 2600 | ManualBalanceAddition |
| 2700 | ManualBalanceDeduction |

## Transaction Status

| Status | Description |
|--------|-------------|
| 1 | Pending |
| 2 | Rejected |
| 3 | Approved |
| 4 | Cancelled |
| 6 | Withdrawal Approved |
| 7 | Manual Transfer Approved |

## Payment Gateway Status

| Status | Description |
|--------|-------------|
| 1000 | Started |
| 1002 | Processing |
| 1003 | Pending |
| 1005 | PG Withdrawal Approved |
| 1007 | PG Deposit Approved |
| 1009 | Expired/Rejected |
| 1016 | Admin Rejected |

## Promotion Status

| Status | Description |
|--------|-------------|
| Waiting | Pending approval |
| Approved | Approved |
| Rejected | Rejected |
| Completed | Turnover met |

## VIP Levels

| LevelId | Name |
|---------|------|
| 1 | VIP0 |
| 2 | Iron |
| 3 | Bronze |
| 4 | Silver |
| 5 | Gold |
| 6 | Platinum |
| 7 | Diamond |

## Customer Status Bits

| Bit | Value | Status |
|-----|-------|--------|
| 1 | 1 | Suspended |
| 2 | 2 | Closed |
| 4 | 4 | Deleted |
| 16 | 16 | Streamer |
| 524288 | 524288 | Exclude VIP |

## Bet Status

| Status | Description |
|--------|-------------|
| running | Unsettled |
| won | Player won |
| lose | Player lost |
| draw | Draw |
| void | Cancelled |
| cashout | Early cashout |

## BO Sections

| Section | Page |
|---------|------|
| 3.1 | Player List |
| 4.1.1 | Transaction Export |
| 4.4 | Transaction Query |
| 4.8 | Daily P&L Report |
| 5.4 | Balance History |
| 6.4 | Promotion Report |
| 9.5 | Display Settings |
| 11.5 | Two-Stage Approval |
