# Skill Rules

## SQL Rules (MUST)

1. `WITH(NOLOCK)` - Every table
2. `COUNT(1)` - Never COUNT(*)
3. `TOP N` - Always limit
4. `ORDER BY` - Always sort
5. `[Column]` - Explicit names

## Investigation Rules

1. **Customer first** - Always get CustomerId before other queries
2. **Recent first** - ORDER BY CreatedOn DESC
3. **10+ rows** - Screenshot must show enough data
4. **Zoom 67%** - Fit more rows
5. **Parse results** - Don't just screenshot, extract data

## Output Rules

1. **To CAS: 500 characters max**
2. **Root cause first**
3. **Action/conclusion second**
4. **No technical jargon**

## Security Rules

1. **User-specific credentials** - Never share
2. **No passwords in logs**
3. **Screenshot sanitize** - Hide sensitive data if needed
