# Playbook: Betting Issues

## Quick Diagnosis

| Symptom | Check | Solution |
|---------|-------|----------|
| Bet not settled | BetHistory | Check bet status |
| Wrong winnings | BetHistory | Verify odds/amount |
| Missing balance | BalanceHistory | Check settlement record |

## Step 1: Check Customer Info

```sql
SELECT TOP 1 [CustomerId], [Username], [Currency], [VipLevel], [CreatedOn]
FROM [Main].[dbo].[Customer] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
```

## Step 2: Check Bet History

```sql
SELECT TOP 50 [Id], [CustomerId], [GameType], [BetAmount], [WinAmount],
       [Status], [RefNo], [CreatedOn]
FROM [GameProvider].[dbo].[BetHistory] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

## Step 3: Check Balance History

```sql
SELECT TOP 30 [Id], [CustomerId], [ActionType], [CashBalanceDelta],
       [Remark], [ModifiedDate]
FROM [Record].[dbo].[BalanceHistory] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
  AND [ActionType] IN ('BetSettlement', 'BetPlacement', 'BetCancel')
ORDER BY [ModifiedDate] DESC
```

## Bet Status Codes

| Status | Meaning |
|--------|---------|
| running | Unsettled bet |
| waiting | Waiting for result |
| won | Player won |
| lose | Player lost |
| draw | Draw result |
| void | Cancelled/voided |
| cashout | Early cashout |

## Game Types

| Code | Type |
|------|------|
| 201 | Slot |
| 300 | Sportsbook |
| 301 | Live Casino |

## To CAS Templates

```
To CAS:
Bet RefNo {refNo} status is {status}. Settlement pending.
```

```
To CAS:
Bet settled as {status}. WinAmount {amount} credited on {date}.
```
