# Playbook: Login Issues

## Quick Diagnosis

| Symptom | Check | Solution |
|---------|-------|----------|
| Cannot login | LoginHistory | Check fail reason |
| Account locked | Customer | Check CustomerStatus bits |
| 2FA issue | LoginHistory | Check OTP attempts |

## Step 1: Check Customer Info

```sql
SELECT TOP 1 [CustomerId], [Username], [Currency], [VipLevel], [CustomerStatus], [CreatedOn]
FROM [Main].[dbo].[Customer] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
```

## Step 2: Check Customer Status Bits

```sql
SELECT [CustomerId], [Username], [CustomerStatus],
       CASE WHEN [CustomerStatus] & 1 = 1 THEN 'Suspended' ELSE '' END AS Suspended,
       CASE WHEN [CustomerStatus] & 2 = 2 THEN 'Closed' ELSE '' END AS Closed,
       CASE WHEN [CustomerStatus] & 4 = 4 THEN 'Deleted' ELSE '' END AS Deleted,
       CASE WHEN [CustomerStatus] & 16 = 16 THEN 'Streamer' ELSE '' END AS Streamer
FROM [Main].[dbo].[Customer] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
```

## Step 3: Check Login History

```sql
SELECT TOP 30 [Id], [Username], [IP], [Result], [DeviceType], [FailReason], [CreatedOn]
FROM [AAA].[dbo].[LoginHistory] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
ORDER BY [CreatedOn] DESC
```

## Customer Status Bits

| Bit | Value | Status |
|-----|-------|--------|
| 1 | 1 | Suspended |
| 2 | 2 | Closed |
| 4 | 4 | Deleted |
| 16 | 16 | Streamer |
| 524288 | 524288 | Exclude VIP |

**Check:** `CustomerStatus & 2 = 2` means Closed

## Login Results

| Result | Meaning |
|--------|---------|
| Success | Login OK |
| Failed | Wrong password |
| Locked | Too many attempts |
| Suspended | Account suspended |
| InvalidOTP | Wrong 2FA code |

## To CAS Templates

```
To CAS:
Account status is Suspended (bit 1). Contact admin to unsuspend.
```

```
To CAS:
Login failed {count} times from IP {ip}. Last fail: {reason}.
```

```
To CAS:
2FA (OTP) failed {count} times. Player should wait or reset 2FA.
```
