# Playbook: Payment Issues

## Quick Diagnosis

| Symptom | Check | Solution |
|---------|-------|----------|
| Deposit pending | Payment.Transaction | Check provider callback |
| Withdrawal rejected | TransactionRequest | Check status/reason |
| Not in BO | Two-stage approval | Check BO 11.5 |
| Status changed | Callback log | Provider duplicate |

## Step 1: Check Transaction

```sql
SELECT TOP 10 [ID], [TransactionType], [TransactionStatus], [Amount],
       [RefNo], [BeforeBalance], [AfterBalance], [CreatedOn]
FROM [Account].[dbo].[TransactionRequest] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [RefNo] = '{refNo}'
ORDER BY [CreatedOn] DESC
```

## Step 2: Check Payment Gateway

```sql
SELECT TOP 10 [Id], [RefNo], [Status], [Amount], [ProviderRef], [CreatedOn]
FROM [Payment].[dbo].[Transaction] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [RefNo] = '{refNo}'
ORDER BY [CreatedOn] DESC
```

## Step 3: Check Withdrawal Limit

```sql
SELECT TOP 10 [Id], [Status], [Amount], [Requirement], [CurrentTurnover], [EventId]
FROM [Account].[dbo].[WithdrawalLimit] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

## Payment Status Codes

| Status | Meaning |
|--------|---------|
| 1000 | Started |
| 1003 | Pending |
| 1007 | Deposit Approved |
| 1005 | Withdrawal Approved |
| 1009 | Rejected |

## To CAS Templates

```
To CAS:
Deposit pending at payment gateway (Status=1003). No callback received yet.
```

```
To CAS:
Transaction pending Two-Stage Approval. Please check BO 11.5.
```

```
To CAS:
Status changed from Success to Rejected due to provider duplicate callback.
```
