# Playbook: Promotion Issues

## Quick Diagnosis

| Symptom | Check | Solution |
|---------|-------|----------|
| Cannot apply | `PromotionSystemRejectRecord` | Check reject reason |
| Balance history missing | `Statement` table | Bug - display issue |
| Lucky wheel no ticket | Promotion dates | Timing issue |
| Auto-complete wrong | `PromotionTurnover` | Recalculate |

## Step 1: Get Customer Info

```sql
SELECT TOP 1 [CustomerId], [Username], [VipLevel]
FROM [Main].[dbo].[Customer] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
```

## Step 2: Check Rejection

```sql
SELECT TOP 10 [Id], [ActionType], [RejectSetting], [Remark], [CreatedOn]
FROM [Promotion].[dbo].[PromotionSystemRejectRecord] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [Username] = '{username}'
ORDER BY [CreatedOn] DESC
```

## Step 3: Check Promotion Request

```sql
SELECT TOP 10 [Id], [Status], [ApproveAmount], [IsCreatePromotionWallet], [CreatedOn]
FROM [Promotion].[dbo].[PromotionRequest] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

## Step 4: Check Balance History

```sql
SELECT TOP 10 [Id], [ActionType], [CashBalanceDelta], [WalletId], [ModifiedDate]
FROM [Record].[dbo].[BalanceHistory] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
  AND [ActionType] LIKE '%Promotion%'
ORDER BY [ModifiedDate] DESC
```

## Common Reject Reasons

| RejectSetting | Meaning |
|---------------|---------|
| SameFP | Same fingerprint used |
| SameIP | Same IP used |
| MaxClaim | Max claims reached |
| NotEligible | VIP level not met |

## To CAS Templates

```
To CAS:
Same FP already used by another player. Cannot claim twice from same device.
```

```
To CAS:
Balance history INSERT failed (known bug). Statement exists, bonus credited. Display issue only.
```

```
To CAS:
Lucky wheel ticket not issued - promotion was disabled at deposit time.
```
