# Playbook: VIP Issues

## Quick Diagnosis

| Symptom | Check | Solution |
|---------|-------|----------|
| Not upgraded | MemberPerformance | Check deposit/turnover |
| Wrong bonus | BenefitsSetting | Check setting at upgrade time |
| No upgrade message | SiteMessage | Check message config |

## Step 1: Check VIP Level

```sql
SELECT TOP 1 [CustomerId], [VipLevel], [Currency]
FROM [Main].[dbo].[Customer] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
```

## Step 2: Check Level Changes

```sql
SELECT TOP 10 [Id], [FromLevelId], [ToLevelId], [CreatedOn], [CreatedBy]
FROM [VIP].[dbo].[MemberLevelChangeLog] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

## Step 3: Check Performance

```sql
SELECT TOP 10 [Id], [LevelId], [Deposit], [Turnover], [CreatedOn]
FROM [VIP].[dbo].[MemberPerformance] WITH(NOLOCK)
WHERE [WebId] = {webId} AND [CustomerId] = {customerId}
ORDER BY [CreatedOn] DESC
```

## Step 4: Check Benefits Setting

```sql
SELECT TOP 10 [Id], [LevelId], [Type], [Commission], [ModifiedOn], [ModifiedBy]
FROM [VIP].[dbo].[BenefitsSetting] WITH(NOLOCK)
WHERE [EventId] IN (SELECT [Id] FROM [VIP].[dbo].[Event] WHERE [WebId] = {webId})
  AND [Type] = 'UpgradeBonus'
ORDER BY [ModifiedOn] DESC
```

## VIP Levels

| Id | Name |
|----|------|
| 1 | VIP0 |
| 2 | Iron |
| 3 | Bronze |
| 4 | Silver |
| 5 | Gold |
| 6 | Platinum |
| 7 | Diamond |

## To CAS Templates

```
To CAS:
Player VIP level is Iron (2). Promotion requires Gold (5). Not eligible.
```

```
To CAS:
BenefitsSetting changed from 100 to 50 on {date}. Player received correct amount at upgrade time.
```
