"""
Agents Package - Specialized agents for investigation swarm.

Multi-Agent Swarm Architecture:
- CoordinatorAgent: Orchestrates 4-phase workflow
- DBAgent: Database operations with connection pooling
- JiraAgent: Ticket parsing and Jira integration
- AnalysisAgent: Error detection and root cause analysis
- LearningAgent: Pattern learning and solution matching
"""

from .base import BaseAgent, AgentState, TaskResult
from .coordinator import CoordinatorAgent
from .db_agent import DBAgent
from .jira_agent import JiraAgent
from .analysis_agent import AnalysisAgent
from .learning_agent import LearningAgent

__all__ = [
    'BaseAgent', 'AgentState', 'TaskResult',
    'CoordinatorAgent',
    'DBAgent',
    'JiraAgent',
    'AnalysisAgent',
    'LearningAgent'
]
