# Aspose.Slides Core Classes Reference

## AdjustValue

**Namespace**: `Aspose.Slides.AdjustValue`

Represents a geometry shape's adjustment value. These values affect shape's form.

---

## AdjustValueCollection

**Namespace**: `Aspose.Slides.AdjustValueCollection`

Reprasents a collection of shape's adjustments.

---

## Audio

**Namespace**: `Aspose.Slides.Audio`

Represents an embedded audio file.

---

## AudioCollection

**Namespace**: `Aspose.Slides.AudioCollection`

Represents a collection of embedded audio files.

---

## AudioFrame

**Namespace**: `Aspose.Slides.AudioFrame`

Represents an audio clip on a slide.

---

## AudioPlayModePreset

**Namespace**: `Aspose.Slides.AudioPlayModePreset`

Constants which define how a sound is played.

---

## AudioVolumeMode

**Namespace**: `Aspose.Slides.AudioVolumeMode`

Constants which define audio volume.

---

## AutoShape

**Namespace**: `Aspose.Slides.AutoShape`

Represents an AutoShape.

---

## AutoShapeLock

**Namespace**: `Aspose.Slides.AutoShapeLock`

Determines which operations are disabled on the parent AutoshapeEx.

---

## Backdrop3DScene

**Namespace**: `Aspose.Slides.Backdrop3DScene`

Defines a plane in which effects, such as glow and shadow, are applied in relation to the shape they are being applied to.

---

## Background

**Namespace**: `Aspose.Slides.Background`

Represents background of a slide.

---

## BackgroundType

**Namespace**: `Aspose.Slides.BackgroundType`

Defines the slide background fill source.

---

## BaseHandoutNotesSlideHeaderFooterManager

**Namespace**: `Aspose.Slides.BaseHandoutNotesSlideHeaderFooterManager`

Represents manager which holds behavior of the placeholders, including header placeholder for all types handout and notes slides.

---

## BaseHeaderFooterManager

**Namespace**: `Aspose.Slides.BaseHeaderFooterManager`

Represents manager which holds behavior of the footer, date-time, page number placeholders for all slide types.

---

## BasePortionFormat

**Namespace**: `Aspose.Slides.BasePortionFormat`

Common text portion formatting properties.

---

## BaseShapeLock

**Namespace**: `Aspose.Slides.BaseShapeLock`

Represents a base class for locks (disabled operation).

---

## BaseSlide

**Namespace**: `Aspose.Slides.BaseSlide`

Represents common data for all slide types.

---

## BaseSlideHeaderFooterManager

**Namespace**: `Aspose.Slides.BaseSlideHeaderFooterManager`

Represents manager which holds behavior of the footer, date-time, page number placeholders for all slide types.

---

## BevelPresetType

**Namespace**: `Aspose.Slides.BevelPresetType`

Constants which define 3D bevel of shape.

---

## BlackWhiteMode

**Namespace**: `Aspose.Slides.BlackWhiteMode`

Determines how colored shape should be transformed into black and white.

---

## BlobManagementOptions

**Namespace**: `Aspose.Slides.BlobManagementOptions`

Represents options which can be used to manage BLOB handling rules and other BLOB settings.

---

## BrowsedAtKiosk

**Namespace**: `Aspose.Slides.BrowsedAtKiosk`

Browsed at a kiosk (full screen)

---

## BrowsedByIndividual

**Namespace**: `Aspose.Slides.BrowsedByIndividual`

Browsed by individual (window)

---

## BuildVersionInfo

**Namespace**: `Aspose.Slides.BuildVersionInfo`

Contains information about version of Aspose.Slides.

---

## BulletFormat

**Namespace**: `Aspose.Slides.BulletFormat`

Represents paragraph bullet formatting properties.

---

## BulletType

**Namespace**: `Aspose.Slides.BulletType`

Represents the type of the extended bullets.

---

## Camera

**Namespace**: `Aspose.Slides.Camera`

Represents Camera.

---

## CameraPresetType

**Namespace**: `Aspose.Slides.CameraPresetType`

Constants which define camera preset type.

---

## Captions

**Namespace**: `Aspose.Slides.Captions`

Represents the WebVTT closed captions.

---

## CaptionsCollection

**Namespace**: `Aspose.Slides.CaptionsCollection`

Represents a collection of the closed captions.

---

## Cell

**Namespace**: `Aspose.Slides.Cell`

Represents a cell of a table.

---

## CellCollection

**Namespace**: `Aspose.Slides.CellCollection`

Represents a collection of cells.

---

## CellFormat

**Namespace**: `Aspose.Slides.CellFormat`

Represents format of a table cell.

---

## ColorFormat

**Namespace**: `Aspose.Slides.ColorFormat`

Represents a color used in a presentation.

---

## ColorOperation

**Namespace**: `Aspose.Slides.ColorOperation`

Represents different color operations used for color transformations. Immutable object.

---

## ColorOperationCollection

**Namespace**: `Aspose.Slides.ColorOperationCollection`

Represents a collection of color transform operations.

---

## ColorSchemeIndex

**Namespace**: `Aspose.Slides.ColorSchemeIndex`

Represents an index in a colorscheme.

---

## ColorStringFormat

**Namespace**: `Aspose.Slides.ColorStringFormat`

Represents a type of hyperlink action.

---

## ColorTransformOperation

**Namespace**: `Aspose.Slides.ColorTransformOperation`

Defines color transform operation.

---

## ColorType

**Namespace**: `Aspose.Slides.ColorType`

Represents different color modes.

---

## Column

**Namespace**: `Aspose.Slides.Column`

Represents a column in a table.

---

## ColumnCollection

**Namespace**: `Aspose.Slides.ColumnCollection`

Represents collection of columns in a table.

---

## ColumnFormat

**Namespace**: `Aspose.Slides.ColumnFormat`

Represents format of a table column.

---

## Comment

**Namespace**: `Aspose.Slides.Comment`

Represents a comment on a slide.

---

## CommentAuthor

**Namespace**: `Aspose.Slides.CommentAuthor`

Represents an author of comments.

---

## CommentAuthorCollection

**Namespace**: `Aspose.Slides.CommentAuthorCollection`

Represents a collection of comment authors.

---

## CommentCollection

**Namespace**: `Aspose.Slides.CommentCollection`

Represents a collection of comments of one author.

---

## CommonSlideViewProperties

**Namespace**: `Aspose.Slides.CommonSlideViewProperties`

Represents common slide view properties.

---

## Connector

**Namespace**: `Aspose.Slides.Connector`

Represents a connector.

---

## ConnectorLock

**Namespace**: `Aspose.Slides.ConnectorLock`

Determines which operations are disabled on the parent Connector.

---

## Control

**Namespace**: `Aspose.Slides.Control`

Represents an ActiveX control.

---

## ControlCollection

**Namespace**: `Aspose.Slides.ControlCollection`

A collection of ActiveX controls.

---

## ControlPropertiesCollection

**Namespace**: `Aspose.Slides.ControlPropertiesCollection`

A collection of AcitveX properties.

---

## ControlType

**Namespace**: `Aspose.Slides.ControlType`

Defines a control type which should be embedded by

---

## CustomData

**Namespace**: `Aspose.Slides.CustomData`

Represents container for custom data.

---

## CustomXmlPart

**Namespace**: `Aspose.Slides.CustomXmlPart`

Represents custom xml part.

---

## CustomXmlPartCollection

**Namespace**: `Aspose.Slides.CustomXmlPartCollection`

Represents collection of custom xml parts.

---

## DigitalSignature

**Namespace**: `Aspose.Slides.DigitalSignature`

Digital signature in signed file.

---

## DigitalSignatureCollection

**Namespace**: `Aspose.Slides.DigitalSignatureCollection`

Represents a collection of digital signatures attached to a document.

---

## DocumentProperties

**Namespace**: `Aspose.Slides.DocumentProperties`

Represents properties of a presentation.

---

## DomObject`1

**Namespace**: `Aspose.Slides.DomObject`1`

Base DOM object

---

## DrawingGuide

**Namespace**: `Aspose.Slides.DrawingGuide`

Represents an adjustable drawing guide.

---

## DrawingGuidesCollection

**Namespace**: `Aspose.Slides.DrawingGuidesCollection`

Represents a collection of the adjustable drawing guides.

---

## EffectFormat

**Namespace**: `Aspose.Slides.EffectFormat`

Represents effect properties of shape.

---

## EmbeddingLevel

**Namespace**: `Aspose.Slides.EmbeddingLevel`

Represents the licensing rights for embedding the font.

---

## Field

**Namespace**: `Aspose.Slides.Field`

Represents a field.

---

## FieldType

**Namespace**: `Aspose.Slides.FieldType`

Represents a type of field. This value determines which text will be set to the field portion when it will be updated.

---

## FillBlendMode

**Namespace**: `Aspose.Slides.FillBlendMode`

Determines blend mode.

---

## FillFormat

**Namespace**: `Aspose.Slides.FillFormat`

Represents a fill formatting options.

---

## FillType

**Namespace**: `Aspose.Slides.FillType`

Specifies the interior fill type of various visual objects.

---

## FontAlignment

**Namespace**: `Aspose.Slides.FontAlignment`

Represents vertical font alignment.

---

## FontCollectionIndex

**Namespace**: `Aspose.Slides.FontCollectionIndex`

Represents font's index in a collection.

---

## FontData

**Namespace**: `Aspose.Slides.FontData`

Represents a font definition. Immutable.

---

## FontDataFactory

**Namespace**: `Aspose.Slides.FontDataFactory`

FontData factory

---

## FontFallBackRule

**Namespace**: `Aspose.Slides.FontFallBackRule`

Represents font fallback rule

---

## FontFallBackRulesCollection

**Namespace**: `Aspose.Slides.FontFallBackRulesCollection`

Represents a collection of FontFallBack rules, defined by user

---

## FontSources

**Namespace**: `Aspose.Slides.FontSources`

Provides file and memory sources for external fonts.

---

## FontSubstCondition

**Namespace**: `Aspose.Slides.FontSubstCondition`

Represents a rule fot font substitution

---

## FontSubstRule

**Namespace**: `Aspose.Slides.FontSubstRule`

Represents font subtituition information

---

## FontSubstRuleCollection

**Namespace**: `Aspose.Slides.FontSubstRuleCollection`

Represents collection of fonts substitution.

---

## FontSubstitutionInfo

**Namespace**: `Aspose.Slides.FontSubstitutionInfo`

This structure represents the information about the font replacement when it will be rendered.

---

## Fonts

**Namespace**: `Aspose.Slides.Fonts`

Fonts collection.

---

## FontsLoader

**Namespace**: `Aspose.Slides.FontsLoader`

Class for loading custom fonts defined by user. Should be used before creating any presentation objects.

---

## FontsManager

**Namespace**: `Aspose.Slides.FontsManager`

Manages fonts across the presentation.

---

## FormatFactory

**Namespace**: `Aspose.Slides.FormatFactory`

Allows to create formats via COM interface.

---

## GeometryPath

**Namespace**: `Aspose.Slides.GeometryPath`

Represents geometry path of GeometryShape

---

## GeometryShape

**Namespace**: `Aspose.Slides.GeometryShape`

Represents the parent class for all geometric shapes.

---

## GlobalLayoutSlideCollection

**Namespace**: `Aspose.Slides.GlobalLayoutSlideCollection`

Represents a collection of all layout slides in presentation. Extends LayoutSlideCollection class with methods for adding/cloning layout slides in context of uniting of the individual collections of master's layout slides.

---

## GradientDirection

**Namespace**: `Aspose.Slides.GradientDirection`

Represents the gradient style.

---

## GradientFormat

**Namespace**: `Aspose.Slides.GradientFormat`

Represent a gradient format.

---

## GradientShape

**Namespace**: `Aspose.Slides.GradientShape`

Represents the shape of gradient fill.

---

## GradientStop

**Namespace**: `Aspose.Slides.GradientStop`

Represents a gradient format.

---

## GradientStopCollection

**Namespace**: `Aspose.Slides.GradientStopCollection`

Represnts a collection of gradient stops.

---

## GradientStopCollectionEffectiveData

**Namespace**: `Aspose.Slides.GradientStopCollectionEffectiveData`

Represents a collection of GradientStopData objects.

---

## GradientStopEffectiveData

**Namespace**: `Aspose.Slides.GradientStopEffectiveData`

Immutable object which represents a gradient stop.

---

## GradientStyle

**Namespace**: `Aspose.Slides.GradientStyle`

Represents the available gradient styles.

---

## GraphicalObject

**Namespace**: `Aspose.Slides.GraphicalObject`

Represents abstract graphical object.

---

## GraphicalObjectLock

**Namespace**: `Aspose.Slides.GraphicalObjectLock`

Determines which operations are disabled on the parent GraphicalObject.

---

## GroupShape

**Namespace**: `Aspose.Slides.GroupShape`

Represents a group of shapes on a slide.

---

## GroupShapeLock

**Namespace**: `Aspose.Slides.GroupShapeLock`

Determines which operations are disabled on the parent GroupShape.

---

## HeadingPair

**Namespace**: `Aspose.Slides.HeadingPair`

Represents a 'Heading pair' property of the document. It indicates the group name of document parts and the number of parts in group.

---

## Hyperlink

**Namespace**: `Aspose.Slides.Hyperlink`

Represents a hyperlink.

---

## HyperlinkActionType

**Namespace**: `Aspose.Slides.HyperlinkActionType`

Represents a type of hyperlink action.

---

## HyperlinkColorSource

**Namespace**: `Aspose.Slides.HyperlinkColorSource`

Represents source of hyperlink color.

---

## HyperlinkManager

**Namespace**: `Aspose.Slides.HyperlinkManager`

Provide hyperlinks management (adding, removing).

---

## HyperlinkQueries

**Namespace**: `Aspose.Slides.HyperlinkQueries`

Provide easy access to contained hyperlinks.

---

## LayoutPlaceholderManager

**Namespace**: `Aspose.Slides.LayoutPlaceholderManager`

Represents manager that allows you to add placeholders to the layout slide.

---

## LayoutSlide

**Namespace**: `Aspose.Slides.LayoutSlide`

Represents a layout slide.

---

## LayoutSlideCollection

**Namespace**: `Aspose.Slides.LayoutSlideCollection`

Represents a base class for collection of a layout slides.

---

## LayoutSlideHeaderFooterManager

**Namespace**: `Aspose.Slides.LayoutSlideHeaderFooterManager`

Represents manager which holds behavior of the layout slide footer, date-time, page number placeholders and all child placeholders. Child placeholders mean placeholders are contained on depending slides. Depending slides use and depend on layout slide.

---

## LegacyDiagram

**Namespace**: `Aspose.Slides.LegacyDiagram`

Represents a legacy diagram object.

---

## License

**Namespace**: `Aspose.Slides.License`

Provides methods to license the component.

---

## LightRig

**Namespace**: `Aspose.Slides.LightRig`

Represents LightRig.

---

## LightRigPresetType

**Namespace**: `Aspose.Slides.LightRigPresetType`

Constants which define light preset types.

---

## LightingDirection

**Namespace**: `Aspose.Slides.LightingDirection`

Constants which define light directions.

---

## LineAlignment

**Namespace**: `Aspose.Slides.LineAlignment`

Represents the lines alignment type.

---

## LineArrowheadLength

**Namespace**: `Aspose.Slides.LineArrowheadLength`

Represents the length of an arrowhead.

---

## LineArrowheadStyle

**Namespace**: `Aspose.Slides.LineArrowheadStyle`

Represents the style of an arrowhead.

---

## LineArrowheadWidth

**Namespace**: `Aspose.Slides.LineArrowheadWidth`

Represents the width of an arrowhead.

---

## LineCapStyle

**Namespace**: `Aspose.Slides.LineCapStyle`

Represents the line cap style.

---

## LineDashStyle

**Namespace**: `Aspose.Slides.LineDashStyle`

Represents the line dash style.

---

## LineFillFormat

**Namespace**: `Aspose.Slides.LineFillFormat`

Represents properties for lines filling.

---

## LineFormat

**Namespace**: `Aspose.Slides.LineFormat`

Represents format of a line.

---

## LineJoinStyle

**Namespace**: `Aspose.Slides.LineJoinStyle`

Represents the lines join style.

---

## LineSketchType

**Namespace**: `Aspose.Slides.LineSketchType`

Represents which sketch type or effect a shape has been assigned.

---

## LineStyle

**Namespace**: `Aspose.Slides.LineStyle`

Represents the style of a line.

---

## LoadFormat

**Namespace**: `Aspose.Slides.LoadFormat`

Indicates the format of the document that is to be loaded.

---

## LoadOptions

**Namespace**: `Aspose.Slides.LoadOptions`

Allows to specify additional options (such as format or default font) when loading a presentation.

---

## LoadingStreamBehavior

**Namespace**: `Aspose.Slides.LoadingStreamBehavior`

The

---

## MasterHandoutSlide

**Namespace**: `Aspose.Slides.MasterHandoutSlide`

Represents master slide for handouts.

---

## MasterHandoutSlideHeaderFooterManager

**Namespace**: `Aspose.Slides.MasterHandoutSlideHeaderFooterManager`

Represents manager which holds behavior of the master handout slide placeholders, including header placeholder.

---

## MasterLayoutSlideCollection

**Namespace**: `Aspose.Slides.MasterLayoutSlideCollection`

Represents a collections of all layout slides of defined master slide. Extends LayoutSlideCollection class with methods for adding/inserting/removing/cloning/reordering layout slides in context of the individual collections of master's layout slides.

---

## MasterNotesSlide

**Namespace**: `Aspose.Slides.MasterNotesSlide`

Represents master slide for notes.

---

## MasterNotesSlideHeaderFooterManager

**Namespace**: `Aspose.Slides.MasterNotesSlideHeaderFooterManager`

Represents manager which holds behavior of the master notes slide footer, date-time, page number placeholders and all child placeholders. Child placeholders mean placeholders are contained on depending notes slides. Depending notes slides use and depend on master notes slide.

---

## MasterSlide

**Namespace**: `Aspose.Slides.MasterSlide`

Represents a master slide in a presentation.

---

## MasterSlideCollection

**Namespace**: `Aspose.Slides.MasterSlideCollection`

Represents a collection of master slides.

---

## MasterSlideHeaderFooterManager

**Namespace**: `Aspose.Slides.MasterSlideHeaderFooterManager`

Represents manager which holds behavior of the master slide footer, date-time, page number placeholders and all child placeholders. Child placeholders mean placeholders are contained on depending layout slides and depending slides. Depending layout slides and slides use and depend on master slide.

---

## MaterialPresetType

**Namespace**: `Aspose.Slides.MaterialPresetType`

Constants which define material of shape.

---

## Metered

**Namespace**: `Aspose.Slides.Metered`

Provides methods to set metered key.

---

## ModernComment

**Namespace**: `Aspose.Slides.ModernComment`

Represents a comment on a slide.

---

## ModernCommentStatus

**Namespace**: `Aspose.Slides.ModernCommentStatus`

Represents the status of a modern comment.

---

## NamespaceDoc

**Namespace**: `Aspose.Slides.NamespaceDoc`

Contains classes for work with Microsoft PowerPoint presentations without utilizing Microsoft PowerPoint.

---

## NormalViewProperties

**Namespace**: `Aspose.Slides.NormalViewProperties`

Represents normal view properties. The normal view consists of three content regions: the slide itself, a side content region, and a bottom content region.

---

## NormalViewRestoredProperties

**Namespace**: `Aspose.Slides.NormalViewRestoredProperties`

Specifies the sizing of the slide region ((width when a child of restoredTop, height when a child of restoredLeft) of the normal view, when the region is of a variable restored size(neither minimized nor maximized).

---

## NotesSize

**Namespace**: `Aspose.Slides.NotesSize`

Represents a size of notes slide.

---

## NotesSlide

**Namespace**: `Aspose.Slides.NotesSlide`

Represents a notes slide in a presentation.

---

## NotesSlideHeaderFooterManager

**Namespace**: `Aspose.Slides.NotesSlideHeaderFooterManager`

Represents manager which holds behavior of the notes slide placeholders, including header placeholder.

---

## NotesSlideManager

**Namespace**: `Aspose.Slides.NotesSlideManager`

Notes slide manager.

---

## NullableBool

**Namespace**: `Aspose.Slides.NullableBool`

Represents triple boolean values.

---

## NumberedBulletStyle

**Namespace**: `Aspose.Slides.NumberedBulletStyle`

Represents the style of the numbered bullets.

---

## OOXMLCorruptFileException

**Namespace**: `Aspose.Slides.OOXMLCorruptFileException`

Exception which thrown when Office Open XML file format is corrupted.

---

## OOXMLException

**Namespace**: `Aspose.Slides.OOXMLException`

Represents a standard internal exception type related to Office Open XML file format.

---

## OdpException

**Namespace**: `Aspose.Slides.OdpException`

Represents a standard internal exception type.

---

## OdpReadException

**Namespace**: `Aspose.Slides.OdpReadException`

Represents an exception which thrown on presentation reading errors.

---

## OleObjectFrame

**Namespace**: `Aspose.Slides.OleObjectFrame`

Represents an OLE object on a slide.

---

## Orientation

**Namespace**: `Aspose.Slides.Orientation`

Represents the orientation of a shape.

---

## PPImage

**Namespace**: `Aspose.Slides.PPImage`

Represents an image in a presentation.

---

## PPImageFormat

**Namespace**: `Aspose.Slides.PPImageFormat`

Image formats. This enum is replacement for

---

## PVIObject

**Namespace**: `Aspose.Slides.PVIObject`

Encapsulates basic service infrastructure for objects can be a subject of property value inheritance.

---

## Paragraph

**Namespace**: `Aspose.Slides.Paragraph`

Represents a paragraph of text.

---

## ParagraphCollection

**Namespace**: `Aspose.Slides.ParagraphCollection`

Represents a collection of a paragraphs.

---

## ParagraphFactory

**Namespace**: `Aspose.Slides.ParagraphFactory`

Allows to create paragraphs

---

## ParagraphFormat

**Namespace**: `Aspose.Slides.ParagraphFormat`

This class contains the paragraph formatting properties. Unlike

---

## PathCommandType

**Namespace**: `Aspose.Slides.PathCommandType`

Represents graphics path commands

---

## PathFillModeType

**Namespace**: `Aspose.Slides.PathFillModeType`

Specifies the manner in which a path should be filled

---

## PathSegment

**Namespace**: `Aspose.Slides.PathSegment`

Represents segment of graphics path of GeometryShape

---

## PatternFormat

**Namespace**: `Aspose.Slides.PatternFormat`

Represents a pattern to fill a shape.

---

## PatternStyle

**Namespace**: `Aspose.Slides.PatternStyle`

Represents the pattern style.

---

## PersistenceType

**Namespace**: `Aspose.Slides.PersistenceType`

Specifies the method used to store properties of the ActiveX control.

---

## Picture

**Namespace**: `Aspose.Slides.Picture`

Represents a picture in a presentation.

---

## PictureFillFormat

**Namespace**: `Aspose.Slides.PictureFillFormat`

Represents a picture fill style.

---

## PictureFillMode

**Namespace**: `Aspose.Slides.PictureFillMode`

Determines how picture will fill area.

---

## PictureFrame

**Namespace**: `Aspose.Slides.PictureFrame`

Represents a frame with a picture inside.

---

## PictureFrameLock

**Namespace**: `Aspose.Slides.PictureFrameLock`

Determines which operations are disabled on the parent PictureFrame.

---

## Placeholder

**Namespace**: `Aspose.Slides.Placeholder`

Represents a placeholder on a slide.

---

## PlaceholderSize

**Namespace**: `Aspose.Slides.PlaceholderSize`

Represents the size of a placeholder.

---

## PlaceholderType

**Namespace**: `Aspose.Slides.PlaceholderType`

Represents the type of a placeholder.

---

## Portion

**Namespace**: `Aspose.Slides.Portion`

Represents a portion of text inside a text paragraph.

---

## PortionCollection

**Namespace**: `Aspose.Slides.PortionCollection`

Represents a collection of portions.

---

## PortionFactory

**Namespace**: `Aspose.Slides.PortionFactory`

Allows to create test portions

---

## PortionFormat

**Namespace**: `Aspose.Slides.PortionFormat`

This class contains the text portion formatting properties. Unlike

---

## PptCorruptFileException

**Namespace**: `Aspose.Slides.PptCorruptFileException`

Exception which thrown when presentation file is probably corrupt.

---

## PptEditException

**Namespace**: `Aspose.Slides.PptEditException`

Represents an exception thrown when edit presentation error is detected.

---

## PptException

**Namespace**: `Aspose.Slides.PptException`

Represents a standard internal exception type.

---

## PptReadException

**Namespace**: `Aspose.Slides.PptReadException`

Represents an exception which thrown on presentation reading errors.

---

## PptUnsupportedFormatException

**Namespace**: `Aspose.Slides.PptUnsupportedFormatException`

Exception which thrown when presentation file format is unsupported.

---

## PptxEditException

**Namespace**: `Aspose.Slides.PptxEditException`

Represents an exception thrown when edit presentation error is detected.

---

## PptxException

**Namespace**: `Aspose.Slides.PptxException`

Represents a standard internal exception type.

---

## PptxReadException

**Namespace**: `Aspose.Slides.PptxReadException`

Represents an exception which thrown on presentation reading errors.

---

## PptxUnsupportedFormatException

**Namespace**: `Aspose.Slides.PptxUnsupportedFormatException`

Exception which thrown when presentation file format is unsupported.

---

## Presentation

**Namespace**: `Aspose.Slides.Presentation`

Represents a Microsoft PowerPoint presentation.

---

## PresentationFactory

**Namespace**: `Aspose.Slides.PresentationFactory`

Allows to create presentation via COM interface

---

## PresentationHeaderFooterManager

**Namespace**: `Aspose.Slides.PresentationHeaderFooterManager`

Represents manager which holds behavior of all footer, date-time and page number placeholders of presentation.

---

## PresentationInfo

**Namespace**: `Aspose.Slides.PresentationInfo`

Information about presentation file

---

## PresentationLockingBehavior

**Namespace**: `Aspose.Slides.PresentationLockingBehavior`

Represents the behavior regarding treating the

---

## PresentationText

**Namespace**: `Aspose.Slides.PresentationText`

Represents the text extracted from the presentation

---

## PresentedBySpeaker

**Namespace**: `Aspose.Slides.PresentedBySpeaker`

Presented by a speaker (full screen)

---

## PresetColor

**Namespace**: `Aspose.Slides.PresetColor`

Represents predefined color presets.

---

## PresetShadowType

**Namespace**: `Aspose.Slides.PresetShadowType`

Represents a preset for a shadow effect.

---

## ProtectionManager

**Namespace**: `Aspose.Slides.ProtectionManager`

Presentation password protection management.

---

## RectangleAlignment

**Namespace**: `Aspose.Slides.RectangleAlignment`

Defines 2-dimension allignment.

---

## ResourceLoadingAction

**Namespace**: `Aspose.Slides.ResourceLoadingAction`

Specifies the mode of external resource loading.

---

## Row

**Namespace**: `Aspose.Slides.Row`

Represents a row in a table.

---

## RowCollection

**Namespace**: `Aspose.Slides.RowCollection`

Represents table row collection.

---

## RowFormat

**Namespace**: `Aspose.Slides.RowFormat`

Represents format of a table row.

---

## SchemeColor

**Namespace**: `Aspose.Slides.SchemeColor`

Represents colors in a color scheme.

---

## Section

**Namespace**: `Aspose.Slides.Section`

Represents section of slides.

---

## SectionCollection

**Namespace**: `Aspose.Slides.SectionCollection`

Represents a collection of sections.

---

## SectionSlideCollection

**Namespace**: `Aspose.Slides.SectionSlideCollection`

Represents a collection of slides in the section.

---

## SectionZoomFrame

**Namespace**: `Aspose.Slides.SectionZoomFrame`

Represents a Section Zoom object in a slide.

---

## Shape

**Namespace**: `Aspose.Slides.Shape`

Represents a shape on a slide.

---

## ShapeAdjustmentType

**Namespace**: `Aspose.Slides.ShapeAdjustmentType`

Specifies different types of shape adjustment values.

---

## ShapeBevel

**Namespace**: `Aspose.Slides.ShapeBevel`

Contains the properties of shape's main face relief.

---

## ShapeCollection

**Namespace**: `Aspose.Slides.ShapeCollection`

Represents a collection of shapes.

---

## ShapeElement

**Namespace**: `Aspose.Slides.ShapeElement`

Represents a part of shape with same outline and fill properties.

---

## ShapeElementFillSource

**Namespace**: `Aspose.Slides.ShapeElementFillSource`

Represents how shape element should be filled.

---

## ShapeElementStrokeSource

**Namespace**: `Aspose.Slides.ShapeElementStrokeSource`

Represents how shape element should be drawn.

---

## ShapeFrame

**Namespace**: `Aspose.Slides.ShapeFrame`

Represents shape frame's properties.

---

## ShapeStyle

**Namespace**: `Aspose.Slides.ShapeStyle`

Represent shape's style reference.

---

## ShapeThumbnailBounds

**Namespace**: `Aspose.Slides.ShapeThumbnailBounds`

Enumeration of types of shape thumbnail bounds.

---

## ShapeType

**Namespace**: `Aspose.Slides.ShapeType`

Represents preset geometry of geometry shapes.

---

## ShapesAlignmentType

**Namespace**: `Aspose.Slides.ShapesAlignmentType`

Defines a way to change the placement of selected shapes on the slide.

---

## SketchFormat

**Namespace**: `Aspose.Slides.SketchFormat`

Represents properties for lines sketch format.

---

## Slide

**Namespace**: `Aspose.Slides.Slide`

Represents a slide in a presentation.

---

## SlideCollection

**Namespace**: `Aspose.Slides.SlideCollection`

Represents a collection of a slides.

---

## SlideHeaderFooterManager

**Namespace**: `Aspose.Slides.SlideHeaderFooterManager`

Represents manager which holds behavior of the slide footer, date-time, page number placeholders.

---

## SlideLayoutType

**Namespace**: `Aspose.Slides.SlideLayoutType`

Represents the slide layout type.

---

## SlideOrientation

**Namespace**: `Aspose.Slides.SlideOrientation`

Represents the slide orientation.

---

## SlideShowSettings

**Namespace**: `Aspose.Slides.SlideShowSettings`

Represents the slide show settings for the presentation.

---

## SlideShowType

**Namespace**: `Aspose.Slides.SlideShowType`

Base slide show settings. Ancestors represent types of the slide show:

---

## SlideSize

**Namespace**: `Aspose.Slides.SlideSize`

Represents the size and orientation of a slide.

---

## SlideSizeScaleType

**Namespace**: `Aspose.Slides.SlideSizeScaleType`

Represents the scale type of slide content.

---

## SlideSizeType

**Namespace**: `Aspose.Slides.SlideSizeType`

Represents the slide size preset.

---

## SlidesRange

**Namespace**: `Aspose.Slides.SlidesRange`

Slides range

---

## SourceFormat

**Namespace**: `Aspose.Slides.SourceFormat`

Represents source file format.

---

## SplitterBarStateType

**Namespace**: `Aspose.Slides.SplitterBarStateType`

Specifies the state that the splitter bar should be shown in. The splitter bar separates a primary and secondary region within a viewing area.

---

## SpreadsheetOptions

**Namespace**: `Aspose.Slides.SpreadsheetOptions`

Represents options which can be used to specify additional spreadsheets behavior.

---

## StreamWrapper

**Namespace**: `Aspose.Slides.StreamWrapper`

Aspose.IO.Stream wrapper for COM interface.

---

## StreamWrapperFactory

**Namespace**: `Aspose.Slides.StreamWrapperFactory`

Factory of StreamWrappers. For COM interface.

---

## SummaryZoomFrame

**Namespace**: `Aspose.Slides.SummaryZoomFrame`

Represents a Summary Zoom object in a slide.

---

## SummaryZoomSection

**Namespace**: `Aspose.Slides.SummaryZoomSection`

Represents a Summary Zoom Section object in a Summary Zoom frame.

---

## SummaryZoomSectionCollection

**Namespace**: `Aspose.Slides.SummaryZoomSectionCollection`

Represents a collection of Summary Zoom Section objects.

---

## SvgImage

**Namespace**: `Aspose.Slides.SvgImage`

Represents an SVG image.

---

## SystemColor

**Namespace**: `Aspose.Slides.SystemColor`

Represents predefined system colors.

---

## Tab

**Namespace**: `Aspose.Slides.Tab`

Represents a tabulation for a text.

---

## TabAlignment

**Namespace**: `Aspose.Slides.TabAlignment`

Represents the tab alignment.

---

## TabCollection

**Namespace**: `Aspose.Slides.TabCollection`

Represents a collection of tabs.

---

## TabFactory

**Namespace**: `Aspose.Slides.TabFactory`

Allows to create ITab instances

---

## Table

**Namespace**: `Aspose.Slides.Table`

Represents a table on a slide.

---

## TableFormat

**Namespace**: `Aspose.Slides.TableFormat`

Represents format of a table.

---

## TableStylePreset

**Namespace**: `Aspose.Slides.TableStylePreset`

Represents builtin table styles.

---

## TagCollection

**Namespace**: `Aspose.Slides.TagCollection`

Represents the collection of tags (user defined pairs of strings)

---

## TextAlignment

**Namespace**: `Aspose.Slides.TextAlignment`

Represents different text alignment styles.

---

## TextAnchorType

**Namespace**: `Aspose.Slides.TextAnchorType`

text box alignment within a text area.

---

## TextAutofitType

**Namespace**: `Aspose.Slides.TextAutofitType`

Represents text autofit mode.

---

## TextCapType

**Namespace**: `Aspose.Slides.TextCapType`

Represents the type of text capitalisation.

---

## TextExtractionArrangingMode

**Namespace**: `Aspose.Slides.TextExtractionArrangingMode`

Represents the mode to use during text extraction

---

## TextFrame

**Namespace**: `Aspose.Slides.TextFrame`

Represents a TextFrame.

---

## TextFrameFormat

**Namespace**: `Aspose.Slides.TextFrameFormat`

Contains the TextFrame's formatTextFrameFormatting properties.

---

## TextHighlightingOptions

**Namespace**: `Aspose.Slides.TextHighlightingOptions`

Represents options which can be used to highlight text in text frame.

---

## TextSearchOptions

**Namespace**: `Aspose.Slides.TextSearchOptions`

Represents options that can be used to search for text in a Presentation, Slide or TextFrame.

---

## TextShapeType

**Namespace**: `Aspose.Slides.TextShapeType`

Represents text wrapping shape.

---

## TextStrikethroughType

**Namespace**: `Aspose.Slides.TextStrikethroughType`

Represents the type of text strikethrough.

---

## TextStyle

**Namespace**: `Aspose.Slides.TextStyle`

This class contains the text style formatting properties.

---

## TextUnderlineType

**Namespace**: `Aspose.Slides.TextUnderlineType`

Represents the type of text underline.

---

## TextVerticalOverflowType

**Namespace**: `Aspose.Slides.TextVerticalOverflowType`

Represents text vertical overflow type.

---

## TextVerticalType

**Namespace**: `Aspose.Slides.TextVerticalType`

Determines vertical writing mode for a text.

---

## ThreeDFormat

**Namespace**: `Aspose.Slides.ThreeDFormat`

Represents 3-D properties.

---

## TileFlip

**Namespace**: `Aspose.Slides.TileFlip`

Defines tile flipping mode.

---

## Video

**Namespace**: `Aspose.Slides.Video`

Represents an image embedded into a presentation.

---

## VideoCollection

**Namespace**: `Aspose.Slides.VideoCollection`

Represents a collection of Video objects.

---

## VideoFrame

**Namespace**: `Aspose.Slides.VideoFrame`

Represents a video clip on a slide.

---

## VideoPlayModePreset

**Namespace**: `Aspose.Slides.VideoPlayModePreset`

Constants which define how a video is played.

---

## ViewProperties

**Namespace**: `Aspose.Slides.ViewProperties`

Presentation wide view properties.

---

## ViewType

**Namespace**: `Aspose.Slides.ViewType`

Presentation view types

---

## ZoomFrame

**Namespace**: `Aspose.Slides.ZoomFrame`

Represents a Slide Zoom object in a slide.

---

## ZoomImageType

**Namespace**: `Aspose.Slides.ZoomImageType`

Defines whether the Zoom object is using the slide preview or a cover image.

---

## ZoomLayout

**Namespace**: `Aspose.Slides.ZoomLayout`

Specifies the summary zoom layout.

---

## ZoomObject

**Namespace**: `Aspose.Slides.ZoomObject`

Represents an Zoom object in a slide.

---

