---
name: assignment-types
description: |
  4つの課題実施方式（プログラム実装課題、リファクタリング課題、テスト実装課題、テスト駆動開発課題）の定義を提供します。
  課題プラン作成時や課題形式の選定時に自動参照されます。
  「課題形式」「実施方式」「プログラム実装」「リファクタリング」「テスト実装」「TDD」などのキーワードで自動的に適用されます。
---

# 課題の実施方式

本テンプレートでは、以下の4つの課題実施方式から選択できます。

## 1. プログラム実装課題

**概要**: 学生がテスト駆動で段階的にプログラムを実装する形式

**特徴**:
- 学生は `release/README.md` の仕様や `tests/` のREDテストを前提に、`src/kadai/` 配下にプログラムを実装する
- `src/kadai/` 配下のプログラムは白紙状態からスタートするか、一部実装済みの状態から機能を追加する
- `tests/` のREDテストはステージ毎に分かれており、REDを確認する→1ステージGREENにする→コミットをサイクルして課題を実装する
- 実装した課題は `.github/workflows/classroom.yml` に設定したCIで `tests/` 配下のテストを基に自動採点される

**適用例**: 基本アルゴリズム、データ構造の実装、クラス設計の学習

## 2. リファクタリング課題

**概要**: 既存の動作するコードを品質改善する形式

**特徴**:
- 学生は `release/README.md` の仕様・リファクタリング要件や `tests/` のGREEN状態のテスト、`src/kadai/` 配下に実装済のプログラムを基に、リファクタリングを行う
- `tests/` の既にGREEN状態のテストを維持して振る舞いの変化が無い事を保証しながらリファクタリングを行う
- 実装した課題は `.github/workflows/classroom.yml` にASTによるコード品質チェックによって採点される

**適用例**: コードの可読性向上、設計パターン適用、重複コードの削除

## 3. テスト実装課題

**概要**: バグを含むコードに対してテストを書いてバグを検出する形式

**特徴**:
- 学生は `release/README.md` の仕様・受け入れ観点や `src/kadai/` 配下に実装済の一部バグのあるプログラムを基に、`tests/` 配下にテストを記述する
- `src/kadai/` に実装済みのプログラムは `release/README.md` 通りの受け入れ観点でテストを記述することでREDが見つかるようになっている
- 実装した課題は `.github/workflows/classroom.yml` に設定したCIで実装済みのバグを検出できるかどうかで採点される

**適用例**: テスト設計の学習、バグ検出スキル、境界値分析

## 4. テスト駆動開発課題

**概要**: 完全なTDD（RED→GREEN→Refactor）サイクルで実装する形式

**特徴**:
- 学生は `release/README.md` の仕様を基に、以下のサイクルで実装を行う
  - `tests/` 配下にテストを記述してREDを確認
  - `src/kadai` 配下に実装してGREENを確認
  - リファクタリング
- 現状、実装した課題はCIによって採点しない

**適用例**: TDDスキルの習得、設計力の向上

## 選定基準

| 学習目標 | 推奨形式 |
|---------|---------|
| 基本的なプログラミング能力 | プログラム実装課題 |
| コード品質・設計力 | リファクタリング課題 |
| テスト設計・バグ検出能力 | テスト実装課題 |
| 総合的な開発スキル | テスト駆動開発課題 |
